% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect_operations.R
\name{connect_create_user}
\alias{connect_create_user}
\title{Creates a user account for the specified Amazon Connect instance}
\usage{
connect_create_user(
  Username,
  Password = NULL,
  IdentityInfo = NULL,
  PhoneConfig,
  DirectoryUserId = NULL,
  SecurityProfileIds,
  RoutingProfileId,
  HierarchyGroupId = NULL,
  InstanceId,
  Tags = NULL
)
}
\arguments{
\item{Username}{[required] The user name for the account. For instances not using SAML for identity
management, the user name can include up to 20 characters. If you are
using SAML for identity management, the user name can include up to 64
characters from [a-zA-Z0-9_-.\\@]+.}

\item{Password}{The password for the user account. A password is required if you are
using Amazon Connect for identity management. Otherwise, it is an error
to include a password.}

\item{IdentityInfo}{The information about the identity of the user.}

\item{PhoneConfig}{[required] The phone settings for the user.}

\item{DirectoryUserId}{The identifier of the user account in the directory used for identity
management. If Amazon Connect cannot access the directory, you can
specify this identifier to authenticate users. If you include the
identifier, we assume that Amazon Connect cannot access the directory.
Otherwise, the identity information is used to authenticate users from
your directory.

This parameter is required if you are using an existing directory for
identity management in Amazon Connect when Amazon Connect cannot access
your directory to authenticate users. If you are using SAML for identity
management and include this parameter, an error is returned.}

\item{SecurityProfileIds}{[required] The identifier of the security profile for the user.}

\item{RoutingProfileId}{[required] The identifier of the routing profile for the user.}

\item{HierarchyGroupId}{The identifier of the hierarchy group for the user.}

\item{InstanceId}{[required] The identifier of the Amazon Connect instance. You can \href{https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html}{find the instance ID}
in the Amazon Resource Name (ARN) of the instance.}

\item{Tags}{The tags used to organize, track, or control access for this resource.
For example, \{ "Tags": \{"key1":"value1", "key2":"value2"\} \}.}
}
\description{
Creates a user account for the specified Amazon Connect instance.

See \url{https://www.paws-r-sdk.com/docs/connect_create_user/} for full documentation.
}
\keyword{internal}
