% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamodb_operations.R
\name{dynamodb_delete_backup}
\alias{dynamodb_delete_backup}
\title{Deletes an existing backup of a table}
\usage{
dynamodb_delete_backup(BackupArn)
}
\arguments{
\item{BackupArn}{[required] The ARN associated with the backup.}
}
\value{
A list with the following syntax:\preformatted{list(
  BackupDescription = list(
    BackupDetails = list(
      BackupArn = "string",
      BackupName = "string",
      BackupSizeBytes = 123,
      BackupStatus = "CREATING"|"DELETED"|"AVAILABLE",
      BackupType = "USER"|"SYSTEM"|"AWS_BACKUP",
      BackupCreationDateTime = as.POSIXct(
        "2015-01-01"
      ),
      BackupExpiryDateTime = as.POSIXct(
        "2015-01-01"
      )
    ),
    SourceTableDetails = list(
      TableName = "string",
      TableId = "string",
      TableArn = "string",
      TableSizeBytes = 123,
      KeySchema = list(
        list(
          AttributeName = "string",
          KeyType = "HASH"|"RANGE"
        )
      ),
      TableCreationDateTime = as.POSIXct(
        "2015-01-01"
      ),
      ProvisionedThroughput = list(
        ReadCapacityUnits = 123,
        WriteCapacityUnits = 123
      ),
      ItemCount = 123,
      BillingMode = "PROVISIONED"|"PAY_PER_REQUEST"
    ),
    SourceTableFeatureDetails = list(
      LocalSecondaryIndexes = list(
        list(
          IndexName = "string",
          KeySchema = list(
            list(
              AttributeName = "string",
              KeyType = "HASH"|"RANGE"
            )
          ),
          Projection = list(
            ProjectionType = "ALL"|"KEYS_ONLY"|"INCLUDE",
            NonKeyAttributes = list(
              "string"
            )
          )
        )
      ),
      GlobalSecondaryIndexes = list(
        list(
          IndexName = "string",
          KeySchema = list(
            list(
              AttributeName = "string",
              KeyType = "HASH"|"RANGE"
            )
          ),
          Projection = list(
            ProjectionType = "ALL"|"KEYS_ONLY"|"INCLUDE",
            NonKeyAttributes = list(
              "string"
            )
          ),
          ProvisionedThroughput = list(
            ReadCapacityUnits = 123,
            WriteCapacityUnits = 123
          )
        )
      ),
      StreamDescription = list(
        StreamEnabled = TRUE|FALSE,
        StreamViewType = "NEW_IMAGE"|"OLD_IMAGE"|"NEW_AND_OLD_IMAGES"|"KEYS_ONLY"
      ),
      TimeToLiveDescription = list(
        TimeToLiveStatus = "ENABLING"|"DISABLING"|"ENABLED"|"DISABLED",
        AttributeName = "string"
      ),
      SSEDescription = list(
        Status = "ENABLING"|"ENABLED"|"DISABLING"|"DISABLED"|"UPDATING",
        SSEType = "AES256"|"KMS",
        KMSMasterKeyArn = "string",
        InaccessibleEncryptionDateTime = as.POSIXct(
          "2015-01-01"
        )
      )
    )
  )
)
}
}
\description{
Deletes an existing backup of a table.

You can call \code{\link[=dynamodb_delete_backup]{delete_backup}} at a maximum rate
of 10 times per second.
}
\section{Request syntax}{
\preformatted{svc$delete_backup(
  BackupArn = "string"
)
}
}

\keyword{internal}
