% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redshift_operations.R
\name{redshift_describe_node_configuration_options}
\alias{redshift_describe_node_configuration_options}
\title{Returns properties of possible node configurations such as node type,
number of nodes, and disk usage for the specified action type}
\usage{
redshift_describe_node_configuration_options(ActionType,
  ClusterIdentifier, SnapshotIdentifier, OwnerAccount, Filters, Marker,
  MaxRecords)
}
\arguments{
\item{ActionType}{[required] The action type to evaluate for possible node configurations. Specify
"restore-cluster" to get configuration combinations based on an existing
snapshot. Specify "recommend-node-config" to get configuration
recommendations based on an existing cluster or snapshot. Specify
"resize-cluster" to get configuration combinations for elastic resize
based on an existing cluster.}

\item{ClusterIdentifier}{The identifier of the cluster to evaluate for possible node
configurations.}

\item{SnapshotIdentifier}{The identifier of the snapshot to evaluate for possible node
configurations.}

\item{OwnerAccount}{The AWS customer account used to create or copy the snapshot. Required
if you are restoring a snapshot you do not own, optional if you own the
snapshot.}

\item{Filters}{A set of name, operator, and value items to filter the results.}

\item{Marker}{An optional parameter that specifies the starting point to return a set
of response records. When the results of a
\code{\link[=redshift_describe_node_configuration_options]{describe_node_configuration_options}}
request exceed the value specified in \code{MaxRecords}, AWS returns a value
in the \code{Marker} field of the response. You can retrieve the next set of
response records by providing the returned marker value in the \code{Marker}
parameter and retrying the request.}

\item{MaxRecords}{The maximum number of response records to return in each call. If the
number of remaining response records exceeds the specified \code{MaxRecords}
value, a value is returned in a \code{marker} field of the response. You can
retrieve the next set of records by retrying the command with the
returned marker value.

Default: \code{500}

Constraints: minimum 100, maximum 500.}
}
\value{
A list with the following syntax:\preformatted{list(
  NodeConfigurationOptionList = list(
    list(
      NodeType = "string",
      NumberOfNodes = 123,
      EstimatedDiskUtilizationPercent = 123.0,
      Mode = "standard"|"high-performance"
    )
  ),
  Marker = "string"
)
}
}
\description{
Returns properties of possible node configurations such as node type,
number of nodes, and disk usage for the specified action type.
}
\section{Request syntax}{
\preformatted{svc$describe_node_configuration_options(
  ActionType = "restore-cluster"|"recommend-node-config"|"resize-cluster",
  ClusterIdentifier = "string",
  SnapshotIdentifier = "string",
  OwnerAccount = "string",
  Filters = list(
    list(
      Name = "NodeType"|"NumberOfNodes"|"EstimatedDiskUtilizationPercent"|"Mode",
      Operator = "eq"|"lt"|"gt"|"le"|"ge"|"in"|"between",
      Values = list(
        "string"
      )
    )
  ),
  Marker = "string",
  MaxRecords = 123
)
}
}

\keyword{internal}
