% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simpledb_operations.R
\name{simpledb_domain_metadata}
\alias{simpledb_domain_metadata}
\title{Returns information about the domain, including when the domain was
created, the number of items and attributes in the domain, and the size
of the attribute names and values}
\usage{
simpledb_domain_metadata(DomainName)
}
\arguments{
\item{DomainName}{[required] The name of the domain for which to display the metadata of.}
}
\value{
A list with the following syntax:\preformatted{list(
  ItemCount = 123,
  ItemNamesSizeBytes = 123,
  AttributeNameCount = 123,
  AttributeNamesSizeBytes = 123,
  AttributeValueCount = 123,
  AttributeValuesSizeBytes = 123,
  Timestamp = 123
)
}
}
\description{
Returns information about the domain, including when the domain was
created, the number of items and attributes in the domain, and the size
of the attribute names and values.
}
\section{Request syntax}{
\preformatted{svc$domain_metadata(
  DomainName = "string"
)
}
}

\keyword{internal}
