% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docdb_operations.R
\name{docdb_create_db_cluster_parameter_group}
\alias{docdb_create_db_cluster_parameter_group}
\title{Creates a new cluster parameter group}
\usage{
docdb_create_db_cluster_parameter_group(DBClusterParameterGroupName,
  DBParameterGroupFamily, Description, Tags)
}
\arguments{
\item{DBClusterParameterGroupName}{[required] The name of the cluster parameter group.

Constraints:
\itemize{
\item Must not match the name of an existing \code{DBClusterParameterGroup}.
}

This value is stored as a lowercase string.}

\item{DBParameterGroupFamily}{[required] The cluster parameter group family name.}

\item{Description}{[required] The description for the cluster parameter group.}

\item{Tags}{The tags to be assigned to the cluster parameter group.}
}
\value{
A list with the following syntax:\preformatted{list(
  DBClusterParameterGroup = list(
    DBClusterParameterGroupName = "string",
    DBParameterGroupFamily = "string",
    Description = "string",
    DBClusterParameterGroupArn = "string"
  )
)
}
}
\description{
Creates a new cluster parameter group.

Parameters in a cluster parameter group apply to all of the instances in
a cluster.

A cluster parameter group is initially created with the default
parameters for the database engine used by instances in the cluster. In
Amazon DocumentDB, you cannot make modifications directly to the
\code{default.docdb3.6} cluster parameter group. If your Amazon DocumentDB
cluster is using the default cluster parameter group and you want to
modify a value in it, you must first \href{https://docs.aws.amazon.com/documentdb/latest/developerguide/}{create a new parameter group} or
\href{https://docs.aws.amazon.com/documentdb/latest/developerguide/}{copy an existing parameter group},
modify it, and then apply the modified parameter group to your cluster.
For the new cluster parameter group and associated settings to take
effect, you must then reboot the instances in the cluster without
failover. For more information, see \href{https://docs.aws.amazon.com/documentdb/latest/developerguide/}{Modifying Amazon DocumentDB Cluster Parameter Groups}.
}
\section{Request syntax}{
\preformatted{svc$create_db_cluster_parameter_group(
  DBClusterParameterGroupName = "string",
  DBParameterGroupFamily = "string",
  Description = "string",
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
