% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redshift_operations.R
\name{redshift_create_cluster_parameter_group}
\alias{redshift_create_cluster_parameter_group}
\title{Creates an Amazon Redshift parameter group}
\usage{
redshift_create_cluster_parameter_group(ParameterGroupName,
  ParameterGroupFamily, Description, Tags)
}
\arguments{
\item{ParameterGroupName}{[required] The name of the cluster parameter group.

Constraints:
\itemize{
\item Must be 1 to 255 alphanumeric characters or hyphens
\item First character must be a letter.
\item Cannot end with a hyphen or contain two consecutive hyphens.
\item Must be unique withing your AWS account.
}

This value is stored as a lower-case string.}

\item{ParameterGroupFamily}{[required] The Amazon Redshift engine version to which the cluster parameter group
applies. The cluster engine version determines the set of parameters.

To get a list of valid parameter group family names, you can call
DescribeClusterParameterGroups. By default, Amazon Redshift returns a
list of all the parameter groups that are owned by your AWS account,
including the default parameter groups for each Amazon Redshift engine
version. The parameter group family names associated with the default
parameter groups provide you the valid values. For example, a valid
family name is "redshift-1.0".}

\item{Description}{[required] A description of the parameter group.}

\item{Tags}{A list of tag instances.}
}
\description{
Creates an Amazon Redshift parameter group.
}
\details{
Creating parameter groups is independent of creating clusters. You can
associate a cluster with a parameter group when you create the cluster.
You can also associate an existing cluster with a parameter group after
the cluster is created by using ModifyCluster.

Parameters in the parameter group define specific behavior that applies
to the databases you create on the cluster. For more information about
parameters and parameter groups, go to \href{https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html}{Amazon Redshift Parameter Groups}
in the \emph{Amazon Redshift Cluster Management Guide}.
}
\section{Request syntax}{
\preformatted{svc$create_cluster_parameter_group(
  ParameterGroupName = "string",
  ParameterGroupFamily = "string",
  Description = "string",
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
