% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redshift_operations.R
\name{redshift_describe_reserved_nodes}
\alias{redshift_describe_reserved_nodes}
\title{Returns the descriptions of the reserved nodes}
\usage{
redshift_describe_reserved_nodes(ReservedNodeId, MaxRecords, Marker)
}
\arguments{
\item{ReservedNodeId}{Identifier for the node reservation.}

\item{MaxRecords}{The maximum number of response records to return in each call. If the
number of remaining response records exceeds the specified \code{MaxRecords}
value, a value is returned in a \code{marker} field of the response. You can
retrieve the next set of records by retrying the command with the
returned marker value.

Default: \code{100}

Constraints: minimum 20, maximum 100.}

\item{Marker}{An optional parameter that specifies the starting point to return a set
of response records. When the results of a DescribeReservedNodes request
exceed the value specified in \code{MaxRecords}, AWS returns a value in the
\code{Marker} field of the response. You can retrieve the next set of
response records by providing the returned marker value in the \code{Marker}
parameter and retrying the request.}
}
\description{
Returns the descriptions of the reserved nodes.
}
\section{Request syntax}{
\preformatted{svc$describe_reserved_nodes(
  ReservedNodeId = "string",
  MaxRecords = 123,
  Marker = "string"
)
}
}

\keyword{internal}
