% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_copy_db_cluster_snapshot}
\alias{rds_copy_db_cluster_snapshot}
\title{Copies a snapshot of a DB cluster}
\usage{
rds_copy_db_cluster_snapshot(SourceDBClusterSnapshotIdentifier,
  TargetDBClusterSnapshotIdentifier, KmsKeyId, PreSignedUrl, CopyTags,
  Tags, SourceRegion)
}
\arguments{
\item{SourceDBClusterSnapshotIdentifier}{[required] The identifier of the DB cluster snapshot to copy. This parameter isn\'t
case-sensitive.

You can\'t copy an encrypted, shared DB cluster snapshot from one AWS
Region to another.

Constraints:
\itemize{
\item Must specify a valid system snapshot in the \"available\" state.
\item If the source snapshot is in the same AWS Region as the copy,
specify a valid DB snapshot identifier.
\item If the source snapshot is in a different AWS Region than the copy,
specify a valid DB cluster snapshot ARN. For more information, go to
\href{https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_CopySnapshot.html#USER_CopySnapshot.AcrossRegions}{Copying Snapshots Across AWS Regions}
in the \emph{Amazon Aurora User Guide.}
}

Example: \code{my-cluster-snapshot1}}

\item{TargetDBClusterSnapshotIdentifier}{[required] The identifier of the new DB cluster snapshot to create from the source
DB cluster snapshot. This parameter isn\'t case-sensitive.

Constraints:
\itemize{
\item Must contain from 1 to 63 letters, numbers, or hyphens.
\item First character must be a letter.
\item Can\'t end with a hyphen or contain two consecutive hyphens.
}

Example: \code{my-cluster-snapshot2}}

\item{KmsKeyId}{The AWS KMS key ID for an encrypted DB cluster snapshot. The KMS key ID
is the Amazon Resource Name (ARN), KMS key identifier, or the KMS key
alias for the KMS encryption key.

If you copy an encrypted DB cluster snapshot from your AWS account, you
can specify a value for \code{KmsKeyId} to encrypt the copy with a new KMS
encryption key. If you don\'t specify a value for \code{KmsKeyId}, then the
copy of the DB cluster snapshot is encrypted with the same KMS key as
the source DB cluster snapshot.

If you copy an encrypted DB cluster snapshot that is shared from another
AWS account, then you must specify a value for \code{KmsKeyId}.

To copy an encrypted DB cluster snapshot to another AWS Region, you must
set \code{KmsKeyId} to the KMS key ID you want to use to encrypt the copy of
the DB cluster snapshot in the destination AWS Region. KMS encryption
keys are specific to the AWS Region that they are created in, and you
can\'t use encryption keys from one AWS Region in another AWS Region.

If you copy an unencrypted DB cluster snapshot and specify a value for
the \code{KmsKeyId} parameter, an error is returned.}

\item{PreSignedUrl}{The URL that contains a Signature Version 4 signed request for the
\code{CopyDBClusterSnapshot} API action in the AWS Region that contains the
source DB cluster snapshot to copy. The \code{PreSignedUrl} parameter must be
used when copying an encrypted DB cluster snapshot from another AWS
Region. Don\'t specify \code{PreSignedUrl} when you are copying an encrypted
DB cluster snapshot in the same AWS Region.

The pre-signed URL must be a valid request for the
\code{CopyDBClusterSnapshot} API action that can be executed in the source
AWS Region that contains the encrypted DB cluster snapshot to be copied.
The pre-signed URL request must contain the following parameter values:
\itemize{
\item \code{KmsKeyId} - The AWS KMS key identifier for the key to use to
encrypt the copy of the DB cluster snapshot in the destination AWS
Region. This is the same identifier for both the
\code{CopyDBClusterSnapshot} action that is called in the destination AWS
Region, and the action contained in the pre-signed URL.
\item \code{DestinationRegion} - The name of the AWS Region that the DB cluster
snapshot is to be created in.
\item \code{SourceDBClusterSnapshotIdentifier} - The DB cluster snapshot
identifier for the encrypted DB cluster snapshot to be copied. This
identifier must be in the Amazon Resource Name (ARN) format for the
source AWS Region. For example, if you are copying an encrypted DB
cluster snapshot from the us-west-2 AWS Region, then your
\code{SourceDBClusterSnapshotIdentifier} looks like the following
example:
\code{arn:aws:rds:us-west-2:123456789012:cluster-snapshot:aurora-cluster1-snapshot-20161115}.
}

To learn how to generate a Signature Version 4 signed request, see
\href{https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html}{Authenticating Requests: Using Query Parameters (AWS Signature Version 4)}
and \href{https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html}{Signature Version 4 Signing Process}.

If you are using an AWS SDK tool or the AWS CLI, you can specify
\code{SourceRegion} (or \code{--source-region} for the AWS CLI) instead of
specifying \code{PreSignedUrl} manually. Specifying \code{SourceRegion}
autogenerates a pre-signed URL that is a valid request for the operation
that can be executed in the source AWS Region.

If you supply a value for this operation\'s \code{SourceRegion} parameter, a
pre-signed URL will be calculated on your behalf.}

\item{CopyTags}{A value that indicates whether to copy all tags from the source DB
cluster snapshot to the target DB cluster snapshot. By default, tags are
not copied.}

\item{Tags}{}

\item{SourceRegion}{The ID of the region that contains the snapshot to be copied.}
}
\description{
Copies a snapshot of a DB cluster.
}
\details{
To copy a DB cluster snapshot from a shared manual DB cluster snapshot,
\code{SourceDBClusterSnapshotIdentifier} must be the Amazon Resource Name
(ARN) of the shared DB cluster snapshot.

You can copy an encrypted DB cluster snapshot from another AWS Region.
In that case, the AWS Region where you call the \code{CopyDBClusterSnapshot}
action is the destination AWS Region for the encrypted DB cluster
snapshot to be copied to. To copy an encrypted DB cluster snapshot from
another AWS Region, you must provide the following values:
\itemize{
\item \code{KmsKeyId} - The AWS Key Management System (AWS KMS) key identifier
for the key to use to encrypt the copy of the DB cluster snapshot in
the destination AWS Region.
\item \code{PreSignedUrl} - A URL that contains a Signature Version 4 signed
request for the \code{CopyDBClusterSnapshot} action to be called in the
source AWS Region where the DB cluster snapshot is copied from. The
pre-signed URL must be a valid request for the
\code{CopyDBClusterSnapshot} API action that can be executed in the
source AWS Region that contains the encrypted DB cluster snapshot to
be copied.

The pre-signed URL request must contain the following parameter
values:
\itemize{
\item \code{KmsKeyId} - The KMS key identifier for the key to use to
encrypt the copy of the DB cluster snapshot in the destination
AWS Region. This is the same identifier for both the
\code{CopyDBClusterSnapshot} action that is called in the destination
AWS Region, and the action contained in the pre-signed URL.
\item \code{DestinationRegion} - The name of the AWS Region that the DB
cluster snapshot is to be created in.
\item \code{SourceDBClusterSnapshotIdentifier} - The DB cluster snapshot
identifier for the encrypted DB cluster snapshot to be copied.
This identifier must be in the Amazon Resource Name (ARN) format
for the source AWS Region. For example, if you are copying an
encrypted DB cluster snapshot from the us-west-2 AWS Region,
then your \code{SourceDBClusterSnapshotIdentifier} looks like the
following example:
\code{arn:aws:rds:us-west-2:123456789012:cluster-snapshot:aurora-cluster1-snapshot-20161115}.
}

To learn how to generate a Signature Version 4 signed request, see
\href{https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html}{Authenticating Requests: Using Query Parameters (AWS Signature Version 4)}
and \href{https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html}{Signature Version 4 Signing Process}.

If you are using an AWS SDK tool or the AWS CLI, you can specify
\code{SourceRegion} (or \code{--source-region} for the AWS CLI) instead of
specifying \code{PreSignedUrl} manually. Specifying \code{SourceRegion}
autogenerates a pre-signed URL that is a valid request for the
operation that can be executed in the source AWS Region.
\item \code{TargetDBClusterSnapshotIdentifier} - The identifier for the new
copy of the DB cluster snapshot in the destination AWS Region.
\item \code{SourceDBClusterSnapshotIdentifier} - The DB cluster snapshot
identifier for the encrypted DB cluster snapshot to be copied. This
identifier must be in the ARN format for the source AWS Region and
is the same value as the \code{SourceDBClusterSnapshotIdentifier} in the
pre-signed URL.
}

To cancel the copy operation once it is in progress, delete the target
DB cluster snapshot identified by \code{TargetDBClusterSnapshotIdentifier}
while that DB cluster snapshot is in \"copying\" status.

For more information on copying encrypted DB cluster snapshots from one
AWS Region to another, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_CopySnapshot.html}{Copying a Snapshot}
in the \emph{Amazon Aurora User Guide.}

For more information on Amazon Aurora, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html}{What Is Amazon Aurora?}
in the \emph{Amazon Aurora User Guide.}

This action only applies to Aurora DB clusters.
}
\section{Request syntax}{
\preformatted{svc$copy_db_cluster_snapshot(
  SourceDBClusterSnapshotIdentifier = "string",
  TargetDBClusterSnapshotIdentifier = "string",
  KmsKeyId = "string",
  PreSignedUrl = "string",
  CopyTags = TRUE|FALSE,
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  ),
  SourceRegion = "string"
)
}
}

\keyword{internal}
