% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_modify_certificates}
\alias{rds_modify_certificates}
\title{Override the system-default Secure Sockets Layer/Transport Layer
Security (SSL/TLS) certificate for Amazon RDS for new DB instances, or
remove the override}
\usage{
rds_modify_certificates(
  CertificateIdentifier = NULL,
  RemoveCustomerOverride = NULL
)
}
\arguments{
\item{CertificateIdentifier}{The new default certificate identifier to override the current one with.

To determine the valid values, use the \code{describe-certificates} CLI
command or the \code{\link[=rds_describe_certificates]{describe_certificates}} API
operation.}

\item{RemoveCustomerOverride}{A value that indicates whether to remove the override for the default
certificate. If the override is removed, the default certificate is the
system default.}
}
\description{
Override the system-default Secure Sockets Layer/Transport Layer Security (SSL/TLS) certificate for Amazon RDS for new DB instances, or remove the override.

See \url{https://paws-r.github.io/docs/rds/modify_certificates.html} for full documentation.
}
\keyword{internal}
