% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qldb_operations.R
\name{qldb_update_ledger}
\alias{qldb_update_ledger}
\title{Updates properties on a ledger}
\usage{
qldb_update_ledger(Name, DeletionProtection = NULL, KmsKey = NULL)
}
\arguments{
\item{Name}{[required] The name of the ledger.}

\item{DeletionProtection}{Specifies whether the ledger is protected from being deleted by any
user. If not defined during ledger creation, this feature is enabled
(\code{true}) by default.

If deletion protection is enabled, you must first disable it before you
can delete the ledger. You can disable it by calling the
\code{\link[=qldb_update_ledger]{update_ledger}} operation to set this parameter to
\code{false}.}

\item{KmsKey}{The key in Key Management Service (KMS) to use for encryption of data at
rest in the ledger. For more information, see \href{https://docs.aws.amazon.com/qldb/latest/developerguide/encryption-at-rest.html}{Encryption at rest}
in the \emph{Amazon QLDB Developer Guide}.

Use one of the following options to specify this parameter:
\itemize{
\item \code{AWS_OWNED_KMS_KEY}: Use an KMS key that is owned and managed by
Amazon Web Services on your behalf.
\item \strong{Undefined}: Make no changes to the KMS key of the ledger.
\item \strong{A valid symmetric customer managed KMS key}: Use the specified
symmetric encryption KMS key in your account that you create, own,
and manage.

Amazon QLDB does not support asymmetric keys. For more information,
see \href{https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html}{Using symmetric and asymmetric keys}
in the \emph{Key Management Service Developer Guide}.
}

To specify a customer managed KMS key, you can use its key ID, Amazon
Resource Name (ARN), alias name, or alias ARN. When using an alias name,
prefix it with \code{"alias/"}. To specify a key in a different Amazon Web
Services account, you must use the key ARN or alias ARN.

For example:
\itemize{
\item Key ID: \verb{1234abcd-12ab-34cd-56ef-1234567890ab}
\item Key ARN:
\verb{arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab}
\item Alias name: \code{alias/ExampleAlias}
\item Alias ARN: \code{arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias}
}

For more information, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id}{Key identifiers (KeyId)}
in the \emph{Key Management Service Developer Guide}.}
}
\description{
Updates properties on a ledger.

See \url{https://www.paws-r-sdk.com/docs/qldb_update_ledger/} for full documentation.
}
\keyword{internal}
