% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_modify_custom_db_engine_version}
\alias{rds_modify_custom_db_engine_version}
\title{Modifies the status of a custom engine version (CEV)}
\usage{
rds_modify_custom_db_engine_version(
  Engine,
  EngineVersion,
  Description = NULL,
  Status = NULL
)
}
\arguments{
\item{Engine}{[required] The DB engine. The only supported values are \code{custom-oracle-ee} and
\code{custom-oracle-ee-cdb}.}

\item{EngineVersion}{[required] The custom engine version (CEV) that you want to modify. This option is
required for RDS Custom for Oracle, but optional for Amazon RDS. The
combination of \code{Engine} and \code{EngineVersion} is unique per customer per
Amazon Web Services Region.}

\item{Description}{An optional description of your CEV.}

\item{Status}{The availability status to be assigned to the CEV. Valid values are as
follows:

\strong{available}

You can use this CEV to create a new RDS Custom DB instance.

\strong{inactive}

You can create a new RDS Custom instance by restoring a DB snapshot with
this CEV. You can't patch or create new instances with this CEV.

You can change any status to any status. A typical reason to change
status is to prevent the accidental use of a CEV, or to make a
deprecated CEV eligible for use again. For example, you might change the
status of your CEV from \code{available} to \code{inactive}, and from \code{inactive}
back to \code{available}. To change the availability status of the CEV, it
must not currently be in use by an RDS Custom instance, snapshot, or
automated backup.}
}
\description{
Modifies the status of a custom engine version (CEV). You can find CEVs to modify by calling \code{\link[=rds_describe_db_engine_versions]{describe_db_engine_versions}}.

See \url{https://www.paws-r-sdk.com/docs/rds_modify_custom_db_engine_version/} for full documentation.
}
\keyword{internal}
