% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_describe_event_subscriptions}
\alias{rds_describe_event_subscriptions}
\title{Lists all the subscription descriptions for a customer account}
\usage{
rds_describe_event_subscriptions(
  SubscriptionName = NULL,
  Filters = NULL,
  MaxRecords = NULL,
  Marker = NULL
)
}
\arguments{
\item{SubscriptionName}{The name of the RDS event notification subscription you want to
describe.}

\item{Filters}{This parameter isn't currently supported.}

\item{MaxRecords}{The maximum number of records to include in the response. If more
records exist than the specified \code{MaxRecords} value, a pagination token
called a marker is included in the response so that you can retrieve the
remaining results.

Default: 100

Constraints: Minimum 20, maximum 100.}

\item{Marker}{An optional pagination token provided by a previous
DescribeOrderableDBInstanceOptions request. If this parameter is
specified, the response includes only records beyond the marker, up to
the value specified by \code{MaxRecords} .}
}
\description{
Lists all the subscription descriptions for a customer account. The description for a subscription includes \code{SubscriptionName}, \code{SNSTopicARN}, \code{CustomerID}, \code{SourceType}, \code{SourceID}, \code{CreationTime}, and \code{Status}.

See \url{https://www.paws-r-sdk.com/docs/rds_describe_event_subscriptions/} for full documentation.
}
\keyword{internal}
