% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codebuild_operations.R
\name{codebuild_list_build_batches}
\alias{codebuild_list_build_batches}
\title{Retrieves the identifiers of your build batches in the current region}
\usage{
codebuild_list_build_batches(filter, maxResults, sortOrder, nextToken)
}
\arguments{
\item{filter}{A \code{BuildBatchFilter} object that specifies the filters for the search.}

\item{maxResults}{The maximum number of results to return.}

\item{sortOrder}{Specifies the sort order of the returned items. Valid values include:
\itemize{
\item \code{ASCENDING}: List the batch build identifiers in ascending order by
identifier.
\item \code{DESCENDING}: List the batch build identifiers in descending order
by identifier.
}}

\item{nextToken}{The \code{nextToken} value returned from a previous call to
\code{\link[=codebuild_list_build_batches]{list_build_batches}}. This specifies the
next item to return. To return the beginning of the list, exclude this
parameter.}
}
\value{
A list with the following syntax:\preformatted{list(
  ids = list(
    "string"
  ),
  nextToken = "string"
)
}
}
\description{
Retrieves the identifiers of your build batches in the current region.
}
\section{Request syntax}{
\preformatted{svc$list_build_batches(
  filter = list(
    status = "SUCCEEDED"|"FAILED"|"FAULT"|"TIMED_OUT"|"IN_PROGRESS"|"STOPPED"
  ),
  maxResults = 123,
  sortOrder = "ASCENDING"|"DESCENDING",
  nextToken = "string"
)
}
}

\keyword{internal}
