% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codebuild_operations.R
\name{codebuild_list_reports_for_report_group}
\alias{codebuild_list_reports_for_report_group}
\title{Returns a list of ARNs for the reports that belong to a ReportGroup}
\usage{
codebuild_list_reports_for_report_group(reportGroupArn, nextToken,
  sortOrder, maxResults, filter)
}
\arguments{
\item{reportGroupArn}{[required] The ARN of the report group for which you want to return report ARNs.}

\item{nextToken}{During a previous call, the maximum number of items that can be returned
is the value specified in \code{maxResults}. If there more items in the list,
then a unique string called a \emph{nextToken} is returned. To get the next
batch of items in the list, call this operation again, adding the next
token to the call. To get all of the items in the list, keep calling
this operation with each subsequent next token that is returned, until
no more next tokens are returned.}

\item{sortOrder}{Use to specify whether the results are returned in ascending or
descending order.}

\item{maxResults}{The maximum number of paginated reports in this report group returned
per response. Use \code{nextToken} to iterate pages in the list of returned
\code{Report} objects. The default value is 100.}

\item{filter}{A \code{ReportFilter} object used to filter the returned reports.}
}
\value{
A list with the following syntax:\preformatted{list(
  nextToken = "string",
  reports = list(
    "string"
  )
)
}
}
\description{
Returns a list of ARNs for the reports that belong to a \code{ReportGroup}.
}
\section{Request syntax}{
\preformatted{svc$list_reports_for_report_group(
  reportGroupArn = "string",
  nextToken = "string",
  sortOrder = "ASCENDING"|"DESCENDING",
  maxResults = 123,
  filter = list(
    status = "GENERATING"|"SUCCEEDED"|"FAILED"|"INCOMPLETE"|"DELETING"
  )
)
}
}

\keyword{internal}
