% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codecommit_operations.R
\name{codecommit_batch_get_commits}
\alias{codecommit_batch_get_commits}
\title{Returns information about the contents of one or more commits in a
repository}
\usage{
codecommit_batch_get_commits(commitIds, repositoryName)
}
\arguments{
\item{commitIds}{[required] The full commit IDs of the commits to get information about.

You must supply the full SHA IDs of each commit. You cannot use
shortened SHA IDs.}

\item{repositoryName}{[required] The name of the repository that contains the commits.}
}
\value{
A list with the following syntax:\preformatted{list(
  commits = list(
    list(
      commitId = "string",
      treeId = "string",
      parents = list(
        "string"
      ),
      message = "string",
      author = list(
        name = "string",
        email = "string",
        date = "string"
      ),
      committer = list(
        name = "string",
        email = "string",
        date = "string"
      ),
      additionalData = "string"
    )
  ),
  errors = list(
    list(
      commitId = "string",
      errorCode = "string",
      errorMessage = "string"
    )
  )
)
}
}
\description{
Returns information about the contents of one or more commits in a
repository.
}
\section{Request syntax}{
\preformatted{svc$batch_get_commits(
  commitIds = list(
    "string"
  ),
  repositoryName = "string"
)
}
}

\keyword{internal}
