% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codestar_operations.R
\name{codestar_update_user_profile}
\alias{codestar_update_user_profile}
\title{Updates a user's profile in AWS CodeStar}
\usage{
codestar_update_user_profile(userArn, displayName, emailAddress,
  sshPublicKey)
}
\arguments{
\item{userArn}{[required] The name that will be displayed as the friendly name for the user in AWS
CodeStar.}

\item{displayName}{The name that is displayed as the friendly name for the user in AWS
CodeStar.}

\item{emailAddress}{The email address that is displayed as part of the user's profile in AWS
CodeStar.}

\item{sshPublicKey}{The SSH public key associated with the user in AWS CodeStar. If a
project owner allows the user remote access to project resources, this
public key will be used along with the user's private key for SSH
access.}
}
\value{
A list with the following syntax:\preformatted{list(
  userArn = "string",
  displayName = "string",
  emailAddress = "string",
  sshPublicKey = "string",
  createdTimestamp = as.POSIXct(
    "2015-01-01"
  ),
  lastModifiedTimestamp = as.POSIXct(
    "2015-01-01"
  )
)
}
}
\description{
Updates a user's profile in AWS CodeStar. The user profile is not
project-specific. Information in the user profile is displayed wherever
the user's information appears to other users in AWS CodeStar.
}
\section{Request syntax}{
\preformatted{svc$update_user_profile(
  userArn = "string",
  displayName = "string",
  emailAddress = "string",
  sshPublicKey = "string"
)
}
}

\keyword{internal}
