% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codeartifact_operations.R
\name{codeartifact_create_repository}
\alias{codeartifact_create_repository}
\title{Creates a repository}
\usage{
codeartifact_create_repository(
  domain,
  domainOwner = NULL,
  repository,
  description = NULL,
  upstreams = NULL,
  tags = NULL
)
}
\arguments{
\item{domain}{[required] The name of the domain that contains the created repository.}

\item{domainOwner}{The 12-digit account number of the Amazon Web Services account that owns
the domain. It does not include dashes or spaces.}

\item{repository}{[required] The name of the repository to create.}

\item{description}{A description of the created repository.}

\item{upstreams}{A list of upstream repositories to associate with the repository. The
order of the upstream repositories in the list determines their priority
order when CodeArtifact looks for a requested package version. For more
information, see \href{https://docs.aws.amazon.com/codeartifact/latest/ug/repos-upstream.html}{Working with upstream repositories}.}

\item{tags}{One or more tag key-value pairs for the repository.}
}
\description{
Creates a repository.

See \url{https://paws-r.github.io/docs/codeartifact/create_repository.html} for full documentation.
}
\keyword{internal}
