# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config
NULL

#' AWS Cloud Control API
#'
#' @description
#' For more information about Amazon Web Services Cloud Control API, see
#' the [Amazon Web Services Cloud Control API User
#' Guide](https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/what-is-cloudcontrolapi.html).
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{access_key_id}:} {AWS access key ID}
#' \item{\strong{secret_access_key}:} {AWS secret access key}
#' \item{\strong{session_token}:} {AWS temporary session token}
#' \item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}:} {Set anonymous credentials.}
#' \item{\strong{endpoint}:} {The complete URL to use for the constructed client.}
#' \item{\strong{region}:} {The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}:} {Immediately close all HTTP connections.}
#' \item{\strong{timeout}:} {The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}:} {Set this to `true` to force the request to use path-style addressing, i.e., `http://s3.amazonaws.com/BUCKET/KEY`.}
#' }
#'
#' @section Service syntax:
#' ```
#' svc <- cloudcontrolapi(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- cloudcontrolapi()
#' svc$cancel_resource_request(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=cloudcontrolapi_cancel_resource_request]{cancel_resource_request} \tab Cancels the specified resource operation request\cr
#'  \link[=cloudcontrolapi_create_resource]{create_resource} \tab Creates the specified resource\cr
#'  \link[=cloudcontrolapi_delete_resource]{delete_resource} \tab Deletes the specified resource\cr
#'  \link[=cloudcontrolapi_get_resource]{get_resource} \tab Returns information about the current state of the specified resource\cr
#'  \link[=cloudcontrolapi_get_resource_request_status]{get_resource_request_status} \tab Returns the current status of a resource operation request\cr
#'  \link[=cloudcontrolapi_list_resource_requests]{list_resource_requests} \tab Returns existing resource operation requests\cr
#'  \link[=cloudcontrolapi_list_resources]{list_resources} \tab Returns information about the specified resources\cr
#'  \link[=cloudcontrolapi_update_resource]{update_resource} \tab Updates the specified property values in the resource
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname cloudcontrolapi
#' @export
cloudcontrolapi <- function(config = list()) {
  svc <- .cloudcontrolapi$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.cloudcontrolapi <- list()

.cloudcontrolapi$operations <- list()

.cloudcontrolapi$metadata <- list(
  service_name = "cloudcontrolapi",
  endpoints = list("*" = list(endpoint = "cloudcontrolapi.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "cloudcontrolapi.{region}.amazonaws.com.cn", global = FALSE), "us-iso-*" = list(endpoint = "cloudcontrolapi.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "cloudcontrolapi.{region}.sc2s.sgov.gov", global = FALSE)),
  service_id = "CloudControl",
  api_version = "2021-09-30",
  signing_name = "cloudcontrolapi",
  json_version = "1.0",
  target_prefix = "CloudApiService"
)

.cloudcontrolapi$service <- function(config = list()) {
  handlers <- new_handlers("jsonrpc", "v4")
  new_service(.cloudcontrolapi$metadata, handlers, config)
}
