% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codeartifact_operations.R
\name{codeartifact_describe_package}
\alias{codeartifact_describe_package}
\title{Returns a PackageDescription object that contains information about the
requested package}
\usage{
codeartifact_describe_package(
  domain,
  domainOwner = NULL,
  repository,
  format,
  namespace = NULL,
  package
)
}
\arguments{
\item{domain}{[required] The name of the domain that contains the repository that contains the
package.}

\item{domainOwner}{The 12-digit account number of the Amazon Web Services account that owns
the domain. It does not include dashes or spaces.}

\item{repository}{[required] The name of the repository that contains the requested package.}

\item{format}{[required] A format that specifies the type of the requested package.}

\item{namespace}{The namespace of the requested package. The package component that
specifies its namespace depends on its type. For example:
\itemize{
\item The namespace of a Maven package is its \code{groupId}. The namespace is
required when requesting Maven packages.
\item The namespace of an npm package is its \code{scope}.
\item Python and NuGet packages do not contain a corresponding component,
packages of those formats do not have a namespace.
\item The namespace of a generic package is its \code{namespace}.
}}

\item{package}{[required] The name of the requested package.}
}
\description{
Returns a \href{https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageDescription.html}{PackageDescription} object that contains information about the requested package.

See \url{https://www.paws-r-sdk.com/docs/codeartifact_describe_package/} for full documentation.
}
\keyword{internal}
