% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_create_flow_definition}
\alias{sagemaker_create_flow_definition}
\title{Creates a flow definition}
\usage{
sagemaker_create_flow_definition(FlowDefinitionName,
  HumanLoopRequestSource, HumanLoopActivationConfig, HumanLoopConfig,
  OutputConfig, RoleArn, Tags)
}
\arguments{
\item{FlowDefinitionName}{[required] The name of your flow definition.}

\item{HumanLoopRequestSource}{Container for configuring the source of human task requests. Use to
specify if Amazon Rekognition or Amazon Textract is used as an
integration source.}

\item{HumanLoopActivationConfig}{An object containing information about the events that trigger a human
workflow.}

\item{HumanLoopConfig}{[required] An object containing information about the tasks the human reviewers
will perform.}

\item{OutputConfig}{[required] An object containing information about where the human review results
will be uploaded.}

\item{RoleArn}{[required] The Amazon Resource Name (ARN) of the role needed to call other services
on your behalf. For example,
\verb{arn:aws:iam::1234567890:role/service-role/AmazonSageMaker-ExecutionRole-20180111T151298}.}

\item{Tags}{An array of key-value pairs that contain metadata to help you categorize
and organize a flow definition. Each tag consists of a key and a value,
both of which you define.}
}
\value{
A list with the following syntax:\preformatted{list(
  FlowDefinitionArn = "string"
)
}
}
\description{
Creates a flow definition.
}
\section{Request syntax}{
\preformatted{svc$create_flow_definition(
  FlowDefinitionName = "string",
  HumanLoopRequestSource = list(
    AwsManagedHumanLoopRequestSource = "AWS/Rekognition/DetectModerationLabels/Image/V3"|"AWS/Textract/AnalyzeDocument/Forms/V1"
  ),
  HumanLoopActivationConfig = list(
    HumanLoopActivationConditionsConfig = list(
      HumanLoopActivationConditions = "string"
    )
  ),
  HumanLoopConfig = list(
    WorkteamArn = "string",
    HumanTaskUiArn = "string",
    TaskTitle = "string",
    TaskDescription = "string",
    TaskCount = 123,
    TaskAvailabilityLifetimeInSeconds = 123,
    TaskTimeLimitInSeconds = 123,
    TaskKeywords = list(
      "string"
    ),
    PublicWorkforceTaskPrice = list(
      AmountInUsd = list(
        Dollars = 123,
        Cents = 123,
        TenthFractionsOfACent = 123
      )
    )
  ),
  OutputConfig = list(
    S3OutputPath = "string",
    KmsKeyId = "string"
  ),
  RoleArn = "string",
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
