% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/translate_operations.R
\name{translate_get_parallel_data}
\alias{translate_get_parallel_data}
\title{Provides information about a parallel data resource}
\usage{
translate_get_parallel_data(Name)
}
\arguments{
\item{Name}{[required] The name of the parallel data resource that is being retrieved.}
}
\value{
A list with the following syntax:\preformatted{list(
  ParallelDataProperties = list(
    Name = "string",
    Arn = "string",
    Description = "string",
    Status = "CREATING"|"UPDATING"|"ACTIVE"|"DELETING"|"FAILED",
    SourceLanguageCode = "string",
    TargetLanguageCodes = list(
      "string"
    ),
    ParallelDataConfig = list(
      S3Uri = "string",
      Format = "TSV"|"CSV"|"TMX"
    ),
    Message = "string",
    ImportedDataSize = 123,
    ImportedRecordCount = 123,
    FailedRecordCount = 123,
    SkippedRecordCount = 123,
    EncryptionKey = list(
      Type = "KMS",
      Id = "string"
    ),
    CreatedAt = as.POSIXct(
      "2015-01-01"
    ),
    LastUpdatedAt = as.POSIXct(
      "2015-01-01"
    ),
    LatestUpdateAttemptStatus = "CREATING"|"UPDATING"|"ACTIVE"|"DELETING"|"FAILED",
    LatestUpdateAttemptAt = as.POSIXct(
      "2015-01-01"
    )
  ),
  DataLocation = list(
    RepositoryType = "string",
    Location = "string"
  ),
  AuxiliaryDataLocation = list(
    RepositoryType = "string",
    Location = "string"
  ),
  LatestUpdateAttemptAuxiliaryDataLocation = list(
    RepositoryType = "string",
    Location = "string"
  )
)
}
}
\description{
Provides information about a parallel data resource.
}
\section{Request syntax}{
\preformatted{svc$get_parallel_data(
  Name = "string"
)
}
}

\keyword{internal}
