% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transcribeservice_operations.R
\name{transcribeservice_update_vocabulary_filter}
\alias{transcribeservice_update_vocabulary_filter}
\title{Updates a vocabulary filter with a new list of filtered words}
\usage{
transcribeservice_update_vocabulary_filter(VocabularyFilterName, Words,
  VocabularyFilterFileUri)
}
\arguments{
\item{VocabularyFilterName}{[required] The name of the vocabulary filter to update. If you try to update a
vocabulary filter with the same name as a previous vocabulary filter you
will receive a \code{ConflictException} error.}

\item{Words}{The words to use in the vocabulary filter. Only use characters from the
character set defined for custom vocabularies. For a list of character
sets, see \href{https://docs.aws.amazon.com/transcribe/latest/dg/how-vocabulary.html#charsets}{Character Sets for Custom Vocabularies}.

If you provide a list of words in the \code{Words} parameter, you can\'t use
the \code{VocabularyFilterFileUri} parameter.}

\item{VocabularyFilterFileUri}{The Amazon S3 location of a text file used as input to create the
vocabulary filter. Only use characters from the character set defined
for custom vocabularies. For a list of character sets, see \href{https://docs.aws.amazon.com/transcribe/latest/dg/how-vocabulary.html#charsets}{Character Sets for Custom Vocabularies}.

The specified file must be less than 50 KB of UTF-8 characters.

If you provide the location of a list of words in the
\code{VocabularyFilterFileUri} parameter, you can\'t use the \code{Words}
parameter.}
}
\description{
Updates a vocabulary filter with a new list of filtered words.
}
\section{Request syntax}{
\preformatted{svc$update_vocabulary_filter(
  VocabularyFilterName = "string",
  Words = list(
    "string"
  ),
  VocabularyFilterFileUri = "string"
)
}
}

\keyword{internal}
