# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include sagemaker_service.R
NULL

#' Creates an association between the source and the destination
#'
#' @description
#' Creates an *association* between the source and the destination. A source can be associated with multiple destinations, and a destination can be associated with multiple sources. An association is a lineage tracking entity. For more information, see [Amazon SageMaker ML Lineage Tracking](https://docs.aws.amazon.com/sagemaker/latest/dg/lineage-tracking.html).
#'
#' See [https://paws-r.github.io/docs/sagemaker/add_association.html](https://paws-r.github.io/docs/sagemaker/add_association.html) for full documentation.
#'
#' @param SourceArn &#91;required&#93; The ARN of the source.
#' @param DestinationArn &#91;required&#93; The Amazon Resource Name (ARN) of the destination.
#' @param AssociationType The type of association. The following are suggested uses for each type.
#' Amazon SageMaker places no restrictions on their use.
#' 
#' -   ContributedTo - The source contributed to the destination or had a
#'     part in enabling the destination. For example, the training data
#'     contributed to the training job.
#' 
#' -   AssociatedWith - The source is connected to the destination. For
#'     example, an approval workflow is associated with a model deployment.
#' 
#' -   DerivedFrom - The destination is a modification of the source. For
#'     example, a digest output of a channel input for a processing job is
#'     derived from the original inputs.
#' 
#' -   Produced - The source generated the destination. For example, a
#'     training job produced a model artifact.
#'
#' @keywords internal
#'
#' @rdname sagemaker_add_association
sagemaker_add_association <- function(SourceArn, DestinationArn, AssociationType = NULL) {
  op <- new_operation(
    name = "AddAssociation",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$add_association_input(SourceArn = SourceArn, DestinationArn = DestinationArn, AssociationType = AssociationType)
  output <- .sagemaker$add_association_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$add_association <- sagemaker_add_association

#' Adds or overwrites one or more tags for the specified SageMaker resource
#'
#' @description
#' Adds or overwrites one or more tags for the specified SageMaker resource. You can add tags to notebook instances, training jobs, hyperparameter tuning jobs, batch transform jobs, models, labeling jobs, work teams, endpoint configurations, and endpoints.
#'
#' See [https://paws-r.github.io/docs/sagemaker/add_tags.html](https://paws-r.github.io/docs/sagemaker/add_tags.html) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource that you want to tag.
#' @param Tags &#91;required&#93; An array of key-value pairs. You can use tags to categorize your Amazon
#' Web Services resources in different ways, for example, by purpose,
#' owner, or environment. For more information, see [Tagging Amazon Web
#' Services
#' Resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html).
#'
#' @keywords internal
#'
#' @rdname sagemaker_add_tags
sagemaker_add_tags <- function(ResourceArn, Tags) {
  op <- new_operation(
    name = "AddTags",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$add_tags_input(ResourceArn = ResourceArn, Tags = Tags)
  output <- .sagemaker$add_tags_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$add_tags <- sagemaker_add_tags

#' Associates a trial component with a trial
#'
#' @description
#' Associates a trial component with a trial. A trial component can be associated with multiple trials. To disassociate a trial component from a trial, call the [`disassociate_trial_component`][sagemaker_disassociate_trial_component] API.
#'
#' See [https://paws-r.github.io/docs/sagemaker/associate_trial_component.html](https://paws-r.github.io/docs/sagemaker/associate_trial_component.html) for full documentation.
#'
#' @param TrialComponentName &#91;required&#93; The name of the component to associated with the trial.
#' @param TrialName &#91;required&#93; The name of the trial to associate with.
#'
#' @keywords internal
#'
#' @rdname sagemaker_associate_trial_component
sagemaker_associate_trial_component <- function(TrialComponentName, TrialName) {
  op <- new_operation(
    name = "AssociateTrialComponent",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$associate_trial_component_input(TrialComponentName = TrialComponentName, TrialName = TrialName)
  output <- .sagemaker$associate_trial_component_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$associate_trial_component <- sagemaker_associate_trial_component

#' This action batch describes a list of versioned model packages
#'
#' @description
#' This action batch describes a list of versioned model packages
#'
#' See [https://paws-r.github.io/docs/sagemaker/batch_describe_model_package.html](https://paws-r.github.io/docs/sagemaker/batch_describe_model_package.html) for full documentation.
#'
#' @param ModelPackageArnList &#91;required&#93; The list of Amazon Resource Name (ARN) of the model package groups.
#'
#' @keywords internal
#'
#' @rdname sagemaker_batch_describe_model_package
sagemaker_batch_describe_model_package <- function(ModelPackageArnList) {
  op <- new_operation(
    name = "BatchDescribeModelPackage",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$batch_describe_model_package_input(ModelPackageArnList = ModelPackageArnList)
  output <- .sagemaker$batch_describe_model_package_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$batch_describe_model_package <- sagemaker_batch_describe_model_package

#' Creates an action
#'
#' @description
#' Creates an *action*. An action is a lineage tracking entity that represents an action or activity. For example, a model deployment or an HPO job. Generally, an action involves at least one input or output artifact. For more information, see [Amazon SageMaker ML Lineage Tracking](https://docs.aws.amazon.com/sagemaker/latest/dg/lineage-tracking.html).
#'
#' See [https://paws-r.github.io/docs/sagemaker/create_action.html](https://paws-r.github.io/docs/sagemaker/create_action.html) for full documentation.
#'
#' @param ActionName &#91;required&#93; The name of the action. Must be unique to your account in an Amazon Web
#' Services Region.
#' @param Source &#91;required&#93; The source type, ID, and URI.
#' @param ActionType &#91;required&#93; The action type.
#' @param Description The description of the action.
#' @param Status The status of the action.
#' @param Properties A list of properties to add to the action.
#' @param MetadataProperties 
#' @param Tags A list of tags to apply to the action.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_action
sagemaker_create_action <- function(ActionName, Source, ActionType, Description = NULL, Status = NULL, Properties = NULL, MetadataProperties = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateAction",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$create_action_input(ActionName = ActionName, Source = Source, ActionType = ActionType, Description = Description, Status = Status, Properties = Properties, MetadataProperties = MetadataProperties, Tags = Tags)
  output <- .sagemaker$create_action_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_action <- sagemaker_create_action

#' Create a machine learning algorithm that you can use in SageMaker and
#' list in the Amazon Web Services Marketplace
#'
#' @description
#' Create a machine learning algorithm that you can use in SageMaker and list in the Amazon Web Services Marketplace.
#'
#' See [https://paws-r.github.io/docs/sagemaker/create_algorithm.html](https://paws-r.github.io/docs/sagemaker/create_algorithm.html) for full documentation.
#'
#' @param AlgorithmName &#91;required&#93; The name of the algorithm.
#' @param AlgorithmDescription A description of the algorithm.
#' @param TrainingSpecification &#91;required&#93; Specifies details about training jobs run by this algorithm, including
#' the following:
#' 
#' -   The Amazon ECR path of the container and the version digest of the
#'     algorithm.
#' 
#' -   The hyperparameters that the algorithm supports.
#' 
#' -   The instance types that the algorithm supports for training.
#' 
#' -   Whether the algorithm supports distributed training.
#' 
#' -   The metrics that the algorithm emits to Amazon CloudWatch.
#' 
#' -   Which metrics that the algorithm emits can be used as the objective
#'     metric for hyperparameter tuning jobs.
#' 
#' -   The input channels that the algorithm supports for training data.
#'     For example, an algorithm might support `train`, `validation`, and
#'     `test` channels.
#' @param InferenceSpecification Specifies details about inference jobs that the algorithm runs,
#' including the following:
#' 
#' -   The Amazon ECR paths of containers that contain the inference code
#'     and model artifacts.
#' 
#' -   The instance types that the algorithm supports for transform jobs
#'     and real-time endpoints used for inference.
#' 
#' -   The input and output content formats that the algorithm supports for
#'     inference.
#' @param ValidationSpecification Specifies configurations for one or more training jobs and that
#' SageMaker runs to test the algorithm's training code and, optionally,
#' one or more batch transform jobs that SageMaker runs to test the
#' algorithm's inference code.
#' @param CertifyForMarketplace Whether to certify the algorithm so that it can be listed in Amazon Web
#' Services Marketplace.
#' @param Tags An array of key-value pairs. You can use tags to categorize your Amazon
#' Web Services resources in different ways, for example, by purpose,
#' owner, or environment. For more information, see [Tagging Amazon Web
#' Services
#' Resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html).
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_algorithm
sagemaker_create_algorithm <- function(AlgorithmName, AlgorithmDescription = NULL, TrainingSpecification, InferenceSpecification = NULL, ValidationSpecification = NULL, CertifyForMarketplace = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateAlgorithm",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$create_algorithm_input(AlgorithmName = AlgorithmName, AlgorithmDescription = AlgorithmDescription, TrainingSpecification = TrainingSpecification, InferenceSpecification = InferenceSpecification, ValidationSpecification = ValidationSpecification, CertifyForMarketplace = CertifyForMarketplace, Tags = Tags)
  output <- .sagemaker$create_algorithm_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_algorithm <- sagemaker_create_algorithm

#' Creates a running app for the specified UserProfile
#'
#' @description
#' Creates a running app for the specified UserProfile. Supported apps are `JupyterServer` and `KernelGateway`. This operation is automatically invoked by Amazon SageMaker Studio upon access to the associated Domain, and when new kernel configurations are selected by the user. A user may have multiple Apps active simultaneously.
#'
#' See [https://paws-r.github.io/docs/sagemaker/create_app.html](https://paws-r.github.io/docs/sagemaker/create_app.html) for full documentation.
#'
#' @param DomainId &#91;required&#93; The domain ID.
#' @param UserProfileName &#91;required&#93; The user profile name.
#' @param AppType &#91;required&#93; The type of app. Supported apps are `JupyterServer` and `KernelGateway`.
#' `TensorBoard` is not supported.
#' @param AppName &#91;required&#93; The name of the app.
#' @param Tags Each tag consists of a key and an optional value. Tag keys must be
#' unique per resource.
#' @param ResourceSpec The instance type and the Amazon Resource Name (ARN) of the SageMaker
#' image created on the instance.
#' 
#' The value of `InstanceType` passed as part of the `ResourceSpec` in the
#' [`create_app`][sagemaker_create_app] call overrides the value passed as
#' part of the `ResourceSpec` configured for the user profile or the
#' domain. If `InstanceType` is not specified in any of those three
#' `ResourceSpec` values for a `KernelGateway` app, the
#' [`create_app`][sagemaker_create_app] call fails with a request
#' validation error.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_app
sagemaker_create_app <- function(DomainId, UserProfileName, AppType, AppName, Tags = NULL, ResourceSpec = NULL) {
  op <- new_operation(
    name = "CreateApp",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$create_app_input(DomainId = DomainId, UserProfileName = UserProfileName, AppType = AppType, AppName = AppName, Tags = Tags, ResourceSpec = ResourceSpec)
  output <- .sagemaker$create_app_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_app <- sagemaker_create_app

#' Creates a configuration for running a SageMaker image as a KernelGateway
#' app
#'
#' @description
#' Creates a configuration for running a SageMaker image as a KernelGateway app. The configuration specifies the Amazon Elastic File System (EFS) storage volume on the image, and a list of the kernels in the image.
#'
#' See [https://paws-r.github.io/docs/sagemaker/create_app_image_config.html](https://paws-r.github.io/docs/sagemaker/create_app_image_config.html) for full documentation.
#'
#' @param AppImageConfigName &#91;required&#93; The name of the AppImageConfig. Must be unique to your account.
#' @param Tags A list of tags to apply to the AppImageConfig.
#' @param KernelGatewayImageConfig The KernelGatewayImageConfig. You can only specify one image kernel in
#' the AppImageConfig API. This kernel will be shown to users before the
#' image starts. Once the image runs, all kernels are visible in
#' JupyterLab.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_app_image_config
sagemaker_create_app_image_config <- function(AppImageConfigName, Tags = NULL, KernelGatewayImageConfig = NULL) {
  op <- new_operation(
    name = "CreateAppImageConfig",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$create_app_image_config_input(AppImageConfigName = AppImageConfigName, Tags = Tags, KernelGatewayImageConfig = KernelGatewayImageConfig)
  output <- .sagemaker$create_app_image_config_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_app_image_config <- sagemaker_create_app_image_config

#' Creates an artifact
#'
#' @description
#' Creates an *artifact*. An artifact is a lineage tracking entity that represents a URI addressable object or data. Some examples are the S3 URI of a dataset and the ECR registry path of an image. For more information, see [Amazon SageMaker ML Lineage Tracking](https://docs.aws.amazon.com/sagemaker/latest/dg/lineage-tracking.html).
#'
#' See [https://paws-r.github.io/docs/sagemaker/create_artifact.html](https://paws-r.github.io/docs/sagemaker/create_artifact.html) for full documentation.
#'
#' @param ArtifactName The name of the artifact. Must be unique to your account in an Amazon
#' Web Services Region.
#' @param Source &#91;required&#93; The ID, ID type, and URI of the source.
#' @param ArtifactType &#91;required&#93; The artifact type.
#' @param Properties A list of properties to add to the artifact.
#' @param MetadataProperties 
#' @param Tags A list of tags to apply to the artifact.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_artifact
sagemaker_create_artifact <- function(ArtifactName = NULL, Source, ArtifactType, Properties = NULL, MetadataProperties = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateArtifact",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$create_artifact_input(ArtifactName = ArtifactName, Source = Source, ArtifactType = ArtifactType, Properties = Properties, MetadataProperties = MetadataProperties, Tags = Tags)
  output <- .sagemaker$create_artifact_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_artifact <- sagemaker_create_artifact

#' Creates an Autopilot job
#'
#' @description
#' Creates an Autopilot job.
#'
#' See [https://paws-r.github.io/docs/sagemaker/create_auto_ml_job.html](https://paws-r.github.io/docs/sagemaker/create_auto_ml_job.html) for full documentation.
#'
#' @param AutoMLJobName &#91;required&#93; Identifies an Autopilot job. The name must be unique to your account and
#' is case-insensitive.
#' @param InputDataConfig &#91;required&#93; An array of channel objects that describes the input data and its
#' location. Each channel is a named input source. Similar to
#' `InputDataConfig` supported by . Format(s) supported: CSV, Parquet. A
#' minimum of 500 rows is required for the training dataset. There is not a
#' minimum number of rows required for the validation dataset.
#' @param OutputDataConfig &#91;required&#93; Provides information about encryption and the Amazon S3 output path
#' needed to store artifacts from an AutoML job. Format(s) supported: CSV.
#' @param ProblemType Defines the type of supervised learning available for the candidates.
#' For more information, see [Amazon SageMaker Autopilot problem types and
#' algorithm support](https://docs.aws.amazon.com/sagemaker/latest/dg/).
#' @param AutoMLJobObjective Defines the objective metric used to measure the predictive quality of
#' an AutoML job. You provide an AutoMLJobObjective$MetricName and
#' Autopilot infers whether to minimize or maximize it.
#' @param AutoMLJobConfig A collection of settings used to configure an AutoML job.
#' @param RoleArn &#91;required&#93; The ARN of the role that is used to access the data.
#' @param GenerateCandidateDefinitionsOnly Generates possible candidates without training the models. A candidate
#' is a combination of data preprocessors, algorithms, and algorithm
#' parameter settings.
#' @param Tags Each tag consists of a key and an optional value. Tag keys must be
#' unique per resource.
#' @param ModelDeployConfig Specifies how to generate the endpoint name for an automatic one-click
#' Autopilot model deployment.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_auto_ml_job
sagemaker_create_auto_ml_job <- function(AutoMLJobName, InputDataConfig, OutputDataConfig, ProblemType = NULL, AutoMLJobObjective = NULL, AutoMLJobConfig = NULL, RoleArn, GenerateCandidateDefinitionsOnly = NULL, Tags = NULL, ModelDeployConfig = NULL) {
  op <- new_operation(
    name = "CreateAutoMLJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$create_auto_ml_job_input(AutoMLJobName = AutoMLJobName, InputDataConfig = InputDataConfig, OutputDataConfig = OutputDataConfig, ProblemType = ProblemType, AutoMLJobObjective = AutoMLJobObjective, AutoMLJobConfig = AutoMLJobConfig, RoleArn = RoleArn, GenerateCandidateDefinitionsOnly = GenerateCandidateDefinitionsOnly, Tags = Tags, ModelDeployConfig = ModelDeployConfig)
  output <- .sagemaker$create_auto_ml_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_auto_ml_job <- sagemaker_create_auto_ml_job

#' Creates a Git repository as a resource in your SageMaker account
#'
#' @description
#' Creates a Git repository as a resource in your SageMaker account. You can associate the repository with notebook instances so that you can use Git source control for the notebooks you create. The Git repository is a resource in your SageMaker account, so it can be associated with more than one notebook instance, and it persists independently from the lifecycle of any notebook instances it is associated with.
#'
#' See [https://paws-r.github.io/docs/sagemaker/create_code_repository.html](https://paws-r.github.io/docs/sagemaker/create_code_repository.html) for full documentation.
#'
#' @param CodeRepositoryName &#91;required&#93; The name of the Git repository. The name must have 1 to 63 characters.
#' Valid characters are a-z, A-Z, 0-9, and - (hyphen).
#' @param GitConfig &#91;required&#93; Specifies details about the repository, including the URL where the
#' repository is located, the default branch, and credentials to use to
#' access the repository.
#' @param Tags An array of key-value pairs. You can use tags to categorize your Amazon
#' Web Services resources in different ways, for example, by purpose,
#' owner, or environment. For more information, see [Tagging Amazon Web
#' Services
#' Resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html).
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_code_repository
sagemaker_create_code_repository <- function(CodeRepositoryName, GitConfig, Tags = NULL) {
  op <- new_operation(
    name = "CreateCodeRepository",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$create_code_repository_input(CodeRepositoryName = CodeRepositoryName, GitConfig = GitConfig, Tags = Tags)
  output <- .sagemaker$create_code_repository_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_code_repository <- sagemaker_create_code_repository

#' Starts a model compilation job
#'
#' @description
#' Starts a model compilation job. After the model has been compiled, Amazon SageMaker saves the resulting model artifacts to an Amazon Simple Storage Service (Amazon S3) bucket that you specify.
#'
#' See [https://paws-r.github.io/docs/sagemaker/create_compilation_job.html](https://paws-r.github.io/docs/sagemaker/create_compilation_job.html) for full documentation.
#'
#' @param CompilationJobName &#91;required&#93; A name for the model compilation job. The name must be unique within the
#' Amazon Web Services Region and within your Amazon Web Services account.
#' @param RoleArn &#91;required&#93; The Amazon Resource Name (ARN) of an IAM role that enables Amazon
#' SageMaker to perform tasks on your behalf.
#' 
#' During model compilation, Amazon SageMaker needs your permission to:
#' 
#' -   Read input data from an S3 bucket
#' 
#' -   Write model artifacts to an S3 bucket
#' 
#' -   Write logs to Amazon CloudWatch Logs
#' 
#' -   Publish metrics to Amazon CloudWatch
#' 
#' You grant permissions for all of these tasks to an IAM role. To pass
#' this role to Amazon SageMaker, the caller of this API must have the
#' `iam:PassRole` permission. For more information, see [Amazon SageMaker
#' Roles.](https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html)
#' @param ModelPackageVersionArn The Amazon Resource Name (ARN) of a versioned model package. Provide
#' either a `ModelPackageVersionArn` or an `InputConfig` object in the
#' request syntax. The presence of both objects in the
#' [`create_compilation_job`][sagemaker_create_compilation_job] request
#' will return an exception.
#' @param InputConfig Provides information about the location of input model artifacts, the
#' name and shape of the expected data inputs, and the framework in which
#' the model was trained.
#' @param OutputConfig &#91;required&#93; Provides information about the output location for the compiled model
#' and the target device the model runs on.
#' @param VpcConfig A VpcConfig object that specifies the VPC that you want your compilation
#' job to connect to. Control access to your models by configuring the VPC.
#' For more information, see [Protect Compilation Jobs by Using an Amazon
#' Virtual Private
#' Cloud](https://docs.aws.amazon.com/sagemaker/latest/dg/neo-vpc.html).
#' @param StoppingCondition &#91;required&#93; Specifies a limit to how long a model compilation job can run. When the
#' job reaches the time limit, Amazon SageMaker ends the compilation job.
#' Use this API to cap model training costs.
#' @param Tags An array of key-value pairs. You can use tags to categorize your Amazon
#' Web Services resources in different ways, for example, by purpose,
#' owner, or environment. For more information, see [Tagging Amazon Web
#' Services
#' Resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html).
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_compilation_job
sagemaker_create_compilation_job <- function(CompilationJobName, RoleArn, ModelPackageVersionArn = NULL, InputConfig = NULL, OutputConfig, VpcConfig = NULL, StoppingCondition, Tags = NULL) {
  op <- new_operation(
    name = "CreateCompilationJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$create_compilation_job_input(CompilationJobName = CompilationJobName, RoleArn = RoleArn, ModelPackageVersionArn = ModelPackageVersionArn, InputConfig = InputConfig, OutputConfig = OutputConfig, VpcConfig = VpcConfig, StoppingCondition = StoppingCondition, Tags = Tags)
  output <- .sagemaker$create_compilation_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_compilation_job <- sagemaker_create_compilation_job

#' Creates a context
#'
#' @description
#' Creates a *context*. A context is a lineage tracking entity that represents a logical grouping of other tracking or experiment entities. Some examples are an endpoint and a model package. For more information, see [Amazon SageMaker ML Lineage Tracking](https://docs.aws.amazon.com/sagemaker/latest/dg/lineage-tracking.html).
#'
#' See [https://paws-r.github.io/docs/sagemaker/create_context.html](https://paws-r.github.io/docs/sagemaker/create_context.html) for full documentation.
#'
#' @param ContextName &#91;required&#93; The name of the context. Must be unique to your account in an Amazon Web
#' Services Region.
#' @param Source &#91;required&#93; The source type, ID, and URI.
#' @param ContextType &#91;required&#93; The context type.
#' @param Description The description of the context.
#' @param Properties A list of properties to add to the context.
#' @param Tags A list of tags to apply to the context.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_context
sagemaker_create_context <- function(ContextName, Source, ContextType, Description = NULL, Properties = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateContext",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$create_context_input(ContextName = ContextName, Source = Source, ContextType = ContextType, Description = Description, Properties = Properties, Tags = Tags)
  output <- .sagemaker$create_context_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_context <- sagemaker_create_context

#' Creates a definition for a job that monitors data quality and drift
#'
#' @description
#' Creates a definition for a job that monitors data quality and drift. For information about model monitor, see [Amazon SageMaker Model Monitor](https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor.html).
#'
#' See [https://paws-r.github.io/docs/sagemaker/create_data_quality_job_definition.html](https://paws-r.github.io/docs/sagemaker/create_data_quality_job_definition.html) for full documentation.
#'
#' @param JobDefinitionName &#91;required&#93; The name for the monitoring job definition.
#' @param DataQualityBaselineConfig Configures the constraints and baselines for the monitoring job.
#' @param DataQualityAppSpecification &#91;required&#93; Specifies the container that runs the monitoring job.
#' @param DataQualityJobInput &#91;required&#93; A list of inputs for the monitoring job. Currently endpoints are
#' supported as monitoring inputs.
#' @param DataQualityJobOutputConfig &#91;required&#93; 
#' @param JobResources &#91;required&#93; 
#' @param NetworkConfig Specifies networking configuration for the monitoring job.
#' @param RoleArn &#91;required&#93; The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can
#' assume to perform tasks on your behalf.
#' @param StoppingCondition 
#' @param Tags (Optional) An array of key-value pairs. For more information, see [Using
#' Cost Allocation
#' Tags](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL)
#' in the *Amazon Web Services Billing and Cost Management User Guide*.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_data_quality_job_definition
sagemaker_create_data_quality_job_definition <- function(JobDefinitionName, DataQualityBaselineConfig = NULL, DataQualityAppSpecification, DataQualityJobInput, DataQualityJobOutputConfig, JobResources, NetworkConfig = NULL, RoleArn, StoppingCondition = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateDataQualityJobDefinition",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$create_data_quality_job_definition_input(JobDefinitionName = JobDefinitionName, DataQualityBaselineConfig = DataQualityBaselineConfig, DataQualityAppSpecification = DataQualityAppSpecification, DataQualityJobInput = DataQualityJobInput, DataQualityJobOutputConfig = DataQualityJobOutputConfig, JobResources = JobResources, NetworkConfig = NetworkConfig, RoleArn = RoleArn, StoppingCondition = StoppingCondition, Tags = Tags)
  output <- .sagemaker$create_data_quality_job_definition_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_data_quality_job_definition <- sagemaker_create_data_quality_job_definition

#' Creates a device fleet
#'
#' @description
#' Creates a device fleet.
#'
#' See [https://paws-r.github.io/docs/sagemaker/create_device_fleet.html](https://paws-r.github.io/docs/sagemaker/create_device_fleet.html) for full documentation.
#'
#' @param DeviceFleetName &#91;required&#93; The name of the fleet that the device belongs to.
#' @param RoleArn The Amazon Resource Name (ARN) that has access to Amazon Web Services
#' Internet of Things (IoT).
#' @param Description A description of the fleet.
#' @param OutputConfig &#91;required&#93; The output configuration for storing sample data collected by the fleet.
#' @param Tags Creates tags for the specified fleet.
#' @param EnableIotRoleAlias Whether to create an Amazon Web Services IoT Role Alias during device
#' fleet creation. The name of the role alias generated will match this
#' pattern: "SageMakerEdge-\{DeviceFleetName\}".
#' 
#' For example, if your device fleet is called "demo-fleet", the name of
#' the role alias will be "SageMakerEdge-demo-fleet".
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_device_fleet
sagemaker_create_device_fleet <- function(DeviceFleetName, RoleArn = NULL, Description = NULL, OutputConfig, Tags = NULL, EnableIotRoleAlias = NULL) {
  op <- new_operation(
    name = "CreateDeviceFleet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$create_device_fleet_input(DeviceFleetName = DeviceFleetName, RoleArn = RoleArn, Description = Description, OutputConfig = OutputConfig, Tags = Tags, EnableIotRoleAlias = EnableIotRoleAlias)
  output <- .sagemaker$create_device_fleet_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_device_fleet <- sagemaker_create_device_fleet

#' Creates a Domain used by Amazon SageMaker Studio
#'
#' @description
#' Creates a `Domain` used by Amazon SageMaker Studio. A domain consists of an associated Amazon Elastic File System (EFS) volume, a list of authorized users, and a variety of security, application, policy, and Amazon Virtual Private Cloud (VPC) configurations. An Amazon Web Services account is limited to one domain per region. Users within a domain can share notebook files and other artifacts with each other.
#'
#' See [https://paws-r.github.io/docs/sagemaker/create_domain.html](https://paws-r.github.io/docs/sagemaker/create_domain.html) for full documentation.
#'
#' @param DomainName &#91;required&#93; A name for the domain.
#' @param AuthMode &#91;required&#93; The mode of authentication that members use to access the domain.
#' @param DefaultUserSettings &#91;required&#93; The default settings to use to create a user profile when `UserSettings`
#' isn't specified in the call to the
#' [`create_user_profile`][sagemaker_create_user_profile] API.
#' 
#' `SecurityGroups` is aggregated when specified in both calls. For all
#' other settings in `UserSettings`, the values specified in
#' [`create_user_profile`][sagemaker_create_user_profile] take precedence
#' over those specified in [`create_domain`][sagemaker_create_domain].
#' @param SubnetIds &#91;required&#93; The VPC subnets that Studio uses for communication.
#' @param VpcId &#91;required&#93; The ID of the Amazon Virtual Private Cloud (VPC) that Studio uses for
#' communication.
#' @param Tags Tags to associated with the Domain. Each tag consists of a key and an
#' optional value. Tag keys must be unique per resource. Tags are
#' searchable using the [`search`][sagemaker_search] API.
#' 
#' Tags that you specify for the Domain are also added to all Apps that the
#' Domain launches.
#' @param AppNetworkAccessType Specifies the VPC used for non-EFS traffic. The default value is
#' `PublicInternetOnly`.
#' 
#' -   `PublicInternetOnly` - Non-EFS traffic is through a VPC managed by
#'     Amazon SageMaker, which allows direct internet access
#' 
#' -   `VpcOnly` - All Studio traffic is through the specified VPC and
#'     subnets
#' @param HomeEfsFileSystemKmsKeyId Use `KmsKeyId`.
#' @param KmsKeyId SageMaker uses Amazon Web Services KMS to encrypt the EFS volume
#' attached to the domain with an Amazon Web Services managed key by
#' default. For more control, specify a customer managed key.
#' @param AppSecurityGroupManagement The entity that creates and manages the required security groups for
#' inter-app communication in `VPCOnly` mode. Required when
#' `CreateDomain.AppNetworkAccessType` is `VPCOnly` and
#' `DomainSettings.RStudioServerProDomainSettings.DomainExecutionRoleArn`
#' is provided.
#' @param DomainSettings A collection of `Domain` settings.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_domain
sagemaker_create_domain <- function(DomainName, AuthMode, DefaultUserSettings, SubnetIds, VpcId, Tags = NULL, AppNetworkAccessType = NULL, HomeEfsFileSystemKmsKeyId = NULL, KmsKeyId = NULL, AppSecurityGroupManagement = NULL, DomainSettings = NULL) {
  op <- new_operation(
    name = "CreateDomain",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$create_domain_input(DomainName = DomainName, AuthMode = AuthMode, DefaultUserSettings = DefaultUserSettings, SubnetIds = SubnetIds, VpcId = VpcId, Tags = Tags, AppNetworkAccessType = AppNetworkAccessType, HomeEfsFileSystemKmsKeyId = HomeEfsFileSystemKmsKeyId, KmsKeyId = KmsKeyId, AppSecurityGroupManagement = AppSecurityGroupManagement, DomainSettings = DomainSettings)
  output <- .sagemaker$create_domain_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_domain <- sagemaker_create_domain

#' Creates an edge deployment plan, consisting of multiple stages
#'
#' @description
#' Creates an edge deployment plan, consisting of multiple stages. Each stage may have a different deployment configuration and devices.
#'
#' See [https://paws-r.github.io/docs/sagemaker/create_edge_deployment_plan.html](https://paws-r.github.io/docs/sagemaker/create_edge_deployment_plan.html) for full documentation.
#'
#' @param EdgeDeploymentPlanName &#91;required&#93; The name of the edge deployment plan.
#' @param ModelConfigs &#91;required&#93; List of models associated with the edge deployment plan.
#' @param DeviceFleetName &#91;required&#93; The device fleet used for this edge deployment plan.
#' @param Stages List of stages of the edge deployment plan. The number of stages is
#' limited to 10 per deployment.
#' @param Tags List of tags with which to tag the edge deployment plan.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_edge_deployment_plan
sagemaker_create_edge_deployment_plan <- function(EdgeDeploymentPlanName, ModelConfigs, DeviceFleetName, Stages = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateEdgeDeploymentPlan",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$create_edge_deployment_plan_input(EdgeDeploymentPlanName = EdgeDeploymentPlanName, ModelConfigs = ModelConfigs, DeviceFleetName = DeviceFleetName, Stages = Stages, Tags = Tags)
  output <- .sagemaker$create_edge_deployment_plan_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_edge_deployment_plan <- sagemaker_create_edge_deployment_plan

#' Creates a new stage in an existing edge deployment plan
#'
#' @description
#' Creates a new stage in an existing edge deployment plan.
#'
#' See [https://paws-r.github.io/docs/sagemaker/create_edge_deployment_stage.html](https://paws-r.github.io/docs/sagemaker/create_edge_deployment_stage.html) for full documentation.
#'
#' @param EdgeDeploymentPlanName &#91;required&#93; The name of the edge deployment plan.
#' @param Stages &#91;required&#93; List of stages to be added to the edge deployment plan.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_edge_deployment_stage
sagemaker_create_edge_deployment_stage <- function(EdgeDeploymentPlanName, Stages) {
  op <- new_operation(
    name = "CreateEdgeDeploymentStage",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$create_edge_deployment_stage_input(EdgeDeploymentPlanName = EdgeDeploymentPlanName, Stages = Stages)
  output <- .sagemaker$create_edge_deployment_stage_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_edge_deployment_stage <- sagemaker_create_edge_deployment_stage

#' Starts a SageMaker Edge Manager model packaging job
#'
#' @description
#' Starts a SageMaker Edge Manager model packaging job. Edge Manager will use the model artifacts from the Amazon Simple Storage Service bucket that you specify. After the model has been packaged, Amazon SageMaker saves the resulting artifacts to an S3 bucket that you specify.
#'
#' See [https://paws-r.github.io/docs/sagemaker/create_edge_packaging_job.html](https://paws-r.github.io/docs/sagemaker/create_edge_packaging_job.html) for full documentation.
#'
#' @param EdgePackagingJobName &#91;required&#93; The name of the edge packaging job.
#' @param CompilationJobName &#91;required&#93; The name of the SageMaker Neo compilation job that will be used to
#' locate model artifacts for packaging.
#' @param ModelName &#91;required&#93; The name of the model.
#' @param ModelVersion &#91;required&#93; The version of the model.
#' @param RoleArn &#91;required&#93; The Amazon Resource Name (ARN) of an IAM role that enables Amazon
#' SageMaker to download and upload the model, and to contact SageMaker
#' Neo.
#' @param OutputConfig &#91;required&#93; Provides information about the output location for the packaged model.
#' @param ResourceKey The Amazon Web Services KMS key to use when encrypting the EBS volume
#' the edge packaging job runs on.
#' @param Tags Creates tags for the packaging job.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_edge_packaging_job
sagemaker_create_edge_packaging_job <- function(EdgePackagingJobName, CompilationJobName, ModelName, ModelVersion, RoleArn, OutputConfig, ResourceKey = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateEdgePackagingJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$create_edge_packaging_job_input(EdgePackagingJobName = EdgePackagingJobName, CompilationJobName = CompilationJobName, ModelName = ModelName, ModelVersion = ModelVersion, RoleArn = RoleArn, OutputConfig = OutputConfig, ResourceKey = ResourceKey, Tags = Tags)
  output <- .sagemaker$create_edge_packaging_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_edge_packaging_job <- sagemaker_create_edge_packaging_job

#' Creates an endpoint using the endpoint configuration specified in the
#' request
#'
#' @description
#' Creates an endpoint using the endpoint configuration specified in the request. SageMaker uses the endpoint to provision resources and deploy models. You create the endpoint configuration with the [`create_endpoint_config`][sagemaker_create_endpoint_config] API.
#'
#' See [https://paws-r.github.io/docs/sagemaker/create_endpoint.html](https://paws-r.github.io/docs/sagemaker/create_endpoint.html) for full documentation.
#'
#' @param EndpointName &#91;required&#93; The name of the endpoint.The name must be unique within an Amazon Web
#' Services Region in your Amazon Web Services account. The name is
#' case-insensitive in [`create_endpoint`][sagemaker_create_endpoint], but
#' the case is preserved and must be matched in .
#' @param EndpointConfigName &#91;required&#93; The name of an endpoint configuration. For more information, see
#' [`create_endpoint_config`][sagemaker_create_endpoint_config].
#' @param DeploymentConfig 
#' @param Tags An array of key-value pairs. You can use tags to categorize your Amazon
#' Web Services resources in different ways, for example, by purpose,
#' owner, or environment. For more information, see [Tagging Amazon Web
#' Services
#' Resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html).
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_endpoint
sagemaker_create_endpoint <- function(EndpointName, EndpointConfigName, DeploymentConfig = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateEndpoint",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$create_endpoint_input(EndpointName = EndpointName, EndpointConfigName = EndpointConfigName, DeploymentConfig = DeploymentConfig, Tags = Tags)
  output <- .sagemaker$create_endpoint_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_endpoint <- sagemaker_create_endpoint

#' Creates an endpoint configuration that SageMaker hosting services uses
#' to deploy models
#'
#' @description
#' Creates an endpoint configuration that SageMaker hosting services uses to deploy models. In the configuration, you identify one or more models, created using the [`create_model`][sagemaker_create_model] API, to deploy and the resources that you want SageMaker to provision. Then you call the [`create_endpoint`][sagemaker_create_endpoint] API.
#'
#' See [https://paws-r.github.io/docs/sagemaker/create_endpoint_config.html](https://paws-r.github.io/docs/sagemaker/create_endpoint_config.html) for full documentation.
#'
#' @param EndpointConfigName &#91;required&#93; The name of the endpoint configuration. You specify this name in a
#' [`create_endpoint`][sagemaker_create_endpoint] request.
#' @param ProductionVariants &#91;required&#93; An list of `ProductionVariant` objects, one for each model that you want
#' to host at this endpoint.
#' @param DataCaptureConfig 
#' @param Tags An array of key-value pairs. You can use tags to categorize your Amazon
#' Web Services resources in different ways, for example, by purpose,
#' owner, or environment. For more information, see [Tagging Amazon Web
#' Services
#' Resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html).
#' @param KmsKeyId The Amazon Resource Name (ARN) of a Amazon Web Services Key Management
#' Service key that SageMaker uses to encrypt data on the storage volume
#' attached to the ML compute instance that hosts the endpoint.
#' 
#' The KmsKeyId can be any of the following formats:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Alias name: `alias/ExampleAlias`
#' 
#' -   Alias name ARN:
#'     `arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias`
#' 
#' The KMS key policy must grant permission to the IAM role that you
#' specify in your [`create_endpoint`][sagemaker_create_endpoint],
#' [`update_endpoint`][sagemaker_update_endpoint] requests. For more
#' information, refer to the Amazon Web Services Key Management Service
#' section [Using Key Policies in Amazon Web Services
#' KMS](https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html)
#' 
#' Certain Nitro-based instances include local storage, dependent on the
#' instance type. Local storage volumes are encrypted using a hardware
#' module on the instance. You can't request a `KmsKeyId` when using an
#' instance type with local storage. If any of the models that you specify
#' in the `ProductionVariants` parameter use nitro-based instances with
#' local storage, do not specify a value for the `KmsKeyId` parameter. If
#' you specify a value for `KmsKeyId` when using any nitro-based instances
#' with local storage, the call to
#' [`create_endpoint_config`][sagemaker_create_endpoint_config] fails.
#' 
#' For a list of instance types that support local instance storage, see
#' [Instance Store
#' Volumes](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#instance-store-volumes).
#' 
#' For more information about local instance storage encryption, see [SSD
#' Instance Store
#' Volumes](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ssd-instance-store.html).
#' @param AsyncInferenceConfig Specifies configuration for how an endpoint performs asynchronous
#' inference. This is a required field in order for your Endpoint to be
#' invoked using
#' [InvokeEndpointAsync](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_runtime_InvokeEndpointAsync.html).
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_endpoint_config
sagemaker_create_endpoint_config <- function(EndpointConfigName, ProductionVariants, DataCaptureConfig = NULL, Tags = NULL, KmsKeyId = NULL, AsyncInferenceConfig = NULL) {
  op <- new_operation(
    name = "CreateEndpointConfig",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$create_endpoint_config_input(EndpointConfigName = EndpointConfigName, ProductionVariants = ProductionVariants, DataCaptureConfig = DataCaptureConfig, Tags = Tags, KmsKeyId = KmsKeyId, AsyncInferenceConfig = AsyncInferenceConfig)
  output <- .sagemaker$create_endpoint_config_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_endpoint_config <- sagemaker_create_endpoint_config

#' Creates an SageMaker experiment
#'
#' @description
#' Creates an SageMaker *experiment*. An experiment is a collection of *trials* that are observed, compared and evaluated as a group. A trial is a set of steps, called *trial components*, that produce a machine learning model.
#'
#' See [https://paws-r.github.io/docs/sagemaker/create_experiment.html](https://paws-r.github.io/docs/sagemaker/create_experiment.html) for full documentation.
#'
#' @param ExperimentName &#91;required&#93; The name of the experiment. The name must be unique in your Amazon Web
#' Services account and is not case-sensitive.
#' @param DisplayName The name of the experiment as displayed. The name doesn't need to be
#' unique. If you don't specify `DisplayName`, the value in
#' `ExperimentName` is displayed.
#' @param Description The description of the experiment.
#' @param Tags A list of tags to associate with the experiment. You can use
#' [`search`][sagemaker_search] API to search on the tags.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_experiment
sagemaker_create_experiment <- function(ExperimentName, DisplayName = NULL, Description = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateExperiment",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$create_experiment_input(ExperimentName = ExperimentName, DisplayName = DisplayName, Description = Description, Tags = Tags)
  output <- .sagemaker$create_experiment_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_experiment <- sagemaker_create_experiment

#' Create a new FeatureGroup
#'
#' @description
#' Create a new `FeatureGroup`. A `FeatureGroup` is a group of `Features` defined in the `FeatureStore` to describe a `Record`.
#'
#' See [https://paws-r.github.io/docs/sagemaker/create_feature_group.html](https://paws-r.github.io/docs/sagemaker/create_feature_group.html) for full documentation.
#'
#' @param FeatureGroupName &#91;required&#93; The name of the `FeatureGroup`. The name must be unique within an Amazon
#' Web Services Region in an Amazon Web Services account. The name:
#' 
#' -   Must start and end with an alphanumeric character.
#' 
#' -   Can only contain alphanumeric character and hyphens. Spaces are not
#'     allowed.
#' @param RecordIdentifierFeatureName &#91;required&#93; The name of the `Feature` whose value uniquely identifies a `Record`
#' defined in the `FeatureStore`. Only the latest record per identifier
#' value will be stored in the `OnlineStore`. `RecordIdentifierFeatureName`
#' must be one of feature definitions' names.
#' 
#' You use the `RecordIdentifierFeatureName` to access data in a
#' `FeatureStore`.
#' 
#' This name:
#' 
#' -   Must start and end with an alphanumeric character.
#' 
#' -   Can only contains alphanumeric characters, hyphens, underscores.
#'     Spaces are not allowed.
#' @param EventTimeFeatureName &#91;required&#93; The name of the feature that stores the `EventTime` of a `Record` in a
#' `FeatureGroup`.
#' 
#' An `EventTime` is a point in time when a new event occurs that
#' corresponds to the creation or update of a `Record` in a `FeatureGroup`.
#' All `Records` in the `FeatureGroup` must have a corresponding
#' `EventTime`.
#' 
#' An `EventTime` can be a `String` or `Fractional`.
#' 
#' -   `Fractional`: `EventTime` feature values must be a Unix timestamp in
#'     seconds.
#' 
#' -   `String`: `EventTime` feature values must be an ISO-8601 string in
#'     the format. The following formats are supported
#'     `yyyy-MM-dd'T'HH:mm:ssZ` and `yyyy-MM-dd'T'HH:mm:ss.SSSZ` where
#'     `yyyy`, `MM`, and `dd` represent the year, month, and day
#'     respectively and `HH`, `mm`, `ss`, and if applicable, `SSS`
#'     represent the hour, month, second and milliseconds respsectively.
#'     `'T'` and `Z` are constants.
#' @param FeatureDefinitions &#91;required&#93; A list of `Feature` names and types. `Name` and `Type` is compulsory per
#' `Feature`.
#' 
#' Valid feature `FeatureType`s are `Integral`, `Fractional` and `String`.
#' 
#' `FeatureName`s cannot be any of the following: `is_deleted`,
#' `write_time`, `api_invocation_time`
#' 
#' You can create up to 2,500 `FeatureDefinition`s per `FeatureGroup`.
#' @param OnlineStoreConfig You can turn the `OnlineStore` on or off by specifying `True` for the
#' `EnableOnlineStore` flag in `OnlineStoreConfig`; the default value is
#' `False`.
#' 
#' You can also include an Amazon Web Services KMS key ID (`KMSKeyId`) for
#' at-rest encryption of the `OnlineStore`.
#' @param OfflineStoreConfig Use this to configure an `OfflineFeatureStore`. This parameter allows
#' you to specify:
#' 
#' -   The Amazon Simple Storage Service (Amazon S3) location of an
#'     `OfflineStore`.
#' 
#' -   A configuration for an Amazon Web Services Glue or Amazon Web
#'     Services Hive data catalog.
#' 
#' -   An KMS encryption key to encrypt the Amazon S3 location used for
#'     `OfflineStore`. If KMS encryption key is not specified, by default
#'     we encrypt all data at rest using Amazon Web Services KMS key. By
#'     defining your [bucket-level
#'     key](https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucket-key.html)
#'     for SSE, you can reduce Amazon Web Services KMS requests costs by up
#'     to 99 percent.
#' 
#' To learn more about this parameter, see OfflineStoreConfig.
#' @param RoleArn The Amazon Resource Name (ARN) of the IAM execution role used to persist
#' data into the `OfflineStore` if an `OfflineStoreConfig` is provided.
#' @param Description A free-form description of a `FeatureGroup`.
#' @param Tags Tags used to identify `Features` in each `FeatureGroup`.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_feature_group
sagemaker_create_feature_group <- function(FeatureGroupName, RecordIdentifierFeatureName, EventTimeFeatureName, FeatureDefinitions, OnlineStoreConfig = NULL, OfflineStoreConfig = NULL, RoleArn = NULL, Description = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateFeatureGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$create_feature_group_input(FeatureGroupName = FeatureGroupName, RecordIdentifierFeatureName = RecordIdentifierFeatureName, EventTimeFeatureName = EventTimeFeatureName, FeatureDefinitions = FeatureDefinitions, OnlineStoreConfig = OnlineStoreConfig, OfflineStoreConfig = OfflineStoreConfig, RoleArn = RoleArn, Description = Description, Tags = Tags)
  output <- .sagemaker$create_feature_group_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_feature_group <- sagemaker_create_feature_group

#' Creates a flow definition
#'
#' @description
#' Creates a flow definition.
#'
#' See [https://paws-r.github.io/docs/sagemaker/create_flow_definition.html](https://paws-r.github.io/docs/sagemaker/create_flow_definition.html) for full documentation.
#'
#' @param FlowDefinitionName &#91;required&#93; The name of your flow definition.
#' @param HumanLoopRequestSource Container for configuring the source of human task requests. Use to
#' specify if Amazon Rekognition or Amazon Textract is used as an
#' integration source.
#' @param HumanLoopActivationConfig An object containing information about the events that trigger a human
#' workflow.
#' @param HumanLoopConfig &#91;required&#93; An object containing information about the tasks the human reviewers
#' will perform.
#' @param OutputConfig &#91;required&#93; An object containing information about where the human review results
#' will be uploaded.
#' @param RoleArn &#91;required&#93; The Amazon Resource Name (ARN) of the role needed to call other services
#' on your behalf. For example,
#' `arn:aws:iam::1234567890:role/service-role/AmazonSageMaker-ExecutionRole-20180111T151298`.
#' @param Tags An array of key-value pairs that contain metadata to help you categorize
#' and organize a flow definition. Each tag consists of a key and a value,
#' both of which you define.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_flow_definition
sagemaker_create_flow_definition <- function(FlowDefinitionName, HumanLoopRequestSource = NULL, HumanLoopActivationConfig = NULL, HumanLoopConfig, OutputConfig, RoleArn, Tags = NULL) {
  op <- new_operation(
    name = "CreateFlowDefinition",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$create_flow_definition_input(FlowDefinitionName = FlowDefinitionName, HumanLoopRequestSource = HumanLoopRequestSource, HumanLoopActivationConfig = HumanLoopActivationConfig, HumanLoopConfig = HumanLoopConfig, OutputConfig = OutputConfig, RoleArn = RoleArn, Tags = Tags)
  output <- .sagemaker$create_flow_definition_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_flow_definition <- sagemaker_create_flow_definition

#' Defines the settings you will use for the human review workflow user
#' interface
#'
#' @description
#' Defines the settings you will use for the human review workflow user interface. Reviewers will see a three-panel interface with an instruction area, the item to review, and an input area.
#'
#' See [https://paws-r.github.io/docs/sagemaker/create_human_task_ui.html](https://paws-r.github.io/docs/sagemaker/create_human_task_ui.html) for full documentation.
#'
#' @param HumanTaskUiName &#91;required&#93; The name of the user interface you are creating.
#' @param UiTemplate &#91;required&#93; 
#' @param Tags An array of key-value pairs that contain metadata to help you categorize
#' and organize a human review workflow user interface. Each tag consists
#' of a key and a value, both of which you define.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_human_task_ui
sagemaker_create_human_task_ui <- function(HumanTaskUiName, UiTemplate, Tags = NULL) {
  op <- new_operation(
    name = "CreateHumanTaskUi",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$create_human_task_ui_input(HumanTaskUiName = HumanTaskUiName, UiTemplate = UiTemplate, Tags = Tags)
  output <- .sagemaker$create_human_task_ui_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_human_task_ui <- sagemaker_create_human_task_ui

#' Starts a hyperparameter tuning job
#'
#' @description
#' Starts a hyperparameter tuning job. A hyperparameter tuning job finds the best version of a model by running many training jobs on your dataset using the algorithm you choose and values for hyperparameters within ranges that you specify. It then chooses the hyperparameter values that result in a model that performs the best, as measured by an objective metric that you choose.
#'
#' See [https://paws-r.github.io/docs/sagemaker/create_hyper_parameter_tuning_job.html](https://paws-r.github.io/docs/sagemaker/create_hyper_parameter_tuning_job.html) for full documentation.
#'
#' @param HyperParameterTuningJobName &#91;required&#93; The name of the tuning job. This name is the prefix for the names of all
#' training jobs that this tuning job launches. The name must be unique
#' within the same Amazon Web Services account and Amazon Web Services
#' Region. The name must have 1 to 32 characters. Valid characters are a-z,
#' A-Z, 0-9, and : + = @@ _ % - (hyphen). The name is not case sensitive.
#' @param HyperParameterTuningJobConfig &#91;required&#93; The HyperParameterTuningJobConfig object that describes the tuning job,
#' including the search strategy, the objective metric used to evaluate
#' training jobs, ranges of parameters to search, and resource limits for
#' the tuning job. For more information, see [How Hyperparameter Tuning
#' Works](https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-how-it-works.html).
#' @param TrainingJobDefinition The HyperParameterTrainingJobDefinition object that describes the
#' training jobs that this tuning job launches, including static
#' hyperparameters, input data configuration, output data configuration,
#' resource configuration, and stopping condition.
#' @param TrainingJobDefinitions A list of the HyperParameterTrainingJobDefinition objects launched for
#' this tuning job.
#' @param WarmStartConfig Specifies the configuration for starting the hyperparameter tuning job
#' using one or more previous tuning jobs as a starting point. The results
#' of previous tuning jobs are used to inform which combinations of
#' hyperparameters to search over in the new tuning job.
#' 
#' All training jobs launched by the new hyperparameter tuning job are
#' evaluated by using the objective metric. If you specify
#' `IDENTICAL_DATA_AND_ALGORITHM` as the `WarmStartType` value for the warm
#' start configuration, the training job that performs the best in the new
#' tuning job is compared to the best training jobs from the parent tuning
#' jobs. From these, the training job that performs the best as measured by
#' the objective metric is returned as the overall best training job.
#' 
#' All training jobs launched by parent hyperparameter tuning jobs and the
#' new hyperparameter tuning jobs count against the limit of training jobs
#' for the tuning job.
#' @param Tags An array of key-value pairs. You can use tags to categorize your Amazon
#' Web Services resources in different ways, for example, by purpose,
#' owner, or environment. For more information, see [Tagging Amazon Web
#' Services
#' Resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html).
#' 
#' Tags that you specify for the tuning job are also added to all training
#' jobs that the tuning job launches.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_hyper_parameter_tuning_job
sagemaker_create_hyper_parameter_tuning_job <- function(HyperParameterTuningJobName, HyperParameterTuningJobConfig, TrainingJobDefinition = NULL, TrainingJobDefinitions = NULL, WarmStartConfig = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateHyperParameterTuningJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$create_hyper_parameter_tuning_job_input(HyperParameterTuningJobName = HyperParameterTuningJobName, HyperParameterTuningJobConfig = HyperParameterTuningJobConfig, TrainingJobDefinition = TrainingJobDefinition, TrainingJobDefinitions = TrainingJobDefinitions, WarmStartConfig = WarmStartConfig, Tags = Tags)
  output <- .sagemaker$create_hyper_parameter_tuning_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_hyper_parameter_tuning_job <- sagemaker_create_hyper_parameter_tuning_job

#' Creates a custom SageMaker image
#'
#' @description
#' Creates a custom SageMaker image. A SageMaker image is a set of image versions. Each image version represents a container image stored in Amazon Elastic Container Registry (ECR). For more information, see [Bring your own SageMaker image](https://docs.aws.amazon.com/sagemaker/latest/dg/studio-byoi.html).
#'
#' See [https://paws-r.github.io/docs/sagemaker/create_image.html](https://paws-r.github.io/docs/sagemaker/create_image.html) for full documentation.
#'
#' @param Description The description of the image.
#' @param DisplayName The display name of the image. If not provided, `ImageName` is
#' displayed.
#' @param ImageName &#91;required&#93; The name of the image. Must be unique to your account.
#' @param RoleArn &#91;required&#93; The Amazon Resource Name (ARN) of an IAM role that enables Amazon
#' SageMaker to perform tasks on your behalf.
#' @param Tags A list of tags to apply to the image.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_image
sagemaker_create_image <- function(Description = NULL, DisplayName = NULL, ImageName, RoleArn, Tags = NULL) {
  op <- new_operation(
    name = "CreateImage",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$create_image_input(Description = Description, DisplayName = DisplayName, ImageName = ImageName, RoleArn = RoleArn, Tags = Tags)
  output <- .sagemaker$create_image_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_image <- sagemaker_create_image

#' Creates a version of the SageMaker image specified by ImageName
#'
#' @description
#' Creates a version of the SageMaker image specified by `ImageName`. The version represents the Amazon Elastic Container Registry (ECR) container image specified by `BaseImage`.
#'
#' See [https://paws-r.github.io/docs/sagemaker/create_image_version.html](https://paws-r.github.io/docs/sagemaker/create_image_version.html) for full documentation.
#'
#' @param BaseImage &#91;required&#93; The registry path of the container image to use as the starting point
#' for this version. The path is an Amazon Elastic Container Registry (ECR)
#' URI in the following format:
#' 
#' `<acct-id>.dkr.ecr.<region>.amazonaws.com/<repo-name[:tag] or [@@digest]>`
#' @param ClientToken &#91;required&#93; A unique ID. If not specified, the Amazon Web Services CLI and Amazon
#' Web Services SDKs, such as the SDK for Python (Boto3), add a unique
#' value to the call.
#' @param ImageName &#91;required&#93; The `ImageName` of the `Image` to create a version of.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_image_version
sagemaker_create_image_version <- function(BaseImage, ClientToken, ImageName) {
  op <- new_operation(
    name = "CreateImageVersion",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$create_image_version_input(BaseImage = BaseImage, ClientToken = ClientToken, ImageName = ImageName)
  output <- .sagemaker$create_image_version_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_image_version <- sagemaker_create_image_version

#' Starts a recommendation job
#'
#' @description
#' Starts a recommendation job. You can create either an instance recommendation or load test job.
#'
#' See [https://paws-r.github.io/docs/sagemaker/create_inference_recommendations_job.html](https://paws-r.github.io/docs/sagemaker/create_inference_recommendations_job.html) for full documentation.
#'
#' @param JobName &#91;required&#93; A name for the recommendation job. The name must be unique within the
#' Amazon Web Services Region and within your Amazon Web Services account.
#' @param JobType &#91;required&#93; Defines the type of recommendation job. Specify `Default` to initiate an
#' instance recommendation and `Advanced` to initiate a load test. If left
#' unspecified, Amazon SageMaker Inference Recommender will run an instance
#' recommendation (`DEFAULT`) job.
#' @param RoleArn &#91;required&#93; The Amazon Resource Name (ARN) of an IAM role that enables Amazon
#' SageMaker to perform tasks on your behalf.
#' @param InputConfig &#91;required&#93; Provides information about the versioned model package Amazon Resource
#' Name (ARN), the traffic pattern, and endpoint configurations.
#' @param JobDescription Description of the recommendation job.
#' @param StoppingConditions A set of conditions for stopping a recommendation job. If any of the
#' conditions are met, the job is automatically stopped.
#' @param OutputConfig Provides information about the output artifacts and the KMS key to use
#' for Amazon S3 server-side encryption.
#' @param Tags The metadata that you apply to Amazon Web Services resources to help you
#' categorize and organize them. Each tag consists of a key and a value,
#' both of which you define. For more information, see [Tagging Amazon Web
#' Services
#' Resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
#' in the Amazon Web Services General Reference.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_inference_recommendations_job
sagemaker_create_inference_recommendations_job <- function(JobName, JobType, RoleArn, InputConfig, JobDescription = NULL, StoppingConditions = NULL, OutputConfig = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateInferenceRecommendationsJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$create_inference_recommendations_job_input(JobName = JobName, JobType = JobType, RoleArn = RoleArn, InputConfig = InputConfig, JobDescription = JobDescription, StoppingConditions = StoppingConditions, OutputConfig = OutputConfig, Tags = Tags)
  output <- .sagemaker$create_inference_recommendations_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_inference_recommendations_job <- sagemaker_create_inference_recommendations_job

#' Creates a job that uses workers to label the data objects in your input
#' dataset
#'
#' @description
#' Creates a job that uses workers to label the data objects in your input dataset. You can use the labeled data to train machine learning models.
#'
#' See [https://paws-r.github.io/docs/sagemaker/create_labeling_job.html](https://paws-r.github.io/docs/sagemaker/create_labeling_job.html) for full documentation.
#'
#' @param LabelingJobName &#91;required&#93; The name of the labeling job. This name is used to identify the job in a
#' list of labeling jobs. Labeling job names must be unique within an
#' Amazon Web Services account and region. `LabelingJobName` is not case
#' sensitive. For example, Example-job and example-job are considered the
#' same labeling job name by Ground Truth.
#' @param LabelAttributeName &#91;required&#93; The attribute name to use for the label in the output manifest file.
#' This is the key for the key/value pair formed with the label that a
#' worker assigns to the object. The `LabelAttributeName` must meet the
#' following requirements.
#' 
#' -   The name can't end with "-metadata".
#' 
#' -   If you are using one of the following [built-in task
#'     types](https://docs.aws.amazon.com/sagemaker/latest/dg/sms-task-types.html),
#'     the attribute name *must* end with "-ref". If the task type you are
#'     using is not listed below, the attribute name *must not* end with
#'     "-ref".
#' 
#'     -   Image semantic segmentation (`SemanticSegmentation)`, and
#'         adjustment (`AdjustmentSemanticSegmentation`) and verification
#'         (`VerificationSemanticSegmentation`) labeling jobs for this task
#'         type.
#' 
#'     -   Video frame object detection (`VideoObjectDetection`), and
#'         adjustment and verification (`AdjustmentVideoObjectDetection`)
#'         labeling jobs for this task type.
#' 
#'     -   Video frame object tracking (`VideoObjectTracking`), and
#'         adjustment and verification (`AdjustmentVideoObjectTracking`)
#'         labeling jobs for this task type.
#' 
#'     -   3D point cloud semantic segmentation
#'         (`3DPointCloudSemanticSegmentation`), and adjustment and
#'         verification (`Adjustment3DPointCloudSemanticSegmentation`)
#'         labeling jobs for this task type.
#' 
#'     -   3D point cloud object tracking (`3DPointCloudObjectTracking`),
#'         and adjustment and verification
#'         (`Adjustment3DPointCloudObjectTracking`) labeling jobs for this
#'         task type.
#' 
#' If you are creating an adjustment or verification labeling job, you must
#' use a *different* `LabelAttributeName` than the one used in the original
#' labeling job. The original labeling job is the Ground Truth labeling job
#' that produced the labels that you want verified or adjusted. To learn
#' more about adjustment and verification labeling jobs, see [Verify and
#' Adjust
#' Labels](https://docs.aws.amazon.com/sagemaker/latest/dg/sms-verification-data.html).
#' @param InputConfig &#91;required&#93; Input data for the labeling job, such as the Amazon S3 location of the
#' data objects and the location of the manifest file that describes the
#' data objects.
#' 
#' You must specify at least one of the following: `S3DataSource` or
#' `SnsDataSource`.
#' 
#' -   Use `SnsDataSource` to specify an SNS input topic for a streaming
#'     labeling job. If you do not specify and SNS input topic ARN, Ground
#'     Truth will create a one-time labeling job that stops after all data
#'     objects in the input manifest file have been labeled.
#' 
#' -   Use `S3DataSource` to specify an input manifest file for both
#'     streaming and one-time labeling jobs. Adding an `S3DataSource` is
#'     optional if you use `SnsDataSource` to create a streaming labeling
#'     job.
#' 
#' If you use the Amazon Mechanical Turk workforce, your input data should
#' not include confidential information, personal information or protected
#' health information. Use `ContentClassifiers` to specify that your data
#' is free of personally identifiable information and adult content.
#' @param OutputConfig &#91;required&#93; The location of the output data and the Amazon Web Services Key
#' Management Service key ID for the key used to encrypt the output data,
#' if any.
#' @param RoleArn &#91;required&#93; The Amazon Resource Number (ARN) that Amazon SageMaker assumes to
#' perform tasks on your behalf during data labeling. You must grant this
#' role the necessary permissions so that Amazon SageMaker can successfully
#' complete data labeling.
#' @param LabelCategoryConfigS3Uri The S3 URI of the file, referred to as a *label category configuration
#' file*, that defines the categories used to label the data objects.
#' 
#' For 3D point cloud and video frame task types, you can add label
#' category attributes and frame attributes to your label category
#' configuration file. To learn how, see [Create a Labeling Category
#' Configuration File for 3D Point Cloud Labeling
#' Jobs](https://docs.aws.amazon.com/sagemaker/latest/dg/sms-label-cat-config-attributes.html).
#' 
#' For named entity recognition jobs, in addition to `"labels"`, you must
#' provide worker instructions in the label category configuration file
#' using the `"instructions"` parameter:
#' `"instructions": {"shortInstruction":"<h1>Add header</h1><p>Add Instructions</p>", "fullInstruction":"<p>Add additional instructions.</p>"}`.
#' For details and an example, see [Create a Named Entity Recognition
#' Labeling Job
#' (API)](https://docs.aws.amazon.com/sagemaker/latest/dg/sms-named-entity-recg.html#sms-creating-ner-api)
#' .
#' 
#' For all other [built-in task
#' types](https://docs.aws.amazon.com/sagemaker/latest/dg/sms-task-types.html)
#' and [custom
#' tasks](https://docs.aws.amazon.com/sagemaker/latest/dg/sms-custom-templates.html),
#' your label category configuration file must be a JSON file in the
#' following format. Identify the labels you want to use by replacing
#' `label_1`, `label_2`,`...`,`label_n` with your label categories.
#' 
#' `\{ `
#' 
#' `"document-version": "2018-11-28",`
#' 
#' `"labels": [{"label": "label_1"},{"label": "label_2"},...{"label": "label_n"}]`
#' 
#' `\}`
#' 
#' Note the following about the label category configuration file:
#' 
#' -   For image classification and text classification (single and
#'     multi-label) you must specify at least two label categories. For all
#'     other task types, the minimum number of label categories required is
#'     one.
#' 
#' -   Each label category must be unique, you cannot specify duplicate
#'     label categories.
#' 
#' -   If you create a 3D point cloud or video frame adjustment or
#'     verification labeling job, you must include
#'     `auditLabelAttributeName` in the label category configuration. Use
#'     this parameter to enter the
#'     [`LabelAttributeName`](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateLabelingJob.html#sagemaker-CreateLabelingJob-request-LabelAttributeName)
#'     of the labeling job you want to adjust or verify annotations of.
#' @param StoppingConditions A set of conditions for stopping the labeling job. If any of the
#' conditions are met, the job is automatically stopped. You can use these
#' conditions to control the cost of data labeling.
#' @param LabelingJobAlgorithmsConfig Configures the information required to perform automated data labeling.
#' @param HumanTaskConfig &#91;required&#93; Configures the labeling task and how it is presented to workers;
#' including, but not limited to price, keywords, and batch size (task
#' count).
#' @param Tags An array of key/value pairs. For more information, see [Using Cost
#' Allocation
#' Tags](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what)
#' in the *Amazon Web Services Billing and Cost Management User Guide*.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_labeling_job
sagemaker_create_labeling_job <- function(LabelingJobName, LabelAttributeName, InputConfig, OutputConfig, RoleArn, LabelCategoryConfigS3Uri = NULL, StoppingConditions = NULL, LabelingJobAlgorithmsConfig = NULL, HumanTaskConfig, Tags = NULL) {
  op <- new_operation(
    name = "CreateLabelingJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$create_labeling_job_input(LabelingJobName = LabelingJobName, LabelAttributeName = LabelAttributeName, InputConfig = InputConfig, OutputConfig = OutputConfig, RoleArn = RoleArn, LabelCategoryConfigS3Uri = LabelCategoryConfigS3Uri, StoppingConditions = StoppingConditions, LabelingJobAlgorithmsConfig = LabelingJobAlgorithmsConfig, HumanTaskConfig = HumanTaskConfig, Tags = Tags)
  output <- .sagemaker$create_labeling_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_labeling_job <- sagemaker_create_labeling_job

#' Creates a model in SageMaker
#'
#' @description
#' Creates a model in SageMaker. In the request, you name the model and describe a primary container. For the primary container, you specify the Docker image that contains inference code, artifacts (from prior training), and a custom environment map that the inference code uses when you deploy the model for predictions.
#'
#' See [https://paws-r.github.io/docs/sagemaker/create_model.html](https://paws-r.github.io/docs/sagemaker/create_model.html) for full documentation.
#'
#' @param ModelName &#91;required&#93; The name of the new model.
#' @param PrimaryContainer The location of the primary docker image containing inference code,
#' associated artifacts, and custom environment map that the inference code
#' uses when the model is deployed for predictions.
#' @param Containers Specifies the containers in the inference pipeline.
#' @param InferenceExecutionConfig Specifies details of how containers in a multi-container endpoint are
#' called.
#' @param ExecutionRoleArn &#91;required&#93; The Amazon Resource Name (ARN) of the IAM role that SageMaker can assume
#' to access model artifacts and docker image for deployment on ML compute
#' instances or for batch transform jobs. Deploying on ML compute instances
#' is part of model hosting. For more information, see [SageMaker
#' Roles](https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html).
#' 
#' To be able to pass this role to SageMaker, the caller of this API must
#' have the `iam:PassRole` permission.
#' @param Tags An array of key-value pairs. You can use tags to categorize your Amazon
#' Web Services resources in different ways, for example, by purpose,
#' owner, or environment. For more information, see [Tagging Amazon Web
#' Services
#' Resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html).
#' @param VpcConfig A VpcConfig object that specifies the VPC that you want your model to
#' connect to. Control access to and from your model container by
#' configuring the VPC. `VpcConfig` is used in hosting services and in
#' batch transform. For more information, see [Protect Endpoints by Using
#' an Amazon Virtual Private
#' Cloud](https://docs.aws.amazon.com/sagemaker/latest/dg/host-vpc.html)
#' and [Protect Data in Batch Transform Jobs by Using an Amazon Virtual
#' Private
#' Cloud](https://docs.aws.amazon.com/sagemaker/latest/dg/batch-vpc.html).
#' @param EnableNetworkIsolation Isolates the model container. No inbound or outbound network calls can
#' be made to or from the model container.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_model
sagemaker_create_model <- function(ModelName, PrimaryContainer = NULL, Containers = NULL, InferenceExecutionConfig = NULL, ExecutionRoleArn, Tags = NULL, VpcConfig = NULL, EnableNetworkIsolation = NULL) {
  op <- new_operation(
    name = "CreateModel",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$create_model_input(ModelName = ModelName, PrimaryContainer = PrimaryContainer, Containers = Containers, InferenceExecutionConfig = InferenceExecutionConfig, ExecutionRoleArn = ExecutionRoleArn, Tags = Tags, VpcConfig = VpcConfig, EnableNetworkIsolation = EnableNetworkIsolation)
  output <- .sagemaker$create_model_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_model <- sagemaker_create_model

#' Creates the definition for a model bias job
#'
#' @description
#' Creates the definition for a model bias job.
#'
#' See [https://paws-r.github.io/docs/sagemaker/create_model_bias_job_definition.html](https://paws-r.github.io/docs/sagemaker/create_model_bias_job_definition.html) for full documentation.
#'
#' @param JobDefinitionName &#91;required&#93; The name of the bias job definition. The name must be unique within an
#' Amazon Web Services Region in the Amazon Web Services account.
#' @param ModelBiasBaselineConfig The baseline configuration for a model bias job.
#' @param ModelBiasAppSpecification &#91;required&#93; Configures the model bias job to run a specified Docker container image.
#' @param ModelBiasJobInput &#91;required&#93; Inputs for the model bias job.
#' @param ModelBiasJobOutputConfig &#91;required&#93; 
#' @param JobResources &#91;required&#93; 
#' @param NetworkConfig Networking options for a model bias job.
#' @param RoleArn &#91;required&#93; The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can
#' assume to perform tasks on your behalf.
#' @param StoppingCondition 
#' @param Tags (Optional) An array of key-value pairs. For more information, see [Using
#' Cost Allocation
#' Tags](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL)
#' in the *Amazon Web Services Billing and Cost Management User Guide*.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_model_bias_job_definition
sagemaker_create_model_bias_job_definition <- function(JobDefinitionName, ModelBiasBaselineConfig = NULL, ModelBiasAppSpecification, ModelBiasJobInput, ModelBiasJobOutputConfig, JobResources, NetworkConfig = NULL, RoleArn, StoppingCondition = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateModelBiasJobDefinition",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$create_model_bias_job_definition_input(JobDefinitionName = JobDefinitionName, ModelBiasBaselineConfig = ModelBiasBaselineConfig, ModelBiasAppSpecification = ModelBiasAppSpecification, ModelBiasJobInput = ModelBiasJobInput, ModelBiasJobOutputConfig = ModelBiasJobOutputConfig, JobResources = JobResources, NetworkConfig = NetworkConfig, RoleArn = RoleArn, StoppingCondition = StoppingCondition, Tags = Tags)
  output <- .sagemaker$create_model_bias_job_definition_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_model_bias_job_definition <- sagemaker_create_model_bias_job_definition

#' Creates the definition for a model explainability job
#'
#' @description
#' Creates the definition for a model explainability job.
#'
#' See [https://paws-r.github.io/docs/sagemaker/create_model_explainability_job_definition.html](https://paws-r.github.io/docs/sagemaker/create_model_explainability_job_definition.html) for full documentation.
#'
#' @param JobDefinitionName &#91;required&#93; The name of the model explainability job definition. The name must be
#' unique within an Amazon Web Services Region in the Amazon Web Services
#' account.
#' @param ModelExplainabilityBaselineConfig The baseline configuration for a model explainability job.
#' @param ModelExplainabilityAppSpecification &#91;required&#93; Configures the model explainability job to run a specified Docker
#' container image.
#' @param ModelExplainabilityJobInput &#91;required&#93; Inputs for the model explainability job.
#' @param ModelExplainabilityJobOutputConfig &#91;required&#93; 
#' @param JobResources &#91;required&#93; 
#' @param NetworkConfig Networking options for a model explainability job.
#' @param RoleArn &#91;required&#93; The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can
#' assume to perform tasks on your behalf.
#' @param StoppingCondition 
#' @param Tags (Optional) An array of key-value pairs. For more information, see [Using
#' Cost Allocation
#' Tags](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL)
#' in the *Amazon Web Services Billing and Cost Management User Guide*.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_model_explainability_job_definition
sagemaker_create_model_explainability_job_definition <- function(JobDefinitionName, ModelExplainabilityBaselineConfig = NULL, ModelExplainabilityAppSpecification, ModelExplainabilityJobInput, ModelExplainabilityJobOutputConfig, JobResources, NetworkConfig = NULL, RoleArn, StoppingCondition = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateModelExplainabilityJobDefinition",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$create_model_explainability_job_definition_input(JobDefinitionName = JobDefinitionName, ModelExplainabilityBaselineConfig = ModelExplainabilityBaselineConfig, ModelExplainabilityAppSpecification = ModelExplainabilityAppSpecification, ModelExplainabilityJobInput = ModelExplainabilityJobInput, ModelExplainabilityJobOutputConfig = ModelExplainabilityJobOutputConfig, JobResources = JobResources, NetworkConfig = NetworkConfig, RoleArn = RoleArn, StoppingCondition = StoppingCondition, Tags = Tags)
  output <- .sagemaker$create_model_explainability_job_definition_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_model_explainability_job_definition <- sagemaker_create_model_explainability_job_definition

#' Creates a model package that you can use to create SageMaker models or
#' list on Amazon Web Services Marketplace, or a versioned model that is
#' part of a model group
#'
#' @description
#' Creates a model package that you can use to create SageMaker models or list on Amazon Web Services Marketplace, or a versioned model that is part of a model group. Buyers can subscribe to model packages listed on Amazon Web Services Marketplace to create models in SageMaker.
#'
#' See [https://paws-r.github.io/docs/sagemaker/create_model_package.html](https://paws-r.github.io/docs/sagemaker/create_model_package.html) for full documentation.
#'
#' @param ModelPackageName The name of the model package. The name must have 1 to 63 characters.
#' Valid characters are a-z, A-Z, 0-9, and - (hyphen).
#' 
#' This parameter is required for unversioned models. It is not applicable
#' to versioned models.
#' @param ModelPackageGroupName The name or Amazon Resource Name (ARN) of the model package group that
#' this model version belongs to.
#' 
#' This parameter is required for versioned models, and does not apply to
#' unversioned models.
#' @param ModelPackageDescription A description of the model package.
#' @param InferenceSpecification Specifies details about inference jobs that can be run with models based
#' on this model package, including the following:
#' 
#' -   The Amazon ECR paths of containers that contain the inference code
#'     and model artifacts.
#' 
#' -   The instance types that the model package supports for transform
#'     jobs and real-time endpoints used for inference.
#' 
#' -   The input and output content formats that the model package supports
#'     for inference.
#' @param ValidationSpecification Specifies configurations for one or more transform jobs that SageMaker
#' runs to test the model package.
#' @param SourceAlgorithmSpecification Details about the algorithm that was used to create the model package.
#' @param CertifyForMarketplace Whether to certify the model package for listing on Amazon Web Services
#' Marketplace.
#' 
#' This parameter is optional for unversioned models, and does not apply to
#' versioned models.
#' @param Tags A list of key value pairs associated with the model. For more
#' information, see [Tagging Amazon Web Services
#' resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
#' in the *Amazon Web Services General Reference Guide*.
#' @param ModelApprovalStatus Whether the model is approved for deployment.
#' 
#' This parameter is optional for versioned models, and does not apply to
#' unversioned models.
#' 
#' For versioned models, the value of this parameter must be set to
#' `Approved` to deploy the model.
#' @param MetadataProperties 
#' @param ModelMetrics A structure that contains model metrics reports.
#' @param ClientToken A unique token that guarantees that the call to this API is idempotent.
#' @param CustomerMetadataProperties The metadata properties associated with the model package versions.
#' @param DriftCheckBaselines Represents the drift check baselines that can be used when the model
#' monitor is set using the model package. For more information, see the
#' topic on [Drift Detection against Previous Baselines in SageMaker
#' Pipelines](https://docs.aws.amazon.com/sagemaker/latest/dg/pipelines-quality-clarify-baseline-lifecycle.html#pipelines-quality-clarify-baseline-drift-detection)
#' in the *Amazon SageMaker Developer Guide*.
#' @param Domain The machine learning domain of your model package and its components.
#' Common machine learning domains include computer vision and natural
#' language processing.
#' @param Task The machine learning task your model package accomplishes. Common
#' machine learning tasks include object detection and image
#' classification. The following tasks are supported by Inference
#' Recommender: `"IMAGE_CLASSIFICATION"` | `"OBJECT_DETECTION"` |
#' `"TEXT_GENERATION"` |`"IMAGE_SEGMENTATION"` | `"FILL_MASK"` |
#' `"CLASSIFICATION"` | `"REGRESSION"` | `"OTHER"`.
#' 
#' Specify "OTHER" if none of the tasks listed fit your use case.
#' @param SamplePayloadUrl The Amazon Simple Storage Service (Amazon S3) path where the sample
#' payload are stored. This path must point to a single gzip compressed tar
#' archive (.tar.gz suffix).
#' @param AdditionalInferenceSpecifications An array of additional Inference Specification objects. Each additional
#' Inference Specification specifies artifacts based on this model package
#' that can be used on inference endpoints. Generally used with SageMaker
#' Neo to store the compiled artifacts.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_model_package
sagemaker_create_model_package <- function(ModelPackageName = NULL, ModelPackageGroupName = NULL, ModelPackageDescription = NULL, InferenceSpecification = NULL, ValidationSpecification = NULL, SourceAlgorithmSpecification = NULL, CertifyForMarketplace = NULL, Tags = NULL, ModelApprovalStatus = NULL, MetadataProperties = NULL, ModelMetrics = NULL, ClientToken = NULL, CustomerMetadataProperties = NULL, DriftCheckBaselines = NULL, Domain = NULL, Task = NULL, SamplePayloadUrl = NULL, AdditionalInferenceSpecifications = NULL) {
  op <- new_operation(
    name = "CreateModelPackage",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$create_model_package_input(ModelPackageName = ModelPackageName, ModelPackageGroupName = ModelPackageGroupName, ModelPackageDescription = ModelPackageDescription, InferenceSpecification = InferenceSpecification, ValidationSpecification = ValidationSpecification, SourceAlgorithmSpecification = SourceAlgorithmSpecification, CertifyForMarketplace = CertifyForMarketplace, Tags = Tags, ModelApprovalStatus = ModelApprovalStatus, MetadataProperties = MetadataProperties, ModelMetrics = ModelMetrics, ClientToken = ClientToken, CustomerMetadataProperties = CustomerMetadataProperties, DriftCheckBaselines = DriftCheckBaselines, Domain = Domain, Task = Task, SamplePayloadUrl = SamplePayloadUrl, AdditionalInferenceSpecifications = AdditionalInferenceSpecifications)
  output <- .sagemaker$create_model_package_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_model_package <- sagemaker_create_model_package

#' Creates a model group
#'
#' @description
#' Creates a model group. A model group contains a group of model versions.
#'
#' See [https://paws-r.github.io/docs/sagemaker/create_model_package_group.html](https://paws-r.github.io/docs/sagemaker/create_model_package_group.html) for full documentation.
#'
#' @param ModelPackageGroupName &#91;required&#93; The name of the model group.
#' @param ModelPackageGroupDescription A description for the model group.
#' @param Tags A list of key value pairs associated with the model group. For more
#' information, see [Tagging Amazon Web Services
#' resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
#' in the *Amazon Web Services General Reference Guide*.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_model_package_group
sagemaker_create_model_package_group <- function(ModelPackageGroupName, ModelPackageGroupDescription = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateModelPackageGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$create_model_package_group_input(ModelPackageGroupName = ModelPackageGroupName, ModelPackageGroupDescription = ModelPackageGroupDescription, Tags = Tags)
  output <- .sagemaker$create_model_package_group_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_model_package_group <- sagemaker_create_model_package_group

#' Creates a definition for a job that monitors model quality and drift
#'
#' @description
#' Creates a definition for a job that monitors model quality and drift. For information about model monitor, see [Amazon SageMaker Model Monitor](https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor.html).
#'
#' See [https://paws-r.github.io/docs/sagemaker/create_model_quality_job_definition.html](https://paws-r.github.io/docs/sagemaker/create_model_quality_job_definition.html) for full documentation.
#'
#' @param JobDefinitionName &#91;required&#93; The name of the monitoring job definition.
#' @param ModelQualityBaselineConfig Specifies the constraints and baselines for the monitoring job.
#' @param ModelQualityAppSpecification &#91;required&#93; The container that runs the monitoring job.
#' @param ModelQualityJobInput &#91;required&#93; A list of the inputs that are monitored. Currently endpoints are
#' supported.
#' @param ModelQualityJobOutputConfig &#91;required&#93; 
#' @param JobResources &#91;required&#93; 
#' @param NetworkConfig Specifies the network configuration for the monitoring job.
#' @param RoleArn &#91;required&#93; The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can
#' assume to perform tasks on your behalf.
#' @param StoppingCondition 
#' @param Tags (Optional) An array of key-value pairs. For more information, see [Using
#' Cost Allocation
#' Tags](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL)
#' in the *Amazon Web Services Billing and Cost Management User Guide*.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_model_quality_job_definition
sagemaker_create_model_quality_job_definition <- function(JobDefinitionName, ModelQualityBaselineConfig = NULL, ModelQualityAppSpecification, ModelQualityJobInput, ModelQualityJobOutputConfig, JobResources, NetworkConfig = NULL, RoleArn, StoppingCondition = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateModelQualityJobDefinition",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$create_model_quality_job_definition_input(JobDefinitionName = JobDefinitionName, ModelQualityBaselineConfig = ModelQualityBaselineConfig, ModelQualityAppSpecification = ModelQualityAppSpecification, ModelQualityJobInput = ModelQualityJobInput, ModelQualityJobOutputConfig = ModelQualityJobOutputConfig, JobResources = JobResources, NetworkConfig = NetworkConfig, RoleArn = RoleArn, StoppingCondition = StoppingCondition, Tags = Tags)
  output <- .sagemaker$create_model_quality_job_definition_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_model_quality_job_definition <- sagemaker_create_model_quality_job_definition

#' Creates a schedule that regularly starts Amazon SageMaker Processing
#' Jobs to monitor the data captured for an Amazon SageMaker Endoint
#'
#' @description
#' Creates a schedule that regularly starts Amazon SageMaker Processing Jobs to monitor the data captured for an Amazon SageMaker Endoint.
#'
#' See [https://paws-r.github.io/docs/sagemaker/create_monitoring_schedule.html](https://paws-r.github.io/docs/sagemaker/create_monitoring_schedule.html) for full documentation.
#'
#' @param MonitoringScheduleName &#91;required&#93; The name of the monitoring schedule. The name must be unique within an
#' Amazon Web Services Region within an Amazon Web Services account.
#' @param MonitoringScheduleConfig &#91;required&#93; The configuration object that specifies the monitoring schedule and
#' defines the monitoring job.
#' @param Tags (Optional) An array of key-value pairs. For more information, see Using
#' Cost Allocation Tags in the *Amazon Web Services Billing and Cost
#' Management User Guide*.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_monitoring_schedule
sagemaker_create_monitoring_schedule <- function(MonitoringScheduleName, MonitoringScheduleConfig, Tags = NULL) {
  op <- new_operation(
    name = "CreateMonitoringSchedule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$create_monitoring_schedule_input(MonitoringScheduleName = MonitoringScheduleName, MonitoringScheduleConfig = MonitoringScheduleConfig, Tags = Tags)
  output <- .sagemaker$create_monitoring_schedule_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_monitoring_schedule <- sagemaker_create_monitoring_schedule

#' Creates an SageMaker notebook instance
#'
#' @description
#' Creates an SageMaker notebook instance. A notebook instance is a machine learning (ML) compute instance running on a Jupyter notebook.
#'
#' See [https://paws-r.github.io/docs/sagemaker/create_notebook_instance.html](https://paws-r.github.io/docs/sagemaker/create_notebook_instance.html) for full documentation.
#'
#' @param NotebookInstanceName &#91;required&#93; The name of the new notebook instance.
#' @param InstanceType &#91;required&#93; The type of ML compute instance to launch for the notebook instance.
#' @param SubnetId The ID of the subnet in a VPC to which you would like to have a
#' connectivity from your ML compute instance.
#' @param SecurityGroupIds The VPC security group IDs, in the form sg-xxxxxxxx. The security groups
#' must be for the same VPC as specified in the subnet.
#' @param RoleArn &#91;required&#93; When you send any requests to Amazon Web Services resources from the
#' notebook instance, SageMaker assumes this role to perform tasks on your
#' behalf. You must grant this role necessary permissions so SageMaker can
#' perform these tasks. The policy must allow the SageMaker service
#' principal (sagemaker.amazonaws.com) permissions to assume this role. For
#' more information, see [SageMaker
#' Roles](https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html).
#' 
#' To be able to pass this role to SageMaker, the caller of this API must
#' have the `iam:PassRole` permission.
#' @param KmsKeyId The Amazon Resource Name (ARN) of a Amazon Web Services Key Management
#' Service key that SageMaker uses to encrypt data on the storage volume
#' attached to your notebook instance. The KMS key you provide must be
#' enabled. For information, see [Enabling and Disabling
#' Keys](https://docs.aws.amazon.com/kms/latest/developerguide/enabling-keys.html)
#' in the *Amazon Web Services Key Management Service Developer Guide*.
#' @param Tags An array of key-value pairs. You can use tags to categorize your Amazon
#' Web Services resources in different ways, for example, by purpose,
#' owner, or environment. For more information, see [Tagging Amazon Web
#' Services
#' Resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html).
#' @param LifecycleConfigName The name of a lifecycle configuration to associate with the notebook
#' instance. For information about lifestyle configurations, see [Step 2.1:
#' (Optional) Customize a Notebook
#' Instance](https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html).
#' @param DirectInternetAccess Sets whether SageMaker provides internet access to the notebook
#' instance. If you set this to `Disabled` this notebook instance is able
#' to access resources only in your VPC, and is not be able to connect to
#' SageMaker training and endpoint services unless you configure a NAT
#' Gateway in your VPC.
#' 
#' For more information, see [Notebook Instances Are Internet-Enabled by
#' Default](https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-interface-endpoint.html#appendix-notebook-and-internet-access).
#' You can set the value of this parameter to `Disabled` only if you set a
#' value for the `SubnetId` parameter.
#' @param VolumeSizeInGB The size, in GB, of the ML storage volume to attach to the notebook
#' instance. The default value is 5 GB.
#' @param AcceleratorTypes A list of Elastic Inference (EI) instance types to associate with this
#' notebook instance. Currently, only one instance type can be associated
#' with a notebook instance. For more information, see [Using Elastic
#' Inference in Amazon
#' SageMaker](https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html).
#' @param DefaultCodeRepository A Git repository to associate with the notebook instance as its default
#' code repository. This can be either the name of a Git repository stored
#' as a resource in your account, or the URL of a Git repository in [Amazon
#' Web Services
#' CodeCommit](https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html)
#' or in any other Git repository. When you open a notebook instance, it
#' opens in the directory that contains this repository. For more
#' information, see [Associating Git Repositories with SageMaker Notebook
#' Instances](https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html).
#' @param AdditionalCodeRepositories An array of up to three Git repositories to associate with the notebook
#' instance. These can be either the names of Git repositories stored as
#' resources in your account, or the URL of Git repositories in [Amazon Web
#' Services
#' CodeCommit](https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html)
#' or in any other Git repository. These repositories are cloned at the
#' same level as the default repository of your notebook instance. For more
#' information, see [Associating Git Repositories with SageMaker Notebook
#' Instances](https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html).
#' @param RootAccess Whether root access is enabled or disabled for users of the notebook
#' instance. The default value is `Enabled`.
#' 
#' Lifecycle configurations need root access to be able to set up a
#' notebook instance. Because of this, lifecycle configurations associated
#' with a notebook instance always run with root access even if you disable
#' root access for users.
#' @param PlatformIdentifier The platform identifier of the notebook instance runtime environment.
#' @param InstanceMetadataServiceConfiguration Information on the IMDS configuration of the notebook instance
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_notebook_instance
sagemaker_create_notebook_instance <- function(NotebookInstanceName, InstanceType, SubnetId = NULL, SecurityGroupIds = NULL, RoleArn, KmsKeyId = NULL, Tags = NULL, LifecycleConfigName = NULL, DirectInternetAccess = NULL, VolumeSizeInGB = NULL, AcceleratorTypes = NULL, DefaultCodeRepository = NULL, AdditionalCodeRepositories = NULL, RootAccess = NULL, PlatformIdentifier = NULL, InstanceMetadataServiceConfiguration = NULL) {
  op <- new_operation(
    name = "CreateNotebookInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$create_notebook_instance_input(NotebookInstanceName = NotebookInstanceName, InstanceType = InstanceType, SubnetId = SubnetId, SecurityGroupIds = SecurityGroupIds, RoleArn = RoleArn, KmsKeyId = KmsKeyId, Tags = Tags, LifecycleConfigName = LifecycleConfigName, DirectInternetAccess = DirectInternetAccess, VolumeSizeInGB = VolumeSizeInGB, AcceleratorTypes = AcceleratorTypes, DefaultCodeRepository = DefaultCodeRepository, AdditionalCodeRepositories = AdditionalCodeRepositories, RootAccess = RootAccess, PlatformIdentifier = PlatformIdentifier, InstanceMetadataServiceConfiguration = InstanceMetadataServiceConfiguration)
  output <- .sagemaker$create_notebook_instance_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_notebook_instance <- sagemaker_create_notebook_instance

#' Creates a lifecycle configuration that you can associate with a notebook
#' instance
#'
#' @description
#' Creates a lifecycle configuration that you can associate with a notebook instance. A *lifecycle configuration* is a collection of shell scripts that run when you create or start a notebook instance.
#'
#' See [https://paws-r.github.io/docs/sagemaker/create_notebook_instance_lifecycle_config.html](https://paws-r.github.io/docs/sagemaker/create_notebook_instance_lifecycle_config.html) for full documentation.
#'
#' @param NotebookInstanceLifecycleConfigName &#91;required&#93; The name of the lifecycle configuration.
#' @param OnCreate A shell script that runs only once, when you create a notebook instance.
#' The shell script must be a base64-encoded string.
#' @param OnStart A shell script that runs every time you start a notebook instance,
#' including when you create the notebook instance. The shell script must
#' be a base64-encoded string.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_notebook_instance_lifecycle_config
sagemaker_create_notebook_instance_lifecycle_config <- function(NotebookInstanceLifecycleConfigName, OnCreate = NULL, OnStart = NULL) {
  op <- new_operation(
    name = "CreateNotebookInstanceLifecycleConfig",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$create_notebook_instance_lifecycle_config_input(NotebookInstanceLifecycleConfigName = NotebookInstanceLifecycleConfigName, OnCreate = OnCreate, OnStart = OnStart)
  output <- .sagemaker$create_notebook_instance_lifecycle_config_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_notebook_instance_lifecycle_config <- sagemaker_create_notebook_instance_lifecycle_config

#' Creates a pipeline using a JSON pipeline definition
#'
#' @description
#' Creates a pipeline using a JSON pipeline definition.
#'
#' See [https://paws-r.github.io/docs/sagemaker/create_pipeline.html](https://paws-r.github.io/docs/sagemaker/create_pipeline.html) for full documentation.
#'
#' @param PipelineName &#91;required&#93; The name of the pipeline.
#' @param PipelineDisplayName The display name of the pipeline.
#' @param PipelineDefinition The JSON pipeline definition of the pipeline.
#' @param PipelineDefinitionS3Location The location of the pipeline definition stored in Amazon S3. If
#' specified, SageMaker will retrieve the pipeline definition from this
#' location.
#' @param PipelineDescription A description of the pipeline.
#' @param ClientRequestToken &#91;required&#93; A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the operation. An idempotent operation completes no more
#' than one time.
#' @param RoleArn &#91;required&#93; The Amazon Resource Name (ARN) of the role used by the pipeline to
#' access and create resources.
#' @param Tags A list of tags to apply to the created pipeline.
#' @param ParallelismConfiguration This is the configuration that controls the parallelism of the pipeline.
#' If specified, it applies to all runs of this pipeline by default.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_pipeline
sagemaker_create_pipeline <- function(PipelineName, PipelineDisplayName = NULL, PipelineDefinition = NULL, PipelineDefinitionS3Location = NULL, PipelineDescription = NULL, ClientRequestToken, RoleArn, Tags = NULL, ParallelismConfiguration = NULL) {
  op <- new_operation(
    name = "CreatePipeline",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$create_pipeline_input(PipelineName = PipelineName, PipelineDisplayName = PipelineDisplayName, PipelineDefinition = PipelineDefinition, PipelineDefinitionS3Location = PipelineDefinitionS3Location, PipelineDescription = PipelineDescription, ClientRequestToken = ClientRequestToken, RoleArn = RoleArn, Tags = Tags, ParallelismConfiguration = ParallelismConfiguration)
  output <- .sagemaker$create_pipeline_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_pipeline <- sagemaker_create_pipeline

#' Creates a URL for a specified UserProfile in a Domain
#'
#' @description
#' Creates a URL for a specified UserProfile in a Domain. When accessed in a web browser, the user will be automatically signed in to Amazon SageMaker Studio, and granted access to all of the Apps and files associated with the Domain's Amazon Elastic File System (EFS) volume. This operation can only be called when the authentication mode equals IAM.
#'
#' See [https://paws-r.github.io/docs/sagemaker/create_presigned_domain_url.html](https://paws-r.github.io/docs/sagemaker/create_presigned_domain_url.html) for full documentation.
#'
#' @param DomainId &#91;required&#93; The domain ID.
#' @param UserProfileName &#91;required&#93; The name of the UserProfile to sign-in as.
#' @param SessionExpirationDurationInSeconds The session expiration duration in seconds. This value defaults to
#' 43200.
#' @param ExpiresInSeconds The number of seconds until the pre-signed URL expires. This value
#' defaults to 300.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_presigned_domain_url
sagemaker_create_presigned_domain_url <- function(DomainId, UserProfileName, SessionExpirationDurationInSeconds = NULL, ExpiresInSeconds = NULL) {
  op <- new_operation(
    name = "CreatePresignedDomainUrl",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$create_presigned_domain_url_input(DomainId = DomainId, UserProfileName = UserProfileName, SessionExpirationDurationInSeconds = SessionExpirationDurationInSeconds, ExpiresInSeconds = ExpiresInSeconds)
  output <- .sagemaker$create_presigned_domain_url_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_presigned_domain_url <- sagemaker_create_presigned_domain_url

#' Returns a URL that you can use to connect to the Jupyter server from a
#' notebook instance
#'
#' @description
#' Returns a URL that you can use to connect to the Jupyter server from a notebook instance. In the SageMaker console, when you choose `Open` next to a notebook instance, SageMaker opens a new tab showing the Jupyter server home page from the notebook instance. The console uses this API to get the URL and show the page.
#'
#' See [https://paws-r.github.io/docs/sagemaker/create_presigned_notebook_instance_url.html](https://paws-r.github.io/docs/sagemaker/create_presigned_notebook_instance_url.html) for full documentation.
#'
#' @param NotebookInstanceName &#91;required&#93; The name of the notebook instance.
#' @param SessionExpirationDurationInSeconds The duration of the session, in seconds. The default is 12 hours.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_presigned_notebook_instance_url
sagemaker_create_presigned_notebook_instance_url <- function(NotebookInstanceName, SessionExpirationDurationInSeconds = NULL) {
  op <- new_operation(
    name = "CreatePresignedNotebookInstanceUrl",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$create_presigned_notebook_instance_url_input(NotebookInstanceName = NotebookInstanceName, SessionExpirationDurationInSeconds = SessionExpirationDurationInSeconds)
  output <- .sagemaker$create_presigned_notebook_instance_url_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_presigned_notebook_instance_url <- sagemaker_create_presigned_notebook_instance_url

#' Creates a processing job
#'
#' @description
#' Creates a processing job.
#'
#' See [https://paws-r.github.io/docs/sagemaker/create_processing_job.html](https://paws-r.github.io/docs/sagemaker/create_processing_job.html) for full documentation.
#'
#' @param ProcessingInputs An array of inputs configuring the data to download into the processing
#' container.
#' @param ProcessingOutputConfig Output configuration for the processing job.
#' @param ProcessingJobName &#91;required&#93; The name of the processing job. The name must be unique within an Amazon
#' Web Services Region in the Amazon Web Services account.
#' @param ProcessingResources &#91;required&#93; Identifies the resources, ML compute instances, and ML storage volumes
#' to deploy for a processing job. In distributed training, you specify
#' more than one instance.
#' @param StoppingCondition The time limit for how long the processing job is allowed to run.
#' @param AppSpecification &#91;required&#93; Configures the processing job to run a specified Docker container image.
#' @param Environment The environment variables to set in the Docker container. Up to 100 key
#' and values entries in the map are supported.
#' @param NetworkConfig Networking options for a processing job, such as whether to allow
#' inbound and outbound network calls to and from processing containers,
#' and the VPC subnets and security groups to use for VPC-enabled
#' processing jobs.
#' @param RoleArn &#91;required&#93; The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can
#' assume to perform tasks on your behalf.
#' @param Tags (Optional) An array of key-value pairs. For more information, see [Using
#' Cost Allocation
#' Tags](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL)
#' in the *Amazon Web Services Billing and Cost Management User Guide*.
#' @param ExperimentConfig 
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_processing_job
sagemaker_create_processing_job <- function(ProcessingInputs = NULL, ProcessingOutputConfig = NULL, ProcessingJobName, ProcessingResources, StoppingCondition = NULL, AppSpecification, Environment = NULL, NetworkConfig = NULL, RoleArn, Tags = NULL, ExperimentConfig = NULL) {
  op <- new_operation(
    name = "CreateProcessingJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$create_processing_job_input(ProcessingInputs = ProcessingInputs, ProcessingOutputConfig = ProcessingOutputConfig, ProcessingJobName = ProcessingJobName, ProcessingResources = ProcessingResources, StoppingCondition = StoppingCondition, AppSpecification = AppSpecification, Environment = Environment, NetworkConfig = NetworkConfig, RoleArn = RoleArn, Tags = Tags, ExperimentConfig = ExperimentConfig)
  output <- .sagemaker$create_processing_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_processing_job <- sagemaker_create_processing_job

#' Creates a machine learning (ML) project that can contain one or more
#' templates that set up an ML pipeline from training to deploying an
#' approved model
#'
#' @description
#' Creates a machine learning (ML) project that can contain one or more templates that set up an ML pipeline from training to deploying an approved model.
#'
#' See [https://paws-r.github.io/docs/sagemaker/create_project.html](https://paws-r.github.io/docs/sagemaker/create_project.html) for full documentation.
#'
#' @param ProjectName &#91;required&#93; The name of the project.
#' @param ProjectDescription A description for the project.
#' @param ServiceCatalogProvisioningDetails &#91;required&#93; The product ID and provisioning artifact ID to provision a service
#' catalog. The provisioning artifact ID will default to the latest
#' provisioning artifact ID of the product, if you don't provide the
#' provisioning artifact ID. For more information, see [What is Amazon Web
#' Services Service
#' Catalog](https://docs.aws.amazon.com/servicecatalog/latest/adminguide/introduction.html).
#' @param Tags An array of key-value pairs that you want to use to organize and track
#' your Amazon Web Services resource costs. For more information, see
#' [Tagging Amazon Web Services
#' resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
#' in the *Amazon Web Services General Reference Guide*.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_project
sagemaker_create_project <- function(ProjectName, ProjectDescription = NULL, ServiceCatalogProvisioningDetails, Tags = NULL) {
  op <- new_operation(
    name = "CreateProject",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$create_project_input(ProjectName = ProjectName, ProjectDescription = ProjectDescription, ServiceCatalogProvisioningDetails = ServiceCatalogProvisioningDetails, Tags = Tags)
  output <- .sagemaker$create_project_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_project <- sagemaker_create_project

#' Creates a new Studio Lifecycle Configuration
#'
#' @description
#' Creates a new Studio Lifecycle Configuration.
#'
#' See [https://paws-r.github.io/docs/sagemaker/create_studio_lifecycle_config.html](https://paws-r.github.io/docs/sagemaker/create_studio_lifecycle_config.html) for full documentation.
#'
#' @param StudioLifecycleConfigName &#91;required&#93; The name of the Studio Lifecycle Configuration to create.
#' @param StudioLifecycleConfigContent &#91;required&#93; The content of your Studio Lifecycle Configuration script. This content
#' must be base64 encoded.
#' @param StudioLifecycleConfigAppType &#91;required&#93; The App type that the Lifecycle Configuration is attached to.
#' @param Tags Tags to be associated with the Lifecycle Configuration. Each tag
#' consists of a key and an optional value. Tag keys must be unique per
#' resource. Tags are searchable using the Search API.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_studio_lifecycle_config
sagemaker_create_studio_lifecycle_config <- function(StudioLifecycleConfigName, StudioLifecycleConfigContent, StudioLifecycleConfigAppType, Tags = NULL) {
  op <- new_operation(
    name = "CreateStudioLifecycleConfig",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$create_studio_lifecycle_config_input(StudioLifecycleConfigName = StudioLifecycleConfigName, StudioLifecycleConfigContent = StudioLifecycleConfigContent, StudioLifecycleConfigAppType = StudioLifecycleConfigAppType, Tags = Tags)
  output <- .sagemaker$create_studio_lifecycle_config_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_studio_lifecycle_config <- sagemaker_create_studio_lifecycle_config

#' Starts a model training job
#'
#' @description
#' Starts a model training job. After training completes, SageMaker saves the resulting model artifacts to an Amazon S3 location that you specify.
#'
#' See [https://paws-r.github.io/docs/sagemaker/create_training_job.html](https://paws-r.github.io/docs/sagemaker/create_training_job.html) for full documentation.
#'
#' @param TrainingJobName &#91;required&#93; The name of the training job. The name must be unique within an Amazon
#' Web Services Region in an Amazon Web Services account.
#' @param HyperParameters Algorithm-specific parameters that influence the quality of the model.
#' You set hyperparameters before you start the learning process. For a
#' list of hyperparameters for each training algorithm provided by
#' SageMaker, see
#' [Algorithms](https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html).
#' 
#' You can specify a maximum of 100 hyperparameters. Each hyperparameter is
#' a key-value pair. Each key and value is limited to 256 characters, as
#' specified by the `Length Constraint`.
#' @param AlgorithmSpecification &#91;required&#93; The registry path of the Docker image that contains the training
#' algorithm and algorithm-specific metadata, including the input mode. For
#' more information about algorithms provided by SageMaker, see
#' [Algorithms](https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html).
#' For information about providing your own algorithms, see [Using Your Own
#' Algorithms with Amazon
#' SageMaker](https://docs.aws.amazon.com/sagemaker/latest/dg/docker-containers.html).
#' @param RoleArn &#91;required&#93; The Amazon Resource Name (ARN) of an IAM role that SageMaker can assume
#' to perform tasks on your behalf.
#' 
#' During model training, SageMaker needs your permission to read input
#' data from an S3 bucket, download a Docker image that contains training
#' code, write model artifacts to an S3 bucket, write logs to Amazon
#' CloudWatch Logs, and publish metrics to Amazon CloudWatch. You grant
#' permissions for all of these tasks to an IAM role. For more information,
#' see [SageMaker
#' Roles](https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html).
#' 
#' To be able to pass this role to SageMaker, the caller of this API must
#' have the `iam:PassRole` permission.
#' @param InputDataConfig An array of `Channel` objects. Each channel is a named input source.
#' `InputDataConfig` describes the input data and its location.
#' 
#' Algorithms can accept input data from one or more channels. For example,
#' an algorithm might have two channels of input data, `training_data` and
#' `validation_data`. The configuration for each channel provides the S3,
#' EFS, or FSx location where the input data is stored. It also provides
#' information about the stored data: the MIME type, compression method,
#' and whether the data is wrapped in RecordIO format.
#' 
#' Depending on the input mode that the algorithm supports, SageMaker
#' either copies input data files from an S3 bucket to a local directory in
#' the Docker container, or makes it available as input streams. For
#' example, if you specify an EFS location, input data files are available
#' as input streams. They do not need to be downloaded.
#' @param OutputDataConfig &#91;required&#93; Specifies the path to the S3 location where you want to store model
#' artifacts. SageMaker creates subfolders for the artifacts.
#' @param ResourceConfig &#91;required&#93; The resources, including the ML compute instances and ML storage
#' volumes, to use for model training.
#' 
#' ML storage volumes store model artifacts and incremental states.
#' Training algorithms might also use ML storage volumes for scratch space.
#' If you want SageMaker to use the ML storage volume to store the training
#' data, choose `File` as the `TrainingInputMode` in the algorithm
#' specification. For distributed training algorithms, specify an instance
#' count greater than 1.
#' @param VpcConfig A VpcConfig object that specifies the VPC that you want your training
#' job to connect to. Control access to and from your training container by
#' configuring the VPC. For more information, see [Protect Training Jobs by
#' Using an Amazon Virtual Private
#' Cloud](https://docs.aws.amazon.com/sagemaker/latest/dg/train-vpc.html).
#' @param StoppingCondition &#91;required&#93; Specifies a limit to how long a model training job can run. It also
#' specifies how long a managed Spot training job has to complete. When the
#' job reaches the time limit, SageMaker ends the training job. Use this
#' API to cap model training costs.
#' 
#' To stop a job, SageMaker sends the algorithm the `SIGTERM` signal, which
#' delays job termination for 120 seconds. Algorithms can use this
#' 120-second window to save the model artifacts, so the results of
#' training are not lost.
#' @param Tags An array of key-value pairs. You can use tags to categorize your Amazon
#' Web Services resources in different ways, for example, by purpose,
#' owner, or environment. For more information, see [Tagging Amazon Web
#' Services
#' Resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html).
#' @param EnableNetworkIsolation Isolates the training container. No inbound or outbound network calls
#' can be made, except for calls between peers within a training cluster
#' for distributed training. If you enable network isolation for training
#' jobs that are configured to use a VPC, SageMaker downloads and uploads
#' customer data and model artifacts through the specified VPC, but the
#' training container does not have network access.
#' @param EnableInterContainerTrafficEncryption To encrypt all communications between ML compute instances in
#' distributed training, choose `True`. Encryption provides greater
#' security for distributed training, but training might take longer. How
#' long it takes depends on the amount of communication between compute
#' instances, especially if you use a deep learning algorithm in
#' distributed training. For more information, see [Protect Communications
#' Between ML Compute Instances in a Distributed Training
#' Job](https://docs.aws.amazon.com/sagemaker/latest/dg/train-encrypt.html).
#' @param EnableManagedSpotTraining To train models using managed spot training, choose `True`. Managed spot
#' training provides a fully managed and scalable infrastructure for
#' training machine learning models. this option is useful when training
#' jobs can be interrupted and when there is flexibility when the training
#' job is run.
#' 
#' The complete and intermediate results of jobs are stored in an Amazon S3
#' bucket, and can be used as a starting point to train models
#' incrementally. Amazon SageMaker provides metrics and logs in CloudWatch.
#' They can be used to see when managed spot training jobs are running,
#' interrupted, resumed, or completed.
#' @param CheckpointConfig Contains information about the output location for managed spot training
#' checkpoint data.
#' @param DebugHookConfig 
#' @param DebugRuleConfigurations Configuration information for Debugger rules for debugging output
#' tensors.
#' @param TensorBoardOutputConfig 
#' @param ExperimentConfig 
#' @param ProfilerConfig 
#' @param ProfilerRuleConfigurations Configuration information for Debugger rules for profiling system and
#' framework metrics.
#' @param Environment The environment variables to set in the Docker container.
#' @param RetryStrategy The number of times to retry the job when the job fails due to an
#' `InternalServerError`.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_training_job
sagemaker_create_training_job <- function(TrainingJobName, HyperParameters = NULL, AlgorithmSpecification, RoleArn, InputDataConfig = NULL, OutputDataConfig, ResourceConfig, VpcConfig = NULL, StoppingCondition, Tags = NULL, EnableNetworkIsolation = NULL, EnableInterContainerTrafficEncryption = NULL, EnableManagedSpotTraining = NULL, CheckpointConfig = NULL, DebugHookConfig = NULL, DebugRuleConfigurations = NULL, TensorBoardOutputConfig = NULL, ExperimentConfig = NULL, ProfilerConfig = NULL, ProfilerRuleConfigurations = NULL, Environment = NULL, RetryStrategy = NULL) {
  op <- new_operation(
    name = "CreateTrainingJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$create_training_job_input(TrainingJobName = TrainingJobName, HyperParameters = HyperParameters, AlgorithmSpecification = AlgorithmSpecification, RoleArn = RoleArn, InputDataConfig = InputDataConfig, OutputDataConfig = OutputDataConfig, ResourceConfig = ResourceConfig, VpcConfig = VpcConfig, StoppingCondition = StoppingCondition, Tags = Tags, EnableNetworkIsolation = EnableNetworkIsolation, EnableInterContainerTrafficEncryption = EnableInterContainerTrafficEncryption, EnableManagedSpotTraining = EnableManagedSpotTraining, CheckpointConfig = CheckpointConfig, DebugHookConfig = DebugHookConfig, DebugRuleConfigurations = DebugRuleConfigurations, TensorBoardOutputConfig = TensorBoardOutputConfig, ExperimentConfig = ExperimentConfig, ProfilerConfig = ProfilerConfig, ProfilerRuleConfigurations = ProfilerRuleConfigurations, Environment = Environment, RetryStrategy = RetryStrategy)
  output <- .sagemaker$create_training_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_training_job <- sagemaker_create_training_job

#' Starts a transform job
#'
#' @description
#' Starts a transform job. A transform job uses a trained model to get inferences on a dataset and saves these results to an Amazon S3 location that you specify.
#'
#' See [https://paws-r.github.io/docs/sagemaker/create_transform_job.html](https://paws-r.github.io/docs/sagemaker/create_transform_job.html) for full documentation.
#'
#' @param TransformJobName &#91;required&#93; The name of the transform job. The name must be unique within an Amazon
#' Web Services Region in an Amazon Web Services account.
#' @param ModelName &#91;required&#93; The name of the model that you want to use for the transform job.
#' `ModelName` must be the name of an existing Amazon SageMaker model
#' within an Amazon Web Services Region in an Amazon Web Services account.
#' @param MaxConcurrentTransforms The maximum number of parallel requests that can be sent to each
#' instance in a transform job. If `MaxConcurrentTransforms` is set to `0`
#' or left unset, Amazon SageMaker checks the optional execution-parameters
#' to determine the settings for your chosen algorithm. If the
#' execution-parameters endpoint is not enabled, the default value is `1`.
#' For more information on execution-parameters, see [How Containers Serve
#' Requests](https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms-batch-code.html#your-algorithms-batch-code-how-containe-serves-requests).
#' For built-in algorithms, you don't need to set a value for
#' `MaxConcurrentTransforms`.
#' @param ModelClientConfig Configures the timeout and maximum number of retries for processing a
#' transform job invocation.
#' @param MaxPayloadInMB The maximum allowed size of the payload, in MB. A *payload* is the data
#' portion of a record (without metadata). The value in `MaxPayloadInMB`
#' must be greater than, or equal to, the size of a single record. To
#' estimate the size of a record in MB, divide the size of your dataset by
#' the number of records. To ensure that the records fit within the maximum
#' payload size, we recommend using a slightly larger value. The default
#' value is `6` MB.
#' 
#' The value of `MaxPayloadInMB` cannot be greater than 100 MB. If you
#' specify the `MaxConcurrentTransforms` parameter, the value of
#' `(MaxConcurrentTransforms * MaxPayloadInMB)` also cannot exceed 100 MB.
#' 
#' For cases where the payload might be arbitrarily large and is
#' transmitted using HTTP chunked encoding, set the value to `0`. This
#' feature works only in supported algorithms. Currently, Amazon SageMaker
#' built-in algorithms do not support HTTP chunked encoding.
#' @param BatchStrategy Specifies the number of records to include in a mini-batch for an HTTP
#' inference request. A *record* is a single unit of input data that
#' inference can be made on. For example, a single line in a CSV file is a
#' record.
#' 
#' To enable the batch strategy, you must set the `SplitType` property to
#' `Line`, `RecordIO`, or `TFRecord`.
#' 
#' To use only one record when making an HTTP invocation request to a
#' container, set `BatchStrategy` to `SingleRecord` and `SplitType` to
#' `Line`.
#' 
#' To fit as many records in a mini-batch as can fit within the
#' `MaxPayloadInMB` limit, set `BatchStrategy` to `MultiRecord` and
#' `SplitType` to `Line`.
#' @param Environment The environment variables to set in the Docker container. We support up
#' to 16 key and values entries in the map.
#' @param TransformInput &#91;required&#93; Describes the input source and the way the transform job consumes it.
#' @param TransformOutput &#91;required&#93; Describes the results of the transform job.
#' @param TransformResources &#91;required&#93; Describes the resources, including ML instance types and ML instance
#' count, to use for the transform job.
#' @param DataProcessing The data structure used to specify the data to be used for inference in
#' a batch transform job and to associate the data that is relevant to the
#' prediction results in the output. The input filter provided allows you
#' to exclude input data that is not needed for inference in a batch
#' transform job. The output filter provided allows you to include input
#' data relevant to interpreting the predictions in the output from the
#' job. For more information, see [Associate Prediction Results with their
#' Corresponding Input
#' Records](https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform-data-processing.html).
#' @param Tags (Optional) An array of key-value pairs. For more information, see [Using
#' Cost Allocation
#' Tags](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what)
#' in the *Amazon Web Services Billing and Cost Management User Guide*.
#' @param ExperimentConfig 
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_transform_job
sagemaker_create_transform_job <- function(TransformJobName, ModelName, MaxConcurrentTransforms = NULL, ModelClientConfig = NULL, MaxPayloadInMB = NULL, BatchStrategy = NULL, Environment = NULL, TransformInput, TransformOutput, TransformResources, DataProcessing = NULL, Tags = NULL, ExperimentConfig = NULL) {
  op <- new_operation(
    name = "CreateTransformJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$create_transform_job_input(TransformJobName = TransformJobName, ModelName = ModelName, MaxConcurrentTransforms = MaxConcurrentTransforms, ModelClientConfig = ModelClientConfig, MaxPayloadInMB = MaxPayloadInMB, BatchStrategy = BatchStrategy, Environment = Environment, TransformInput = TransformInput, TransformOutput = TransformOutput, TransformResources = TransformResources, DataProcessing = DataProcessing, Tags = Tags, ExperimentConfig = ExperimentConfig)
  output <- .sagemaker$create_transform_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_transform_job <- sagemaker_create_transform_job

#' Creates an SageMaker trial
#'
#' @description
#' Creates an SageMaker *trial*. A trial is a set of steps called *trial components* that produce a machine learning model. A trial is part of a single SageMaker *experiment*.
#'
#' See [https://paws-r.github.io/docs/sagemaker/create_trial.html](https://paws-r.github.io/docs/sagemaker/create_trial.html) for full documentation.
#'
#' @param TrialName &#91;required&#93; The name of the trial. The name must be unique in your Amazon Web
#' Services account and is not case-sensitive.
#' @param DisplayName The name of the trial as displayed. The name doesn't need to be unique.
#' If `DisplayName` isn't specified, `TrialName` is displayed.
#' @param ExperimentName &#91;required&#93; The name of the experiment to associate the trial with.
#' @param MetadataProperties 
#' @param Tags A list of tags to associate with the trial. You can use
#' [`search`][sagemaker_search] API to search on the tags.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_trial
sagemaker_create_trial <- function(TrialName, DisplayName = NULL, ExperimentName, MetadataProperties = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateTrial",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$create_trial_input(TrialName = TrialName, DisplayName = DisplayName, ExperimentName = ExperimentName, MetadataProperties = MetadataProperties, Tags = Tags)
  output <- .sagemaker$create_trial_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_trial <- sagemaker_create_trial

#' Creates a trial component, which is a stage of a machine learning trial
#'
#' @description
#' Creates a *trial component*, which is a stage of a machine learning *trial*. A trial is composed of one or more trial components. A trial component can be used in multiple trials.
#'
#' See [https://paws-r.github.io/docs/sagemaker/create_trial_component.html](https://paws-r.github.io/docs/sagemaker/create_trial_component.html) for full documentation.
#'
#' @param TrialComponentName &#91;required&#93; The name of the component. The name must be unique in your Amazon Web
#' Services account and is not case-sensitive.
#' @param DisplayName The name of the component as displayed. The name doesn't need to be
#' unique. If `DisplayName` isn't specified, `TrialComponentName` is
#' displayed.
#' @param Status The status of the component. States include:
#' 
#' -   InProgress
#' 
#' -   Completed
#' 
#' -   Failed
#' @param StartTime When the component started.
#' @param EndTime When the component ended.
#' @param Parameters The hyperparameters for the component.
#' @param InputArtifacts The input artifacts for the component. Examples of input artifacts are
#' datasets, algorithms, hyperparameters, source code, and instance types.
#' @param OutputArtifacts The output artifacts for the component. Examples of output artifacts are
#' metrics, snapshots, logs, and images.
#' @param MetadataProperties 
#' @param Tags A list of tags to associate with the component. You can use
#' [`search`][sagemaker_search] API to search on the tags.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_trial_component
sagemaker_create_trial_component <- function(TrialComponentName, DisplayName = NULL, Status = NULL, StartTime = NULL, EndTime = NULL, Parameters = NULL, InputArtifacts = NULL, OutputArtifacts = NULL, MetadataProperties = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateTrialComponent",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$create_trial_component_input(TrialComponentName = TrialComponentName, DisplayName = DisplayName, Status = Status, StartTime = StartTime, EndTime = EndTime, Parameters = Parameters, InputArtifacts = InputArtifacts, OutputArtifacts = OutputArtifacts, MetadataProperties = MetadataProperties, Tags = Tags)
  output <- .sagemaker$create_trial_component_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_trial_component <- sagemaker_create_trial_component

#' Creates a user profile
#'
#' @description
#' Creates a user profile. A user profile represents a single user within a domain, and is the main way to reference a "person" for the purposes of sharing, reporting, and other user-oriented features. This entity is created when a user onboards to Amazon SageMaker Studio. If an administrator invites a person by email or imports them from SSO, a user profile is automatically created. A user profile is the primary holder of settings for an individual user and has a reference to the user's private Amazon Elastic File System (EFS) home directory.
#'
#' See [https://paws-r.github.io/docs/sagemaker/create_user_profile.html](https://paws-r.github.io/docs/sagemaker/create_user_profile.html) for full documentation.
#'
#' @param DomainId &#91;required&#93; The ID of the associated Domain.
#' @param UserProfileName &#91;required&#93; A name for the UserProfile. This value is not case sensitive.
#' @param SingleSignOnUserIdentifier A specifier for the type of value specified in SingleSignOnUserValue.
#' Currently, the only supported value is "UserName". If the Domain's
#' AuthMode is SSO, this field is required. If the Domain's AuthMode is not
#' SSO, this field cannot be specified.
#' @param SingleSignOnUserValue The username of the associated Amazon Web Services Single Sign-On User
#' for this UserProfile. If the Domain's AuthMode is SSO, this field is
#' required, and must match a valid username of a user in your directory.
#' If the Domain's AuthMode is not SSO, this field cannot be specified.
#' @param Tags Each tag consists of a key and an optional value. Tag keys must be
#' unique per resource.
#' 
#' Tags that you specify for the User Profile are also added to all Apps
#' that the User Profile launches.
#' @param UserSettings A collection of settings.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_user_profile
sagemaker_create_user_profile <- function(DomainId, UserProfileName, SingleSignOnUserIdentifier = NULL, SingleSignOnUserValue = NULL, Tags = NULL, UserSettings = NULL) {
  op <- new_operation(
    name = "CreateUserProfile",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$create_user_profile_input(DomainId = DomainId, UserProfileName = UserProfileName, SingleSignOnUserIdentifier = SingleSignOnUserIdentifier, SingleSignOnUserValue = SingleSignOnUserValue, Tags = Tags, UserSettings = UserSettings)
  output <- .sagemaker$create_user_profile_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_user_profile <- sagemaker_create_user_profile

#' Use this operation to create a workforce
#'
#' @description
#' Use this operation to create a workforce. This operation will return an error if a workforce already exists in the Amazon Web Services Region that you specify. You can only create one workforce in each Amazon Web Services Region per Amazon Web Services account.
#'
#' See [https://paws-r.github.io/docs/sagemaker/create_workforce.html](https://paws-r.github.io/docs/sagemaker/create_workforce.html) for full documentation.
#'
#' @param CognitoConfig Use this parameter to configure an Amazon Cognito private workforce. A
#' single Cognito workforce is created using and corresponds to a single
#' [Amazon Cognito user
#' pool](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html).
#' 
#' Do not use `OidcConfig` if you specify values for `CognitoConfig`.
#' @param OidcConfig Use this parameter to configure a private workforce using your own OIDC
#' Identity Provider.
#' 
#' Do not use `CognitoConfig` if you specify values for `OidcConfig`.
#' @param SourceIpConfig 
#' @param WorkforceName &#91;required&#93; The name of the private workforce.
#' @param Tags An array of key-value pairs that contain metadata to help you categorize
#' and organize our workforce. Each tag consists of a key and a value, both
#' of which you define.
#' @param WorkforceVpcConfig Use this parameter to configure a workforce using VPC.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_workforce
sagemaker_create_workforce <- function(CognitoConfig = NULL, OidcConfig = NULL, SourceIpConfig = NULL, WorkforceName, Tags = NULL, WorkforceVpcConfig = NULL) {
  op <- new_operation(
    name = "CreateWorkforce",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$create_workforce_input(CognitoConfig = CognitoConfig, OidcConfig = OidcConfig, SourceIpConfig = SourceIpConfig, WorkforceName = WorkforceName, Tags = Tags, WorkforceVpcConfig = WorkforceVpcConfig)
  output <- .sagemaker$create_workforce_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_workforce <- sagemaker_create_workforce

#' Creates a new work team for labeling your data
#'
#' @description
#' Creates a new work team for labeling your data. A work team is defined by one or more Amazon Cognito user pools. You must first create the user pools before you can create a work team.
#'
#' See [https://paws-r.github.io/docs/sagemaker/create_workteam.html](https://paws-r.github.io/docs/sagemaker/create_workteam.html) for full documentation.
#'
#' @param WorkteamName &#91;required&#93; The name of the work team. Use this name to identify the work team.
#' @param WorkforceName The name of the workforce.
#' @param MemberDefinitions &#91;required&#93; A list of `MemberDefinition` objects that contains objects that identify
#' the workers that make up the work team.
#' 
#' Workforces can be created using Amazon Cognito or your own OIDC Identity
#' Provider (IdP). For private workforces created using Amazon Cognito use
#' `CognitoMemberDefinition`. For workforces created using your own OIDC
#' identity provider (IdP) use `OidcMemberDefinition`. Do not provide input
#' for both of these parameters in a single request.
#' 
#' For workforces created using Amazon Cognito, private work teams
#' correspond to Amazon Cognito *user groups* within the user pool used to
#' create a workforce. All of the `CognitoMemberDefinition` objects that
#' make up the member definition must have the same `ClientId` and
#' `UserPool` values. To add a Amazon Cognito user group to an existing
#' worker pool, see Adding groups to a User Pool. For more information
#' about user pools, see [Amazon Cognito User
#' Pools](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html).
#' 
#' For workforces created using your own OIDC IdP, specify the user groups
#' that you want to include in your private work team in
#' `OidcMemberDefinition` by listing those groups in `Groups`.
#' @param Description &#91;required&#93; A description of the work team.
#' @param NotificationConfiguration Configures notification of workers regarding available or expiring work
#' items.
#' @param Tags An array of key-value pairs.
#' 
#' For more information, see [Resource
#' Tag](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html)
#' and [Using Cost Allocation
#' Tags](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what)
#' in the *Amazon Web Services Billing and Cost Management User Guide*.
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_workteam
sagemaker_create_workteam <- function(WorkteamName, WorkforceName = NULL, MemberDefinitions, Description, NotificationConfiguration = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateWorkteam",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$create_workteam_input(WorkteamName = WorkteamName, WorkforceName = WorkforceName, MemberDefinitions = MemberDefinitions, Description = Description, NotificationConfiguration = NotificationConfiguration, Tags = Tags)
  output <- .sagemaker$create_workteam_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_workteam <- sagemaker_create_workteam

#' Deletes an action
#'
#' @description
#' Deletes an action.
#'
#' See [https://paws-r.github.io/docs/sagemaker/delete_action.html](https://paws-r.github.io/docs/sagemaker/delete_action.html) for full documentation.
#'
#' @param ActionName &#91;required&#93; The name of the action to delete.
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_action
sagemaker_delete_action <- function(ActionName) {
  op <- new_operation(
    name = "DeleteAction",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$delete_action_input(ActionName = ActionName)
  output <- .sagemaker$delete_action_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_action <- sagemaker_delete_action

#' Removes the specified algorithm from your account
#'
#' @description
#' Removes the specified algorithm from your account.
#'
#' See [https://paws-r.github.io/docs/sagemaker/delete_algorithm.html](https://paws-r.github.io/docs/sagemaker/delete_algorithm.html) for full documentation.
#'
#' @param AlgorithmName &#91;required&#93; The name of the algorithm to delete.
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_algorithm
sagemaker_delete_algorithm <- function(AlgorithmName) {
  op <- new_operation(
    name = "DeleteAlgorithm",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$delete_algorithm_input(AlgorithmName = AlgorithmName)
  output <- .sagemaker$delete_algorithm_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_algorithm <- sagemaker_delete_algorithm

#' Used to stop and delete an app
#'
#' @description
#' Used to stop and delete an app.
#'
#' See [https://paws-r.github.io/docs/sagemaker/delete_app.html](https://paws-r.github.io/docs/sagemaker/delete_app.html) for full documentation.
#'
#' @param DomainId &#91;required&#93; The domain ID.
#' @param UserProfileName &#91;required&#93; The user profile name.
#' @param AppType &#91;required&#93; The type of app.
#' @param AppName &#91;required&#93; The name of the app.
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_app
sagemaker_delete_app <- function(DomainId, UserProfileName, AppType, AppName) {
  op <- new_operation(
    name = "DeleteApp",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$delete_app_input(DomainId = DomainId, UserProfileName = UserProfileName, AppType = AppType, AppName = AppName)
  output <- .sagemaker$delete_app_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_app <- sagemaker_delete_app

#' Deletes an AppImageConfig
#'
#' @description
#' Deletes an AppImageConfig.
#'
#' See [https://paws-r.github.io/docs/sagemaker/delete_app_image_config.html](https://paws-r.github.io/docs/sagemaker/delete_app_image_config.html) for full documentation.
#'
#' @param AppImageConfigName &#91;required&#93; The name of the AppImageConfig to delete.
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_app_image_config
sagemaker_delete_app_image_config <- function(AppImageConfigName) {
  op <- new_operation(
    name = "DeleteAppImageConfig",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$delete_app_image_config_input(AppImageConfigName = AppImageConfigName)
  output <- .sagemaker$delete_app_image_config_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_app_image_config <- sagemaker_delete_app_image_config

#' Deletes an artifact
#'
#' @description
#' Deletes an artifact. Either `ArtifactArn` or `Source` must be specified.
#'
#' See [https://paws-r.github.io/docs/sagemaker/delete_artifact.html](https://paws-r.github.io/docs/sagemaker/delete_artifact.html) for full documentation.
#'
#' @param ArtifactArn The Amazon Resource Name (ARN) of the artifact to delete.
#' @param Source The URI of the source.
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_artifact
sagemaker_delete_artifact <- function(ArtifactArn = NULL, Source = NULL) {
  op <- new_operation(
    name = "DeleteArtifact",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$delete_artifact_input(ArtifactArn = ArtifactArn, Source = Source)
  output <- .sagemaker$delete_artifact_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_artifact <- sagemaker_delete_artifact

#' Deletes an association
#'
#' @description
#' Deletes an association.
#'
#' See [https://paws-r.github.io/docs/sagemaker/delete_association.html](https://paws-r.github.io/docs/sagemaker/delete_association.html) for full documentation.
#'
#' @param SourceArn &#91;required&#93; The ARN of the source.
#' @param DestinationArn &#91;required&#93; The Amazon Resource Name (ARN) of the destination.
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_association
sagemaker_delete_association <- function(SourceArn, DestinationArn) {
  op <- new_operation(
    name = "DeleteAssociation",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$delete_association_input(SourceArn = SourceArn, DestinationArn = DestinationArn)
  output <- .sagemaker$delete_association_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_association <- sagemaker_delete_association

#' Deletes the specified Git repository from your account
#'
#' @description
#' Deletes the specified Git repository from your account.
#'
#' See [https://paws-r.github.io/docs/sagemaker/delete_code_repository.html](https://paws-r.github.io/docs/sagemaker/delete_code_repository.html) for full documentation.
#'
#' @param CodeRepositoryName &#91;required&#93; The name of the Git repository to delete.
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_code_repository
sagemaker_delete_code_repository <- function(CodeRepositoryName) {
  op <- new_operation(
    name = "DeleteCodeRepository",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$delete_code_repository_input(CodeRepositoryName = CodeRepositoryName)
  output <- .sagemaker$delete_code_repository_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_code_repository <- sagemaker_delete_code_repository

#' Deletes an context
#'
#' @description
#' Deletes an context.
#'
#' See [https://paws-r.github.io/docs/sagemaker/delete_context.html](https://paws-r.github.io/docs/sagemaker/delete_context.html) for full documentation.
#'
#' @param ContextName &#91;required&#93; The name of the context to delete.
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_context
sagemaker_delete_context <- function(ContextName) {
  op <- new_operation(
    name = "DeleteContext",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$delete_context_input(ContextName = ContextName)
  output <- .sagemaker$delete_context_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_context <- sagemaker_delete_context

#' Deletes a data quality monitoring job definition
#'
#' @description
#' Deletes a data quality monitoring job definition.
#'
#' See [https://paws-r.github.io/docs/sagemaker/delete_data_quality_job_definition.html](https://paws-r.github.io/docs/sagemaker/delete_data_quality_job_definition.html) for full documentation.
#'
#' @param JobDefinitionName &#91;required&#93; The name of the data quality monitoring job definition to delete.
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_data_quality_job_definition
sagemaker_delete_data_quality_job_definition <- function(JobDefinitionName) {
  op <- new_operation(
    name = "DeleteDataQualityJobDefinition",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$delete_data_quality_job_definition_input(JobDefinitionName = JobDefinitionName)
  output <- .sagemaker$delete_data_quality_job_definition_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_data_quality_job_definition <- sagemaker_delete_data_quality_job_definition

#' Deletes a fleet
#'
#' @description
#' Deletes a fleet.
#'
#' See [https://paws-r.github.io/docs/sagemaker/delete_device_fleet.html](https://paws-r.github.io/docs/sagemaker/delete_device_fleet.html) for full documentation.
#'
#' @param DeviceFleetName &#91;required&#93; The name of the fleet to delete.
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_device_fleet
sagemaker_delete_device_fleet <- function(DeviceFleetName) {
  op <- new_operation(
    name = "DeleteDeviceFleet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$delete_device_fleet_input(DeviceFleetName = DeviceFleetName)
  output <- .sagemaker$delete_device_fleet_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_device_fleet <- sagemaker_delete_device_fleet

#' Used to delete a domain
#'
#' @description
#' Used to delete a domain. If you onboarded with IAM mode, you will need to delete your domain to onboard again using SSO. Use with caution. All of the members of the domain will lose access to their EFS volume, including data, notebooks, and other artifacts.
#'
#' See [https://paws-r.github.io/docs/sagemaker/delete_domain.html](https://paws-r.github.io/docs/sagemaker/delete_domain.html) for full documentation.
#'
#' @param DomainId &#91;required&#93; The domain ID.
#' @param RetentionPolicy The retention policy for this domain, which specifies whether resources
#' will be retained after the Domain is deleted. By default, all resources
#' are retained (not automatically deleted).
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_domain
sagemaker_delete_domain <- function(DomainId, RetentionPolicy = NULL) {
  op <- new_operation(
    name = "DeleteDomain",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$delete_domain_input(DomainId = DomainId, RetentionPolicy = RetentionPolicy)
  output <- .sagemaker$delete_domain_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_domain <- sagemaker_delete_domain

#' Deletes an edge deployment plan if (and only if) all the stages in the
#' plan are inactive or there are no stages in the plan
#'
#' @description
#' Deletes an edge deployment plan if (and only if) all the stages in the plan are inactive or there are no stages in the plan.
#'
#' See [https://paws-r.github.io/docs/sagemaker/delete_edge_deployment_plan.html](https://paws-r.github.io/docs/sagemaker/delete_edge_deployment_plan.html) for full documentation.
#'
#' @param EdgeDeploymentPlanName &#91;required&#93; The name of the edge deployment plan to delete.
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_edge_deployment_plan
sagemaker_delete_edge_deployment_plan <- function(EdgeDeploymentPlanName) {
  op <- new_operation(
    name = "DeleteEdgeDeploymentPlan",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$delete_edge_deployment_plan_input(EdgeDeploymentPlanName = EdgeDeploymentPlanName)
  output <- .sagemaker$delete_edge_deployment_plan_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_edge_deployment_plan <- sagemaker_delete_edge_deployment_plan

#' Delete a stage in an edge deployment plan if (and only if) the stage is
#' inactive
#'
#' @description
#' Delete a stage in an edge deployment plan if (and only if) the stage is inactive.
#'
#' See [https://paws-r.github.io/docs/sagemaker/delete_edge_deployment_stage.html](https://paws-r.github.io/docs/sagemaker/delete_edge_deployment_stage.html) for full documentation.
#'
#' @param EdgeDeploymentPlanName &#91;required&#93; The name of the edge deployment plan from which the stage will be
#' deleted.
#' @param StageName &#91;required&#93; The name of the stage.
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_edge_deployment_stage
sagemaker_delete_edge_deployment_stage <- function(EdgeDeploymentPlanName, StageName) {
  op <- new_operation(
    name = "DeleteEdgeDeploymentStage",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$delete_edge_deployment_stage_input(EdgeDeploymentPlanName = EdgeDeploymentPlanName, StageName = StageName)
  output <- .sagemaker$delete_edge_deployment_stage_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_edge_deployment_stage <- sagemaker_delete_edge_deployment_stage

#' Deletes an endpoint
#'
#' @description
#' Deletes an endpoint. SageMaker frees up all of the resources that were deployed when the endpoint was created.
#'
#' See [https://paws-r.github.io/docs/sagemaker/delete_endpoint.html](https://paws-r.github.io/docs/sagemaker/delete_endpoint.html) for full documentation.
#'
#' @param EndpointName &#91;required&#93; The name of the endpoint that you want to delete.
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_endpoint
sagemaker_delete_endpoint <- function(EndpointName) {
  op <- new_operation(
    name = "DeleteEndpoint",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$delete_endpoint_input(EndpointName = EndpointName)
  output <- .sagemaker$delete_endpoint_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_endpoint <- sagemaker_delete_endpoint

#' Deletes an endpoint configuration
#'
#' @description
#' Deletes an endpoint configuration. The [`delete_endpoint_config`][sagemaker_delete_endpoint_config] API deletes only the specified configuration. It does not delete endpoints created using the configuration.
#'
#' See [https://paws-r.github.io/docs/sagemaker/delete_endpoint_config.html](https://paws-r.github.io/docs/sagemaker/delete_endpoint_config.html) for full documentation.
#'
#' @param EndpointConfigName &#91;required&#93; The name of the endpoint configuration that you want to delete.
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_endpoint_config
sagemaker_delete_endpoint_config <- function(EndpointConfigName) {
  op <- new_operation(
    name = "DeleteEndpointConfig",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$delete_endpoint_config_input(EndpointConfigName = EndpointConfigName)
  output <- .sagemaker$delete_endpoint_config_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_endpoint_config <- sagemaker_delete_endpoint_config

#' Deletes an SageMaker experiment
#'
#' @description
#' Deletes an SageMaker experiment. All trials associated with the experiment must be deleted first. Use the [`list_trials`][sagemaker_list_trials] API to get a list of the trials associated with the experiment.
#'
#' See [https://paws-r.github.io/docs/sagemaker/delete_experiment.html](https://paws-r.github.io/docs/sagemaker/delete_experiment.html) for full documentation.
#'
#' @param ExperimentName &#91;required&#93; The name of the experiment to delete.
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_experiment
sagemaker_delete_experiment <- function(ExperimentName) {
  op <- new_operation(
    name = "DeleteExperiment",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$delete_experiment_input(ExperimentName = ExperimentName)
  output <- .sagemaker$delete_experiment_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_experiment <- sagemaker_delete_experiment

#' Delete the FeatureGroup and any data that was written to the OnlineStore
#' of the FeatureGroup
#'
#' @description
#' Delete the `FeatureGroup` and any data that was written to the `OnlineStore` of the `FeatureGroup`. Data cannot be accessed from the `OnlineStore` immediately after [`delete_feature_group`][sagemaker_delete_feature_group] is called.
#'
#' See [https://paws-r.github.io/docs/sagemaker/delete_feature_group.html](https://paws-r.github.io/docs/sagemaker/delete_feature_group.html) for full documentation.
#'
#' @param FeatureGroupName &#91;required&#93; The name of the `FeatureGroup` you want to delete. The name must be
#' unique within an Amazon Web Services Region in an Amazon Web Services
#' account.
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_feature_group
sagemaker_delete_feature_group <- function(FeatureGroupName) {
  op <- new_operation(
    name = "DeleteFeatureGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$delete_feature_group_input(FeatureGroupName = FeatureGroupName)
  output <- .sagemaker$delete_feature_group_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_feature_group <- sagemaker_delete_feature_group

#' Deletes the specified flow definition
#'
#' @description
#' Deletes the specified flow definition.
#'
#' See [https://paws-r.github.io/docs/sagemaker/delete_flow_definition.html](https://paws-r.github.io/docs/sagemaker/delete_flow_definition.html) for full documentation.
#'
#' @param FlowDefinitionName &#91;required&#93; The name of the flow definition you are deleting.
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_flow_definition
sagemaker_delete_flow_definition <- function(FlowDefinitionName) {
  op <- new_operation(
    name = "DeleteFlowDefinition",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$delete_flow_definition_input(FlowDefinitionName = FlowDefinitionName)
  output <- .sagemaker$delete_flow_definition_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_flow_definition <- sagemaker_delete_flow_definition

#' Use this operation to delete a human task user interface (worker task
#' template)
#'
#' @description
#' Use this operation to delete a human task user interface (worker task template).
#'
#' See [https://paws-r.github.io/docs/sagemaker/delete_human_task_ui.html](https://paws-r.github.io/docs/sagemaker/delete_human_task_ui.html) for full documentation.
#'
#' @param HumanTaskUiName &#91;required&#93; The name of the human task user interface (work task template) you want
#' to delete.
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_human_task_ui
sagemaker_delete_human_task_ui <- function(HumanTaskUiName) {
  op <- new_operation(
    name = "DeleteHumanTaskUi",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$delete_human_task_ui_input(HumanTaskUiName = HumanTaskUiName)
  output <- .sagemaker$delete_human_task_ui_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_human_task_ui <- sagemaker_delete_human_task_ui

#' Deletes a SageMaker image and all versions of the image
#'
#' @description
#' Deletes a SageMaker image and all versions of the image. The container images aren't deleted.
#'
#' See [https://paws-r.github.io/docs/sagemaker/delete_image.html](https://paws-r.github.io/docs/sagemaker/delete_image.html) for full documentation.
#'
#' @param ImageName &#91;required&#93; The name of the image to delete.
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_image
sagemaker_delete_image <- function(ImageName) {
  op <- new_operation(
    name = "DeleteImage",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$delete_image_input(ImageName = ImageName)
  output <- .sagemaker$delete_image_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_image <- sagemaker_delete_image

#' Deletes a version of a SageMaker image
#'
#' @description
#' Deletes a version of a SageMaker image. The container image the version represents isn't deleted.
#'
#' See [https://paws-r.github.io/docs/sagemaker/delete_image_version.html](https://paws-r.github.io/docs/sagemaker/delete_image_version.html) for full documentation.
#'
#' @param ImageName &#91;required&#93; The name of the image.
#' @param Version &#91;required&#93; The version to delete.
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_image_version
sagemaker_delete_image_version <- function(ImageName, Version) {
  op <- new_operation(
    name = "DeleteImageVersion",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$delete_image_version_input(ImageName = ImageName, Version = Version)
  output <- .sagemaker$delete_image_version_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_image_version <- sagemaker_delete_image_version

#' Deletes a model
#'
#' @description
#' Deletes a model. The [`delete_model`][sagemaker_delete_model] API deletes only the model entry that was created in SageMaker when you called the [`create_model`][sagemaker_create_model] API. It does not delete model artifacts, inference code, or the IAM role that you specified when creating the model.
#'
#' See [https://paws-r.github.io/docs/sagemaker/delete_model.html](https://paws-r.github.io/docs/sagemaker/delete_model.html) for full documentation.
#'
#' @param ModelName &#91;required&#93; The name of the model to delete.
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_model
sagemaker_delete_model <- function(ModelName) {
  op <- new_operation(
    name = "DeleteModel",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$delete_model_input(ModelName = ModelName)
  output <- .sagemaker$delete_model_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_model <- sagemaker_delete_model

#' Deletes an Amazon SageMaker model bias job definition
#'
#' @description
#' Deletes an Amazon SageMaker model bias job definition.
#'
#' See [https://paws-r.github.io/docs/sagemaker/delete_model_bias_job_definition.html](https://paws-r.github.io/docs/sagemaker/delete_model_bias_job_definition.html) for full documentation.
#'
#' @param JobDefinitionName &#91;required&#93; The name of the model bias job definition to delete.
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_model_bias_job_definition
sagemaker_delete_model_bias_job_definition <- function(JobDefinitionName) {
  op <- new_operation(
    name = "DeleteModelBiasJobDefinition",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$delete_model_bias_job_definition_input(JobDefinitionName = JobDefinitionName)
  output <- .sagemaker$delete_model_bias_job_definition_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_model_bias_job_definition <- sagemaker_delete_model_bias_job_definition

#' Deletes an Amazon SageMaker model explainability job definition
#'
#' @description
#' Deletes an Amazon SageMaker model explainability job definition.
#'
#' See [https://paws-r.github.io/docs/sagemaker/delete_model_explainability_job_definition.html](https://paws-r.github.io/docs/sagemaker/delete_model_explainability_job_definition.html) for full documentation.
#'
#' @param JobDefinitionName &#91;required&#93; The name of the model explainability job definition to delete.
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_model_explainability_job_definition
sagemaker_delete_model_explainability_job_definition <- function(JobDefinitionName) {
  op <- new_operation(
    name = "DeleteModelExplainabilityJobDefinition",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$delete_model_explainability_job_definition_input(JobDefinitionName = JobDefinitionName)
  output <- .sagemaker$delete_model_explainability_job_definition_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_model_explainability_job_definition <- sagemaker_delete_model_explainability_job_definition

#' Deletes a model package
#'
#' @description
#' Deletes a model package.
#'
#' See [https://paws-r.github.io/docs/sagemaker/delete_model_package.html](https://paws-r.github.io/docs/sagemaker/delete_model_package.html) for full documentation.
#'
#' @param ModelPackageName &#91;required&#93; The name or Amazon Resource Name (ARN) of the model package to delete.
#' 
#' When you specify a name, the name must have 1 to 63 characters. Valid
#' characters are a-z, A-Z, 0-9, and - (hyphen).
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_model_package
sagemaker_delete_model_package <- function(ModelPackageName) {
  op <- new_operation(
    name = "DeleteModelPackage",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$delete_model_package_input(ModelPackageName = ModelPackageName)
  output <- .sagemaker$delete_model_package_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_model_package <- sagemaker_delete_model_package

#' Deletes the specified model group
#'
#' @description
#' Deletes the specified model group.
#'
#' See [https://paws-r.github.io/docs/sagemaker/delete_model_package_group.html](https://paws-r.github.io/docs/sagemaker/delete_model_package_group.html) for full documentation.
#'
#' @param ModelPackageGroupName &#91;required&#93; The name of the model group to delete.
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_model_package_group
sagemaker_delete_model_package_group <- function(ModelPackageGroupName) {
  op <- new_operation(
    name = "DeleteModelPackageGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$delete_model_package_group_input(ModelPackageGroupName = ModelPackageGroupName)
  output <- .sagemaker$delete_model_package_group_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_model_package_group <- sagemaker_delete_model_package_group

#' Deletes a model group resource policy
#'
#' @description
#' Deletes a model group resource policy.
#'
#' See [https://paws-r.github.io/docs/sagemaker/delete_model_package_group_policy.html](https://paws-r.github.io/docs/sagemaker/delete_model_package_group_policy.html) for full documentation.
#'
#' @param ModelPackageGroupName &#91;required&#93; The name of the model group for which to delete the policy.
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_model_package_group_policy
sagemaker_delete_model_package_group_policy <- function(ModelPackageGroupName) {
  op <- new_operation(
    name = "DeleteModelPackageGroupPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$delete_model_package_group_policy_input(ModelPackageGroupName = ModelPackageGroupName)
  output <- .sagemaker$delete_model_package_group_policy_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_model_package_group_policy <- sagemaker_delete_model_package_group_policy

#' Deletes the secified model quality monitoring job definition
#'
#' @description
#' Deletes the secified model quality monitoring job definition.
#'
#' See [https://paws-r.github.io/docs/sagemaker/delete_model_quality_job_definition.html](https://paws-r.github.io/docs/sagemaker/delete_model_quality_job_definition.html) for full documentation.
#'
#' @param JobDefinitionName &#91;required&#93; The name of the model quality monitoring job definition to delete.
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_model_quality_job_definition
sagemaker_delete_model_quality_job_definition <- function(JobDefinitionName) {
  op <- new_operation(
    name = "DeleteModelQualityJobDefinition",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$delete_model_quality_job_definition_input(JobDefinitionName = JobDefinitionName)
  output <- .sagemaker$delete_model_quality_job_definition_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_model_quality_job_definition <- sagemaker_delete_model_quality_job_definition

#' Deletes a monitoring schedule
#'
#' @description
#' Deletes a monitoring schedule. Also stops the schedule had not already been stopped. This does not delete the job execution history of the monitoring schedule.
#'
#' See [https://paws-r.github.io/docs/sagemaker/delete_monitoring_schedule.html](https://paws-r.github.io/docs/sagemaker/delete_monitoring_schedule.html) for full documentation.
#'
#' @param MonitoringScheduleName &#91;required&#93; The name of the monitoring schedule to delete.
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_monitoring_schedule
sagemaker_delete_monitoring_schedule <- function(MonitoringScheduleName) {
  op <- new_operation(
    name = "DeleteMonitoringSchedule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$delete_monitoring_schedule_input(MonitoringScheduleName = MonitoringScheduleName)
  output <- .sagemaker$delete_monitoring_schedule_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_monitoring_schedule <- sagemaker_delete_monitoring_schedule

#' Deletes an SageMaker notebook instance
#'
#' @description
#' Deletes an SageMaker notebook instance. Before you can delete a notebook instance, you must call the [`stop_notebook_instance`][sagemaker_stop_notebook_instance] API.
#'
#' See [https://paws-r.github.io/docs/sagemaker/delete_notebook_instance.html](https://paws-r.github.io/docs/sagemaker/delete_notebook_instance.html) for full documentation.
#'
#' @param NotebookInstanceName &#91;required&#93; The name of the SageMaker notebook instance to delete.
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_notebook_instance
sagemaker_delete_notebook_instance <- function(NotebookInstanceName) {
  op <- new_operation(
    name = "DeleteNotebookInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$delete_notebook_instance_input(NotebookInstanceName = NotebookInstanceName)
  output <- .sagemaker$delete_notebook_instance_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_notebook_instance <- sagemaker_delete_notebook_instance

#' Deletes a notebook instance lifecycle configuration
#'
#' @description
#' Deletes a notebook instance lifecycle configuration.
#'
#' See [https://paws-r.github.io/docs/sagemaker/delete_notebook_instance_lifecycle_config.html](https://paws-r.github.io/docs/sagemaker/delete_notebook_instance_lifecycle_config.html) for full documentation.
#'
#' @param NotebookInstanceLifecycleConfigName &#91;required&#93; The name of the lifecycle configuration to delete.
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_notebook_instance_lifecycle_config
sagemaker_delete_notebook_instance_lifecycle_config <- function(NotebookInstanceLifecycleConfigName) {
  op <- new_operation(
    name = "DeleteNotebookInstanceLifecycleConfig",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$delete_notebook_instance_lifecycle_config_input(NotebookInstanceLifecycleConfigName = NotebookInstanceLifecycleConfigName)
  output <- .sagemaker$delete_notebook_instance_lifecycle_config_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_notebook_instance_lifecycle_config <- sagemaker_delete_notebook_instance_lifecycle_config

#' Deletes a pipeline if there are no running instances of the pipeline
#'
#' @description
#' Deletes a pipeline if there are no running instances of the pipeline. To delete a pipeline, you must stop all running instances of the pipeline using the [`stop_pipeline_execution`][sagemaker_stop_pipeline_execution] API. When you delete a pipeline, all instances of the pipeline are deleted.
#'
#' See [https://paws-r.github.io/docs/sagemaker/delete_pipeline.html](https://paws-r.github.io/docs/sagemaker/delete_pipeline.html) for full documentation.
#'
#' @param PipelineName &#91;required&#93; The name of the pipeline to delete.
#' @param ClientRequestToken &#91;required&#93; A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the operation. An idempotent operation completes no more
#' than one time.
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_pipeline
sagemaker_delete_pipeline <- function(PipelineName, ClientRequestToken) {
  op <- new_operation(
    name = "DeletePipeline",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$delete_pipeline_input(PipelineName = PipelineName, ClientRequestToken = ClientRequestToken)
  output <- .sagemaker$delete_pipeline_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_pipeline <- sagemaker_delete_pipeline

#' Delete the specified project
#'
#' @description
#' Delete the specified project.
#'
#' See [https://paws-r.github.io/docs/sagemaker/delete_project.html](https://paws-r.github.io/docs/sagemaker/delete_project.html) for full documentation.
#'
#' @param ProjectName &#91;required&#93; The name of the project to delete.
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_project
sagemaker_delete_project <- function(ProjectName) {
  op <- new_operation(
    name = "DeleteProject",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$delete_project_input(ProjectName = ProjectName)
  output <- .sagemaker$delete_project_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_project <- sagemaker_delete_project

#' Deletes the Studio Lifecycle Configuration
#'
#' @description
#' Deletes the Studio Lifecycle Configuration. In order to delete the Lifecycle Configuration, there must be no running apps using the Lifecycle Configuration. You must also remove the Lifecycle Configuration from UserSettings in all Domains and UserProfiles.
#'
#' See [https://paws-r.github.io/docs/sagemaker/delete_studio_lifecycle_config.html](https://paws-r.github.io/docs/sagemaker/delete_studio_lifecycle_config.html) for full documentation.
#'
#' @param StudioLifecycleConfigName &#91;required&#93; The name of the Studio Lifecycle Configuration to delete.
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_studio_lifecycle_config
sagemaker_delete_studio_lifecycle_config <- function(StudioLifecycleConfigName) {
  op <- new_operation(
    name = "DeleteStudioLifecycleConfig",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$delete_studio_lifecycle_config_input(StudioLifecycleConfigName = StudioLifecycleConfigName)
  output <- .sagemaker$delete_studio_lifecycle_config_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_studio_lifecycle_config <- sagemaker_delete_studio_lifecycle_config

#' Deletes the specified tags from an SageMaker resource
#'
#' @description
#' Deletes the specified tags from an SageMaker resource.
#'
#' See [https://paws-r.github.io/docs/sagemaker/delete_tags.html](https://paws-r.github.io/docs/sagemaker/delete_tags.html) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource whose tags you want to
#' delete.
#' @param TagKeys &#91;required&#93; An array or one or more tag keys to delete.
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_tags
sagemaker_delete_tags <- function(ResourceArn, TagKeys) {
  op <- new_operation(
    name = "DeleteTags",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$delete_tags_input(ResourceArn = ResourceArn, TagKeys = TagKeys)
  output <- .sagemaker$delete_tags_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_tags <- sagemaker_delete_tags

#' Deletes the specified trial
#'
#' @description
#' Deletes the specified trial. All trial components that make up the trial must be deleted first. Use the [`describe_trial_component`][sagemaker_describe_trial_component] API to get the list of trial components.
#'
#' See [https://paws-r.github.io/docs/sagemaker/delete_trial.html](https://paws-r.github.io/docs/sagemaker/delete_trial.html) for full documentation.
#'
#' @param TrialName &#91;required&#93; The name of the trial to delete.
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_trial
sagemaker_delete_trial <- function(TrialName) {
  op <- new_operation(
    name = "DeleteTrial",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$delete_trial_input(TrialName = TrialName)
  output <- .sagemaker$delete_trial_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_trial <- sagemaker_delete_trial

#' Deletes the specified trial component
#'
#' @description
#' Deletes the specified trial component. A trial component must be disassociated from all trials before the trial component can be deleted. To disassociate a trial component from a trial, call the [`disassociate_trial_component`][sagemaker_disassociate_trial_component] API.
#'
#' See [https://paws-r.github.io/docs/sagemaker/delete_trial_component.html](https://paws-r.github.io/docs/sagemaker/delete_trial_component.html) for full documentation.
#'
#' @param TrialComponentName &#91;required&#93; The name of the component to delete.
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_trial_component
sagemaker_delete_trial_component <- function(TrialComponentName) {
  op <- new_operation(
    name = "DeleteTrialComponent",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$delete_trial_component_input(TrialComponentName = TrialComponentName)
  output <- .sagemaker$delete_trial_component_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_trial_component <- sagemaker_delete_trial_component

#' Deletes a user profile
#'
#' @description
#' Deletes a user profile. When a user profile is deleted, the user loses access to their EFS volume, including data, notebooks, and other artifacts.
#'
#' See [https://paws-r.github.io/docs/sagemaker/delete_user_profile.html](https://paws-r.github.io/docs/sagemaker/delete_user_profile.html) for full documentation.
#'
#' @param DomainId &#91;required&#93; The domain ID.
#' @param UserProfileName &#91;required&#93; The user profile name.
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_user_profile
sagemaker_delete_user_profile <- function(DomainId, UserProfileName) {
  op <- new_operation(
    name = "DeleteUserProfile",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$delete_user_profile_input(DomainId = DomainId, UserProfileName = UserProfileName)
  output <- .sagemaker$delete_user_profile_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_user_profile <- sagemaker_delete_user_profile

#' Use this operation to delete a workforce
#'
#' @description
#' Use this operation to delete a workforce.
#'
#' See [https://paws-r.github.io/docs/sagemaker/delete_workforce.html](https://paws-r.github.io/docs/sagemaker/delete_workforce.html) for full documentation.
#'
#' @param WorkforceName &#91;required&#93; The name of the workforce.
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_workforce
sagemaker_delete_workforce <- function(WorkforceName) {
  op <- new_operation(
    name = "DeleteWorkforce",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$delete_workforce_input(WorkforceName = WorkforceName)
  output <- .sagemaker$delete_workforce_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_workforce <- sagemaker_delete_workforce

#' Deletes an existing work team
#'
#' @description
#' Deletes an existing work team. This operation can't be undone.
#'
#' See [https://paws-r.github.io/docs/sagemaker/delete_workteam.html](https://paws-r.github.io/docs/sagemaker/delete_workteam.html) for full documentation.
#'
#' @param WorkteamName &#91;required&#93; The name of the work team to delete.
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_workteam
sagemaker_delete_workteam <- function(WorkteamName) {
  op <- new_operation(
    name = "DeleteWorkteam",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$delete_workteam_input(WorkteamName = WorkteamName)
  output <- .sagemaker$delete_workteam_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_workteam <- sagemaker_delete_workteam

#' Deregisters the specified devices
#'
#' @description
#' Deregisters the specified devices. After you deregister a device, you will need to re-register the devices.
#'
#' See [https://paws-r.github.io/docs/sagemaker/deregister_devices.html](https://paws-r.github.io/docs/sagemaker/deregister_devices.html) for full documentation.
#'
#' @param DeviceFleetName &#91;required&#93; The name of the fleet the devices belong to.
#' @param DeviceNames &#91;required&#93; The unique IDs of the devices.
#'
#' @keywords internal
#'
#' @rdname sagemaker_deregister_devices
sagemaker_deregister_devices <- function(DeviceFleetName, DeviceNames) {
  op <- new_operation(
    name = "DeregisterDevices",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$deregister_devices_input(DeviceFleetName = DeviceFleetName, DeviceNames = DeviceNames)
  output <- .sagemaker$deregister_devices_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$deregister_devices <- sagemaker_deregister_devices

#' Describes an action
#'
#' @description
#' Describes an action.
#'
#' See [https://paws-r.github.io/docs/sagemaker/describe_action.html](https://paws-r.github.io/docs/sagemaker/describe_action.html) for full documentation.
#'
#' @param ActionName &#91;required&#93; The name of the action to describe.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_action
sagemaker_describe_action <- function(ActionName) {
  op <- new_operation(
    name = "DescribeAction",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_action_input(ActionName = ActionName)
  output <- .sagemaker$describe_action_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_action <- sagemaker_describe_action

#' Returns a description of the specified algorithm that is in your account
#'
#' @description
#' Returns a description of the specified algorithm that is in your account.
#'
#' See [https://paws-r.github.io/docs/sagemaker/describe_algorithm.html](https://paws-r.github.io/docs/sagemaker/describe_algorithm.html) for full documentation.
#'
#' @param AlgorithmName &#91;required&#93; The name of the algorithm to describe.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_algorithm
sagemaker_describe_algorithm <- function(AlgorithmName) {
  op <- new_operation(
    name = "DescribeAlgorithm",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_algorithm_input(AlgorithmName = AlgorithmName)
  output <- .sagemaker$describe_algorithm_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_algorithm <- sagemaker_describe_algorithm

#' Describes the app
#'
#' @description
#' Describes the app.
#'
#' See [https://paws-r.github.io/docs/sagemaker/describe_app.html](https://paws-r.github.io/docs/sagemaker/describe_app.html) for full documentation.
#'
#' @param DomainId &#91;required&#93; The domain ID.
#' @param UserProfileName &#91;required&#93; The user profile name.
#' @param AppType &#91;required&#93; The type of app.
#' @param AppName &#91;required&#93; The name of the app.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_app
sagemaker_describe_app <- function(DomainId, UserProfileName, AppType, AppName) {
  op <- new_operation(
    name = "DescribeApp",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_app_input(DomainId = DomainId, UserProfileName = UserProfileName, AppType = AppType, AppName = AppName)
  output <- .sagemaker$describe_app_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_app <- sagemaker_describe_app

#' Describes an AppImageConfig
#'
#' @description
#' Describes an AppImageConfig.
#'
#' See [https://paws-r.github.io/docs/sagemaker/describe_app_image_config.html](https://paws-r.github.io/docs/sagemaker/describe_app_image_config.html) for full documentation.
#'
#' @param AppImageConfigName &#91;required&#93; The name of the AppImageConfig to describe.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_app_image_config
sagemaker_describe_app_image_config <- function(AppImageConfigName) {
  op <- new_operation(
    name = "DescribeAppImageConfig",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_app_image_config_input(AppImageConfigName = AppImageConfigName)
  output <- .sagemaker$describe_app_image_config_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_app_image_config <- sagemaker_describe_app_image_config

#' Describes an artifact
#'
#' @description
#' Describes an artifact.
#'
#' See [https://paws-r.github.io/docs/sagemaker/describe_artifact.html](https://paws-r.github.io/docs/sagemaker/describe_artifact.html) for full documentation.
#'
#' @param ArtifactArn &#91;required&#93; The Amazon Resource Name (ARN) of the artifact to describe.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_artifact
sagemaker_describe_artifact <- function(ArtifactArn) {
  op <- new_operation(
    name = "DescribeArtifact",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_artifact_input(ArtifactArn = ArtifactArn)
  output <- .sagemaker$describe_artifact_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_artifact <- sagemaker_describe_artifact

#' Returns information about an Amazon SageMaker AutoML job
#'
#' @description
#' Returns information about an Amazon SageMaker AutoML job.
#'
#' See [https://paws-r.github.io/docs/sagemaker/describe_auto_ml_job.html](https://paws-r.github.io/docs/sagemaker/describe_auto_ml_job.html) for full documentation.
#'
#' @param AutoMLJobName &#91;required&#93; Requests information about an AutoML job using its unique name.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_auto_ml_job
sagemaker_describe_auto_ml_job <- function(AutoMLJobName) {
  op <- new_operation(
    name = "DescribeAutoMLJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_auto_ml_job_input(AutoMLJobName = AutoMLJobName)
  output <- .sagemaker$describe_auto_ml_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_auto_ml_job <- sagemaker_describe_auto_ml_job

#' Gets details about the specified Git repository
#'
#' @description
#' Gets details about the specified Git repository.
#'
#' See [https://paws-r.github.io/docs/sagemaker/describe_code_repository.html](https://paws-r.github.io/docs/sagemaker/describe_code_repository.html) for full documentation.
#'
#' @param CodeRepositoryName &#91;required&#93; The name of the Git repository to describe.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_code_repository
sagemaker_describe_code_repository <- function(CodeRepositoryName) {
  op <- new_operation(
    name = "DescribeCodeRepository",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_code_repository_input(CodeRepositoryName = CodeRepositoryName)
  output <- .sagemaker$describe_code_repository_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_code_repository <- sagemaker_describe_code_repository

#' Returns information about a model compilation job
#'
#' @description
#' Returns information about a model compilation job.
#'
#' See [https://paws-r.github.io/docs/sagemaker/describe_compilation_job.html](https://paws-r.github.io/docs/sagemaker/describe_compilation_job.html) for full documentation.
#'
#' @param CompilationJobName &#91;required&#93; The name of the model compilation job that you want information about.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_compilation_job
sagemaker_describe_compilation_job <- function(CompilationJobName) {
  op <- new_operation(
    name = "DescribeCompilationJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_compilation_job_input(CompilationJobName = CompilationJobName)
  output <- .sagemaker$describe_compilation_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_compilation_job <- sagemaker_describe_compilation_job

#' Describes a context
#'
#' @description
#' Describes a context.
#'
#' See [https://paws-r.github.io/docs/sagemaker/describe_context.html](https://paws-r.github.io/docs/sagemaker/describe_context.html) for full documentation.
#'
#' @param ContextName &#91;required&#93; The name of the context to describe.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_context
sagemaker_describe_context <- function(ContextName) {
  op <- new_operation(
    name = "DescribeContext",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_context_input(ContextName = ContextName)
  output <- .sagemaker$describe_context_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_context <- sagemaker_describe_context

#' Gets the details of a data quality monitoring job definition
#'
#' @description
#' Gets the details of a data quality monitoring job definition.
#'
#' See [https://paws-r.github.io/docs/sagemaker/describe_data_quality_job_definition.html](https://paws-r.github.io/docs/sagemaker/describe_data_quality_job_definition.html) for full documentation.
#'
#' @param JobDefinitionName &#91;required&#93; The name of the data quality monitoring job definition to describe.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_data_quality_job_definition
sagemaker_describe_data_quality_job_definition <- function(JobDefinitionName) {
  op <- new_operation(
    name = "DescribeDataQualityJobDefinition",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_data_quality_job_definition_input(JobDefinitionName = JobDefinitionName)
  output <- .sagemaker$describe_data_quality_job_definition_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_data_quality_job_definition <- sagemaker_describe_data_quality_job_definition

#' Describes the device
#'
#' @description
#' Describes the device.
#'
#' See [https://paws-r.github.io/docs/sagemaker/describe_device.html](https://paws-r.github.io/docs/sagemaker/describe_device.html) for full documentation.
#'
#' @param NextToken Next token of device description.
#' @param DeviceName &#91;required&#93; The unique ID of the device.
#' @param DeviceFleetName &#91;required&#93; The name of the fleet the devices belong to.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_device
sagemaker_describe_device <- function(NextToken = NULL, DeviceName, DeviceFleetName) {
  op <- new_operation(
    name = "DescribeDevice",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_device_input(NextToken = NextToken, DeviceName = DeviceName, DeviceFleetName = DeviceFleetName)
  output <- .sagemaker$describe_device_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_device <- sagemaker_describe_device

#' A description of the fleet the device belongs to
#'
#' @description
#' A description of the fleet the device belongs to.
#'
#' See [https://paws-r.github.io/docs/sagemaker/describe_device_fleet.html](https://paws-r.github.io/docs/sagemaker/describe_device_fleet.html) for full documentation.
#'
#' @param DeviceFleetName &#91;required&#93; The name of the fleet.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_device_fleet
sagemaker_describe_device_fleet <- function(DeviceFleetName) {
  op <- new_operation(
    name = "DescribeDeviceFleet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_device_fleet_input(DeviceFleetName = DeviceFleetName)
  output <- .sagemaker$describe_device_fleet_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_device_fleet <- sagemaker_describe_device_fleet

#' The description of the domain
#'
#' @description
#' The description of the domain.
#'
#' See [https://paws-r.github.io/docs/sagemaker/describe_domain.html](https://paws-r.github.io/docs/sagemaker/describe_domain.html) for full documentation.
#'
#' @param DomainId &#91;required&#93; The domain ID.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_domain
sagemaker_describe_domain <- function(DomainId) {
  op <- new_operation(
    name = "DescribeDomain",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_domain_input(DomainId = DomainId)
  output <- .sagemaker$describe_domain_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_domain <- sagemaker_describe_domain

#' Describes an edge deployment plan with deployment status per stage
#'
#' @description
#' Describes an edge deployment plan with deployment status per stage.
#'
#' See [https://paws-r.github.io/docs/sagemaker/describe_edge_deployment_plan.html](https://paws-r.github.io/docs/sagemaker/describe_edge_deployment_plan.html) for full documentation.
#'
#' @param EdgeDeploymentPlanName &#91;required&#93; The name of the deployment plan to describe.
#' @param NextToken If the edge deployment plan has enough stages to require tokening, then
#' this is the response from the last list of stages returned.
#' @param MaxResults The maximum number of results to select (50 by default).
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_edge_deployment_plan
sagemaker_describe_edge_deployment_plan <- function(EdgeDeploymentPlanName, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeEdgeDeploymentPlan",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_edge_deployment_plan_input(EdgeDeploymentPlanName = EdgeDeploymentPlanName, NextToken = NextToken, MaxResults = MaxResults)
  output <- .sagemaker$describe_edge_deployment_plan_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_edge_deployment_plan <- sagemaker_describe_edge_deployment_plan

#' A description of edge packaging jobs
#'
#' @description
#' A description of edge packaging jobs.
#'
#' See [https://paws-r.github.io/docs/sagemaker/describe_edge_packaging_job.html](https://paws-r.github.io/docs/sagemaker/describe_edge_packaging_job.html) for full documentation.
#'
#' @param EdgePackagingJobName &#91;required&#93; The name of the edge packaging job.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_edge_packaging_job
sagemaker_describe_edge_packaging_job <- function(EdgePackagingJobName) {
  op <- new_operation(
    name = "DescribeEdgePackagingJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_edge_packaging_job_input(EdgePackagingJobName = EdgePackagingJobName)
  output <- .sagemaker$describe_edge_packaging_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_edge_packaging_job <- sagemaker_describe_edge_packaging_job

#' Returns the description of an endpoint
#'
#' @description
#' Returns the description of an endpoint.
#'
#' See [https://paws-r.github.io/docs/sagemaker/describe_endpoint.html](https://paws-r.github.io/docs/sagemaker/describe_endpoint.html) for full documentation.
#'
#' @param EndpointName &#91;required&#93; The name of the endpoint.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_endpoint
sagemaker_describe_endpoint <- function(EndpointName) {
  op <- new_operation(
    name = "DescribeEndpoint",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_endpoint_input(EndpointName = EndpointName)
  output <- .sagemaker$describe_endpoint_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_endpoint <- sagemaker_describe_endpoint

#' Returns the description of an endpoint configuration created using the
#' CreateEndpointConfig API
#'
#' @description
#' Returns the description of an endpoint configuration created using the [`create_endpoint_config`][sagemaker_create_endpoint_config] API.
#'
#' See [https://paws-r.github.io/docs/sagemaker/describe_endpoint_config.html](https://paws-r.github.io/docs/sagemaker/describe_endpoint_config.html) for full documentation.
#'
#' @param EndpointConfigName &#91;required&#93; The name of the endpoint configuration.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_endpoint_config
sagemaker_describe_endpoint_config <- function(EndpointConfigName) {
  op <- new_operation(
    name = "DescribeEndpointConfig",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_endpoint_config_input(EndpointConfigName = EndpointConfigName)
  output <- .sagemaker$describe_endpoint_config_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_endpoint_config <- sagemaker_describe_endpoint_config

#' Provides a list of an experiment's properties
#'
#' @description
#' Provides a list of an experiment's properties.
#'
#' See [https://paws-r.github.io/docs/sagemaker/describe_experiment.html](https://paws-r.github.io/docs/sagemaker/describe_experiment.html) for full documentation.
#'
#' @param ExperimentName &#91;required&#93; The name of the experiment to describe.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_experiment
sagemaker_describe_experiment <- function(ExperimentName) {
  op <- new_operation(
    name = "DescribeExperiment",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_experiment_input(ExperimentName = ExperimentName)
  output <- .sagemaker$describe_experiment_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_experiment <- sagemaker_describe_experiment

#' Use this operation to describe a FeatureGroup
#'
#' @description
#' Use this operation to describe a `FeatureGroup`. The response includes information on the creation time, `FeatureGroup` name, the unique identifier for each `FeatureGroup`, and more.
#'
#' See [https://paws-r.github.io/docs/sagemaker/describe_feature_group.html](https://paws-r.github.io/docs/sagemaker/describe_feature_group.html) for full documentation.
#'
#' @param FeatureGroupName &#91;required&#93; The name of the `FeatureGroup` you want described.
#' @param NextToken A token to resume pagination of the list of `Features`
#' (`FeatureDefinitions`). 2,500 `Features` are returned by default.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_feature_group
sagemaker_describe_feature_group <- function(FeatureGroupName, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeFeatureGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_feature_group_input(FeatureGroupName = FeatureGroupName, NextToken = NextToken)
  output <- .sagemaker$describe_feature_group_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_feature_group <- sagemaker_describe_feature_group

#' Shows the metadata for a feature within a feature group
#'
#' @description
#' Shows the metadata for a feature within a feature group.
#'
#' See [https://paws-r.github.io/docs/sagemaker/describe_feature_metadata.html](https://paws-r.github.io/docs/sagemaker/describe_feature_metadata.html) for full documentation.
#'
#' @param FeatureGroupName &#91;required&#93; The name of the feature group containing the feature.
#' @param FeatureName &#91;required&#93; The name of the feature.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_feature_metadata
sagemaker_describe_feature_metadata <- function(FeatureGroupName, FeatureName) {
  op <- new_operation(
    name = "DescribeFeatureMetadata",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_feature_metadata_input(FeatureGroupName = FeatureGroupName, FeatureName = FeatureName)
  output <- .sagemaker$describe_feature_metadata_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_feature_metadata <- sagemaker_describe_feature_metadata

#' Returns information about the specified flow definition
#'
#' @description
#' Returns information about the specified flow definition.
#'
#' See [https://paws-r.github.io/docs/sagemaker/describe_flow_definition.html](https://paws-r.github.io/docs/sagemaker/describe_flow_definition.html) for full documentation.
#'
#' @param FlowDefinitionName &#91;required&#93; The name of the flow definition.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_flow_definition
sagemaker_describe_flow_definition <- function(FlowDefinitionName) {
  op <- new_operation(
    name = "DescribeFlowDefinition",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_flow_definition_input(FlowDefinitionName = FlowDefinitionName)
  output <- .sagemaker$describe_flow_definition_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_flow_definition <- sagemaker_describe_flow_definition

#' Returns information about the requested human task user interface
#' (worker task template)
#'
#' @description
#' Returns information about the requested human task user interface (worker task template).
#'
#' See [https://paws-r.github.io/docs/sagemaker/describe_human_task_ui.html](https://paws-r.github.io/docs/sagemaker/describe_human_task_ui.html) for full documentation.
#'
#' @param HumanTaskUiName &#91;required&#93; The name of the human task user interface (worker task template) you
#' want information about.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_human_task_ui
sagemaker_describe_human_task_ui <- function(HumanTaskUiName) {
  op <- new_operation(
    name = "DescribeHumanTaskUi",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_human_task_ui_input(HumanTaskUiName = HumanTaskUiName)
  output <- .sagemaker$describe_human_task_ui_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_human_task_ui <- sagemaker_describe_human_task_ui

#' Gets a description of a hyperparameter tuning job
#'
#' @description
#' Gets a description of a hyperparameter tuning job.
#'
#' See [https://paws-r.github.io/docs/sagemaker/describe_hyper_parameter_tuning_job.html](https://paws-r.github.io/docs/sagemaker/describe_hyper_parameter_tuning_job.html) for full documentation.
#'
#' @param HyperParameterTuningJobName &#91;required&#93; The name of the tuning job.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_hyper_parameter_tuning_job
sagemaker_describe_hyper_parameter_tuning_job <- function(HyperParameterTuningJobName) {
  op <- new_operation(
    name = "DescribeHyperParameterTuningJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_hyper_parameter_tuning_job_input(HyperParameterTuningJobName = HyperParameterTuningJobName)
  output <- .sagemaker$describe_hyper_parameter_tuning_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_hyper_parameter_tuning_job <- sagemaker_describe_hyper_parameter_tuning_job

#' Describes a SageMaker image
#'
#' @description
#' Describes a SageMaker image.
#'
#' See [https://paws-r.github.io/docs/sagemaker/describe_image.html](https://paws-r.github.io/docs/sagemaker/describe_image.html) for full documentation.
#'
#' @param ImageName &#91;required&#93; The name of the image to describe.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_image
sagemaker_describe_image <- function(ImageName) {
  op <- new_operation(
    name = "DescribeImage",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_image_input(ImageName = ImageName)
  output <- .sagemaker$describe_image_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_image <- sagemaker_describe_image

#' Describes a version of a SageMaker image
#'
#' @description
#' Describes a version of a SageMaker image.
#'
#' See [https://paws-r.github.io/docs/sagemaker/describe_image_version.html](https://paws-r.github.io/docs/sagemaker/describe_image_version.html) for full documentation.
#'
#' @param ImageName &#91;required&#93; The name of the image.
#' @param Version The version of the image. If not specified, the latest version is
#' described.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_image_version
sagemaker_describe_image_version <- function(ImageName, Version = NULL) {
  op <- new_operation(
    name = "DescribeImageVersion",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_image_version_input(ImageName = ImageName, Version = Version)
  output <- .sagemaker$describe_image_version_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_image_version <- sagemaker_describe_image_version

#' Provides the results of the Inference Recommender job
#'
#' @description
#' Provides the results of the Inference Recommender job. One or more recommendation jobs are returned.
#'
#' See [https://paws-r.github.io/docs/sagemaker/describe_inference_recommendations_job.html](https://paws-r.github.io/docs/sagemaker/describe_inference_recommendations_job.html) for full documentation.
#'
#' @param JobName &#91;required&#93; The name of the job. The name must be unique within an Amazon Web
#' Services Region in the Amazon Web Services account.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_inference_recommendations_job
sagemaker_describe_inference_recommendations_job <- function(JobName) {
  op <- new_operation(
    name = "DescribeInferenceRecommendationsJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_inference_recommendations_job_input(JobName = JobName)
  output <- .sagemaker$describe_inference_recommendations_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_inference_recommendations_job <- sagemaker_describe_inference_recommendations_job

#' Gets information about a labeling job
#'
#' @description
#' Gets information about a labeling job.
#'
#' See [https://paws-r.github.io/docs/sagemaker/describe_labeling_job.html](https://paws-r.github.io/docs/sagemaker/describe_labeling_job.html) for full documentation.
#'
#' @param LabelingJobName &#91;required&#93; The name of the labeling job to return information for.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_labeling_job
sagemaker_describe_labeling_job <- function(LabelingJobName) {
  op <- new_operation(
    name = "DescribeLabelingJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_labeling_job_input(LabelingJobName = LabelingJobName)
  output <- .sagemaker$describe_labeling_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_labeling_job <- sagemaker_describe_labeling_job

#' Provides a list of properties for the requested lineage group
#'
#' @description
#' Provides a list of properties for the requested lineage group. For more information, see [Cross-Account Lineage Tracking](https://docs.aws.amazon.com/sagemaker/latest/dg/xaccount-lineage-tracking.html) in the *Amazon SageMaker Developer Guide*.
#'
#' See [https://paws-r.github.io/docs/sagemaker/describe_lineage_group.html](https://paws-r.github.io/docs/sagemaker/describe_lineage_group.html) for full documentation.
#'
#' @param LineageGroupName &#91;required&#93; The name of the lineage group.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_lineage_group
sagemaker_describe_lineage_group <- function(LineageGroupName) {
  op <- new_operation(
    name = "DescribeLineageGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_lineage_group_input(LineageGroupName = LineageGroupName)
  output <- .sagemaker$describe_lineage_group_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_lineage_group <- sagemaker_describe_lineage_group

#' Describes a model that you created using the CreateModel API
#'
#' @description
#' Describes a model that you created using the [`create_model`][sagemaker_create_model] API.
#'
#' See [https://paws-r.github.io/docs/sagemaker/describe_model.html](https://paws-r.github.io/docs/sagemaker/describe_model.html) for full documentation.
#'
#' @param ModelName &#91;required&#93; The name of the model.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_model
sagemaker_describe_model <- function(ModelName) {
  op <- new_operation(
    name = "DescribeModel",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_model_input(ModelName = ModelName)
  output <- .sagemaker$describe_model_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_model <- sagemaker_describe_model

#' Returns a description of a model bias job definition
#'
#' @description
#' Returns a description of a model bias job definition.
#'
#' See [https://paws-r.github.io/docs/sagemaker/describe_model_bias_job_definition.html](https://paws-r.github.io/docs/sagemaker/describe_model_bias_job_definition.html) for full documentation.
#'
#' @param JobDefinitionName &#91;required&#93; The name of the model bias job definition. The name must be unique
#' within an Amazon Web Services Region in the Amazon Web Services account.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_model_bias_job_definition
sagemaker_describe_model_bias_job_definition <- function(JobDefinitionName) {
  op <- new_operation(
    name = "DescribeModelBiasJobDefinition",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_model_bias_job_definition_input(JobDefinitionName = JobDefinitionName)
  output <- .sagemaker$describe_model_bias_job_definition_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_model_bias_job_definition <- sagemaker_describe_model_bias_job_definition

#' Returns a description of a model explainability job definition
#'
#' @description
#' Returns a description of a model explainability job definition.
#'
#' See [https://paws-r.github.io/docs/sagemaker/describe_model_explainability_job_definition.html](https://paws-r.github.io/docs/sagemaker/describe_model_explainability_job_definition.html) for full documentation.
#'
#' @param JobDefinitionName &#91;required&#93; The name of the model explainability job definition. The name must be
#' unique within an Amazon Web Services Region in the Amazon Web Services
#' account.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_model_explainability_job_definition
sagemaker_describe_model_explainability_job_definition <- function(JobDefinitionName) {
  op <- new_operation(
    name = "DescribeModelExplainabilityJobDefinition",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_model_explainability_job_definition_input(JobDefinitionName = JobDefinitionName)
  output <- .sagemaker$describe_model_explainability_job_definition_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_model_explainability_job_definition <- sagemaker_describe_model_explainability_job_definition

#' Returns a description of the specified model package, which is used to
#' create SageMaker models or list them on Amazon Web Services Marketplace
#'
#' @description
#' Returns a description of the specified model package, which is used to create SageMaker models or list them on Amazon Web Services Marketplace.
#'
#' See [https://paws-r.github.io/docs/sagemaker/describe_model_package.html](https://paws-r.github.io/docs/sagemaker/describe_model_package.html) for full documentation.
#'
#' @param ModelPackageName &#91;required&#93; The name or Amazon Resource Name (ARN) of the model package to describe.
#' 
#' When you specify a name, the name must have 1 to 63 characters. Valid
#' characters are a-z, A-Z, 0-9, and - (hyphen).
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_model_package
sagemaker_describe_model_package <- function(ModelPackageName) {
  op <- new_operation(
    name = "DescribeModelPackage",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_model_package_input(ModelPackageName = ModelPackageName)
  output <- .sagemaker$describe_model_package_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_model_package <- sagemaker_describe_model_package

#' Gets a description for the specified model group
#'
#' @description
#' Gets a description for the specified model group.
#'
#' See [https://paws-r.github.io/docs/sagemaker/describe_model_package_group.html](https://paws-r.github.io/docs/sagemaker/describe_model_package_group.html) for full documentation.
#'
#' @param ModelPackageGroupName &#91;required&#93; The name of gthe model group to describe.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_model_package_group
sagemaker_describe_model_package_group <- function(ModelPackageGroupName) {
  op <- new_operation(
    name = "DescribeModelPackageGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_model_package_group_input(ModelPackageGroupName = ModelPackageGroupName)
  output <- .sagemaker$describe_model_package_group_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_model_package_group <- sagemaker_describe_model_package_group

#' Returns a description of a model quality job definition
#'
#' @description
#' Returns a description of a model quality job definition.
#'
#' See [https://paws-r.github.io/docs/sagemaker/describe_model_quality_job_definition.html](https://paws-r.github.io/docs/sagemaker/describe_model_quality_job_definition.html) for full documentation.
#'
#' @param JobDefinitionName &#91;required&#93; The name of the model quality job. The name must be unique within an
#' Amazon Web Services Region in the Amazon Web Services account.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_model_quality_job_definition
sagemaker_describe_model_quality_job_definition <- function(JobDefinitionName) {
  op <- new_operation(
    name = "DescribeModelQualityJobDefinition",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_model_quality_job_definition_input(JobDefinitionName = JobDefinitionName)
  output <- .sagemaker$describe_model_quality_job_definition_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_model_quality_job_definition <- sagemaker_describe_model_quality_job_definition

#' Describes the schedule for a monitoring job
#'
#' @description
#' Describes the schedule for a monitoring job.
#'
#' See [https://paws-r.github.io/docs/sagemaker/describe_monitoring_schedule.html](https://paws-r.github.io/docs/sagemaker/describe_monitoring_schedule.html) for full documentation.
#'
#' @param MonitoringScheduleName &#91;required&#93; Name of a previously created monitoring schedule.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_monitoring_schedule
sagemaker_describe_monitoring_schedule <- function(MonitoringScheduleName) {
  op <- new_operation(
    name = "DescribeMonitoringSchedule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_monitoring_schedule_input(MonitoringScheduleName = MonitoringScheduleName)
  output <- .sagemaker$describe_monitoring_schedule_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_monitoring_schedule <- sagemaker_describe_monitoring_schedule

#' Returns information about a notebook instance
#'
#' @description
#' Returns information about a notebook instance.
#'
#' See [https://paws-r.github.io/docs/sagemaker/describe_notebook_instance.html](https://paws-r.github.io/docs/sagemaker/describe_notebook_instance.html) for full documentation.
#'
#' @param NotebookInstanceName &#91;required&#93; The name of the notebook instance that you want information about.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_notebook_instance
sagemaker_describe_notebook_instance <- function(NotebookInstanceName) {
  op <- new_operation(
    name = "DescribeNotebookInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_notebook_instance_input(NotebookInstanceName = NotebookInstanceName)
  output <- .sagemaker$describe_notebook_instance_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_notebook_instance <- sagemaker_describe_notebook_instance

#' Returns a description of a notebook instance lifecycle configuration
#'
#' @description
#' Returns a description of a notebook instance lifecycle configuration.
#'
#' See [https://paws-r.github.io/docs/sagemaker/describe_notebook_instance_lifecycle_config.html](https://paws-r.github.io/docs/sagemaker/describe_notebook_instance_lifecycle_config.html) for full documentation.
#'
#' @param NotebookInstanceLifecycleConfigName &#91;required&#93; The name of the lifecycle configuration to describe.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_notebook_instance_lifecycle_config
sagemaker_describe_notebook_instance_lifecycle_config <- function(NotebookInstanceLifecycleConfigName) {
  op <- new_operation(
    name = "DescribeNotebookInstanceLifecycleConfig",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_notebook_instance_lifecycle_config_input(NotebookInstanceLifecycleConfigName = NotebookInstanceLifecycleConfigName)
  output <- .sagemaker$describe_notebook_instance_lifecycle_config_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_notebook_instance_lifecycle_config <- sagemaker_describe_notebook_instance_lifecycle_config

#' Describes the details of a pipeline
#'
#' @description
#' Describes the details of a pipeline.
#'
#' See [https://paws-r.github.io/docs/sagemaker/describe_pipeline.html](https://paws-r.github.io/docs/sagemaker/describe_pipeline.html) for full documentation.
#'
#' @param PipelineName &#91;required&#93; The name of the pipeline to describe.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_pipeline
sagemaker_describe_pipeline <- function(PipelineName) {
  op <- new_operation(
    name = "DescribePipeline",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_pipeline_input(PipelineName = PipelineName)
  output <- .sagemaker$describe_pipeline_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_pipeline <- sagemaker_describe_pipeline

#' Describes the details of an execution's pipeline definition
#'
#' @description
#' Describes the details of an execution's pipeline definition.
#'
#' See [https://paws-r.github.io/docs/sagemaker/describe_pipeline_definition_for_execution.html](https://paws-r.github.io/docs/sagemaker/describe_pipeline_definition_for_execution.html) for full documentation.
#'
#' @param PipelineExecutionArn &#91;required&#93; The Amazon Resource Name (ARN) of the pipeline execution.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_pipeline_definition_for_execution
sagemaker_describe_pipeline_definition_for_execution <- function(PipelineExecutionArn) {
  op <- new_operation(
    name = "DescribePipelineDefinitionForExecution",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_pipeline_definition_for_execution_input(PipelineExecutionArn = PipelineExecutionArn)
  output <- .sagemaker$describe_pipeline_definition_for_execution_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_pipeline_definition_for_execution <- sagemaker_describe_pipeline_definition_for_execution

#' Describes the details of a pipeline execution
#'
#' @description
#' Describes the details of a pipeline execution.
#'
#' See [https://paws-r.github.io/docs/sagemaker/describe_pipeline_execution.html](https://paws-r.github.io/docs/sagemaker/describe_pipeline_execution.html) for full documentation.
#'
#' @param PipelineExecutionArn &#91;required&#93; The Amazon Resource Name (ARN) of the pipeline execution.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_pipeline_execution
sagemaker_describe_pipeline_execution <- function(PipelineExecutionArn) {
  op <- new_operation(
    name = "DescribePipelineExecution",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_pipeline_execution_input(PipelineExecutionArn = PipelineExecutionArn)
  output <- .sagemaker$describe_pipeline_execution_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_pipeline_execution <- sagemaker_describe_pipeline_execution

#' Returns a description of a processing job
#'
#' @description
#' Returns a description of a processing job.
#'
#' See [https://paws-r.github.io/docs/sagemaker/describe_processing_job.html](https://paws-r.github.io/docs/sagemaker/describe_processing_job.html) for full documentation.
#'
#' @param ProcessingJobName &#91;required&#93; The name of the processing job. The name must be unique within an Amazon
#' Web Services Region in the Amazon Web Services account.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_processing_job
sagemaker_describe_processing_job <- function(ProcessingJobName) {
  op <- new_operation(
    name = "DescribeProcessingJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_processing_job_input(ProcessingJobName = ProcessingJobName)
  output <- .sagemaker$describe_processing_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_processing_job <- sagemaker_describe_processing_job

#' Describes the details of a project
#'
#' @description
#' Describes the details of a project.
#'
#' See [https://paws-r.github.io/docs/sagemaker/describe_project.html](https://paws-r.github.io/docs/sagemaker/describe_project.html) for full documentation.
#'
#' @param ProjectName &#91;required&#93; The name of the project to describe.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_project
sagemaker_describe_project <- function(ProjectName) {
  op <- new_operation(
    name = "DescribeProject",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_project_input(ProjectName = ProjectName)
  output <- .sagemaker$describe_project_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_project <- sagemaker_describe_project

#' Describes the Studio Lifecycle Configuration
#'
#' @description
#' Describes the Studio Lifecycle Configuration.
#'
#' See [https://paws-r.github.io/docs/sagemaker/describe_studio_lifecycle_config.html](https://paws-r.github.io/docs/sagemaker/describe_studio_lifecycle_config.html) for full documentation.
#'
#' @param StudioLifecycleConfigName &#91;required&#93; The name of the Studio Lifecycle Configuration to describe.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_studio_lifecycle_config
sagemaker_describe_studio_lifecycle_config <- function(StudioLifecycleConfigName) {
  op <- new_operation(
    name = "DescribeStudioLifecycleConfig",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_studio_lifecycle_config_input(StudioLifecycleConfigName = StudioLifecycleConfigName)
  output <- .sagemaker$describe_studio_lifecycle_config_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_studio_lifecycle_config <- sagemaker_describe_studio_lifecycle_config

#' Gets information about a work team provided by a vendor
#'
#' @description
#' Gets information about a work team provided by a vendor. It returns details about the subscription with a vendor in the Amazon Web Services Marketplace.
#'
#' See [https://paws-r.github.io/docs/sagemaker/describe_subscribed_workteam.html](https://paws-r.github.io/docs/sagemaker/describe_subscribed_workteam.html) for full documentation.
#'
#' @param WorkteamArn &#91;required&#93; The Amazon Resource Name (ARN) of the subscribed work team to describe.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_subscribed_workteam
sagemaker_describe_subscribed_workteam <- function(WorkteamArn) {
  op <- new_operation(
    name = "DescribeSubscribedWorkteam",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_subscribed_workteam_input(WorkteamArn = WorkteamArn)
  output <- .sagemaker$describe_subscribed_workteam_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_subscribed_workteam <- sagemaker_describe_subscribed_workteam

#' Returns information about a training job
#'
#' @description
#' Returns information about a training job.
#'
#' See [https://paws-r.github.io/docs/sagemaker/describe_training_job.html](https://paws-r.github.io/docs/sagemaker/describe_training_job.html) for full documentation.
#'
#' @param TrainingJobName &#91;required&#93; The name of the training job.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_training_job
sagemaker_describe_training_job <- function(TrainingJobName) {
  op <- new_operation(
    name = "DescribeTrainingJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_training_job_input(TrainingJobName = TrainingJobName)
  output <- .sagemaker$describe_training_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_training_job <- sagemaker_describe_training_job

#' Returns information about a transform job
#'
#' @description
#' Returns information about a transform job.
#'
#' See [https://paws-r.github.io/docs/sagemaker/describe_transform_job.html](https://paws-r.github.io/docs/sagemaker/describe_transform_job.html) for full documentation.
#'
#' @param TransformJobName &#91;required&#93; The name of the transform job that you want to view details of.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_transform_job
sagemaker_describe_transform_job <- function(TransformJobName) {
  op <- new_operation(
    name = "DescribeTransformJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_transform_job_input(TransformJobName = TransformJobName)
  output <- .sagemaker$describe_transform_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_transform_job <- sagemaker_describe_transform_job

#' Provides a list of a trial's properties
#'
#' @description
#' Provides a list of a trial's properties.
#'
#' See [https://paws-r.github.io/docs/sagemaker/describe_trial.html](https://paws-r.github.io/docs/sagemaker/describe_trial.html) for full documentation.
#'
#' @param TrialName &#91;required&#93; The name of the trial to describe.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_trial
sagemaker_describe_trial <- function(TrialName) {
  op <- new_operation(
    name = "DescribeTrial",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_trial_input(TrialName = TrialName)
  output <- .sagemaker$describe_trial_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_trial <- sagemaker_describe_trial

#' Provides a list of a trials component's properties
#'
#' @description
#' Provides a list of a trials component's properties.
#'
#' See [https://paws-r.github.io/docs/sagemaker/describe_trial_component.html](https://paws-r.github.io/docs/sagemaker/describe_trial_component.html) for full documentation.
#'
#' @param TrialComponentName &#91;required&#93; The name of the trial component to describe.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_trial_component
sagemaker_describe_trial_component <- function(TrialComponentName) {
  op <- new_operation(
    name = "DescribeTrialComponent",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_trial_component_input(TrialComponentName = TrialComponentName)
  output <- .sagemaker$describe_trial_component_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_trial_component <- sagemaker_describe_trial_component

#' Describes a user profile
#'
#' @description
#' Describes a user profile. For more information, see [`create_user_profile`][sagemaker_create_user_profile].
#'
#' See [https://paws-r.github.io/docs/sagemaker/describe_user_profile.html](https://paws-r.github.io/docs/sagemaker/describe_user_profile.html) for full documentation.
#'
#' @param DomainId &#91;required&#93; The domain ID.
#' @param UserProfileName &#91;required&#93; The user profile name. This value is not case sensitive.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_user_profile
sagemaker_describe_user_profile <- function(DomainId, UserProfileName) {
  op <- new_operation(
    name = "DescribeUserProfile",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_user_profile_input(DomainId = DomainId, UserProfileName = UserProfileName)
  output <- .sagemaker$describe_user_profile_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_user_profile <- sagemaker_describe_user_profile

#' Lists private workforce information, including workforce name, Amazon
#' Resource Name (ARN), and, if applicable, allowed IP address ranges
#' (CIDRs)
#'
#' @description
#' Lists private workforce information, including workforce name, Amazon Resource Name (ARN), and, if applicable, allowed IP address ranges ([CIDRs](https://docs.aws.amazon.com/vpc/latest/userguide/how-it-works.html)). Allowable IP address ranges are the IP addresses that workers can use to access tasks.
#'
#' See [https://paws-r.github.io/docs/sagemaker/describe_workforce.html](https://paws-r.github.io/docs/sagemaker/describe_workforce.html) for full documentation.
#'
#' @param WorkforceName &#91;required&#93; The name of the private workforce whose access you want to restrict.
#' `WorkforceName` is automatically set to `default` when a workforce is
#' created and cannot be modified.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_workforce
sagemaker_describe_workforce <- function(WorkforceName) {
  op <- new_operation(
    name = "DescribeWorkforce",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_workforce_input(WorkforceName = WorkforceName)
  output <- .sagemaker$describe_workforce_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_workforce <- sagemaker_describe_workforce

#' Gets information about a specific work team
#'
#' @description
#' Gets information about a specific work team. You can see information such as the create date, the last updated date, membership information, and the work team's Amazon Resource Name (ARN).
#'
#' See [https://paws-r.github.io/docs/sagemaker/describe_workteam.html](https://paws-r.github.io/docs/sagemaker/describe_workteam.html) for full documentation.
#'
#' @param WorkteamName &#91;required&#93; The name of the work team to return a description of.
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_workteam
sagemaker_describe_workteam <- function(WorkteamName) {
  op <- new_operation(
    name = "DescribeWorkteam",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_workteam_input(WorkteamName = WorkteamName)
  output <- .sagemaker$describe_workteam_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_workteam <- sagemaker_describe_workteam

#' Disables using Service Catalog in SageMaker
#'
#' @description
#' Disables using Service Catalog in SageMaker. Service Catalog is used to create SageMaker projects.
#'
#' See [https://paws-r.github.io/docs/sagemaker/disable_sagemaker_servicecatalog_portfolio.html](https://paws-r.github.io/docs/sagemaker/disable_sagemaker_servicecatalog_portfolio.html) for full documentation.
#'
#' @keywords internal
#'
#' @rdname sagemaker_disable_sagemaker_servicecatalog_portfolio
sagemaker_disable_sagemaker_servicecatalog_portfolio <- function() {
  op <- new_operation(
    name = "DisableSagemakerServicecatalogPortfolio",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$disable_sagemaker_servicecatalog_portfolio_input()
  output <- .sagemaker$disable_sagemaker_servicecatalog_portfolio_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$disable_sagemaker_servicecatalog_portfolio <- sagemaker_disable_sagemaker_servicecatalog_portfolio

#' Disassociates a trial component from a trial
#'
#' @description
#' Disassociates a trial component from a trial. This doesn't effect other trials the component is associated with. Before you can delete a component, you must disassociate the component from all trials it is associated with. To associate a trial component with a trial, call the [`associate_trial_component`][sagemaker_associate_trial_component] API.
#'
#' See [https://paws-r.github.io/docs/sagemaker/disassociate_trial_component.html](https://paws-r.github.io/docs/sagemaker/disassociate_trial_component.html) for full documentation.
#'
#' @param TrialComponentName &#91;required&#93; The name of the component to disassociate from the trial.
#' @param TrialName &#91;required&#93; The name of the trial to disassociate from.
#'
#' @keywords internal
#'
#' @rdname sagemaker_disassociate_trial_component
sagemaker_disassociate_trial_component <- function(TrialComponentName, TrialName) {
  op <- new_operation(
    name = "DisassociateTrialComponent",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$disassociate_trial_component_input(TrialComponentName = TrialComponentName, TrialName = TrialName)
  output <- .sagemaker$disassociate_trial_component_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$disassociate_trial_component <- sagemaker_disassociate_trial_component

#' Enables using Service Catalog in SageMaker
#'
#' @description
#' Enables using Service Catalog in SageMaker. Service Catalog is used to create SageMaker projects.
#'
#' See [https://paws-r.github.io/docs/sagemaker/enable_sagemaker_servicecatalog_portfolio.html](https://paws-r.github.io/docs/sagemaker/enable_sagemaker_servicecatalog_portfolio.html) for full documentation.
#'
#' @keywords internal
#'
#' @rdname sagemaker_enable_sagemaker_servicecatalog_portfolio
sagemaker_enable_sagemaker_servicecatalog_portfolio <- function() {
  op <- new_operation(
    name = "EnableSagemakerServicecatalogPortfolio",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$enable_sagemaker_servicecatalog_portfolio_input()
  output <- .sagemaker$enable_sagemaker_servicecatalog_portfolio_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$enable_sagemaker_servicecatalog_portfolio <- sagemaker_enable_sagemaker_servicecatalog_portfolio

#' Describes a fleet
#'
#' @description
#' Describes a fleet.
#'
#' See [https://paws-r.github.io/docs/sagemaker/get_device_fleet_report.html](https://paws-r.github.io/docs/sagemaker/get_device_fleet_report.html) for full documentation.
#'
#' @param DeviceFleetName &#91;required&#93; The name of the fleet.
#'
#' @keywords internal
#'
#' @rdname sagemaker_get_device_fleet_report
sagemaker_get_device_fleet_report <- function(DeviceFleetName) {
  op <- new_operation(
    name = "GetDeviceFleetReport",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$get_device_fleet_report_input(DeviceFleetName = DeviceFleetName)
  output <- .sagemaker$get_device_fleet_report_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$get_device_fleet_report <- sagemaker_get_device_fleet_report

#' The resource policy for the lineage group
#'
#' @description
#' The resource policy for the lineage group.
#'
#' See [https://paws-r.github.io/docs/sagemaker/get_lineage_group_policy.html](https://paws-r.github.io/docs/sagemaker/get_lineage_group_policy.html) for full documentation.
#'
#' @param LineageGroupName &#91;required&#93; The name or Amazon Resource Name (ARN) of the lineage group.
#'
#' @keywords internal
#'
#' @rdname sagemaker_get_lineage_group_policy
sagemaker_get_lineage_group_policy <- function(LineageGroupName) {
  op <- new_operation(
    name = "GetLineageGroupPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$get_lineage_group_policy_input(LineageGroupName = LineageGroupName)
  output <- .sagemaker$get_lineage_group_policy_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$get_lineage_group_policy <- sagemaker_get_lineage_group_policy

#' Gets a resource policy that manages access for a model group
#'
#' @description
#' Gets a resource policy that manages access for a model group. For information about resource policies, see [Identity-based policies and resource-based policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_identity-vs-resource.html) in the *Amazon Web Services Identity and Access Management User Guide.*.
#'
#' See [https://paws-r.github.io/docs/sagemaker/get_model_package_group_policy.html](https://paws-r.github.io/docs/sagemaker/get_model_package_group_policy.html) for full documentation.
#'
#' @param ModelPackageGroupName &#91;required&#93; The name of the model group for which to get the resource policy.
#'
#' @keywords internal
#'
#' @rdname sagemaker_get_model_package_group_policy
sagemaker_get_model_package_group_policy <- function(ModelPackageGroupName) {
  op <- new_operation(
    name = "GetModelPackageGroupPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$get_model_package_group_policy_input(ModelPackageGroupName = ModelPackageGroupName)
  output <- .sagemaker$get_model_package_group_policy_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$get_model_package_group_policy <- sagemaker_get_model_package_group_policy

#' Gets the status of Service Catalog in SageMaker
#'
#' @description
#' Gets the status of Service Catalog in SageMaker. Service Catalog is used to create SageMaker projects.
#'
#' See [https://paws-r.github.io/docs/sagemaker/get_sagemaker_servicecatalog_portfolio_status.html](https://paws-r.github.io/docs/sagemaker/get_sagemaker_servicecatalog_portfolio_status.html) for full documentation.
#'
#' @keywords internal
#'
#' @rdname sagemaker_get_sagemaker_servicecatalog_portfolio_status
sagemaker_get_sagemaker_servicecatalog_portfolio_status <- function() {
  op <- new_operation(
    name = "GetSagemakerServicecatalogPortfolioStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$get_sagemaker_servicecatalog_portfolio_status_input()
  output <- .sagemaker$get_sagemaker_servicecatalog_portfolio_status_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$get_sagemaker_servicecatalog_portfolio_status <- sagemaker_get_sagemaker_servicecatalog_portfolio_status

#' An auto-complete API for the search functionality in the Amazon
#' SageMaker console
#'
#' @description
#' An auto-complete API for the search functionality in the Amazon SageMaker console. It returns suggestions of possible matches for the property name to use in [`search`][sagemaker_search] queries. Provides suggestions for `HyperParameters`, `Tags`, and `Metrics`.
#'
#' See [https://paws-r.github.io/docs/sagemaker/get_search_suggestions.html](https://paws-r.github.io/docs/sagemaker/get_search_suggestions.html) for full documentation.
#'
#' @param Resource &#91;required&#93; The name of the Amazon SageMaker resource to search for.
#' @param SuggestionQuery Limits the property names that are included in the response.
#'
#' @keywords internal
#'
#' @rdname sagemaker_get_search_suggestions
sagemaker_get_search_suggestions <- function(Resource, SuggestionQuery = NULL) {
  op <- new_operation(
    name = "GetSearchSuggestions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$get_search_suggestions_input(Resource = Resource, SuggestionQuery = SuggestionQuery)
  output <- .sagemaker$get_search_suggestions_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$get_search_suggestions <- sagemaker_get_search_suggestions

#' Lists the actions in your account and their properties
#'
#' @description
#' Lists the actions in your account and their properties.
#'
#' See [https://paws-r.github.io/docs/sagemaker/list_actions.html](https://paws-r.github.io/docs/sagemaker/list_actions.html) for full documentation.
#'
#' @param SourceUri A filter that returns only actions with the specified source URI.
#' @param ActionType A filter that returns only actions of the specified type.
#' @param CreatedAfter A filter that returns only actions created on or after the specified
#' time.
#' @param CreatedBefore A filter that returns only actions created on or before the specified
#' time.
#' @param SortBy The property used to sort results. The default value is `CreationTime`.
#' @param SortOrder The sort order. The default value is `Descending`.
#' @param NextToken If the previous call to [`list_actions`][sagemaker_list_actions] didn't
#' return the full set of actions, the call returns a token for getting the
#' next set of actions.
#' @param MaxResults The maximum number of actions to return in the response. The default
#' value is 10.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_actions
sagemaker_list_actions <- function(SourceUri = NULL, ActionType = NULL, CreatedAfter = NULL, CreatedBefore = NULL, SortBy = NULL, SortOrder = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListActions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_actions_input(SourceUri = SourceUri, ActionType = ActionType, CreatedAfter = CreatedAfter, CreatedBefore = CreatedBefore, SortBy = SortBy, SortOrder = SortOrder, NextToken = NextToken, MaxResults = MaxResults)
  output <- .sagemaker$list_actions_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_actions <- sagemaker_list_actions

#' Lists the machine learning algorithms that have been created
#'
#' @description
#' Lists the machine learning algorithms that have been created.
#'
#' See [https://paws-r.github.io/docs/sagemaker/list_algorithms.html](https://paws-r.github.io/docs/sagemaker/list_algorithms.html) for full documentation.
#'
#' @param CreationTimeAfter A filter that returns only algorithms created after the specified time
#' (timestamp).
#' @param CreationTimeBefore A filter that returns only algorithms created before the specified time
#' (timestamp).
#' @param MaxResults The maximum number of algorithms to return in the response.
#' @param NameContains A string in the algorithm name. This filter returns only algorithms
#' whose name contains the specified string.
#' @param NextToken If the response to a previous
#' [`list_algorithms`][sagemaker_list_algorithms] request was truncated,
#' the response includes a `NextToken`. To retrieve the next set of
#' algorithms, use the token in the next request.
#' @param SortBy The parameter by which to sort the results. The default is
#' `CreationTime`.
#' @param SortOrder The sort order for the results. The default is `Ascending`.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_algorithms
sagemaker_list_algorithms <- function(CreationTimeAfter = NULL, CreationTimeBefore = NULL, MaxResults = NULL, NameContains = NULL, NextToken = NULL, SortBy = NULL, SortOrder = NULL) {
  op <- new_operation(
    name = "ListAlgorithms",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_algorithms_input(CreationTimeAfter = CreationTimeAfter, CreationTimeBefore = CreationTimeBefore, MaxResults = MaxResults, NameContains = NameContains, NextToken = NextToken, SortBy = SortBy, SortOrder = SortOrder)
  output <- .sagemaker$list_algorithms_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_algorithms <- sagemaker_list_algorithms

#' Lists the AppImageConfigs in your account and their properties
#'
#' @description
#' Lists the AppImageConfigs in your account and their properties. The list can be filtered by creation time or modified time, and whether the AppImageConfig name contains a specified string.
#'
#' See [https://paws-r.github.io/docs/sagemaker/list_app_image_configs.html](https://paws-r.github.io/docs/sagemaker/list_app_image_configs.html) for full documentation.
#'
#' @param MaxResults The maximum number of AppImageConfigs to return in the response. The
#' default value is 10.
#' @param NextToken If the previous call to [`list_images`][sagemaker_list_images] didn't
#' return the full set of AppImageConfigs, the call returns a token for
#' getting the next set of AppImageConfigs.
#' @param NameContains A filter that returns only AppImageConfigs whose name contains the
#' specified string.
#' @param CreationTimeBefore A filter that returns only AppImageConfigs created on or before the
#' specified time.
#' @param CreationTimeAfter A filter that returns only AppImageConfigs created on or after the
#' specified time.
#' @param ModifiedTimeBefore A filter that returns only AppImageConfigs modified on or before the
#' specified time.
#' @param ModifiedTimeAfter A filter that returns only AppImageConfigs modified on or after the
#' specified time.
#' @param SortBy The property used to sort results. The default value is `CreationTime`.
#' @param SortOrder The sort order. The default value is `Descending`.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_app_image_configs
sagemaker_list_app_image_configs <- function(MaxResults = NULL, NextToken = NULL, NameContains = NULL, CreationTimeBefore = NULL, CreationTimeAfter = NULL, ModifiedTimeBefore = NULL, ModifiedTimeAfter = NULL, SortBy = NULL, SortOrder = NULL) {
  op <- new_operation(
    name = "ListAppImageConfigs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_app_image_configs_input(MaxResults = MaxResults, NextToken = NextToken, NameContains = NameContains, CreationTimeBefore = CreationTimeBefore, CreationTimeAfter = CreationTimeAfter, ModifiedTimeBefore = ModifiedTimeBefore, ModifiedTimeAfter = ModifiedTimeAfter, SortBy = SortBy, SortOrder = SortOrder)
  output <- .sagemaker$list_app_image_configs_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_app_image_configs <- sagemaker_list_app_image_configs

#' Lists apps
#'
#' @description
#' Lists apps.
#'
#' See [https://paws-r.github.io/docs/sagemaker/list_apps.html](https://paws-r.github.io/docs/sagemaker/list_apps.html) for full documentation.
#'
#' @param NextToken If the previous response was truncated, you will receive this token. Use
#' it in your next request to receive the next set of results.
#' @param MaxResults Returns a list up to a specified limit.
#' @param SortOrder The sort order for the results. The default is Ascending.
#' @param SortBy The parameter by which to sort the results. The default is CreationTime.
#' @param DomainIdEquals A parameter to search for the domain ID.
#' @param UserProfileNameEquals A parameter to search by user profile name.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_apps
sagemaker_list_apps <- function(NextToken = NULL, MaxResults = NULL, SortOrder = NULL, SortBy = NULL, DomainIdEquals = NULL, UserProfileNameEquals = NULL) {
  op <- new_operation(
    name = "ListApps",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_apps_input(NextToken = NextToken, MaxResults = MaxResults, SortOrder = SortOrder, SortBy = SortBy, DomainIdEquals = DomainIdEquals, UserProfileNameEquals = UserProfileNameEquals)
  output <- .sagemaker$list_apps_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_apps <- sagemaker_list_apps

#' Lists the artifacts in your account and their properties
#'
#' @description
#' Lists the artifacts in your account and their properties.
#'
#' See [https://paws-r.github.io/docs/sagemaker/list_artifacts.html](https://paws-r.github.io/docs/sagemaker/list_artifacts.html) for full documentation.
#'
#' @param SourceUri A filter that returns only artifacts with the specified source URI.
#' @param ArtifactType A filter that returns only artifacts of the specified type.
#' @param CreatedAfter A filter that returns only artifacts created on or after the specified
#' time.
#' @param CreatedBefore A filter that returns only artifacts created on or before the specified
#' time.
#' @param SortBy The property used to sort results. The default value is `CreationTime`.
#' @param SortOrder The sort order. The default value is `Descending`.
#' @param NextToken If the previous call to [`list_artifacts`][sagemaker_list_artifacts]
#' didn't return the full set of artifacts, the call returns a token for
#' getting the next set of artifacts.
#' @param MaxResults The maximum number of artifacts to return in the response. The default
#' value is 10.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_artifacts
sagemaker_list_artifacts <- function(SourceUri = NULL, ArtifactType = NULL, CreatedAfter = NULL, CreatedBefore = NULL, SortBy = NULL, SortOrder = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListArtifacts",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_artifacts_input(SourceUri = SourceUri, ArtifactType = ArtifactType, CreatedAfter = CreatedAfter, CreatedBefore = CreatedBefore, SortBy = SortBy, SortOrder = SortOrder, NextToken = NextToken, MaxResults = MaxResults)
  output <- .sagemaker$list_artifacts_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_artifacts <- sagemaker_list_artifacts

#' Lists the associations in your account and their properties
#'
#' @description
#' Lists the associations in your account and their properties.
#'
#' See [https://paws-r.github.io/docs/sagemaker/list_associations.html](https://paws-r.github.io/docs/sagemaker/list_associations.html) for full documentation.
#'
#' @param SourceArn A filter that returns only associations with the specified source ARN.
#' @param DestinationArn A filter that returns only associations with the specified destination
#' Amazon Resource Name (ARN).
#' @param SourceType A filter that returns only associations with the specified source type.
#' @param DestinationType A filter that returns only associations with the specified destination
#' type.
#' @param AssociationType A filter that returns only associations of the specified type.
#' @param CreatedAfter A filter that returns only associations created on or after the
#' specified time.
#' @param CreatedBefore A filter that returns only associations created on or before the
#' specified time.
#' @param SortBy The property used to sort results. The default value is `CreationTime`.
#' @param SortOrder The sort order. The default value is `Descending`.
#' @param NextToken If the previous call to
#' [`list_associations`][sagemaker_list_associations] didn't return the
#' full set of associations, the call returns a token for getting the next
#' set of associations.
#' @param MaxResults The maximum number of associations to return in the response. The
#' default value is 10.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_associations
sagemaker_list_associations <- function(SourceArn = NULL, DestinationArn = NULL, SourceType = NULL, DestinationType = NULL, AssociationType = NULL, CreatedAfter = NULL, CreatedBefore = NULL, SortBy = NULL, SortOrder = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListAssociations",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_associations_input(SourceArn = SourceArn, DestinationArn = DestinationArn, SourceType = SourceType, DestinationType = DestinationType, AssociationType = AssociationType, CreatedAfter = CreatedAfter, CreatedBefore = CreatedBefore, SortBy = SortBy, SortOrder = SortOrder, NextToken = NextToken, MaxResults = MaxResults)
  output <- .sagemaker$list_associations_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_associations <- sagemaker_list_associations

#' Request a list of jobs
#'
#' @description
#' Request a list of jobs.
#'
#' See [https://paws-r.github.io/docs/sagemaker/list_auto_ml_jobs.html](https://paws-r.github.io/docs/sagemaker/list_auto_ml_jobs.html) for full documentation.
#'
#' @param CreationTimeAfter Request a list of jobs, using a filter for time.
#' @param CreationTimeBefore Request a list of jobs, using a filter for time.
#' @param LastModifiedTimeAfter Request a list of jobs, using a filter for time.
#' @param LastModifiedTimeBefore Request a list of jobs, using a filter for time.
#' @param NameContains Request a list of jobs, using a search filter for name.
#' @param StatusEquals Request a list of jobs, using a filter for status.
#' @param SortOrder The sort order for the results. The default is `Descending`.
#' @param SortBy The parameter by which to sort the results. The default is `Name`.
#' @param MaxResults Request a list of jobs up to a specified limit.
#' @param NextToken If the previous response was truncated, you receive this token. Use it
#' in your next request to receive the next set of results.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_auto_ml_jobs
sagemaker_list_auto_ml_jobs <- function(CreationTimeAfter = NULL, CreationTimeBefore = NULL, LastModifiedTimeAfter = NULL, LastModifiedTimeBefore = NULL, NameContains = NULL, StatusEquals = NULL, SortOrder = NULL, SortBy = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListAutoMLJobs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_auto_ml_jobs_input(CreationTimeAfter = CreationTimeAfter, CreationTimeBefore = CreationTimeBefore, LastModifiedTimeAfter = LastModifiedTimeAfter, LastModifiedTimeBefore = LastModifiedTimeBefore, NameContains = NameContains, StatusEquals = StatusEquals, SortOrder = SortOrder, SortBy = SortBy, MaxResults = MaxResults, NextToken = NextToken)
  output <- .sagemaker$list_auto_ml_jobs_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_auto_ml_jobs <- sagemaker_list_auto_ml_jobs

#' List the candidates created for the job
#'
#' @description
#' List the candidates created for the job.
#'
#' See [https://paws-r.github.io/docs/sagemaker/list_candidates_for_auto_ml_job.html](https://paws-r.github.io/docs/sagemaker/list_candidates_for_auto_ml_job.html) for full documentation.
#'
#' @param AutoMLJobName &#91;required&#93; List the candidates created for the job by providing the job's name.
#' @param StatusEquals List the candidates for the job and filter by status.
#' @param CandidateNameEquals List the candidates for the job and filter by candidate name.
#' @param SortOrder The sort order for the results. The default is `Ascending`.
#' @param SortBy The parameter by which to sort the results. The default is `Descending`.
#' @param MaxResults List the job's candidates up to a specified limit.
#' @param NextToken If the previous response was truncated, you receive this token. Use it
#' in your next request to receive the next set of results.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_candidates_for_auto_ml_job
sagemaker_list_candidates_for_auto_ml_job <- function(AutoMLJobName, StatusEquals = NULL, CandidateNameEquals = NULL, SortOrder = NULL, SortBy = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListCandidatesForAutoMLJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_candidates_for_auto_ml_job_input(AutoMLJobName = AutoMLJobName, StatusEquals = StatusEquals, CandidateNameEquals = CandidateNameEquals, SortOrder = SortOrder, SortBy = SortBy, MaxResults = MaxResults, NextToken = NextToken)
  output <- .sagemaker$list_candidates_for_auto_ml_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_candidates_for_auto_ml_job <- sagemaker_list_candidates_for_auto_ml_job

#' Gets a list of the Git repositories in your account
#'
#' @description
#' Gets a list of the Git repositories in your account.
#'
#' See [https://paws-r.github.io/docs/sagemaker/list_code_repositories.html](https://paws-r.github.io/docs/sagemaker/list_code_repositories.html) for full documentation.
#'
#' @param CreationTimeAfter A filter that returns only Git repositories that were created after the
#' specified time.
#' @param CreationTimeBefore A filter that returns only Git repositories that were created before the
#' specified time.
#' @param LastModifiedTimeAfter A filter that returns only Git repositories that were last modified
#' after the specified time.
#' @param LastModifiedTimeBefore A filter that returns only Git repositories that were last modified
#' before the specified time.
#' @param MaxResults The maximum number of Git repositories to return in the response.
#' @param NameContains A string in the Git repositories name. This filter returns only
#' repositories whose name contains the specified string.
#' @param NextToken If the result of a `ListCodeRepositoriesOutput` request was truncated,
#' the response includes a `NextToken`. To get the next set of Git
#' repositories, use the token in the next request.
#' @param SortBy The field to sort results by. The default is `Name`.
#' @param SortOrder The sort order for results. The default is `Ascending`.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_code_repositories
sagemaker_list_code_repositories <- function(CreationTimeAfter = NULL, CreationTimeBefore = NULL, LastModifiedTimeAfter = NULL, LastModifiedTimeBefore = NULL, MaxResults = NULL, NameContains = NULL, NextToken = NULL, SortBy = NULL, SortOrder = NULL) {
  op <- new_operation(
    name = "ListCodeRepositories",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_code_repositories_input(CreationTimeAfter = CreationTimeAfter, CreationTimeBefore = CreationTimeBefore, LastModifiedTimeAfter = LastModifiedTimeAfter, LastModifiedTimeBefore = LastModifiedTimeBefore, MaxResults = MaxResults, NameContains = NameContains, NextToken = NextToken, SortBy = SortBy, SortOrder = SortOrder)
  output <- .sagemaker$list_code_repositories_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_code_repositories <- sagemaker_list_code_repositories

#' Lists model compilation jobs that satisfy various filters
#'
#' @description
#' Lists model compilation jobs that satisfy various filters.
#'
#' See [https://paws-r.github.io/docs/sagemaker/list_compilation_jobs.html](https://paws-r.github.io/docs/sagemaker/list_compilation_jobs.html) for full documentation.
#'
#' @param NextToken If the result of the previous
#' [`list_compilation_jobs`][sagemaker_list_compilation_jobs] request was
#' truncated, the response includes a `NextToken`. To retrieve the next set
#' of model compilation jobs, use the token in the next request.
#' @param MaxResults The maximum number of model compilation jobs to return in the response.
#' @param CreationTimeAfter A filter that returns the model compilation jobs that were created after
#' a specified time.
#' @param CreationTimeBefore A filter that returns the model compilation jobs that were created
#' before a specified time.
#' @param LastModifiedTimeAfter A filter that returns the model compilation jobs that were modified
#' after a specified time.
#' @param LastModifiedTimeBefore A filter that returns the model compilation jobs that were modified
#' before a specified time.
#' @param NameContains A filter that returns the model compilation jobs whose name contains a
#' specified string.
#' @param StatusEquals A filter that retrieves model compilation jobs with a specific
#' DescribeCompilationJobResponse$CompilationJobStatus status.
#' @param SortBy The field by which to sort results. The default is `CreationTime`.
#' @param SortOrder The sort order for results. The default is `Ascending`.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_compilation_jobs
sagemaker_list_compilation_jobs <- function(NextToken = NULL, MaxResults = NULL, CreationTimeAfter = NULL, CreationTimeBefore = NULL, LastModifiedTimeAfter = NULL, LastModifiedTimeBefore = NULL, NameContains = NULL, StatusEquals = NULL, SortBy = NULL, SortOrder = NULL) {
  op <- new_operation(
    name = "ListCompilationJobs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_compilation_jobs_input(NextToken = NextToken, MaxResults = MaxResults, CreationTimeAfter = CreationTimeAfter, CreationTimeBefore = CreationTimeBefore, LastModifiedTimeAfter = LastModifiedTimeAfter, LastModifiedTimeBefore = LastModifiedTimeBefore, NameContains = NameContains, StatusEquals = StatusEquals, SortBy = SortBy, SortOrder = SortOrder)
  output <- .sagemaker$list_compilation_jobs_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_compilation_jobs <- sagemaker_list_compilation_jobs

#' Lists the contexts in your account and their properties
#'
#' @description
#' Lists the contexts in your account and their properties.
#'
#' See [https://paws-r.github.io/docs/sagemaker/list_contexts.html](https://paws-r.github.io/docs/sagemaker/list_contexts.html) for full documentation.
#'
#' @param SourceUri A filter that returns only contexts with the specified source URI.
#' @param ContextType A filter that returns only contexts of the specified type.
#' @param CreatedAfter A filter that returns only contexts created on or after the specified
#' time.
#' @param CreatedBefore A filter that returns only contexts created on or before the specified
#' time.
#' @param SortBy The property used to sort results. The default value is `CreationTime`.
#' @param SortOrder The sort order. The default value is `Descending`.
#' @param NextToken If the previous call to [`list_contexts`][sagemaker_list_contexts]
#' didn't return the full set of contexts, the call returns a token for
#' getting the next set of contexts.
#' @param MaxResults The maximum number of contexts to return in the response. The default
#' value is 10.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_contexts
sagemaker_list_contexts <- function(SourceUri = NULL, ContextType = NULL, CreatedAfter = NULL, CreatedBefore = NULL, SortBy = NULL, SortOrder = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListContexts",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_contexts_input(SourceUri = SourceUri, ContextType = ContextType, CreatedAfter = CreatedAfter, CreatedBefore = CreatedBefore, SortBy = SortBy, SortOrder = SortOrder, NextToken = NextToken, MaxResults = MaxResults)
  output <- .sagemaker$list_contexts_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_contexts <- sagemaker_list_contexts

#' Lists the data quality job definitions in your account
#'
#' @description
#' Lists the data quality job definitions in your account.
#'
#' See [https://paws-r.github.io/docs/sagemaker/list_data_quality_job_definitions.html](https://paws-r.github.io/docs/sagemaker/list_data_quality_job_definitions.html) for full documentation.
#'
#' @param EndpointName A filter that lists the data quality job definitions associated with the
#' specified endpoint.
#' @param SortBy The field to sort results by. The default is `CreationTime`.
#' @param SortOrder The sort order for results. The default is `Descending`.
#' @param NextToken If the result of the previous
#' [`list_data_quality_job_definitions`][sagemaker_list_data_quality_job_definitions]
#' request was truncated, the response includes a `NextToken`. To retrieve
#' the next set of transform jobs, use the token in the next request.\>
#' @param MaxResults The maximum number of data quality monitoring job definitions to return
#' in the response.
#' @param NameContains A string in the data quality monitoring job definition name. This filter
#' returns only data quality monitoring job definitions whose name contains
#' the specified string.
#' @param CreationTimeBefore A filter that returns only data quality monitoring job definitions
#' created before the specified time.
#' @param CreationTimeAfter A filter that returns only data quality monitoring job definitions
#' created after the specified time.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_data_quality_job_definitions
sagemaker_list_data_quality_job_definitions <- function(EndpointName = NULL, SortBy = NULL, SortOrder = NULL, NextToken = NULL, MaxResults = NULL, NameContains = NULL, CreationTimeBefore = NULL, CreationTimeAfter = NULL) {
  op <- new_operation(
    name = "ListDataQualityJobDefinitions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_data_quality_job_definitions_input(EndpointName = EndpointName, SortBy = SortBy, SortOrder = SortOrder, NextToken = NextToken, MaxResults = MaxResults, NameContains = NameContains, CreationTimeBefore = CreationTimeBefore, CreationTimeAfter = CreationTimeAfter)
  output <- .sagemaker$list_data_quality_job_definitions_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_data_quality_job_definitions <- sagemaker_list_data_quality_job_definitions

#' Returns a list of devices in the fleet
#'
#' @description
#' Returns a list of devices in the fleet.
#'
#' See [https://paws-r.github.io/docs/sagemaker/list_device_fleets.html](https://paws-r.github.io/docs/sagemaker/list_device_fleets.html) for full documentation.
#'
#' @param NextToken The response from the last list when returning a list large enough to
#' need tokening.
#' @param MaxResults The maximum number of results to select.
#' @param CreationTimeAfter Filter fleets where packaging job was created after specified time.
#' @param CreationTimeBefore Filter fleets where the edge packaging job was created before specified
#' time.
#' @param LastModifiedTimeAfter Select fleets where the job was updated after X
#' @param LastModifiedTimeBefore Select fleets where the job was updated before X
#' @param NameContains Filter for fleets containing this name in their fleet device name.
#' @param SortBy The column to sort by.
#' @param SortOrder What direction to sort in.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_device_fleets
sagemaker_list_device_fleets <- function(NextToken = NULL, MaxResults = NULL, CreationTimeAfter = NULL, CreationTimeBefore = NULL, LastModifiedTimeAfter = NULL, LastModifiedTimeBefore = NULL, NameContains = NULL, SortBy = NULL, SortOrder = NULL) {
  op <- new_operation(
    name = "ListDeviceFleets",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_device_fleets_input(NextToken = NextToken, MaxResults = MaxResults, CreationTimeAfter = CreationTimeAfter, CreationTimeBefore = CreationTimeBefore, LastModifiedTimeAfter = LastModifiedTimeAfter, LastModifiedTimeBefore = LastModifiedTimeBefore, NameContains = NameContains, SortBy = SortBy, SortOrder = SortOrder)
  output <- .sagemaker$list_device_fleets_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_device_fleets <- sagemaker_list_device_fleets

#' A list of devices
#'
#' @description
#' A list of devices.
#'
#' See [https://paws-r.github.io/docs/sagemaker/list_devices.html](https://paws-r.github.io/docs/sagemaker/list_devices.html) for full documentation.
#'
#' @param NextToken The response from the last list when returning a list large enough to
#' need tokening.
#' @param MaxResults Maximum number of results to select.
#' @param LatestHeartbeatAfter Select fleets where the job was updated after X
#' @param ModelName A filter that searches devices that contains this name in any of their
#' models.
#' @param DeviceFleetName Filter for fleets containing this name in their device fleet name.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_devices
sagemaker_list_devices <- function(NextToken = NULL, MaxResults = NULL, LatestHeartbeatAfter = NULL, ModelName = NULL, DeviceFleetName = NULL) {
  op <- new_operation(
    name = "ListDevices",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_devices_input(NextToken = NextToken, MaxResults = MaxResults, LatestHeartbeatAfter = LatestHeartbeatAfter, ModelName = ModelName, DeviceFleetName = DeviceFleetName)
  output <- .sagemaker$list_devices_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_devices <- sagemaker_list_devices

#' Lists the domains
#'
#' @description
#' Lists the domains.
#'
#' See [https://paws-r.github.io/docs/sagemaker/list_domains.html](https://paws-r.github.io/docs/sagemaker/list_domains.html) for full documentation.
#'
#' @param NextToken If the previous response was truncated, you will receive this token. Use
#' it in your next request to receive the next set of results.
#' @param MaxResults Returns a list up to a specified limit.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_domains
sagemaker_list_domains <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListDomains",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_domains_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .sagemaker$list_domains_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_domains <- sagemaker_list_domains

#' Lists all edge deployment plans
#'
#' @description
#' Lists all edge deployment plans.
#'
#' See [https://paws-r.github.io/docs/sagemaker/list_edge_deployment_plans.html](https://paws-r.github.io/docs/sagemaker/list_edge_deployment_plans.html) for full documentation.
#'
#' @param NextToken The response from the last list when returning a list large enough to
#' need tokening.
#' @param MaxResults The maximum number of results to select (50 by default).
#' @param CreationTimeAfter Selects edge deployment plans created after this time.
#' @param CreationTimeBefore Selects edge deployment plans created before this time.
#' @param LastModifiedTimeAfter Selects edge deployment plans that were last updated after this time.
#' @param LastModifiedTimeBefore Selects edge deployment plans that were last updated before this time.
#' @param NameContains Selects edge deployment plans with names containing this name.
#' @param DeviceFleetNameContains Selects edge deployment plans with a device fleet name containing this
#' name.
#' @param SortBy The column by which to sort the edge deployment plans. Can be one of
#' `NAME`, `DEVICEFLEETNAME`, `CREATIONTIME`, `LASTMODIFIEDTIME`.
#' @param SortOrder The direction of the sorting (ascending or descending).
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_edge_deployment_plans
sagemaker_list_edge_deployment_plans <- function(NextToken = NULL, MaxResults = NULL, CreationTimeAfter = NULL, CreationTimeBefore = NULL, LastModifiedTimeAfter = NULL, LastModifiedTimeBefore = NULL, NameContains = NULL, DeviceFleetNameContains = NULL, SortBy = NULL, SortOrder = NULL) {
  op <- new_operation(
    name = "ListEdgeDeploymentPlans",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_edge_deployment_plans_input(NextToken = NextToken, MaxResults = MaxResults, CreationTimeAfter = CreationTimeAfter, CreationTimeBefore = CreationTimeBefore, LastModifiedTimeAfter = LastModifiedTimeAfter, LastModifiedTimeBefore = LastModifiedTimeBefore, NameContains = NameContains, DeviceFleetNameContains = DeviceFleetNameContains, SortBy = SortBy, SortOrder = SortOrder)
  output <- .sagemaker$list_edge_deployment_plans_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_edge_deployment_plans <- sagemaker_list_edge_deployment_plans

#' Returns a list of edge packaging jobs
#'
#' @description
#' Returns a list of edge packaging jobs.
#'
#' See [https://paws-r.github.io/docs/sagemaker/list_edge_packaging_jobs.html](https://paws-r.github.io/docs/sagemaker/list_edge_packaging_jobs.html) for full documentation.
#'
#' @param NextToken The response from the last list when returning a list large enough to
#' need tokening.
#' @param MaxResults Maximum number of results to select.
#' @param CreationTimeAfter Select jobs where the job was created after specified time.
#' @param CreationTimeBefore Select jobs where the job was created before specified time.
#' @param LastModifiedTimeAfter Select jobs where the job was updated after specified time.
#' @param LastModifiedTimeBefore Select jobs where the job was updated before specified time.
#' @param NameContains Filter for jobs containing this name in their packaging job name.
#' @param ModelNameContains Filter for jobs where the model name contains this string.
#' @param StatusEquals The job status to filter for.
#' @param SortBy Use to specify what column to sort by.
#' @param SortOrder What direction to sort by.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_edge_packaging_jobs
sagemaker_list_edge_packaging_jobs <- function(NextToken = NULL, MaxResults = NULL, CreationTimeAfter = NULL, CreationTimeBefore = NULL, LastModifiedTimeAfter = NULL, LastModifiedTimeBefore = NULL, NameContains = NULL, ModelNameContains = NULL, StatusEquals = NULL, SortBy = NULL, SortOrder = NULL) {
  op <- new_operation(
    name = "ListEdgePackagingJobs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_edge_packaging_jobs_input(NextToken = NextToken, MaxResults = MaxResults, CreationTimeAfter = CreationTimeAfter, CreationTimeBefore = CreationTimeBefore, LastModifiedTimeAfter = LastModifiedTimeAfter, LastModifiedTimeBefore = LastModifiedTimeBefore, NameContains = NameContains, ModelNameContains = ModelNameContains, StatusEquals = StatusEquals, SortBy = SortBy, SortOrder = SortOrder)
  output <- .sagemaker$list_edge_packaging_jobs_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_edge_packaging_jobs <- sagemaker_list_edge_packaging_jobs

#' Lists endpoint configurations
#'
#' @description
#' Lists endpoint configurations.
#'
#' See [https://paws-r.github.io/docs/sagemaker/list_endpoint_configs.html](https://paws-r.github.io/docs/sagemaker/list_endpoint_configs.html) for full documentation.
#'
#' @param SortBy The field to sort results by. The default is `CreationTime`.
#' @param SortOrder The sort order for results. The default is `Descending`.
#' @param NextToken If the result of the previous `ListEndpointConfig` request was
#' truncated, the response includes a `NextToken`. To retrieve the next set
#' of endpoint configurations, use the token in the next request.
#' @param MaxResults The maximum number of training jobs to return in the response.
#' @param NameContains A string in the endpoint configuration name. This filter returns only
#' endpoint configurations whose name contains the specified string.
#' @param CreationTimeBefore A filter that returns only endpoint configurations created before the
#' specified time (timestamp).
#' @param CreationTimeAfter A filter that returns only endpoint configurations with a creation time
#' greater than or equal to the specified time (timestamp).
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_endpoint_configs
sagemaker_list_endpoint_configs <- function(SortBy = NULL, SortOrder = NULL, NextToken = NULL, MaxResults = NULL, NameContains = NULL, CreationTimeBefore = NULL, CreationTimeAfter = NULL) {
  op <- new_operation(
    name = "ListEndpointConfigs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_endpoint_configs_input(SortBy = SortBy, SortOrder = SortOrder, NextToken = NextToken, MaxResults = MaxResults, NameContains = NameContains, CreationTimeBefore = CreationTimeBefore, CreationTimeAfter = CreationTimeAfter)
  output <- .sagemaker$list_endpoint_configs_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_endpoint_configs <- sagemaker_list_endpoint_configs

#' Lists endpoints
#'
#' @description
#' Lists endpoints.
#'
#' See [https://paws-r.github.io/docs/sagemaker/list_endpoints.html](https://paws-r.github.io/docs/sagemaker/list_endpoints.html) for full documentation.
#'
#' @param SortBy Sorts the list of results. The default is `CreationTime`.
#' @param SortOrder The sort order for results. The default is `Descending`.
#' @param NextToken If the result of a [`list_endpoints`][sagemaker_list_endpoints] request
#' was truncated, the response includes a `NextToken`. To retrieve the next
#' set of endpoints, use the token in the next request.
#' @param MaxResults The maximum number of endpoints to return in the response. This value
#' defaults to 10.
#' @param NameContains A string in endpoint names. This filter returns only endpoints whose
#' name contains the specified string.
#' @param CreationTimeBefore A filter that returns only endpoints that were created before the
#' specified time (timestamp).
#' @param CreationTimeAfter A filter that returns only endpoints with a creation time greater than
#' or equal to the specified time (timestamp).
#' @param LastModifiedTimeBefore A filter that returns only endpoints that were modified before the
#' specified timestamp.
#' @param LastModifiedTimeAfter A filter that returns only endpoints that were modified after the
#' specified timestamp.
#' @param StatusEquals A filter that returns only endpoints with the specified status.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_endpoints
sagemaker_list_endpoints <- function(SortBy = NULL, SortOrder = NULL, NextToken = NULL, MaxResults = NULL, NameContains = NULL, CreationTimeBefore = NULL, CreationTimeAfter = NULL, LastModifiedTimeBefore = NULL, LastModifiedTimeAfter = NULL, StatusEquals = NULL) {
  op <- new_operation(
    name = "ListEndpoints",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_endpoints_input(SortBy = SortBy, SortOrder = SortOrder, NextToken = NextToken, MaxResults = MaxResults, NameContains = NameContains, CreationTimeBefore = CreationTimeBefore, CreationTimeAfter = CreationTimeAfter, LastModifiedTimeBefore = LastModifiedTimeBefore, LastModifiedTimeAfter = LastModifiedTimeAfter, StatusEquals = StatusEquals)
  output <- .sagemaker$list_endpoints_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_endpoints <- sagemaker_list_endpoints

#' Lists all the experiments in your account
#'
#' @description
#' Lists all the experiments in your account. The list can be filtered to show only experiments that were created in a specific time range. The list can be sorted by experiment name or creation time.
#'
#' See [https://paws-r.github.io/docs/sagemaker/list_experiments.html](https://paws-r.github.io/docs/sagemaker/list_experiments.html) for full documentation.
#'
#' @param CreatedAfter A filter that returns only experiments created after the specified time.
#' @param CreatedBefore A filter that returns only experiments created before the specified
#' time.
#' @param SortBy The property used to sort results. The default value is `CreationTime`.
#' @param SortOrder The sort order. The default value is `Descending`.
#' @param NextToken If the previous call to [`list_experiments`][sagemaker_list_experiments]
#' didn't return the full set of experiments, the call returns a token for
#' getting the next set of experiments.
#' @param MaxResults The maximum number of experiments to return in the response. The default
#' value is 10.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_experiments
sagemaker_list_experiments <- function(CreatedAfter = NULL, CreatedBefore = NULL, SortBy = NULL, SortOrder = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListExperiments",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_experiments_input(CreatedAfter = CreatedAfter, CreatedBefore = CreatedBefore, SortBy = SortBy, SortOrder = SortOrder, NextToken = NextToken, MaxResults = MaxResults)
  output <- .sagemaker$list_experiments_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_experiments <- sagemaker_list_experiments

#' List FeatureGroups based on given filter and order
#'
#' @description
#' List `FeatureGroup`s based on given filter and order.
#'
#' See [https://paws-r.github.io/docs/sagemaker/list_feature_groups.html](https://paws-r.github.io/docs/sagemaker/list_feature_groups.html) for full documentation.
#'
#' @param NameContains A string that partially matches one or more `FeatureGroup`s names.
#' Filters `FeatureGroup`s by name.
#' @param FeatureGroupStatusEquals A `FeatureGroup` status. Filters by `FeatureGroup` status.
#' @param OfflineStoreStatusEquals An `OfflineStore` status. Filters by `OfflineStore` status.
#' @param CreationTimeAfter Use this parameter to search for `FeatureGroups`s created after a
#' specific date and time.
#' @param CreationTimeBefore Use this parameter to search for `FeatureGroups`s created before a
#' specific date and time.
#' @param SortOrder The order in which feature groups are listed.
#' @param SortBy The value on which the feature group list is sorted.
#' @param MaxResults The maximum number of results returned by
#' [`list_feature_groups`][sagemaker_list_feature_groups].
#' @param NextToken A token to resume pagination of
#' [`list_feature_groups`][sagemaker_list_feature_groups] results.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_feature_groups
sagemaker_list_feature_groups <- function(NameContains = NULL, FeatureGroupStatusEquals = NULL, OfflineStoreStatusEquals = NULL, CreationTimeAfter = NULL, CreationTimeBefore = NULL, SortOrder = NULL, SortBy = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListFeatureGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_feature_groups_input(NameContains = NameContains, FeatureGroupStatusEquals = FeatureGroupStatusEquals, OfflineStoreStatusEquals = OfflineStoreStatusEquals, CreationTimeAfter = CreationTimeAfter, CreationTimeBefore = CreationTimeBefore, SortOrder = SortOrder, SortBy = SortBy, MaxResults = MaxResults, NextToken = NextToken)
  output <- .sagemaker$list_feature_groups_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_feature_groups <- sagemaker_list_feature_groups

#' Returns information about the flow definitions in your account
#'
#' @description
#' Returns information about the flow definitions in your account.
#'
#' See [https://paws-r.github.io/docs/sagemaker/list_flow_definitions.html](https://paws-r.github.io/docs/sagemaker/list_flow_definitions.html) for full documentation.
#'
#' @param CreationTimeAfter A filter that returns only flow definitions with a creation time greater
#' than or equal to the specified timestamp.
#' @param CreationTimeBefore A filter that returns only flow definitions that were created before the
#' specified timestamp.
#' @param SortOrder An optional value that specifies whether you want the results sorted in
#' `Ascending` or `Descending` order.
#' @param NextToken A token to resume pagination.
#' @param MaxResults The total number of items to return. If the total number of available
#' items is more than the value specified in `MaxResults`, then a
#' `NextToken` will be provided in the output that you can use to resume
#' pagination.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_flow_definitions
sagemaker_list_flow_definitions <- function(CreationTimeAfter = NULL, CreationTimeBefore = NULL, SortOrder = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListFlowDefinitions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_flow_definitions_input(CreationTimeAfter = CreationTimeAfter, CreationTimeBefore = CreationTimeBefore, SortOrder = SortOrder, NextToken = NextToken, MaxResults = MaxResults)
  output <- .sagemaker$list_flow_definitions_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_flow_definitions <- sagemaker_list_flow_definitions

#' Returns information about the human task user interfaces in your account
#'
#' @description
#' Returns information about the human task user interfaces in your account.
#'
#' See [https://paws-r.github.io/docs/sagemaker/list_human_task_uis.html](https://paws-r.github.io/docs/sagemaker/list_human_task_uis.html) for full documentation.
#'
#' @param CreationTimeAfter A filter that returns only human task user interfaces with a creation
#' time greater than or equal to the specified timestamp.
#' @param CreationTimeBefore A filter that returns only human task user interfaces that were created
#' before the specified timestamp.
#' @param SortOrder An optional value that specifies whether you want the results sorted in
#' `Ascending` or `Descending` order.
#' @param NextToken A token to resume pagination.
#' @param MaxResults The total number of items to return. If the total number of available
#' items is more than the value specified in `MaxResults`, then a
#' `NextToken` will be provided in the output that you can use to resume
#' pagination.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_human_task_uis
sagemaker_list_human_task_uis <- function(CreationTimeAfter = NULL, CreationTimeBefore = NULL, SortOrder = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListHumanTaskUis",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_human_task_uis_input(CreationTimeAfter = CreationTimeAfter, CreationTimeBefore = CreationTimeBefore, SortOrder = SortOrder, NextToken = NextToken, MaxResults = MaxResults)
  output <- .sagemaker$list_human_task_uis_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_human_task_uis <- sagemaker_list_human_task_uis

#' Gets a list of HyperParameterTuningJobSummary objects that describe the
#' hyperparameter tuning jobs launched in your account
#'
#' @description
#' Gets a list of HyperParameterTuningJobSummary objects that describe the hyperparameter tuning jobs launched in your account.
#'
#' See [https://paws-r.github.io/docs/sagemaker/list_hyper_parameter_tuning_jobs.html](https://paws-r.github.io/docs/sagemaker/list_hyper_parameter_tuning_jobs.html) for full documentation.
#'
#' @param NextToken If the result of the previous
#' [`list_hyper_parameter_tuning_jobs`][sagemaker_list_hyper_parameter_tuning_jobs]
#' request was truncated, the response includes a `NextToken`. To retrieve
#' the next set of tuning jobs, use the token in the next request.
#' @param MaxResults The maximum number of tuning jobs to return. The default value is 10.
#' @param SortBy The field to sort results by. The default is `Name`.
#' @param SortOrder The sort order for results. The default is `Ascending`.
#' @param NameContains A string in the tuning job name. This filter returns only tuning jobs
#' whose name contains the specified string.
#' @param CreationTimeAfter A filter that returns only tuning jobs that were created after the
#' specified time.
#' @param CreationTimeBefore A filter that returns only tuning jobs that were created before the
#' specified time.
#' @param LastModifiedTimeAfter A filter that returns only tuning jobs that were modified after the
#' specified time.
#' @param LastModifiedTimeBefore A filter that returns only tuning jobs that were modified before the
#' specified time.
#' @param StatusEquals A filter that returns only tuning jobs with the specified status.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_hyper_parameter_tuning_jobs
sagemaker_list_hyper_parameter_tuning_jobs <- function(NextToken = NULL, MaxResults = NULL, SortBy = NULL, SortOrder = NULL, NameContains = NULL, CreationTimeAfter = NULL, CreationTimeBefore = NULL, LastModifiedTimeAfter = NULL, LastModifiedTimeBefore = NULL, StatusEquals = NULL) {
  op <- new_operation(
    name = "ListHyperParameterTuningJobs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_hyper_parameter_tuning_jobs_input(NextToken = NextToken, MaxResults = MaxResults, SortBy = SortBy, SortOrder = SortOrder, NameContains = NameContains, CreationTimeAfter = CreationTimeAfter, CreationTimeBefore = CreationTimeBefore, LastModifiedTimeAfter = LastModifiedTimeAfter, LastModifiedTimeBefore = LastModifiedTimeBefore, StatusEquals = StatusEquals)
  output <- .sagemaker$list_hyper_parameter_tuning_jobs_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_hyper_parameter_tuning_jobs <- sagemaker_list_hyper_parameter_tuning_jobs

#' Lists the versions of a specified image and their properties
#'
#' @description
#' Lists the versions of a specified image and their properties. The list can be filtered by creation time or modified time.
#'
#' See [https://paws-r.github.io/docs/sagemaker/list_image_versions.html](https://paws-r.github.io/docs/sagemaker/list_image_versions.html) for full documentation.
#'
#' @param CreationTimeAfter A filter that returns only versions created on or after the specified
#' time.
#' @param CreationTimeBefore A filter that returns only versions created on or before the specified
#' time.
#' @param ImageName &#91;required&#93; The name of the image to list the versions of.
#' @param LastModifiedTimeAfter A filter that returns only versions modified on or after the specified
#' time.
#' @param LastModifiedTimeBefore A filter that returns only versions modified on or before the specified
#' time.
#' @param MaxResults The maximum number of versions to return in the response. The default
#' value is 10.
#' @param NextToken If the previous call to
#' [`list_image_versions`][sagemaker_list_image_versions] didn't return the
#' full set of versions, the call returns a token for getting the next set
#' of versions.
#' @param SortBy The property used to sort results. The default value is `CREATION_TIME`.
#' @param SortOrder The sort order. The default value is `DESCENDING`.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_image_versions
sagemaker_list_image_versions <- function(CreationTimeAfter = NULL, CreationTimeBefore = NULL, ImageName, LastModifiedTimeAfter = NULL, LastModifiedTimeBefore = NULL, MaxResults = NULL, NextToken = NULL, SortBy = NULL, SortOrder = NULL) {
  op <- new_operation(
    name = "ListImageVersions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_image_versions_input(CreationTimeAfter = CreationTimeAfter, CreationTimeBefore = CreationTimeBefore, ImageName = ImageName, LastModifiedTimeAfter = LastModifiedTimeAfter, LastModifiedTimeBefore = LastModifiedTimeBefore, MaxResults = MaxResults, NextToken = NextToken, SortBy = SortBy, SortOrder = SortOrder)
  output <- .sagemaker$list_image_versions_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_image_versions <- sagemaker_list_image_versions

#' Lists the images in your account and their properties
#'
#' @description
#' Lists the images in your account and their properties. The list can be filtered by creation time or modified time, and whether the image name contains a specified string.
#'
#' See [https://paws-r.github.io/docs/sagemaker/list_images.html](https://paws-r.github.io/docs/sagemaker/list_images.html) for full documentation.
#'
#' @param CreationTimeAfter A filter that returns only images created on or after the specified
#' time.
#' @param CreationTimeBefore A filter that returns only images created on or before the specified
#' time.
#' @param LastModifiedTimeAfter A filter that returns only images modified on or after the specified
#' time.
#' @param LastModifiedTimeBefore A filter that returns only images modified on or before the specified
#' time.
#' @param MaxResults The maximum number of images to return in the response. The default
#' value is 10.
#' @param NameContains A filter that returns only images whose name contains the specified
#' string.
#' @param NextToken If the previous call to [`list_images`][sagemaker_list_images] didn't
#' return the full set of images, the call returns a token for getting the
#' next set of images.
#' @param SortBy The property used to sort results. The default value is `CREATION_TIME`.
#' @param SortOrder The sort order. The default value is `DESCENDING`.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_images
sagemaker_list_images <- function(CreationTimeAfter = NULL, CreationTimeBefore = NULL, LastModifiedTimeAfter = NULL, LastModifiedTimeBefore = NULL, MaxResults = NULL, NameContains = NULL, NextToken = NULL, SortBy = NULL, SortOrder = NULL) {
  op <- new_operation(
    name = "ListImages",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_images_input(CreationTimeAfter = CreationTimeAfter, CreationTimeBefore = CreationTimeBefore, LastModifiedTimeAfter = LastModifiedTimeAfter, LastModifiedTimeBefore = LastModifiedTimeBefore, MaxResults = MaxResults, NameContains = NameContains, NextToken = NextToken, SortBy = SortBy, SortOrder = SortOrder)
  output <- .sagemaker$list_images_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_images <- sagemaker_list_images

#' Lists recommendation jobs that satisfy various filters
#'
#' @description
#' Lists recommendation jobs that satisfy various filters.
#'
#' See [https://paws-r.github.io/docs/sagemaker/list_inference_recommendations_jobs.html](https://paws-r.github.io/docs/sagemaker/list_inference_recommendations_jobs.html) for full documentation.
#'
#' @param CreationTimeAfter A filter that returns only jobs created after the specified time
#' (timestamp).
#' @param CreationTimeBefore A filter that returns only jobs created before the specified time
#' (timestamp).
#' @param LastModifiedTimeAfter A filter that returns only jobs that were last modified after the
#' specified time (timestamp).
#' @param LastModifiedTimeBefore A filter that returns only jobs that were last modified before the
#' specified time (timestamp).
#' @param NameContains A string in the job name. This filter returns only recommendations whose
#' name contains the specified string.
#' @param StatusEquals A filter that retrieves only inference recommendations jobs with a
#' specific status.
#' @param SortBy The parameter by which to sort the results.
#' @param SortOrder The sort order for the results.
#' @param NextToken If the response to a previous `ListInferenceRecommendationsJobsRequest`
#' request was truncated, the response includes a `NextToken`. To retrieve
#' the next set of recommendations, use the token in the next request.
#' @param MaxResults The maximum number of recommendations to return in the response.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_inference_recommendations_jobs
sagemaker_list_inference_recommendations_jobs <- function(CreationTimeAfter = NULL, CreationTimeBefore = NULL, LastModifiedTimeAfter = NULL, LastModifiedTimeBefore = NULL, NameContains = NULL, StatusEquals = NULL, SortBy = NULL, SortOrder = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListInferenceRecommendationsJobs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_inference_recommendations_jobs_input(CreationTimeAfter = CreationTimeAfter, CreationTimeBefore = CreationTimeBefore, LastModifiedTimeAfter = LastModifiedTimeAfter, LastModifiedTimeBefore = LastModifiedTimeBefore, NameContains = NameContains, StatusEquals = StatusEquals, SortBy = SortBy, SortOrder = SortOrder, NextToken = NextToken, MaxResults = MaxResults)
  output <- .sagemaker$list_inference_recommendations_jobs_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_inference_recommendations_jobs <- sagemaker_list_inference_recommendations_jobs

#' Gets a list of labeling jobs
#'
#' @description
#' Gets a list of labeling jobs.
#'
#' See [https://paws-r.github.io/docs/sagemaker/list_labeling_jobs.html](https://paws-r.github.io/docs/sagemaker/list_labeling_jobs.html) for full documentation.
#'
#' @param CreationTimeAfter A filter that returns only labeling jobs created after the specified
#' time (timestamp).
#' @param CreationTimeBefore A filter that returns only labeling jobs created before the specified
#' time (timestamp).
#' @param LastModifiedTimeAfter A filter that returns only labeling jobs modified after the specified
#' time (timestamp).
#' @param LastModifiedTimeBefore A filter that returns only labeling jobs modified before the specified
#' time (timestamp).
#' @param MaxResults The maximum number of labeling jobs to return in each page of the
#' response.
#' @param NextToken If the result of the previous
#' [`list_labeling_jobs`][sagemaker_list_labeling_jobs] request was
#' truncated, the response includes a `NextToken`. To retrieve the next set
#' of labeling jobs, use the token in the next request.
#' @param NameContains A string in the labeling job name. This filter returns only labeling
#' jobs whose name contains the specified string.
#' @param SortBy The field to sort results by. The default is `CreationTime`.
#' @param SortOrder The sort order for results. The default is `Ascending`.
#' @param StatusEquals A filter that retrieves only labeling jobs with a specific status.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_labeling_jobs
sagemaker_list_labeling_jobs <- function(CreationTimeAfter = NULL, CreationTimeBefore = NULL, LastModifiedTimeAfter = NULL, LastModifiedTimeBefore = NULL, MaxResults = NULL, NextToken = NULL, NameContains = NULL, SortBy = NULL, SortOrder = NULL, StatusEquals = NULL) {
  op <- new_operation(
    name = "ListLabelingJobs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_labeling_jobs_input(CreationTimeAfter = CreationTimeAfter, CreationTimeBefore = CreationTimeBefore, LastModifiedTimeAfter = LastModifiedTimeAfter, LastModifiedTimeBefore = LastModifiedTimeBefore, MaxResults = MaxResults, NextToken = NextToken, NameContains = NameContains, SortBy = SortBy, SortOrder = SortOrder, StatusEquals = StatusEquals)
  output <- .sagemaker$list_labeling_jobs_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_labeling_jobs <- sagemaker_list_labeling_jobs

#' Gets a list of labeling jobs assigned to a specified work team
#'
#' @description
#' Gets a list of labeling jobs assigned to a specified work team.
#'
#' See [https://paws-r.github.io/docs/sagemaker/list_labeling_jobs_for_workteam.html](https://paws-r.github.io/docs/sagemaker/list_labeling_jobs_for_workteam.html) for full documentation.
#'
#' @param WorkteamArn &#91;required&#93; The Amazon Resource Name (ARN) of the work team for which you want to
#' see labeling jobs for.
#' @param MaxResults The maximum number of labeling jobs to return in each page of the
#' response.
#' @param NextToken If the result of the previous
#' [`list_labeling_jobs_for_workteam`][sagemaker_list_labeling_jobs_for_workteam]
#' request was truncated, the response includes a `NextToken`. To retrieve
#' the next set of labeling jobs, use the token in the next request.
#' @param CreationTimeAfter A filter that returns only labeling jobs created after the specified
#' time (timestamp).
#' @param CreationTimeBefore A filter that returns only labeling jobs created before the specified
#' time (timestamp).
#' @param JobReferenceCodeContains A filter the limits jobs to only the ones whose job reference code
#' contains the specified string.
#' @param SortBy The field to sort results by. The default is `CreationTime`.
#' @param SortOrder The sort order for results. The default is `Ascending`.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_labeling_jobs_for_workteam
sagemaker_list_labeling_jobs_for_workteam <- function(WorkteamArn, MaxResults = NULL, NextToken = NULL, CreationTimeAfter = NULL, CreationTimeBefore = NULL, JobReferenceCodeContains = NULL, SortBy = NULL, SortOrder = NULL) {
  op <- new_operation(
    name = "ListLabelingJobsForWorkteam",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_labeling_jobs_for_workteam_input(WorkteamArn = WorkteamArn, MaxResults = MaxResults, NextToken = NextToken, CreationTimeAfter = CreationTimeAfter, CreationTimeBefore = CreationTimeBefore, JobReferenceCodeContains = JobReferenceCodeContains, SortBy = SortBy, SortOrder = SortOrder)
  output <- .sagemaker$list_labeling_jobs_for_workteam_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_labeling_jobs_for_workteam <- sagemaker_list_labeling_jobs_for_workteam

#' A list of lineage groups shared with your Amazon Web Services account
#'
#' @description
#' A list of lineage groups shared with your Amazon Web Services account. For more information, see [Cross-Account Lineage Tracking](https://docs.aws.amazon.com/sagemaker/latest/dg/xaccount-lineage-tracking.html) in the *Amazon SageMaker Developer Guide*.
#'
#' See [https://paws-r.github.io/docs/sagemaker/list_lineage_groups.html](https://paws-r.github.io/docs/sagemaker/list_lineage_groups.html) for full documentation.
#'
#' @param CreatedAfter A timestamp to filter against lineage groups created after a certain
#' point in time.
#' @param CreatedBefore A timestamp to filter against lineage groups created before a certain
#' point in time.
#' @param SortBy The parameter by which to sort the results. The default is
#' `CreationTime`.
#' @param SortOrder The sort order for the results. The default is `Ascending`.
#' @param NextToken If the response is truncated, SageMaker returns this token. To retrieve
#' the next set of algorithms, use it in the subsequent request.
#' @param MaxResults The maximum number of endpoints to return in the response. This value
#' defaults to 10.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_lineage_groups
sagemaker_list_lineage_groups <- function(CreatedAfter = NULL, CreatedBefore = NULL, SortBy = NULL, SortOrder = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListLineageGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_lineage_groups_input(CreatedAfter = CreatedAfter, CreatedBefore = CreatedBefore, SortBy = SortBy, SortOrder = SortOrder, NextToken = NextToken, MaxResults = MaxResults)
  output <- .sagemaker$list_lineage_groups_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_lineage_groups <- sagemaker_list_lineage_groups

#' Lists model bias jobs definitions that satisfy various filters
#'
#' @description
#' Lists model bias jobs definitions that satisfy various filters.
#'
#' See [https://paws-r.github.io/docs/sagemaker/list_model_bias_job_definitions.html](https://paws-r.github.io/docs/sagemaker/list_model_bias_job_definitions.html) for full documentation.
#'
#' @param EndpointName Name of the endpoint to monitor for model bias.
#' @param SortBy Whether to sort results by the `Name` or `CreationTime` field. The
#' default is `CreationTime`.
#' @param SortOrder Whether to sort the results in `Ascending` or `Descending` order. The
#' default is `Descending`.
#' @param NextToken The token returned if the response is truncated. To retrieve the next
#' set of job executions, use it in the next request.
#' @param MaxResults The maximum number of model bias jobs to return in the response. The
#' default value is 10.
#' @param NameContains Filter for model bias jobs whose name contains a specified string.
#' @param CreationTimeBefore A filter that returns only model bias jobs created before a specified
#' time.
#' @param CreationTimeAfter A filter that returns only model bias jobs created after a specified
#' time.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_model_bias_job_definitions
sagemaker_list_model_bias_job_definitions <- function(EndpointName = NULL, SortBy = NULL, SortOrder = NULL, NextToken = NULL, MaxResults = NULL, NameContains = NULL, CreationTimeBefore = NULL, CreationTimeAfter = NULL) {
  op <- new_operation(
    name = "ListModelBiasJobDefinitions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_model_bias_job_definitions_input(EndpointName = EndpointName, SortBy = SortBy, SortOrder = SortOrder, NextToken = NextToken, MaxResults = MaxResults, NameContains = NameContains, CreationTimeBefore = CreationTimeBefore, CreationTimeAfter = CreationTimeAfter)
  output <- .sagemaker$list_model_bias_job_definitions_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_model_bias_job_definitions <- sagemaker_list_model_bias_job_definitions

#' Lists model explainability job definitions that satisfy various filters
#'
#' @description
#' Lists model explainability job definitions that satisfy various filters.
#'
#' See [https://paws-r.github.io/docs/sagemaker/list_model_explainability_job_definitions.html](https://paws-r.github.io/docs/sagemaker/list_model_explainability_job_definitions.html) for full documentation.
#'
#' @param EndpointName Name of the endpoint to monitor for model explainability.
#' @param SortBy Whether to sort results by the `Name` or `CreationTime` field. The
#' default is `CreationTime`.
#' @param SortOrder Whether to sort the results in `Ascending` or `Descending` order. The
#' default is `Descending`.
#' @param NextToken The token returned if the response is truncated. To retrieve the next
#' set of job executions, use it in the next request.
#' @param MaxResults The maximum number of jobs to return in the response. The default value
#' is 10.
#' @param NameContains Filter for model explainability jobs whose name contains a specified
#' string.
#' @param CreationTimeBefore A filter that returns only model explainability jobs created before a
#' specified time.
#' @param CreationTimeAfter A filter that returns only model explainability jobs created after a
#' specified time.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_model_explainability_job_definitions
sagemaker_list_model_explainability_job_definitions <- function(EndpointName = NULL, SortBy = NULL, SortOrder = NULL, NextToken = NULL, MaxResults = NULL, NameContains = NULL, CreationTimeBefore = NULL, CreationTimeAfter = NULL) {
  op <- new_operation(
    name = "ListModelExplainabilityJobDefinitions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_model_explainability_job_definitions_input(EndpointName = EndpointName, SortBy = SortBy, SortOrder = SortOrder, NextToken = NextToken, MaxResults = MaxResults, NameContains = NameContains, CreationTimeBefore = CreationTimeBefore, CreationTimeAfter = CreationTimeAfter)
  output <- .sagemaker$list_model_explainability_job_definitions_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_model_explainability_job_definitions <- sagemaker_list_model_explainability_job_definitions

#' Lists the domain, framework, task, and model name of standard machine
#' learning models found in common model zoos
#'
#' @description
#' Lists the domain, framework, task, and model name of standard machine learning models found in common model zoos.
#'
#' See [https://paws-r.github.io/docs/sagemaker/list_model_metadata.html](https://paws-r.github.io/docs/sagemaker/list_model_metadata.html) for full documentation.
#'
#' @param SearchExpression One or more filters that searches for the specified resource or
#' resources in a search. All resource objects that satisfy the
#' expression's condition are included in the search results. Specify the
#' Framework, FrameworkVersion, Domain or Task to filter supported. Filter
#' names and values are case-sensitive.
#' @param NextToken If the response to a previous `ListModelMetadataResponse` request was
#' truncated, the response includes a NextToken. To retrieve the next set
#' of model metadata, use the token in the next request.
#' @param MaxResults The maximum number of models to return in the response.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_model_metadata
sagemaker_list_model_metadata <- function(SearchExpression = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListModelMetadata",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_model_metadata_input(SearchExpression = SearchExpression, NextToken = NextToken, MaxResults = MaxResults)
  output <- .sagemaker$list_model_metadata_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_model_metadata <- sagemaker_list_model_metadata

#' Gets a list of the model groups in your Amazon Web Services account
#'
#' @description
#' Gets a list of the model groups in your Amazon Web Services account.
#'
#' See [https://paws-r.github.io/docs/sagemaker/list_model_package_groups.html](https://paws-r.github.io/docs/sagemaker/list_model_package_groups.html) for full documentation.
#'
#' @param CreationTimeAfter A filter that returns only model groups created after the specified
#' time.
#' @param CreationTimeBefore A filter that returns only model groups created before the specified
#' time.
#' @param MaxResults The maximum number of results to return in the response.
#' @param NameContains A string in the model group name. This filter returns only model groups
#' whose name contains the specified string.
#' @param NextToken If the result of the previous
#' [`list_model_package_groups`][sagemaker_list_model_package_groups]
#' request was truncated, the response includes a `NextToken`. To retrieve
#' the next set of model groups, use the token in the next request.
#' @param SortBy The field to sort results by. The default is `CreationTime`.
#' @param SortOrder The sort order for results. The default is `Ascending`.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_model_package_groups
sagemaker_list_model_package_groups <- function(CreationTimeAfter = NULL, CreationTimeBefore = NULL, MaxResults = NULL, NameContains = NULL, NextToken = NULL, SortBy = NULL, SortOrder = NULL) {
  op <- new_operation(
    name = "ListModelPackageGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_model_package_groups_input(CreationTimeAfter = CreationTimeAfter, CreationTimeBefore = CreationTimeBefore, MaxResults = MaxResults, NameContains = NameContains, NextToken = NextToken, SortBy = SortBy, SortOrder = SortOrder)
  output <- .sagemaker$list_model_package_groups_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_model_package_groups <- sagemaker_list_model_package_groups

#' Lists the model packages that have been created
#'
#' @description
#' Lists the model packages that have been created.
#'
#' See [https://paws-r.github.io/docs/sagemaker/list_model_packages.html](https://paws-r.github.io/docs/sagemaker/list_model_packages.html) for full documentation.
#'
#' @param CreationTimeAfter A filter that returns only model packages created after the specified
#' time (timestamp).
#' @param CreationTimeBefore A filter that returns only model packages created before the specified
#' time (timestamp).
#' @param MaxResults The maximum number of model packages to return in the response.
#' @param NameContains A string in the model package name. This filter returns only model
#' packages whose name contains the specified string.
#' @param ModelApprovalStatus A filter that returns only the model packages with the specified
#' approval status.
#' @param ModelPackageGroupName A filter that returns only model versions that belong to the specified
#' model group.
#' @param ModelPackageType A filter that returns only the model packages of the specified type.
#' This can be one of the following values.
#' 
#' -   `UNVERSIONED` - List only unversioined models. This is the default
#'     value if no `ModelPackageType` is specified.
#' 
#' -   `VERSIONED` - List only versioned models.
#' 
#' -   `BOTH` - List both versioned and unversioned models.
#' @param NextToken If the response to a previous
#' [`list_model_packages`][sagemaker_list_model_packages] request was
#' truncated, the response includes a `NextToken`. To retrieve the next set
#' of model packages, use the token in the next request.
#' @param SortBy The parameter by which to sort the results. The default is
#' `CreationTime`.
#' @param SortOrder The sort order for the results. The default is `Ascending`.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_model_packages
sagemaker_list_model_packages <- function(CreationTimeAfter = NULL, CreationTimeBefore = NULL, MaxResults = NULL, NameContains = NULL, ModelApprovalStatus = NULL, ModelPackageGroupName = NULL, ModelPackageType = NULL, NextToken = NULL, SortBy = NULL, SortOrder = NULL) {
  op <- new_operation(
    name = "ListModelPackages",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_model_packages_input(CreationTimeAfter = CreationTimeAfter, CreationTimeBefore = CreationTimeBefore, MaxResults = MaxResults, NameContains = NameContains, ModelApprovalStatus = ModelApprovalStatus, ModelPackageGroupName = ModelPackageGroupName, ModelPackageType = ModelPackageType, NextToken = NextToken, SortBy = SortBy, SortOrder = SortOrder)
  output <- .sagemaker$list_model_packages_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_model_packages <- sagemaker_list_model_packages

#' Gets a list of model quality monitoring job definitions in your account
#'
#' @description
#' Gets a list of model quality monitoring job definitions in your account.
#'
#' See [https://paws-r.github.io/docs/sagemaker/list_model_quality_job_definitions.html](https://paws-r.github.io/docs/sagemaker/list_model_quality_job_definitions.html) for full documentation.
#'
#' @param EndpointName A filter that returns only model quality monitoring job definitions that
#' are associated with the specified endpoint.
#' @param SortBy The field to sort results by. The default is `CreationTime`.
#' @param SortOrder The sort order for results. The default is `Descending`.
#' @param NextToken If the result of the previous
#' [`list_model_quality_job_definitions`][sagemaker_list_model_quality_job_definitions]
#' request was truncated, the response includes a `NextToken`. To retrieve
#' the next set of model quality monitoring job definitions, use the token
#' in the next request.
#' @param MaxResults The maximum number of results to return in a call to
#' [`list_model_quality_job_definitions`][sagemaker_list_model_quality_job_definitions].
#' @param NameContains A string in the transform job name. This filter returns only model
#' quality monitoring job definitions whose name contains the specified
#' string.
#' @param CreationTimeBefore A filter that returns only model quality monitoring job definitions
#' created before the specified time.
#' @param CreationTimeAfter A filter that returns only model quality monitoring job definitions
#' created after the specified time.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_model_quality_job_definitions
sagemaker_list_model_quality_job_definitions <- function(EndpointName = NULL, SortBy = NULL, SortOrder = NULL, NextToken = NULL, MaxResults = NULL, NameContains = NULL, CreationTimeBefore = NULL, CreationTimeAfter = NULL) {
  op <- new_operation(
    name = "ListModelQualityJobDefinitions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_model_quality_job_definitions_input(EndpointName = EndpointName, SortBy = SortBy, SortOrder = SortOrder, NextToken = NextToken, MaxResults = MaxResults, NameContains = NameContains, CreationTimeBefore = CreationTimeBefore, CreationTimeAfter = CreationTimeAfter)
  output <- .sagemaker$list_model_quality_job_definitions_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_model_quality_job_definitions <- sagemaker_list_model_quality_job_definitions

#' Lists models created with the CreateModel API
#'
#' @description
#' Lists models created with the [`create_model`][sagemaker_create_model] API.
#'
#' See [https://paws-r.github.io/docs/sagemaker/list_models.html](https://paws-r.github.io/docs/sagemaker/list_models.html) for full documentation.
#'
#' @param SortBy Sorts the list of results. The default is `CreationTime`.
#' @param SortOrder The sort order for results. The default is `Descending`.
#' @param NextToken If the response to a previous [`list_models`][sagemaker_list_models]
#' request was truncated, the response includes a `NextToken`. To retrieve
#' the next set of models, use the token in the next request.
#' @param MaxResults The maximum number of models to return in the response.
#' @param NameContains A string in the model name. This filter returns only models whose name
#' contains the specified string.
#' @param CreationTimeBefore A filter that returns only models created before the specified time
#' (timestamp).
#' @param CreationTimeAfter A filter that returns only models with a creation time greater than or
#' equal to the specified time (timestamp).
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_models
sagemaker_list_models <- function(SortBy = NULL, SortOrder = NULL, NextToken = NULL, MaxResults = NULL, NameContains = NULL, CreationTimeBefore = NULL, CreationTimeAfter = NULL) {
  op <- new_operation(
    name = "ListModels",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_models_input(SortBy = SortBy, SortOrder = SortOrder, NextToken = NextToken, MaxResults = MaxResults, NameContains = NameContains, CreationTimeBefore = CreationTimeBefore, CreationTimeAfter = CreationTimeAfter)
  output <- .sagemaker$list_models_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_models <- sagemaker_list_models

#' Returns list of all monitoring job executions
#'
#' @description
#' Returns list of all monitoring job executions.
#'
#' See [https://paws-r.github.io/docs/sagemaker/list_monitoring_executions.html](https://paws-r.github.io/docs/sagemaker/list_monitoring_executions.html) for full documentation.
#'
#' @param MonitoringScheduleName Name of a specific schedule to fetch jobs for.
#' @param EndpointName Name of a specific endpoint to fetch jobs for.
#' @param SortBy Whether to sort results by `Status`, `CreationTime`, `ScheduledTime`
#' field. The default is `CreationTime`.
#' @param SortOrder Whether to sort the results in `Ascending` or `Descending` order. The
#' default is `Descending`.
#' @param NextToken The token returned if the response is truncated. To retrieve the next
#' set of job executions, use it in the next request.
#' @param MaxResults The maximum number of jobs to return in the response. The default value
#' is 10.
#' @param ScheduledTimeBefore Filter for jobs scheduled before a specified time.
#' @param ScheduledTimeAfter Filter for jobs scheduled after a specified time.
#' @param CreationTimeBefore A filter that returns only jobs created before a specified time.
#' @param CreationTimeAfter A filter that returns only jobs created after a specified time.
#' @param LastModifiedTimeBefore A filter that returns only jobs modified after a specified time.
#' @param LastModifiedTimeAfter A filter that returns only jobs modified before a specified time.
#' @param StatusEquals A filter that retrieves only jobs with a specific status.
#' @param MonitoringJobDefinitionName Gets a list of the monitoring job runs of the specified monitoring job
#' definitions.
#' @param MonitoringTypeEquals A filter that returns only the monitoring job runs of the specified
#' monitoring type.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_monitoring_executions
sagemaker_list_monitoring_executions <- function(MonitoringScheduleName = NULL, EndpointName = NULL, SortBy = NULL, SortOrder = NULL, NextToken = NULL, MaxResults = NULL, ScheduledTimeBefore = NULL, ScheduledTimeAfter = NULL, CreationTimeBefore = NULL, CreationTimeAfter = NULL, LastModifiedTimeBefore = NULL, LastModifiedTimeAfter = NULL, StatusEquals = NULL, MonitoringJobDefinitionName = NULL, MonitoringTypeEquals = NULL) {
  op <- new_operation(
    name = "ListMonitoringExecutions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_monitoring_executions_input(MonitoringScheduleName = MonitoringScheduleName, EndpointName = EndpointName, SortBy = SortBy, SortOrder = SortOrder, NextToken = NextToken, MaxResults = MaxResults, ScheduledTimeBefore = ScheduledTimeBefore, ScheduledTimeAfter = ScheduledTimeAfter, CreationTimeBefore = CreationTimeBefore, CreationTimeAfter = CreationTimeAfter, LastModifiedTimeBefore = LastModifiedTimeBefore, LastModifiedTimeAfter = LastModifiedTimeAfter, StatusEquals = StatusEquals, MonitoringJobDefinitionName = MonitoringJobDefinitionName, MonitoringTypeEquals = MonitoringTypeEquals)
  output <- .sagemaker$list_monitoring_executions_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_monitoring_executions <- sagemaker_list_monitoring_executions

#' Returns list of all monitoring schedules
#'
#' @description
#' Returns list of all monitoring schedules.
#'
#' See [https://paws-r.github.io/docs/sagemaker/list_monitoring_schedules.html](https://paws-r.github.io/docs/sagemaker/list_monitoring_schedules.html) for full documentation.
#'
#' @param EndpointName Name of a specific endpoint to fetch schedules for.
#' @param SortBy Whether to sort results by `Status`, `CreationTime`, `ScheduledTime`
#' field. The default is `CreationTime`.
#' @param SortOrder Whether to sort the results in `Ascending` or `Descending` order. The
#' default is `Descending`.
#' @param NextToken The token returned if the response is truncated. To retrieve the next
#' set of job executions, use it in the next request.
#' @param MaxResults The maximum number of jobs to return in the response. The default value
#' is 10.
#' @param NameContains Filter for monitoring schedules whose name contains a specified string.
#' @param CreationTimeBefore A filter that returns only monitoring schedules created before a
#' specified time.
#' @param CreationTimeAfter A filter that returns only monitoring schedules created after a
#' specified time.
#' @param LastModifiedTimeBefore A filter that returns only monitoring schedules modified before a
#' specified time.
#' @param LastModifiedTimeAfter A filter that returns only monitoring schedules modified after a
#' specified time.
#' @param StatusEquals A filter that returns only monitoring schedules modified before a
#' specified time.
#' @param MonitoringJobDefinitionName Gets a list of the monitoring schedules for the specified monitoring job
#' definition.
#' @param MonitoringTypeEquals A filter that returns only the monitoring schedules for the specified
#' monitoring type.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_monitoring_schedules
sagemaker_list_monitoring_schedules <- function(EndpointName = NULL, SortBy = NULL, SortOrder = NULL, NextToken = NULL, MaxResults = NULL, NameContains = NULL, CreationTimeBefore = NULL, CreationTimeAfter = NULL, LastModifiedTimeBefore = NULL, LastModifiedTimeAfter = NULL, StatusEquals = NULL, MonitoringJobDefinitionName = NULL, MonitoringTypeEquals = NULL) {
  op <- new_operation(
    name = "ListMonitoringSchedules",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_monitoring_schedules_input(EndpointName = EndpointName, SortBy = SortBy, SortOrder = SortOrder, NextToken = NextToken, MaxResults = MaxResults, NameContains = NameContains, CreationTimeBefore = CreationTimeBefore, CreationTimeAfter = CreationTimeAfter, LastModifiedTimeBefore = LastModifiedTimeBefore, LastModifiedTimeAfter = LastModifiedTimeAfter, StatusEquals = StatusEquals, MonitoringJobDefinitionName = MonitoringJobDefinitionName, MonitoringTypeEquals = MonitoringTypeEquals)
  output <- .sagemaker$list_monitoring_schedules_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_monitoring_schedules <- sagemaker_list_monitoring_schedules

#' Lists notebook instance lifestyle configurations created with the
#' CreateNotebookInstanceLifecycleConfig API
#'
#' @description
#' Lists notebook instance lifestyle configurations created with the [`create_notebook_instance_lifecycle_config`][sagemaker_create_notebook_instance_lifecycle_config] API.
#'
#' See [https://paws-r.github.io/docs/sagemaker/list_notebook_instance_lifecycle_configs.html](https://paws-r.github.io/docs/sagemaker/list_notebook_instance_lifecycle_configs.html) for full documentation.
#'
#' @param NextToken If the result of a
#' [`list_notebook_instance_lifecycle_configs`][sagemaker_list_notebook_instance_lifecycle_configs]
#' request was truncated, the response includes a `NextToken`. To get the
#' next set of lifecycle configurations, use the token in the next request.
#' @param MaxResults The maximum number of lifecycle configurations to return in the
#' response.
#' @param SortBy Sorts the list of results. The default is `CreationTime`.
#' @param SortOrder The sort order for results.
#' @param NameContains A string in the lifecycle configuration name. This filter returns only
#' lifecycle configurations whose name contains the specified string.
#' @param CreationTimeBefore A filter that returns only lifecycle configurations that were created
#' before the specified time (timestamp).
#' @param CreationTimeAfter A filter that returns only lifecycle configurations that were created
#' after the specified time (timestamp).
#' @param LastModifiedTimeBefore A filter that returns only lifecycle configurations that were modified
#' before the specified time (timestamp).
#' @param LastModifiedTimeAfter A filter that returns only lifecycle configurations that were modified
#' after the specified time (timestamp).
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_notebook_instance_lifecycle_configs
sagemaker_list_notebook_instance_lifecycle_configs <- function(NextToken = NULL, MaxResults = NULL, SortBy = NULL, SortOrder = NULL, NameContains = NULL, CreationTimeBefore = NULL, CreationTimeAfter = NULL, LastModifiedTimeBefore = NULL, LastModifiedTimeAfter = NULL) {
  op <- new_operation(
    name = "ListNotebookInstanceLifecycleConfigs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_notebook_instance_lifecycle_configs_input(NextToken = NextToken, MaxResults = MaxResults, SortBy = SortBy, SortOrder = SortOrder, NameContains = NameContains, CreationTimeBefore = CreationTimeBefore, CreationTimeAfter = CreationTimeAfter, LastModifiedTimeBefore = LastModifiedTimeBefore, LastModifiedTimeAfter = LastModifiedTimeAfter)
  output <- .sagemaker$list_notebook_instance_lifecycle_configs_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_notebook_instance_lifecycle_configs <- sagemaker_list_notebook_instance_lifecycle_configs

#' Returns a list of the SageMaker notebook instances in the requester's
#' account in an Amazon Web Services Region
#'
#' @description
#' Returns a list of the SageMaker notebook instances in the requester's account in an Amazon Web Services Region.
#'
#' See [https://paws-r.github.io/docs/sagemaker/list_notebook_instances.html](https://paws-r.github.io/docs/sagemaker/list_notebook_instances.html) for full documentation.
#'
#' @param NextToken If the previous call to the
#' [`list_notebook_instances`][sagemaker_list_notebook_instances] is
#' truncated, the response includes a `NextToken`. You can use this token
#' in your subsequent
#' [`list_notebook_instances`][sagemaker_list_notebook_instances] request
#' to fetch the next set of notebook instances.
#' 
#' You might specify a filter or a sort order in your request. When
#' response is truncated, you must use the same values for the filer and
#' sort order in the next request.
#' @param MaxResults The maximum number of notebook instances to return.
#' @param SortBy The field to sort results by. The default is `Name`.
#' @param SortOrder The sort order for results.
#' @param NameContains A string in the notebook instances' name. This filter returns only
#' notebook instances whose name contains the specified string.
#' @param CreationTimeBefore A filter that returns only notebook instances that were created before
#' the specified time (timestamp).
#' @param CreationTimeAfter A filter that returns only notebook instances that were created after
#' the specified time (timestamp).
#' @param LastModifiedTimeBefore A filter that returns only notebook instances that were modified before
#' the specified time (timestamp).
#' @param LastModifiedTimeAfter A filter that returns only notebook instances that were modified after
#' the specified time (timestamp).
#' @param StatusEquals A filter that returns only notebook instances with the specified status.
#' @param NotebookInstanceLifecycleConfigNameContains A string in the name of a notebook instances lifecycle configuration
#' associated with this notebook instance. This filter returns only
#' notebook instances associated with a lifecycle configuration with a name
#' that contains the specified string.
#' @param DefaultCodeRepositoryContains A string in the name or URL of a Git repository associated with this
#' notebook instance. This filter returns only notebook instances
#' associated with a git repository with a name that contains the specified
#' string.
#' @param AdditionalCodeRepositoryEquals A filter that returns only notebook instances with associated with the
#' specified git repository.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_notebook_instances
sagemaker_list_notebook_instances <- function(NextToken = NULL, MaxResults = NULL, SortBy = NULL, SortOrder = NULL, NameContains = NULL, CreationTimeBefore = NULL, CreationTimeAfter = NULL, LastModifiedTimeBefore = NULL, LastModifiedTimeAfter = NULL, StatusEquals = NULL, NotebookInstanceLifecycleConfigNameContains = NULL, DefaultCodeRepositoryContains = NULL, AdditionalCodeRepositoryEquals = NULL) {
  op <- new_operation(
    name = "ListNotebookInstances",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_notebook_instances_input(NextToken = NextToken, MaxResults = MaxResults, SortBy = SortBy, SortOrder = SortOrder, NameContains = NameContains, CreationTimeBefore = CreationTimeBefore, CreationTimeAfter = CreationTimeAfter, LastModifiedTimeBefore = LastModifiedTimeBefore, LastModifiedTimeAfter = LastModifiedTimeAfter, StatusEquals = StatusEquals, NotebookInstanceLifecycleConfigNameContains = NotebookInstanceLifecycleConfigNameContains, DefaultCodeRepositoryContains = DefaultCodeRepositoryContains, AdditionalCodeRepositoryEquals = AdditionalCodeRepositoryEquals)
  output <- .sagemaker$list_notebook_instances_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_notebook_instances <- sagemaker_list_notebook_instances

#' Gets a list of PipeLineExecutionStep objects
#'
#' @description
#' Gets a list of `PipeLineExecutionStep` objects.
#'
#' See [https://paws-r.github.io/docs/sagemaker/list_pipeline_execution_steps.html](https://paws-r.github.io/docs/sagemaker/list_pipeline_execution_steps.html) for full documentation.
#'
#' @param PipelineExecutionArn The Amazon Resource Name (ARN) of the pipeline execution.
#' @param NextToken If the result of the previous
#' [`list_pipeline_execution_steps`][sagemaker_list_pipeline_execution_steps]
#' request was truncated, the response includes a `NextToken`. To retrieve
#' the next set of pipeline execution steps, use the token in the next
#' request.
#' @param MaxResults The maximum number of pipeline execution steps to return in the
#' response.
#' @param SortOrder The field by which to sort results. The default is `CreatedTime`.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_pipeline_execution_steps
sagemaker_list_pipeline_execution_steps <- function(PipelineExecutionArn = NULL, NextToken = NULL, MaxResults = NULL, SortOrder = NULL) {
  op <- new_operation(
    name = "ListPipelineExecutionSteps",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_pipeline_execution_steps_input(PipelineExecutionArn = PipelineExecutionArn, NextToken = NextToken, MaxResults = MaxResults, SortOrder = SortOrder)
  output <- .sagemaker$list_pipeline_execution_steps_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_pipeline_execution_steps <- sagemaker_list_pipeline_execution_steps

#' Gets a list of the pipeline executions
#'
#' @description
#' Gets a list of the pipeline executions.
#'
#' See [https://paws-r.github.io/docs/sagemaker/list_pipeline_executions.html](https://paws-r.github.io/docs/sagemaker/list_pipeline_executions.html) for full documentation.
#'
#' @param PipelineName &#91;required&#93; The name of the pipeline.
#' @param CreatedAfter A filter that returns the pipeline executions that were created after a
#' specified time.
#' @param CreatedBefore A filter that returns the pipeline executions that were created before a
#' specified time.
#' @param SortBy The field by which to sort results. The default is `CreatedTime`.
#' @param SortOrder The sort order for results.
#' @param NextToken If the result of the previous
#' [`list_pipeline_executions`][sagemaker_list_pipeline_executions] request
#' was truncated, the response includes a `NextToken`. To retrieve the next
#' set of pipeline executions, use the token in the next request.
#' @param MaxResults The maximum number of pipeline executions to return in the response.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_pipeline_executions
sagemaker_list_pipeline_executions <- function(PipelineName, CreatedAfter = NULL, CreatedBefore = NULL, SortBy = NULL, SortOrder = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListPipelineExecutions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_pipeline_executions_input(PipelineName = PipelineName, CreatedAfter = CreatedAfter, CreatedBefore = CreatedBefore, SortBy = SortBy, SortOrder = SortOrder, NextToken = NextToken, MaxResults = MaxResults)
  output <- .sagemaker$list_pipeline_executions_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_pipeline_executions <- sagemaker_list_pipeline_executions

#' Gets a list of parameters for a pipeline execution
#'
#' @description
#' Gets a list of parameters for a pipeline execution.
#'
#' See [https://paws-r.github.io/docs/sagemaker/list_pipeline_parameters_for_execution.html](https://paws-r.github.io/docs/sagemaker/list_pipeline_parameters_for_execution.html) for full documentation.
#'
#' @param PipelineExecutionArn &#91;required&#93; The Amazon Resource Name (ARN) of the pipeline execution.
#' @param NextToken If the result of the previous
#' [`list_pipeline_parameters_for_execution`][sagemaker_list_pipeline_parameters_for_execution]
#' request was truncated, the response includes a `NextToken`. To retrieve
#' the next set of parameters, use the token in the next request.
#' @param MaxResults The maximum number of parameters to return in the response.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_pipeline_parameters_for_execution
sagemaker_list_pipeline_parameters_for_execution <- function(PipelineExecutionArn, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListPipelineParametersForExecution",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_pipeline_parameters_for_execution_input(PipelineExecutionArn = PipelineExecutionArn, NextToken = NextToken, MaxResults = MaxResults)
  output <- .sagemaker$list_pipeline_parameters_for_execution_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_pipeline_parameters_for_execution <- sagemaker_list_pipeline_parameters_for_execution

#' Gets a list of pipelines
#'
#' @description
#' Gets a list of pipelines.
#'
#' See [https://paws-r.github.io/docs/sagemaker/list_pipelines.html](https://paws-r.github.io/docs/sagemaker/list_pipelines.html) for full documentation.
#'
#' @param PipelineNamePrefix The prefix of the pipeline name.
#' @param CreatedAfter A filter that returns the pipelines that were created after a specified
#' time.
#' @param CreatedBefore A filter that returns the pipelines that were created before a specified
#' time.
#' @param SortBy The field by which to sort results. The default is `CreatedTime`.
#' @param SortOrder The sort order for results.
#' @param NextToken If the result of the previous
#' [`list_pipelines`][sagemaker_list_pipelines] request was truncated, the
#' response includes a `NextToken`. To retrieve the next set of pipelines,
#' use the token in the next request.
#' @param MaxResults The maximum number of pipelines to return in the response.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_pipelines
sagemaker_list_pipelines <- function(PipelineNamePrefix = NULL, CreatedAfter = NULL, CreatedBefore = NULL, SortBy = NULL, SortOrder = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListPipelines",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_pipelines_input(PipelineNamePrefix = PipelineNamePrefix, CreatedAfter = CreatedAfter, CreatedBefore = CreatedBefore, SortBy = SortBy, SortOrder = SortOrder, NextToken = NextToken, MaxResults = MaxResults)
  output <- .sagemaker$list_pipelines_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_pipelines <- sagemaker_list_pipelines

#' Lists processing jobs that satisfy various filters
#'
#' @description
#' Lists processing jobs that satisfy various filters.
#'
#' See [https://paws-r.github.io/docs/sagemaker/list_processing_jobs.html](https://paws-r.github.io/docs/sagemaker/list_processing_jobs.html) for full documentation.
#'
#' @param CreationTimeAfter A filter that returns only processing jobs created after the specified
#' time.
#' @param CreationTimeBefore A filter that returns only processing jobs created after the specified
#' time.
#' @param LastModifiedTimeAfter A filter that returns only processing jobs modified after the specified
#' time.
#' @param LastModifiedTimeBefore A filter that returns only processing jobs modified before the specified
#' time.
#' @param NameContains A string in the processing job name. This filter returns only processing
#' jobs whose name contains the specified string.
#' @param StatusEquals A filter that retrieves only processing jobs with a specific status.
#' @param SortBy The field to sort results by. The default is `CreationTime`.
#' @param SortOrder The sort order for results. The default is `Ascending`.
#' @param NextToken If the result of the previous
#' [`list_processing_jobs`][sagemaker_list_processing_jobs] request was
#' truncated, the response includes a `NextToken`. To retrieve the next set
#' of processing jobs, use the token in the next request.
#' @param MaxResults The maximum number of processing jobs to return in the response.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_processing_jobs
sagemaker_list_processing_jobs <- function(CreationTimeAfter = NULL, CreationTimeBefore = NULL, LastModifiedTimeAfter = NULL, LastModifiedTimeBefore = NULL, NameContains = NULL, StatusEquals = NULL, SortBy = NULL, SortOrder = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListProcessingJobs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_processing_jobs_input(CreationTimeAfter = CreationTimeAfter, CreationTimeBefore = CreationTimeBefore, LastModifiedTimeAfter = LastModifiedTimeAfter, LastModifiedTimeBefore = LastModifiedTimeBefore, NameContains = NameContains, StatusEquals = StatusEquals, SortBy = SortBy, SortOrder = SortOrder, NextToken = NextToken, MaxResults = MaxResults)
  output <- .sagemaker$list_processing_jobs_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_processing_jobs <- sagemaker_list_processing_jobs

#' Gets a list of the projects in an Amazon Web Services account
#'
#' @description
#' Gets a list of the projects in an Amazon Web Services account.
#'
#' See [https://paws-r.github.io/docs/sagemaker/list_projects.html](https://paws-r.github.io/docs/sagemaker/list_projects.html) for full documentation.
#'
#' @param CreationTimeAfter A filter that returns the projects that were created after a specified
#' time.
#' @param CreationTimeBefore A filter that returns the projects that were created before a specified
#' time.
#' @param MaxResults The maximum number of projects to return in the response.
#' @param NameContains A filter that returns the projects whose name contains a specified
#' string.
#' @param NextToken If the result of the previous [`list_projects`][sagemaker_list_projects]
#' request was truncated, the response includes a `NextToken`. To retrieve
#' the next set of projects, use the token in the next request.
#' @param SortBy The field by which to sort results. The default is `CreationTime`.
#' @param SortOrder The sort order for results. The default is `Ascending`.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_projects
sagemaker_list_projects <- function(CreationTimeAfter = NULL, CreationTimeBefore = NULL, MaxResults = NULL, NameContains = NULL, NextToken = NULL, SortBy = NULL, SortOrder = NULL) {
  op <- new_operation(
    name = "ListProjects",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_projects_input(CreationTimeAfter = CreationTimeAfter, CreationTimeBefore = CreationTimeBefore, MaxResults = MaxResults, NameContains = NameContains, NextToken = NextToken, SortBy = SortBy, SortOrder = SortOrder)
  output <- .sagemaker$list_projects_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_projects <- sagemaker_list_projects

#' Lists devices allocated to the stage, containing detailed device
#' information and deployment status
#'
#' @description
#' Lists devices allocated to the stage, containing detailed device information and deployment status.
#'
#' See [https://paws-r.github.io/docs/sagemaker/list_stage_devices.html](https://paws-r.github.io/docs/sagemaker/list_stage_devices.html) for full documentation.
#'
#' @param NextToken The response from the last list when returning a list large enough to
#' neeed tokening.
#' @param MaxResults The maximum number of requests to select.
#' @param EdgeDeploymentPlanName &#91;required&#93; The name of the edge deployment plan.
#' @param ExcludeDevicesDeployedInOtherStage Toggle for excluding devices deployed in other stages.
#' @param StageName &#91;required&#93; The name of the stage in the deployment.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_stage_devices
sagemaker_list_stage_devices <- function(NextToken = NULL, MaxResults = NULL, EdgeDeploymentPlanName, ExcludeDevicesDeployedInOtherStage = NULL, StageName) {
  op <- new_operation(
    name = "ListStageDevices",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_stage_devices_input(NextToken = NextToken, MaxResults = MaxResults, EdgeDeploymentPlanName = EdgeDeploymentPlanName, ExcludeDevicesDeployedInOtherStage = ExcludeDevicesDeployedInOtherStage, StageName = StageName)
  output <- .sagemaker$list_stage_devices_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_stage_devices <- sagemaker_list_stage_devices

#' Lists the Studio Lifecycle Configurations in your Amazon Web Services
#' Account
#'
#' @description
#' Lists the Studio Lifecycle Configurations in your Amazon Web Services Account.
#'
#' See [https://paws-r.github.io/docs/sagemaker/list_studio_lifecycle_configs.html](https://paws-r.github.io/docs/sagemaker/list_studio_lifecycle_configs.html) for full documentation.
#'
#' @param MaxResults The maximum number of Studio Lifecycle Configurations to return in the
#' response. The default value is 10.
#' @param NextToken If the previous call to ListStudioLifecycleConfigs didn't return the
#' full set of Lifecycle Configurations, the call returns a token for
#' getting the next set of Lifecycle Configurations.
#' @param NameContains A string in the Lifecycle Configuration name. This filter returns only
#' Lifecycle Configurations whose name contains the specified string.
#' @param AppTypeEquals A parameter to search for the App Type to which the Lifecycle
#' Configuration is attached.
#' @param CreationTimeBefore A filter that returns only Lifecycle Configurations created on or before
#' the specified time.
#' @param CreationTimeAfter A filter that returns only Lifecycle Configurations created on or after
#' the specified time.
#' @param ModifiedTimeBefore A filter that returns only Lifecycle Configurations modified before the
#' specified time.
#' @param ModifiedTimeAfter A filter that returns only Lifecycle Configurations modified after the
#' specified time.
#' @param SortBy The property used to sort results. The default value is CreationTime.
#' @param SortOrder The sort order. The default value is Descending.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_studio_lifecycle_configs
sagemaker_list_studio_lifecycle_configs <- function(MaxResults = NULL, NextToken = NULL, NameContains = NULL, AppTypeEquals = NULL, CreationTimeBefore = NULL, CreationTimeAfter = NULL, ModifiedTimeBefore = NULL, ModifiedTimeAfter = NULL, SortBy = NULL, SortOrder = NULL) {
  op <- new_operation(
    name = "ListStudioLifecycleConfigs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_studio_lifecycle_configs_input(MaxResults = MaxResults, NextToken = NextToken, NameContains = NameContains, AppTypeEquals = AppTypeEquals, CreationTimeBefore = CreationTimeBefore, CreationTimeAfter = CreationTimeAfter, ModifiedTimeBefore = ModifiedTimeBefore, ModifiedTimeAfter = ModifiedTimeAfter, SortBy = SortBy, SortOrder = SortOrder)
  output <- .sagemaker$list_studio_lifecycle_configs_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_studio_lifecycle_configs <- sagemaker_list_studio_lifecycle_configs

#' Gets a list of the work teams that you are subscribed to in the Amazon
#' Web Services Marketplace
#'
#' @description
#' Gets a list of the work teams that you are subscribed to in the Amazon Web Services Marketplace. The list may be empty if no work team satisfies the filter specified in the `NameContains` parameter.
#'
#' See [https://paws-r.github.io/docs/sagemaker/list_subscribed_workteams.html](https://paws-r.github.io/docs/sagemaker/list_subscribed_workteams.html) for full documentation.
#'
#' @param NameContains A string in the work team name. This filter returns only work teams
#' whose name contains the specified string.
#' @param NextToken If the result of the previous
#' [`list_subscribed_workteams`][sagemaker_list_subscribed_workteams]
#' request was truncated, the response includes a `NextToken`. To retrieve
#' the next set of labeling jobs, use the token in the next request.
#' @param MaxResults The maximum number of work teams to return in each page of the response.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_subscribed_workteams
sagemaker_list_subscribed_workteams <- function(NameContains = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListSubscribedWorkteams",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_subscribed_workteams_input(NameContains = NameContains, NextToken = NextToken, MaxResults = MaxResults)
  output <- .sagemaker$list_subscribed_workteams_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_subscribed_workteams <- sagemaker_list_subscribed_workteams

#' Returns the tags for the specified SageMaker resource
#'
#' @description
#' Returns the tags for the specified SageMaker resource.
#'
#' See [https://paws-r.github.io/docs/sagemaker/list_tags.html](https://paws-r.github.io/docs/sagemaker/list_tags.html) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource whose tags you want to
#' retrieve.
#' @param NextToken If the response to the previous [`list_tags`][sagemaker_list_tags]
#' request is truncated, SageMaker returns this token. To retrieve the next
#' set of tags, use it in the subsequent request.
#' @param MaxResults Maximum number of tags to return.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_tags
sagemaker_list_tags <- function(ResourceArn, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListTags",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_tags_input(ResourceArn = ResourceArn, NextToken = NextToken, MaxResults = MaxResults)
  output <- .sagemaker$list_tags_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_tags <- sagemaker_list_tags

#' Lists training jobs
#'
#' @description
#' Lists training jobs.
#'
#' See [https://paws-r.github.io/docs/sagemaker/list_training_jobs.html](https://paws-r.github.io/docs/sagemaker/list_training_jobs.html) for full documentation.
#'
#' @param NextToken If the result of the previous
#' [`list_training_jobs`][sagemaker_list_training_jobs] request was
#' truncated, the response includes a `NextToken`. To retrieve the next set
#' of training jobs, use the token in the next request.
#' @param MaxResults The maximum number of training jobs to return in the response.
#' @param CreationTimeAfter A filter that returns only training jobs created after the specified
#' time (timestamp).
#' @param CreationTimeBefore A filter that returns only training jobs created before the specified
#' time (timestamp).
#' @param LastModifiedTimeAfter A filter that returns only training jobs modified after the specified
#' time (timestamp).
#' @param LastModifiedTimeBefore A filter that returns only training jobs modified before the specified
#' time (timestamp).
#' @param NameContains A string in the training job name. This filter returns only training
#' jobs whose name contains the specified string.
#' @param StatusEquals A filter that retrieves only training jobs with a specific status.
#' @param SortBy The field to sort results by. The default is `CreationTime`.
#' @param SortOrder The sort order for results. The default is `Ascending`.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_training_jobs
sagemaker_list_training_jobs <- function(NextToken = NULL, MaxResults = NULL, CreationTimeAfter = NULL, CreationTimeBefore = NULL, LastModifiedTimeAfter = NULL, LastModifiedTimeBefore = NULL, NameContains = NULL, StatusEquals = NULL, SortBy = NULL, SortOrder = NULL) {
  op <- new_operation(
    name = "ListTrainingJobs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_training_jobs_input(NextToken = NextToken, MaxResults = MaxResults, CreationTimeAfter = CreationTimeAfter, CreationTimeBefore = CreationTimeBefore, LastModifiedTimeAfter = LastModifiedTimeAfter, LastModifiedTimeBefore = LastModifiedTimeBefore, NameContains = NameContains, StatusEquals = StatusEquals, SortBy = SortBy, SortOrder = SortOrder)
  output <- .sagemaker$list_training_jobs_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_training_jobs <- sagemaker_list_training_jobs

#' Gets a list of TrainingJobSummary objects that describe the training
#' jobs that a hyperparameter tuning job launched
#'
#' @description
#' Gets a list of TrainingJobSummary objects that describe the training jobs that a hyperparameter tuning job launched.
#'
#' See [https://paws-r.github.io/docs/sagemaker/list_training_jobs_for_hyper_parameter_tuning_job.html](https://paws-r.github.io/docs/sagemaker/list_training_jobs_for_hyper_parameter_tuning_job.html) for full documentation.
#'
#' @param HyperParameterTuningJobName &#91;required&#93; The name of the tuning job whose training jobs you want to list.
#' @param NextToken If the result of the previous
#' [`list_training_jobs_for_hyper_parameter_tuning_job`][sagemaker_list_training_jobs_for_hyper_parameter_tuning_job]
#' request was truncated, the response includes a `NextToken`. To retrieve
#' the next set of training jobs, use the token in the next request.
#' @param MaxResults The maximum number of training jobs to return. The default value is 10.
#' @param StatusEquals A filter that returns only training jobs with the specified status.
#' @param SortBy The field to sort results by. The default is `Name`.
#' 
#' If the value of this field is `FinalObjectiveMetricValue`, any training
#' jobs that did not return an objective metric are not listed.
#' @param SortOrder The sort order for results. The default is `Ascending`.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_training_jobs_for_hyper_parameter_tuning_job
sagemaker_list_training_jobs_for_hyper_parameter_tuning_job <- function(HyperParameterTuningJobName, NextToken = NULL, MaxResults = NULL, StatusEquals = NULL, SortBy = NULL, SortOrder = NULL) {
  op <- new_operation(
    name = "ListTrainingJobsForHyperParameterTuningJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_training_jobs_for_hyper_parameter_tuning_job_input(HyperParameterTuningJobName = HyperParameterTuningJobName, NextToken = NextToken, MaxResults = MaxResults, StatusEquals = StatusEquals, SortBy = SortBy, SortOrder = SortOrder)
  output <- .sagemaker$list_training_jobs_for_hyper_parameter_tuning_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_training_jobs_for_hyper_parameter_tuning_job <- sagemaker_list_training_jobs_for_hyper_parameter_tuning_job

#' Lists transform jobs
#'
#' @description
#' Lists transform jobs.
#'
#' See [https://paws-r.github.io/docs/sagemaker/list_transform_jobs.html](https://paws-r.github.io/docs/sagemaker/list_transform_jobs.html) for full documentation.
#'
#' @param CreationTimeAfter A filter that returns only transform jobs created after the specified
#' time.
#' @param CreationTimeBefore A filter that returns only transform jobs created before the specified
#' time.
#' @param LastModifiedTimeAfter A filter that returns only transform jobs modified after the specified
#' time.
#' @param LastModifiedTimeBefore A filter that returns only transform jobs modified before the specified
#' time.
#' @param NameContains A string in the transform job name. This filter returns only transform
#' jobs whose name contains the specified string.
#' @param StatusEquals A filter that retrieves only transform jobs with a specific status.
#' @param SortBy The field to sort results by. The default is `CreationTime`.
#' @param SortOrder The sort order for results. The default is `Descending`.
#' @param NextToken If the result of the previous
#' [`list_transform_jobs`][sagemaker_list_transform_jobs] request was
#' truncated, the response includes a `NextToken`. To retrieve the next set
#' of transform jobs, use the token in the next request.
#' @param MaxResults The maximum number of transform jobs to return in the response. The
#' default value is `10`.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_transform_jobs
sagemaker_list_transform_jobs <- function(CreationTimeAfter = NULL, CreationTimeBefore = NULL, LastModifiedTimeAfter = NULL, LastModifiedTimeBefore = NULL, NameContains = NULL, StatusEquals = NULL, SortBy = NULL, SortOrder = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListTransformJobs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_transform_jobs_input(CreationTimeAfter = CreationTimeAfter, CreationTimeBefore = CreationTimeBefore, LastModifiedTimeAfter = LastModifiedTimeAfter, LastModifiedTimeBefore = LastModifiedTimeBefore, NameContains = NameContains, StatusEquals = StatusEquals, SortBy = SortBy, SortOrder = SortOrder, NextToken = NextToken, MaxResults = MaxResults)
  output <- .sagemaker$list_transform_jobs_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_transform_jobs <- sagemaker_list_transform_jobs

#' Lists the trial components in your account
#'
#' @description
#' Lists the trial components in your account. You can sort the list by trial component name or creation time. You can filter the list to show only components that were created in a specific time range. You can also filter on one of the following:
#'
#' See [https://paws-r.github.io/docs/sagemaker/list_trial_components.html](https://paws-r.github.io/docs/sagemaker/list_trial_components.html) for full documentation.
#'
#' @param ExperimentName A filter that returns only components that are part of the specified
#' experiment. If you specify `ExperimentName`, you can't filter by
#' `SourceArn` or `TrialName`.
#' @param TrialName A filter that returns only components that are part of the specified
#' trial. If you specify `TrialName`, you can't filter by `ExperimentName`
#' or `SourceArn`.
#' @param SourceArn A filter that returns only components that have the specified source
#' Amazon Resource Name (ARN). If you specify `SourceArn`, you can't filter
#' by `ExperimentName` or `TrialName`.
#' @param CreatedAfter A filter that returns only components created after the specified time.
#' @param CreatedBefore A filter that returns only components created before the specified time.
#' @param SortBy The property used to sort results. The default value is `CreationTime`.
#' @param SortOrder The sort order. The default value is `Descending`.
#' @param MaxResults The maximum number of components to return in the response. The default
#' value is 10.
#' @param NextToken If the previous call to
#' [`list_trial_components`][sagemaker_list_trial_components] didn't return
#' the full set of components, the call returns a token for getting the
#' next set of components.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_trial_components
sagemaker_list_trial_components <- function(ExperimentName = NULL, TrialName = NULL, SourceArn = NULL, CreatedAfter = NULL, CreatedBefore = NULL, SortBy = NULL, SortOrder = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListTrialComponents",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_trial_components_input(ExperimentName = ExperimentName, TrialName = TrialName, SourceArn = SourceArn, CreatedAfter = CreatedAfter, CreatedBefore = CreatedBefore, SortBy = SortBy, SortOrder = SortOrder, MaxResults = MaxResults, NextToken = NextToken)
  output <- .sagemaker$list_trial_components_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_trial_components <- sagemaker_list_trial_components

#' Lists the trials in your account
#'
#' @description
#' Lists the trials in your account. Specify an experiment name to limit the list to the trials that are part of that experiment. Specify a trial component name to limit the list to the trials that associated with that trial component. The list can be filtered to show only trials that were created in a specific time range. The list can be sorted by trial name or creation time.
#'
#' See [https://paws-r.github.io/docs/sagemaker/list_trials.html](https://paws-r.github.io/docs/sagemaker/list_trials.html) for full documentation.
#'
#' @param ExperimentName A filter that returns only trials that are part of the specified
#' experiment.
#' @param TrialComponentName A filter that returns only trials that are associated with the specified
#' trial component.
#' @param CreatedAfter A filter that returns only trials created after the specified time.
#' @param CreatedBefore A filter that returns only trials created before the specified time.
#' @param SortBy The property used to sort results. The default value is `CreationTime`.
#' @param SortOrder The sort order. The default value is `Descending`.
#' @param MaxResults The maximum number of trials to return in the response. The default
#' value is 10.
#' @param NextToken If the previous call to [`list_trials`][sagemaker_list_trials] didn't
#' return the full set of trials, the call returns a token for getting the
#' next set of trials.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_trials
sagemaker_list_trials <- function(ExperimentName = NULL, TrialComponentName = NULL, CreatedAfter = NULL, CreatedBefore = NULL, SortBy = NULL, SortOrder = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListTrials",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_trials_input(ExperimentName = ExperimentName, TrialComponentName = TrialComponentName, CreatedAfter = CreatedAfter, CreatedBefore = CreatedBefore, SortBy = SortBy, SortOrder = SortOrder, MaxResults = MaxResults, NextToken = NextToken)
  output <- .sagemaker$list_trials_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_trials <- sagemaker_list_trials

#' Lists user profiles
#'
#' @description
#' Lists user profiles.
#'
#' See [https://paws-r.github.io/docs/sagemaker/list_user_profiles.html](https://paws-r.github.io/docs/sagemaker/list_user_profiles.html) for full documentation.
#'
#' @param NextToken If the previous response was truncated, you will receive this token. Use
#' it in your next request to receive the next set of results.
#' @param MaxResults Returns a list up to a specified limit.
#' @param SortOrder The sort order for the results. The default is Ascending.
#' @param SortBy The parameter by which to sort the results. The default is CreationTime.
#' @param DomainIdEquals A parameter by which to filter the results.
#' @param UserProfileNameContains A parameter by which to filter the results.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_user_profiles
sagemaker_list_user_profiles <- function(NextToken = NULL, MaxResults = NULL, SortOrder = NULL, SortBy = NULL, DomainIdEquals = NULL, UserProfileNameContains = NULL) {
  op <- new_operation(
    name = "ListUserProfiles",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_user_profiles_input(NextToken = NextToken, MaxResults = MaxResults, SortOrder = SortOrder, SortBy = SortBy, DomainIdEquals = DomainIdEquals, UserProfileNameContains = UserProfileNameContains)
  output <- .sagemaker$list_user_profiles_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_user_profiles <- sagemaker_list_user_profiles

#' Use this operation to list all private and vendor workforces in an
#' Amazon Web Services Region
#'
#' @description
#' Use this operation to list all private and vendor workforces in an Amazon Web Services Region. Note that you can only have one private workforce per Amazon Web Services Region.
#'
#' See [https://paws-r.github.io/docs/sagemaker/list_workforces.html](https://paws-r.github.io/docs/sagemaker/list_workforces.html) for full documentation.
#'
#' @param SortBy Sort workforces using the workforce name or creation date.
#' @param SortOrder Sort workforces in ascending or descending order.
#' @param NameContains A filter you can use to search for workforces using part of the
#' workforce name.
#' @param NextToken A token to resume pagination.
#' @param MaxResults The maximum number of workforces returned in the response.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_workforces
sagemaker_list_workforces <- function(SortBy = NULL, SortOrder = NULL, NameContains = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListWorkforces",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_workforces_input(SortBy = SortBy, SortOrder = SortOrder, NameContains = NameContains, NextToken = NextToken, MaxResults = MaxResults)
  output <- .sagemaker$list_workforces_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_workforces <- sagemaker_list_workforces

#' Gets a list of private work teams that you have defined in a region
#'
#' @description
#' Gets a list of private work teams that you have defined in a region. The list may be empty if no work team satisfies the filter specified in the `NameContains` parameter.
#'
#' See [https://paws-r.github.io/docs/sagemaker/list_workteams.html](https://paws-r.github.io/docs/sagemaker/list_workteams.html) for full documentation.
#'
#' @param SortBy The field to sort results by. The default is `CreationTime`.
#' @param SortOrder The sort order for results. The default is `Ascending`.
#' @param NameContains A string in the work team's name. This filter returns only work teams
#' whose name contains the specified string.
#' @param NextToken If the result of the previous
#' [`list_workteams`][sagemaker_list_workteams] request was truncated, the
#' response includes a `NextToken`. To retrieve the next set of labeling
#' jobs, use the token in the next request.
#' @param MaxResults The maximum number of work teams to return in each page of the response.
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_workteams
sagemaker_list_workteams <- function(SortBy = NULL, SortOrder = NULL, NameContains = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListWorkteams",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_workteams_input(SortBy = SortBy, SortOrder = SortOrder, NameContains = NameContains, NextToken = NextToken, MaxResults = MaxResults)
  output <- .sagemaker$list_workteams_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_workteams <- sagemaker_list_workteams

#' Adds a resouce policy to control access to a model group
#'
#' @description
#' Adds a resouce policy to control access to a model group. For information about resoure policies, see [Identity-based policies and resource-based policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_identity-vs-resource.html) in the *Amazon Web Services Identity and Access Management User Guide.*.
#'
#' See [https://paws-r.github.io/docs/sagemaker/put_model_package_group_policy.html](https://paws-r.github.io/docs/sagemaker/put_model_package_group_policy.html) for full documentation.
#'
#' @param ModelPackageGroupName &#91;required&#93; The name of the model group to add a resource policy to.
#' @param ResourcePolicy &#91;required&#93; The resource policy for the model group.
#'
#' @keywords internal
#'
#' @rdname sagemaker_put_model_package_group_policy
sagemaker_put_model_package_group_policy <- function(ModelPackageGroupName, ResourcePolicy) {
  op <- new_operation(
    name = "PutModelPackageGroupPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$put_model_package_group_policy_input(ModelPackageGroupName = ModelPackageGroupName, ResourcePolicy = ResourcePolicy)
  output <- .sagemaker$put_model_package_group_policy_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$put_model_package_group_policy <- sagemaker_put_model_package_group_policy

#' Use this action to inspect your lineage and discover relationships
#' between entities
#'
#' @description
#' Use this action to inspect your lineage and discover relationships between entities. For more information, see [Querying Lineage Entities](https://docs.aws.amazon.com/sagemaker/latest/dg/querying-lineage-entities.html) in the *Amazon SageMaker Developer Guide*.
#'
#' See [https://paws-r.github.io/docs/sagemaker/query_lineage.html](https://paws-r.github.io/docs/sagemaker/query_lineage.html) for full documentation.
#'
#' @param StartArns A list of resource Amazon Resource Name (ARN) that represent the
#' starting point for your lineage query.
#' @param Direction Associations between lineage entities have a direction. This parameter
#' determines the direction from the StartArn(s) that the query traverses.
#' @param IncludeEdges Setting this value to `True` retrieves not only the entities of interest
#' but also the
#' [Associations](https://docs.aws.amazon.com/sagemaker/latest/dg/lineage-tracking-entities.html)
#' and lineage entities on the path. Set to `False` to only return lineage
#' entities that match your query.
#' @param Filters A set of filtering parameters that allow you to specify which entities
#' should be returned.
#' 
#' -   Properties - Key-value pairs to match on the lineage entities'
#'     properties.
#' 
#' -   LineageTypes - A set of lineage entity types to match on. For
#'     example: `TrialComponent`, `Artifact`, or `Context`.
#' 
#' -   CreatedBefore - Filter entities created before this date.
#' 
#' -   ModifiedBefore - Filter entities modified before this date.
#' 
#' -   ModifiedAfter - Filter entities modified after this date.
#' @param MaxDepth The maximum depth in lineage relationships from the `StartArns` that are
#' traversed. Depth is a measure of the number of `Associations` from the
#' `StartArn` entity to the matched results.
#' @param MaxResults Limits the number of vertices in the results. Use the `NextToken` in a
#' response to to retrieve the next page of results.
#' @param NextToken Limits the number of vertices in the request. Use the `NextToken` in a
#' response to to retrieve the next page of results.
#'
#' @keywords internal
#'
#' @rdname sagemaker_query_lineage
sagemaker_query_lineage <- function(StartArns = NULL, Direction = NULL, IncludeEdges = NULL, Filters = NULL, MaxDepth = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "QueryLineage",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$query_lineage_input(StartArns = StartArns, Direction = Direction, IncludeEdges = IncludeEdges, Filters = Filters, MaxDepth = MaxDepth, MaxResults = MaxResults, NextToken = NextToken)
  output <- .sagemaker$query_lineage_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$query_lineage <- sagemaker_query_lineage

#' Register devices
#'
#' @description
#' Register devices.
#'
#' See [https://paws-r.github.io/docs/sagemaker/register_devices.html](https://paws-r.github.io/docs/sagemaker/register_devices.html) for full documentation.
#'
#' @param DeviceFleetName &#91;required&#93; The name of the fleet.
#' @param Devices &#91;required&#93; A list of devices to register with SageMaker Edge Manager.
#' @param Tags The tags associated with devices.
#'
#' @keywords internal
#'
#' @rdname sagemaker_register_devices
sagemaker_register_devices <- function(DeviceFleetName, Devices, Tags = NULL) {
  op <- new_operation(
    name = "RegisterDevices",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$register_devices_input(DeviceFleetName = DeviceFleetName, Devices = Devices, Tags = Tags)
  output <- .sagemaker$register_devices_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$register_devices <- sagemaker_register_devices

#' Renders the UI template so that you can preview the worker's experience
#'
#' @description
#' Renders the UI template so that you can preview the worker's experience.
#'
#' See [https://paws-r.github.io/docs/sagemaker/render_ui_template.html](https://paws-r.github.io/docs/sagemaker/render_ui_template.html) for full documentation.
#'
#' @param UiTemplate A `Template` object containing the worker UI template to render.
#' @param Task &#91;required&#93; A `RenderableTask` object containing a representative task to render.
#' @param RoleArn &#91;required&#93; The Amazon Resource Name (ARN) that has access to the S3 objects that
#' are used by the template.
#' @param HumanTaskUiArn The `HumanTaskUiArn` of the worker UI that you want to render. Do not
#' provide a `HumanTaskUiArn` if you use the `UiTemplate` parameter.
#' 
#' See a list of available Human Ui Amazon Resource Names (ARNs) in
#' UiConfig.
#'
#' @keywords internal
#'
#' @rdname sagemaker_render_ui_template
sagemaker_render_ui_template <- function(UiTemplate = NULL, Task, RoleArn, HumanTaskUiArn = NULL) {
  op <- new_operation(
    name = "RenderUiTemplate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$render_ui_template_input(UiTemplate = UiTemplate, Task = Task, RoleArn = RoleArn, HumanTaskUiArn = HumanTaskUiArn)
  output <- .sagemaker$render_ui_template_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$render_ui_template <- sagemaker_render_ui_template

#' Retry the execution of the pipeline
#'
#' @description
#' Retry the execution of the pipeline.
#'
#' See [https://paws-r.github.io/docs/sagemaker/retry_pipeline_execution.html](https://paws-r.github.io/docs/sagemaker/retry_pipeline_execution.html) for full documentation.
#'
#' @param PipelineExecutionArn &#91;required&#93; The Amazon Resource Name (ARN) of the pipeline execution.
#' @param ClientRequestToken &#91;required&#93; A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the operation. An idempotent operation completes no more
#' than once.
#' @param ParallelismConfiguration This configuration, if specified, overrides the parallelism
#' configuration of the parent pipeline.
#'
#' @keywords internal
#'
#' @rdname sagemaker_retry_pipeline_execution
sagemaker_retry_pipeline_execution <- function(PipelineExecutionArn, ClientRequestToken, ParallelismConfiguration = NULL) {
  op <- new_operation(
    name = "RetryPipelineExecution",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$retry_pipeline_execution_input(PipelineExecutionArn = PipelineExecutionArn, ClientRequestToken = ClientRequestToken, ParallelismConfiguration = ParallelismConfiguration)
  output <- .sagemaker$retry_pipeline_execution_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$retry_pipeline_execution <- sagemaker_retry_pipeline_execution

#' Finds Amazon SageMaker resources that match a search query
#'
#' @description
#' Finds Amazon SageMaker resources that match a search query. Matching resources are returned as a list of `SearchRecord` objects in the response. You can sort the search results by any resource property in a ascending or descending order.
#'
#' See [https://paws-r.github.io/docs/sagemaker/search.html](https://paws-r.github.io/docs/sagemaker/search.html) for full documentation.
#'
#' @param Resource &#91;required&#93; The name of the Amazon SageMaker resource to search for.
#' @param SearchExpression A Boolean conditional statement. Resources must satisfy this condition
#' to be included in search results. You must provide at least one
#' subexpression, filter, or nested filter. The maximum number of recursive
#' `SubExpressions`, `NestedFilters`, and `Filters` that can be included in
#' a `SearchExpression` object is 50.
#' @param SortBy The name of the resource property used to sort the `SearchResults`. The
#' default is `LastModifiedTime`.
#' @param SortOrder How `SearchResults` are ordered. Valid values are `Ascending` or
#' `Descending`. The default is `Descending`.
#' @param NextToken If more than `MaxResults` resources match the specified
#' `SearchExpression`, the response includes a `NextToken`. The `NextToken`
#' can be passed to the next `SearchRequest` to continue retrieving
#' results.
#' @param MaxResults The maximum number of results to return.
#'
#' @keywords internal
#'
#' @rdname sagemaker_search
sagemaker_search <- function(Resource, SearchExpression = NULL, SortBy = NULL, SortOrder = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "Search",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$search_input(Resource = Resource, SearchExpression = SearchExpression, SortBy = SortBy, SortOrder = SortOrder, NextToken = NextToken, MaxResults = MaxResults)
  output <- .sagemaker$search_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$search <- sagemaker_search

#' Notifies the pipeline that the execution of a callback step failed,
#' along with a message describing why
#'
#' @description
#' Notifies the pipeline that the execution of a callback step failed, along with a message describing why. When a callback step is run, the pipeline generates a callback token and includes the token in a message sent to Amazon Simple Queue Service (Amazon SQS).
#'
#' See [https://paws-r.github.io/docs/sagemaker/send_pipeline_execution_step_failure.html](https://paws-r.github.io/docs/sagemaker/send_pipeline_execution_step_failure.html) for full documentation.
#'
#' @param CallbackToken &#91;required&#93; The pipeline generated token from the Amazon SQS queue.
#' @param FailureReason A message describing why the step failed.
#' @param ClientRequestToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the operation. An idempotent operation completes no more
#' than one time.
#'
#' @keywords internal
#'
#' @rdname sagemaker_send_pipeline_execution_step_failure
sagemaker_send_pipeline_execution_step_failure <- function(CallbackToken, FailureReason = NULL, ClientRequestToken = NULL) {
  op <- new_operation(
    name = "SendPipelineExecutionStepFailure",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$send_pipeline_execution_step_failure_input(CallbackToken = CallbackToken, FailureReason = FailureReason, ClientRequestToken = ClientRequestToken)
  output <- .sagemaker$send_pipeline_execution_step_failure_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$send_pipeline_execution_step_failure <- sagemaker_send_pipeline_execution_step_failure

#' Notifies the pipeline that the execution of a callback step succeeded
#' and provides a list of the step's output parameters
#'
#' @description
#' Notifies the pipeline that the execution of a callback step succeeded and provides a list of the step's output parameters. When a callback step is run, the pipeline generates a callback token and includes the token in a message sent to Amazon Simple Queue Service (Amazon SQS).
#'
#' See [https://paws-r.github.io/docs/sagemaker/send_pipeline_execution_step_success.html](https://paws-r.github.io/docs/sagemaker/send_pipeline_execution_step_success.html) for full documentation.
#'
#' @param CallbackToken &#91;required&#93; The pipeline generated token from the Amazon SQS queue.
#' @param OutputParameters A list of the output parameters of the callback step.
#' @param ClientRequestToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the operation. An idempotent operation completes no more
#' than one time.
#'
#' @keywords internal
#'
#' @rdname sagemaker_send_pipeline_execution_step_success
sagemaker_send_pipeline_execution_step_success <- function(CallbackToken, OutputParameters = NULL, ClientRequestToken = NULL) {
  op <- new_operation(
    name = "SendPipelineExecutionStepSuccess",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$send_pipeline_execution_step_success_input(CallbackToken = CallbackToken, OutputParameters = OutputParameters, ClientRequestToken = ClientRequestToken)
  output <- .sagemaker$send_pipeline_execution_step_success_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$send_pipeline_execution_step_success <- sagemaker_send_pipeline_execution_step_success

#' Starts a stage in an edge deployment plan
#'
#' @description
#' Starts a stage in an edge deployment plan.
#'
#' See [https://paws-r.github.io/docs/sagemaker/start_edge_deployment_stage.html](https://paws-r.github.io/docs/sagemaker/start_edge_deployment_stage.html) for full documentation.
#'
#' @param EdgeDeploymentPlanName &#91;required&#93; The name of the edge deployment plan to start.
#' @param StageName &#91;required&#93; The name of the stage to start.
#'
#' @keywords internal
#'
#' @rdname sagemaker_start_edge_deployment_stage
sagemaker_start_edge_deployment_stage <- function(EdgeDeploymentPlanName, StageName) {
  op <- new_operation(
    name = "StartEdgeDeploymentStage",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$start_edge_deployment_stage_input(EdgeDeploymentPlanName = EdgeDeploymentPlanName, StageName = StageName)
  output <- .sagemaker$start_edge_deployment_stage_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$start_edge_deployment_stage <- sagemaker_start_edge_deployment_stage

#' Starts a previously stopped monitoring schedule
#'
#' @description
#' Starts a previously stopped monitoring schedule.
#'
#' See [https://paws-r.github.io/docs/sagemaker/start_monitoring_schedule.html](https://paws-r.github.io/docs/sagemaker/start_monitoring_schedule.html) for full documentation.
#'
#' @param MonitoringScheduleName &#91;required&#93; The name of the schedule to start.
#'
#' @keywords internal
#'
#' @rdname sagemaker_start_monitoring_schedule
sagemaker_start_monitoring_schedule <- function(MonitoringScheduleName) {
  op <- new_operation(
    name = "StartMonitoringSchedule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$start_monitoring_schedule_input(MonitoringScheduleName = MonitoringScheduleName)
  output <- .sagemaker$start_monitoring_schedule_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$start_monitoring_schedule <- sagemaker_start_monitoring_schedule

#' Launches an ML compute instance with the latest version of the libraries
#' and attaches your ML storage volume
#'
#' @description
#' Launches an ML compute instance with the latest version of the libraries and attaches your ML storage volume. After configuring the notebook instance, SageMaker sets the notebook instance status to `InService`. A notebook instance's status must be `InService` before you can connect to your Jupyter notebook.
#'
#' See [https://paws-r.github.io/docs/sagemaker/start_notebook_instance.html](https://paws-r.github.io/docs/sagemaker/start_notebook_instance.html) for full documentation.
#'
#' @param NotebookInstanceName &#91;required&#93; The name of the notebook instance to start.
#'
#' @keywords internal
#'
#' @rdname sagemaker_start_notebook_instance
sagemaker_start_notebook_instance <- function(NotebookInstanceName) {
  op <- new_operation(
    name = "StartNotebookInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$start_notebook_instance_input(NotebookInstanceName = NotebookInstanceName)
  output <- .sagemaker$start_notebook_instance_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$start_notebook_instance <- sagemaker_start_notebook_instance

#' Starts a pipeline execution
#'
#' @description
#' Starts a pipeline execution.
#'
#' See [https://paws-r.github.io/docs/sagemaker/start_pipeline_execution.html](https://paws-r.github.io/docs/sagemaker/start_pipeline_execution.html) for full documentation.
#'
#' @param PipelineName &#91;required&#93; The name of the pipeline.
#' @param PipelineExecutionDisplayName The display name of the pipeline execution.
#' @param PipelineParameters Contains a list of pipeline parameters. This list can be empty.
#' @param PipelineExecutionDescription The description of the pipeline execution.
#' @param ClientRequestToken &#91;required&#93; A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the operation. An idempotent operation completes no more
#' than once.
#' @param ParallelismConfiguration This configuration, if specified, overrides the parallelism
#' configuration of the parent pipeline for this specific run.
#'
#' @keywords internal
#'
#' @rdname sagemaker_start_pipeline_execution
sagemaker_start_pipeline_execution <- function(PipelineName, PipelineExecutionDisplayName = NULL, PipelineParameters = NULL, PipelineExecutionDescription = NULL, ClientRequestToken, ParallelismConfiguration = NULL) {
  op <- new_operation(
    name = "StartPipelineExecution",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$start_pipeline_execution_input(PipelineName = PipelineName, PipelineExecutionDisplayName = PipelineExecutionDisplayName, PipelineParameters = PipelineParameters, PipelineExecutionDescription = PipelineExecutionDescription, ClientRequestToken = ClientRequestToken, ParallelismConfiguration = ParallelismConfiguration)
  output <- .sagemaker$start_pipeline_execution_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$start_pipeline_execution <- sagemaker_start_pipeline_execution

#' A method for forcing the termination of a running job
#'
#' @description
#' A method for forcing the termination of a running job.
#'
#' See [https://paws-r.github.io/docs/sagemaker/stop_auto_ml_job.html](https://paws-r.github.io/docs/sagemaker/stop_auto_ml_job.html) for full documentation.
#'
#' @param AutoMLJobName &#91;required&#93; The name of the object you are requesting.
#'
#' @keywords internal
#'
#' @rdname sagemaker_stop_auto_ml_job
sagemaker_stop_auto_ml_job <- function(AutoMLJobName) {
  op <- new_operation(
    name = "StopAutoMLJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$stop_auto_ml_job_input(AutoMLJobName = AutoMLJobName)
  output <- .sagemaker$stop_auto_ml_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$stop_auto_ml_job <- sagemaker_stop_auto_ml_job

#' Stops a model compilation job
#'
#' @description
#' Stops a model compilation job.
#'
#' See [https://paws-r.github.io/docs/sagemaker/stop_compilation_job.html](https://paws-r.github.io/docs/sagemaker/stop_compilation_job.html) for full documentation.
#'
#' @param CompilationJobName &#91;required&#93; The name of the model compilation job to stop.
#'
#' @keywords internal
#'
#' @rdname sagemaker_stop_compilation_job
sagemaker_stop_compilation_job <- function(CompilationJobName) {
  op <- new_operation(
    name = "StopCompilationJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$stop_compilation_job_input(CompilationJobName = CompilationJobName)
  output <- .sagemaker$stop_compilation_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$stop_compilation_job <- sagemaker_stop_compilation_job

#' Stops a stage in an edge deployment plan
#'
#' @description
#' Stops a stage in an edge deployment plan.
#'
#' See [https://paws-r.github.io/docs/sagemaker/stop_edge_deployment_stage.html](https://paws-r.github.io/docs/sagemaker/stop_edge_deployment_stage.html) for full documentation.
#'
#' @param EdgeDeploymentPlanName &#91;required&#93; The name of the edge deployment plan to stop.
#' @param StageName &#91;required&#93; The name of the stage to stop.
#'
#' @keywords internal
#'
#' @rdname sagemaker_stop_edge_deployment_stage
sagemaker_stop_edge_deployment_stage <- function(EdgeDeploymentPlanName, StageName) {
  op <- new_operation(
    name = "StopEdgeDeploymentStage",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$stop_edge_deployment_stage_input(EdgeDeploymentPlanName = EdgeDeploymentPlanName, StageName = StageName)
  output <- .sagemaker$stop_edge_deployment_stage_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$stop_edge_deployment_stage <- sagemaker_stop_edge_deployment_stage

#' Request to stop an edge packaging job
#'
#' @description
#' Request to stop an edge packaging job.
#'
#' See [https://paws-r.github.io/docs/sagemaker/stop_edge_packaging_job.html](https://paws-r.github.io/docs/sagemaker/stop_edge_packaging_job.html) for full documentation.
#'
#' @param EdgePackagingJobName &#91;required&#93; The name of the edge packaging job.
#'
#' @keywords internal
#'
#' @rdname sagemaker_stop_edge_packaging_job
sagemaker_stop_edge_packaging_job <- function(EdgePackagingJobName) {
  op <- new_operation(
    name = "StopEdgePackagingJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$stop_edge_packaging_job_input(EdgePackagingJobName = EdgePackagingJobName)
  output <- .sagemaker$stop_edge_packaging_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$stop_edge_packaging_job <- sagemaker_stop_edge_packaging_job

#' Stops a running hyperparameter tuning job and all running training jobs
#' that the tuning job launched
#'
#' @description
#' Stops a running hyperparameter tuning job and all running training jobs that the tuning job launched.
#'
#' See [https://paws-r.github.io/docs/sagemaker/stop_hyper_parameter_tuning_job.html](https://paws-r.github.io/docs/sagemaker/stop_hyper_parameter_tuning_job.html) for full documentation.
#'
#' @param HyperParameterTuningJobName &#91;required&#93; The name of the tuning job to stop.
#'
#' @keywords internal
#'
#' @rdname sagemaker_stop_hyper_parameter_tuning_job
sagemaker_stop_hyper_parameter_tuning_job <- function(HyperParameterTuningJobName) {
  op <- new_operation(
    name = "StopHyperParameterTuningJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$stop_hyper_parameter_tuning_job_input(HyperParameterTuningJobName = HyperParameterTuningJobName)
  output <- .sagemaker$stop_hyper_parameter_tuning_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$stop_hyper_parameter_tuning_job <- sagemaker_stop_hyper_parameter_tuning_job

#' Stops an Inference Recommender job
#'
#' @description
#' Stops an Inference Recommender job.
#'
#' See [https://paws-r.github.io/docs/sagemaker/stop_inference_recommendations_job.html](https://paws-r.github.io/docs/sagemaker/stop_inference_recommendations_job.html) for full documentation.
#'
#' @param JobName &#91;required&#93; The name of the job you want to stop.
#'
#' @keywords internal
#'
#' @rdname sagemaker_stop_inference_recommendations_job
sagemaker_stop_inference_recommendations_job <- function(JobName) {
  op <- new_operation(
    name = "StopInferenceRecommendationsJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$stop_inference_recommendations_job_input(JobName = JobName)
  output <- .sagemaker$stop_inference_recommendations_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$stop_inference_recommendations_job <- sagemaker_stop_inference_recommendations_job

#' Stops a running labeling job
#'
#' @description
#' Stops a running labeling job. A job that is stopped cannot be restarted. Any results obtained before the job is stopped are placed in the Amazon S3 output bucket.
#'
#' See [https://paws-r.github.io/docs/sagemaker/stop_labeling_job.html](https://paws-r.github.io/docs/sagemaker/stop_labeling_job.html) for full documentation.
#'
#' @param LabelingJobName &#91;required&#93; The name of the labeling job to stop.
#'
#' @keywords internal
#'
#' @rdname sagemaker_stop_labeling_job
sagemaker_stop_labeling_job <- function(LabelingJobName) {
  op <- new_operation(
    name = "StopLabelingJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$stop_labeling_job_input(LabelingJobName = LabelingJobName)
  output <- .sagemaker$stop_labeling_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$stop_labeling_job <- sagemaker_stop_labeling_job

#' Stops a previously started monitoring schedule
#'
#' @description
#' Stops a previously started monitoring schedule.
#'
#' See [https://paws-r.github.io/docs/sagemaker/stop_monitoring_schedule.html](https://paws-r.github.io/docs/sagemaker/stop_monitoring_schedule.html) for full documentation.
#'
#' @param MonitoringScheduleName &#91;required&#93; The name of the schedule to stop.
#'
#' @keywords internal
#'
#' @rdname sagemaker_stop_monitoring_schedule
sagemaker_stop_monitoring_schedule <- function(MonitoringScheduleName) {
  op <- new_operation(
    name = "StopMonitoringSchedule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$stop_monitoring_schedule_input(MonitoringScheduleName = MonitoringScheduleName)
  output <- .sagemaker$stop_monitoring_schedule_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$stop_monitoring_schedule <- sagemaker_stop_monitoring_schedule

#' Terminates the ML compute instance
#'
#' @description
#' Terminates the ML compute instance. Before terminating the instance, SageMaker disconnects the ML storage volume from it. SageMaker preserves the ML storage volume. SageMaker stops charging you for the ML compute instance when you call [`stop_notebook_instance`][sagemaker_stop_notebook_instance].
#'
#' See [https://paws-r.github.io/docs/sagemaker/stop_notebook_instance.html](https://paws-r.github.io/docs/sagemaker/stop_notebook_instance.html) for full documentation.
#'
#' @param NotebookInstanceName &#91;required&#93; The name of the notebook instance to terminate.
#'
#' @keywords internal
#'
#' @rdname sagemaker_stop_notebook_instance
sagemaker_stop_notebook_instance <- function(NotebookInstanceName) {
  op <- new_operation(
    name = "StopNotebookInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$stop_notebook_instance_input(NotebookInstanceName = NotebookInstanceName)
  output <- .sagemaker$stop_notebook_instance_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$stop_notebook_instance <- sagemaker_stop_notebook_instance

#' Stops a pipeline execution
#'
#' @description
#' Stops a pipeline execution.
#'
#' See [https://paws-r.github.io/docs/sagemaker/stop_pipeline_execution.html](https://paws-r.github.io/docs/sagemaker/stop_pipeline_execution.html) for full documentation.
#'
#' @param PipelineExecutionArn &#91;required&#93; The Amazon Resource Name (ARN) of the pipeline execution.
#' @param ClientRequestToken &#91;required&#93; A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the operation. An idempotent operation completes no more
#' than once.
#'
#' @keywords internal
#'
#' @rdname sagemaker_stop_pipeline_execution
sagemaker_stop_pipeline_execution <- function(PipelineExecutionArn, ClientRequestToken) {
  op <- new_operation(
    name = "StopPipelineExecution",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$stop_pipeline_execution_input(PipelineExecutionArn = PipelineExecutionArn, ClientRequestToken = ClientRequestToken)
  output <- .sagemaker$stop_pipeline_execution_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$stop_pipeline_execution <- sagemaker_stop_pipeline_execution

#' Stops a processing job
#'
#' @description
#' Stops a processing job.
#'
#' See [https://paws-r.github.io/docs/sagemaker/stop_processing_job.html](https://paws-r.github.io/docs/sagemaker/stop_processing_job.html) for full documentation.
#'
#' @param ProcessingJobName &#91;required&#93; The name of the processing job to stop.
#'
#' @keywords internal
#'
#' @rdname sagemaker_stop_processing_job
sagemaker_stop_processing_job <- function(ProcessingJobName) {
  op <- new_operation(
    name = "StopProcessingJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$stop_processing_job_input(ProcessingJobName = ProcessingJobName)
  output <- .sagemaker$stop_processing_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$stop_processing_job <- sagemaker_stop_processing_job

#' Stops a training job
#'
#' @description
#' Stops a training job. To stop a job, SageMaker sends the algorithm the `SIGTERM` signal, which delays job termination for 120 seconds. Algorithms might use this 120-second window to save the model artifacts, so the results of the training is not lost.
#'
#' See [https://paws-r.github.io/docs/sagemaker/stop_training_job.html](https://paws-r.github.io/docs/sagemaker/stop_training_job.html) for full documentation.
#'
#' @param TrainingJobName &#91;required&#93; The name of the training job to stop.
#'
#' @keywords internal
#'
#' @rdname sagemaker_stop_training_job
sagemaker_stop_training_job <- function(TrainingJobName) {
  op <- new_operation(
    name = "StopTrainingJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$stop_training_job_input(TrainingJobName = TrainingJobName)
  output <- .sagemaker$stop_training_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$stop_training_job <- sagemaker_stop_training_job

#' Stops a batch transform job
#'
#' @description
#' Stops a batch transform job.
#'
#' See [https://paws-r.github.io/docs/sagemaker/stop_transform_job.html](https://paws-r.github.io/docs/sagemaker/stop_transform_job.html) for full documentation.
#'
#' @param TransformJobName &#91;required&#93; The name of the batch transform job to stop.
#'
#' @keywords internal
#'
#' @rdname sagemaker_stop_transform_job
sagemaker_stop_transform_job <- function(TransformJobName) {
  op <- new_operation(
    name = "StopTransformJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$stop_transform_job_input(TransformJobName = TransformJobName)
  output <- .sagemaker$stop_transform_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$stop_transform_job <- sagemaker_stop_transform_job

#' Updates an action
#'
#' @description
#' Updates an action.
#'
#' See [https://paws-r.github.io/docs/sagemaker/update_action.html](https://paws-r.github.io/docs/sagemaker/update_action.html) for full documentation.
#'
#' @param ActionName &#91;required&#93; The name of the action to update.
#' @param Description The new description for the action.
#' @param Status The new status for the action.
#' @param Properties The new list of properties. Overwrites the current property list.
#' @param PropertiesToRemove A list of properties to remove.
#'
#' @keywords internal
#'
#' @rdname sagemaker_update_action
sagemaker_update_action <- function(ActionName, Description = NULL, Status = NULL, Properties = NULL, PropertiesToRemove = NULL) {
  op <- new_operation(
    name = "UpdateAction",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$update_action_input(ActionName = ActionName, Description = Description, Status = Status, Properties = Properties, PropertiesToRemove = PropertiesToRemove)
  output <- .sagemaker$update_action_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$update_action <- sagemaker_update_action

#' Updates the properties of an AppImageConfig
#'
#' @description
#' Updates the properties of an AppImageConfig.
#'
#' See [https://paws-r.github.io/docs/sagemaker/update_app_image_config.html](https://paws-r.github.io/docs/sagemaker/update_app_image_config.html) for full documentation.
#'
#' @param AppImageConfigName &#91;required&#93; The name of the AppImageConfig to update.
#' @param KernelGatewayImageConfig The new KernelGateway app to run on the image.
#'
#' @keywords internal
#'
#' @rdname sagemaker_update_app_image_config
sagemaker_update_app_image_config <- function(AppImageConfigName, KernelGatewayImageConfig = NULL) {
  op <- new_operation(
    name = "UpdateAppImageConfig",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$update_app_image_config_input(AppImageConfigName = AppImageConfigName, KernelGatewayImageConfig = KernelGatewayImageConfig)
  output <- .sagemaker$update_app_image_config_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$update_app_image_config <- sagemaker_update_app_image_config

#' Updates an artifact
#'
#' @description
#' Updates an artifact.
#'
#' See [https://paws-r.github.io/docs/sagemaker/update_artifact.html](https://paws-r.github.io/docs/sagemaker/update_artifact.html) for full documentation.
#'
#' @param ArtifactArn &#91;required&#93; The Amazon Resource Name (ARN) of the artifact to update.
#' @param ArtifactName The new name for the artifact.
#' @param Properties The new list of properties. Overwrites the current property list.
#' @param PropertiesToRemove A list of properties to remove.
#'
#' @keywords internal
#'
#' @rdname sagemaker_update_artifact
sagemaker_update_artifact <- function(ArtifactArn, ArtifactName = NULL, Properties = NULL, PropertiesToRemove = NULL) {
  op <- new_operation(
    name = "UpdateArtifact",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$update_artifact_input(ArtifactArn = ArtifactArn, ArtifactName = ArtifactName, Properties = Properties, PropertiesToRemove = PropertiesToRemove)
  output <- .sagemaker$update_artifact_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$update_artifact <- sagemaker_update_artifact

#' Updates the specified Git repository with the specified values
#'
#' @description
#' Updates the specified Git repository with the specified values.
#'
#' See [https://paws-r.github.io/docs/sagemaker/update_code_repository.html](https://paws-r.github.io/docs/sagemaker/update_code_repository.html) for full documentation.
#'
#' @param CodeRepositoryName &#91;required&#93; The name of the Git repository to update.
#' @param GitConfig The configuration of the git repository, including the URL and the
#' Amazon Resource Name (ARN) of the Amazon Web Services Secrets Manager
#' secret that contains the credentials used to access the repository. The
#' secret must have a staging label of `AWSCURRENT` and must be in the
#' following format:
#' 
#' `{"username": UserName, "password": Password}`
#'
#' @keywords internal
#'
#' @rdname sagemaker_update_code_repository
sagemaker_update_code_repository <- function(CodeRepositoryName, GitConfig = NULL) {
  op <- new_operation(
    name = "UpdateCodeRepository",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$update_code_repository_input(CodeRepositoryName = CodeRepositoryName, GitConfig = GitConfig)
  output <- .sagemaker$update_code_repository_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$update_code_repository <- sagemaker_update_code_repository

#' Updates a context
#'
#' @description
#' Updates a context.
#'
#' See [https://paws-r.github.io/docs/sagemaker/update_context.html](https://paws-r.github.io/docs/sagemaker/update_context.html) for full documentation.
#'
#' @param ContextName &#91;required&#93; The name of the context to update.
#' @param Description The new description for the context.
#' @param Properties The new list of properties. Overwrites the current property list.
#' @param PropertiesToRemove A list of properties to remove.
#'
#' @keywords internal
#'
#' @rdname sagemaker_update_context
sagemaker_update_context <- function(ContextName, Description = NULL, Properties = NULL, PropertiesToRemove = NULL) {
  op <- new_operation(
    name = "UpdateContext",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$update_context_input(ContextName = ContextName, Description = Description, Properties = Properties, PropertiesToRemove = PropertiesToRemove)
  output <- .sagemaker$update_context_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$update_context <- sagemaker_update_context

#' Updates a fleet of devices
#'
#' @description
#' Updates a fleet of devices.
#'
#' See [https://paws-r.github.io/docs/sagemaker/update_device_fleet.html](https://paws-r.github.io/docs/sagemaker/update_device_fleet.html) for full documentation.
#'
#' @param DeviceFleetName &#91;required&#93; The name of the fleet.
#' @param RoleArn The Amazon Resource Name (ARN) of the device.
#' @param Description Description of the fleet.
#' @param OutputConfig &#91;required&#93; Output configuration for storing sample data collected by the fleet.
#' @param EnableIotRoleAlias Whether to create an Amazon Web Services IoT Role Alias during device
#' fleet creation. The name of the role alias generated will match this
#' pattern: "SageMakerEdge-\{DeviceFleetName\}".
#' 
#' For example, if your device fleet is called "demo-fleet", the name of
#' the role alias will be "SageMakerEdge-demo-fleet".
#'
#' @keywords internal
#'
#' @rdname sagemaker_update_device_fleet
sagemaker_update_device_fleet <- function(DeviceFleetName, RoleArn = NULL, Description = NULL, OutputConfig, EnableIotRoleAlias = NULL) {
  op <- new_operation(
    name = "UpdateDeviceFleet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$update_device_fleet_input(DeviceFleetName = DeviceFleetName, RoleArn = RoleArn, Description = Description, OutputConfig = OutputConfig, EnableIotRoleAlias = EnableIotRoleAlias)
  output <- .sagemaker$update_device_fleet_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$update_device_fleet <- sagemaker_update_device_fleet

#' Updates one or more devices in a fleet
#'
#' @description
#' Updates one or more devices in a fleet.
#'
#' See [https://paws-r.github.io/docs/sagemaker/update_devices.html](https://paws-r.github.io/docs/sagemaker/update_devices.html) for full documentation.
#'
#' @param DeviceFleetName &#91;required&#93; The name of the fleet the devices belong to.
#' @param Devices &#91;required&#93; List of devices to register with Edge Manager agent.
#'
#' @keywords internal
#'
#' @rdname sagemaker_update_devices
sagemaker_update_devices <- function(DeviceFleetName, Devices) {
  op <- new_operation(
    name = "UpdateDevices",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$update_devices_input(DeviceFleetName = DeviceFleetName, Devices = Devices)
  output <- .sagemaker$update_devices_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$update_devices <- sagemaker_update_devices

#' Updates the default settings for new user profiles in the domain
#'
#' @description
#' Updates the default settings for new user profiles in the domain.
#'
#' See [https://paws-r.github.io/docs/sagemaker/update_domain.html](https://paws-r.github.io/docs/sagemaker/update_domain.html) for full documentation.
#'
#' @param DomainId &#91;required&#93; The ID of the domain to be updated.
#' @param DefaultUserSettings A collection of settings.
#' @param DomainSettingsForUpdate A collection of `DomainSettings` configuration values to update.
#'
#' @keywords internal
#'
#' @rdname sagemaker_update_domain
sagemaker_update_domain <- function(DomainId, DefaultUserSettings = NULL, DomainSettingsForUpdate = NULL) {
  op <- new_operation(
    name = "UpdateDomain",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$update_domain_input(DomainId = DomainId, DefaultUserSettings = DefaultUserSettings, DomainSettingsForUpdate = DomainSettingsForUpdate)
  output <- .sagemaker$update_domain_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$update_domain <- sagemaker_update_domain

#' Deploys the new EndpointConfig specified in the request, switches to
#' using newly created endpoint, and then deletes resources provisioned for
#' the endpoint using the previous EndpointConfig (there is no availability
#' loss)
#'
#' @description
#' Deploys the new `EndpointConfig` specified in the request, switches to using newly created endpoint, and then deletes resources provisioned for the endpoint using the previous `EndpointConfig` (there is no availability loss).
#'
#' See [https://paws-r.github.io/docs/sagemaker/update_endpoint.html](https://paws-r.github.io/docs/sagemaker/update_endpoint.html) for full documentation.
#'
#' @param EndpointName &#91;required&#93; The name of the endpoint whose configuration you want to update.
#' @param EndpointConfigName &#91;required&#93; The name of the new endpoint configuration.
#' @param RetainAllVariantProperties When updating endpoint resources, enables or disables the retention of
#' [variant
#' properties](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_VariantProperty.html),
#' such as the instance count or the variant weight. To retain the variant
#' properties of an endpoint when updating it, set
#' `RetainAllVariantProperties` to `true`. To use the variant properties
#' specified in a new `EndpointConfig` call when updating an endpoint, set
#' `RetainAllVariantProperties` to `false`. The default is `false`.
#' @param ExcludeRetainedVariantProperties When you are updating endpoint resources with
#' UpdateEndpointInput$RetainAllVariantProperties, whose value is set to
#' `true`, `ExcludeRetainedVariantProperties` specifies the list of type
#' VariantProperty to override with the values provided by
#' `EndpointConfig`. If you don't specify a value for
#' `ExcludeAllVariantProperties`, no variant properties are overridden.
#' @param DeploymentConfig The deployment configuration for an endpoint, which contains the desired
#' deployment strategy and rollback configurations.
#' @param RetainDeploymentConfig Specifies whether to reuse the last deployment configuration. The
#' default value is false (the configuration is not reused).
#'
#' @keywords internal
#'
#' @rdname sagemaker_update_endpoint
sagemaker_update_endpoint <- function(EndpointName, EndpointConfigName, RetainAllVariantProperties = NULL, ExcludeRetainedVariantProperties = NULL, DeploymentConfig = NULL, RetainDeploymentConfig = NULL) {
  op <- new_operation(
    name = "UpdateEndpoint",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$update_endpoint_input(EndpointName = EndpointName, EndpointConfigName = EndpointConfigName, RetainAllVariantProperties = RetainAllVariantProperties, ExcludeRetainedVariantProperties = ExcludeRetainedVariantProperties, DeploymentConfig = DeploymentConfig, RetainDeploymentConfig = RetainDeploymentConfig)
  output <- .sagemaker$update_endpoint_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$update_endpoint <- sagemaker_update_endpoint

#' Updates variant weight of one or more variants associated with an
#' existing endpoint, or capacity of one variant associated with an
#' existing endpoint
#'
#' @description
#' Updates variant weight of one or more variants associated with an existing endpoint, or capacity of one variant associated with an existing endpoint. When it receives the request, SageMaker sets the endpoint status to `Updating`. After updating the endpoint, it sets the status to `InService`. To check the status of an endpoint, use the [`describe_endpoint`][sagemaker_describe_endpoint] API.
#'
#' See [https://paws-r.github.io/docs/sagemaker/update_endpoint_weights_and_capacities.html](https://paws-r.github.io/docs/sagemaker/update_endpoint_weights_and_capacities.html) for full documentation.
#'
#' @param EndpointName &#91;required&#93; The name of an existing SageMaker endpoint.
#' @param DesiredWeightsAndCapacities &#91;required&#93; An object that provides new capacity and weight values for a variant.
#'
#' @keywords internal
#'
#' @rdname sagemaker_update_endpoint_weights_and_capacities
sagemaker_update_endpoint_weights_and_capacities <- function(EndpointName, DesiredWeightsAndCapacities) {
  op <- new_operation(
    name = "UpdateEndpointWeightsAndCapacities",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$update_endpoint_weights_and_capacities_input(EndpointName = EndpointName, DesiredWeightsAndCapacities = DesiredWeightsAndCapacities)
  output <- .sagemaker$update_endpoint_weights_and_capacities_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$update_endpoint_weights_and_capacities <- sagemaker_update_endpoint_weights_and_capacities

#' Adds, updates, or removes the description of an experiment
#'
#' @description
#' Adds, updates, or removes the description of an experiment. Updates the display name of an experiment.
#'
#' See [https://paws-r.github.io/docs/sagemaker/update_experiment.html](https://paws-r.github.io/docs/sagemaker/update_experiment.html) for full documentation.
#'
#' @param ExperimentName &#91;required&#93; The name of the experiment to update.
#' @param DisplayName The name of the experiment as displayed. The name doesn't need to be
#' unique. If `DisplayName` isn't specified, `ExperimentName` is displayed.
#' @param Description The description of the experiment.
#'
#' @keywords internal
#'
#' @rdname sagemaker_update_experiment
sagemaker_update_experiment <- function(ExperimentName, DisplayName = NULL, Description = NULL) {
  op <- new_operation(
    name = "UpdateExperiment",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$update_experiment_input(ExperimentName = ExperimentName, DisplayName = DisplayName, Description = Description)
  output <- .sagemaker$update_experiment_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$update_experiment <- sagemaker_update_experiment

#' Updates the feature group
#'
#' @description
#' Updates the feature group.
#'
#' See [https://paws-r.github.io/docs/sagemaker/update_feature_group.html](https://paws-r.github.io/docs/sagemaker/update_feature_group.html) for full documentation.
#'
#' @param FeatureGroupName &#91;required&#93; The name of the feature group that you're updating.
#' @param FeatureAdditions Updates the feature group. Updating a feature group is an asynchronous
#' operation. When you get an HTTP 200 response, you've made a valid
#' request. It takes some time after you've made a valid request for
#' Feature Store to update the feature group.
#'
#' @keywords internal
#'
#' @rdname sagemaker_update_feature_group
sagemaker_update_feature_group <- function(FeatureGroupName, FeatureAdditions = NULL) {
  op <- new_operation(
    name = "UpdateFeatureGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$update_feature_group_input(FeatureGroupName = FeatureGroupName, FeatureAdditions = FeatureAdditions)
  output <- .sagemaker$update_feature_group_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$update_feature_group <- sagemaker_update_feature_group

#' Updates the description and parameters of the feature group
#'
#' @description
#' Updates the description and parameters of the feature group.
#'
#' See [https://paws-r.github.io/docs/sagemaker/update_feature_metadata.html](https://paws-r.github.io/docs/sagemaker/update_feature_metadata.html) for full documentation.
#'
#' @param FeatureGroupName &#91;required&#93; The name of the feature group containing the feature that you're
#' updating.
#' @param FeatureName &#91;required&#93; The name of the feature that you're updating.
#' @param Description A description that you can write to better describe the feature.
#' @param ParameterAdditions A list of key-value pairs that you can add to better describe the
#' feature.
#' @param ParameterRemovals A list of parameter keys that you can specify to remove parameters that
#' describe your feature.
#'
#' @keywords internal
#'
#' @rdname sagemaker_update_feature_metadata
sagemaker_update_feature_metadata <- function(FeatureGroupName, FeatureName, Description = NULL, ParameterAdditions = NULL, ParameterRemovals = NULL) {
  op <- new_operation(
    name = "UpdateFeatureMetadata",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$update_feature_metadata_input(FeatureGroupName = FeatureGroupName, FeatureName = FeatureName, Description = Description, ParameterAdditions = ParameterAdditions, ParameterRemovals = ParameterRemovals)
  output <- .sagemaker$update_feature_metadata_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$update_feature_metadata <- sagemaker_update_feature_metadata

#' Updates the properties of a SageMaker image
#'
#' @description
#' Updates the properties of a SageMaker image. To change the image's tags, use the [`add_tags`][sagemaker_add_tags] and [`delete_tags`][sagemaker_delete_tags] APIs.
#'
#' See [https://paws-r.github.io/docs/sagemaker/update_image.html](https://paws-r.github.io/docs/sagemaker/update_image.html) for full documentation.
#'
#' @param DeleteProperties A list of properties to delete. Only the `Description` and `DisplayName`
#' properties can be deleted.
#' @param Description The new description for the image.
#' @param DisplayName The new display name for the image.
#' @param ImageName &#91;required&#93; The name of the image to update.
#' @param RoleArn The new Amazon Resource Name (ARN) for the IAM role that enables Amazon
#' SageMaker to perform tasks on your behalf.
#'
#' @keywords internal
#'
#' @rdname sagemaker_update_image
sagemaker_update_image <- function(DeleteProperties = NULL, Description = NULL, DisplayName = NULL, ImageName, RoleArn = NULL) {
  op <- new_operation(
    name = "UpdateImage",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$update_image_input(DeleteProperties = DeleteProperties, Description = Description, DisplayName = DisplayName, ImageName = ImageName, RoleArn = RoleArn)
  output <- .sagemaker$update_image_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$update_image <- sagemaker_update_image

#' Updates a versioned model
#'
#' @description
#' Updates a versioned model.
#'
#' See [https://paws-r.github.io/docs/sagemaker/update_model_package.html](https://paws-r.github.io/docs/sagemaker/update_model_package.html) for full documentation.
#'
#' @param ModelPackageArn &#91;required&#93; The Amazon Resource Name (ARN) of the model package.
#' @param ModelApprovalStatus The approval status of the model.
#' @param ApprovalDescription A description for the approval status of the model.
#' @param CustomerMetadataProperties The metadata properties associated with the model package versions.
#' @param CustomerMetadataPropertiesToRemove The metadata properties associated with the model package versions to
#' remove.
#' @param AdditionalInferenceSpecificationsToAdd An array of additional Inference Specification objects to be added to
#' the existing array additional Inference Specification. Total number of
#' additional Inference Specifications can not exceed 15. Each additional
#' Inference Specification specifies artifacts based on this model package
#' that can be used on inference endpoints. Generally used with SageMaker
#' Neo to store the compiled artifacts.
#'
#' @keywords internal
#'
#' @rdname sagemaker_update_model_package
sagemaker_update_model_package <- function(ModelPackageArn, ModelApprovalStatus = NULL, ApprovalDescription = NULL, CustomerMetadataProperties = NULL, CustomerMetadataPropertiesToRemove = NULL, AdditionalInferenceSpecificationsToAdd = NULL) {
  op <- new_operation(
    name = "UpdateModelPackage",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$update_model_package_input(ModelPackageArn = ModelPackageArn, ModelApprovalStatus = ModelApprovalStatus, ApprovalDescription = ApprovalDescription, CustomerMetadataProperties = CustomerMetadataProperties, CustomerMetadataPropertiesToRemove = CustomerMetadataPropertiesToRemove, AdditionalInferenceSpecificationsToAdd = AdditionalInferenceSpecificationsToAdd)
  output <- .sagemaker$update_model_package_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$update_model_package <- sagemaker_update_model_package

#' Updates a previously created schedule
#'
#' @description
#' Updates a previously created schedule.
#'
#' See [https://paws-r.github.io/docs/sagemaker/update_monitoring_schedule.html](https://paws-r.github.io/docs/sagemaker/update_monitoring_schedule.html) for full documentation.
#'
#' @param MonitoringScheduleName &#91;required&#93; The name of the monitoring schedule. The name must be unique within an
#' Amazon Web Services Region within an Amazon Web Services account.
#' @param MonitoringScheduleConfig &#91;required&#93; The configuration object that specifies the monitoring schedule and
#' defines the monitoring job.
#'
#' @keywords internal
#'
#' @rdname sagemaker_update_monitoring_schedule
sagemaker_update_monitoring_schedule <- function(MonitoringScheduleName, MonitoringScheduleConfig) {
  op <- new_operation(
    name = "UpdateMonitoringSchedule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$update_monitoring_schedule_input(MonitoringScheduleName = MonitoringScheduleName, MonitoringScheduleConfig = MonitoringScheduleConfig)
  output <- .sagemaker$update_monitoring_schedule_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$update_monitoring_schedule <- sagemaker_update_monitoring_schedule

#' Updates a notebook instance
#'
#' @description
#' Updates a notebook instance. NotebookInstance updates include upgrading or downgrading the ML compute instance used for your notebook instance to accommodate changes in your workload requirements.
#'
#' See [https://paws-r.github.io/docs/sagemaker/update_notebook_instance.html](https://paws-r.github.io/docs/sagemaker/update_notebook_instance.html) for full documentation.
#'
#' @param NotebookInstanceName &#91;required&#93; The name of the notebook instance to update.
#' @param InstanceType The Amazon ML compute instance type.
#' @param RoleArn The Amazon Resource Name (ARN) of the IAM role that SageMaker can assume
#' to access the notebook instance. For more information, see [SageMaker
#' Roles](https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html).
#' 
#' To be able to pass this role to SageMaker, the caller of this API must
#' have the `iam:PassRole` permission.
#' @param LifecycleConfigName The name of a lifecycle configuration to associate with the notebook
#' instance. For information about lifestyle configurations, see [Step 2.1:
#' (Optional) Customize a Notebook
#' Instance](https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html).
#' @param DisassociateLifecycleConfig Set to `true` to remove the notebook instance lifecycle configuration
#' currently associated with the notebook instance. This operation is
#' idempotent. If you specify a lifecycle configuration that is not
#' associated with the notebook instance when you call this method, it does
#' not throw an error.
#' @param VolumeSizeInGB The size, in GB, of the ML storage volume to attach to the notebook
#' instance. The default value is 5 GB. ML storage volumes are encrypted,
#' so SageMaker can't determine the amount of available free space on the
#' volume. Because of this, you can increase the volume size when you
#' update a notebook instance, but you can't decrease the volume size. If
#' you want to decrease the size of the ML storage volume in use, create a
#' new notebook instance with the desired size.
#' @param DefaultCodeRepository The Git repository to associate with the notebook instance as its
#' default code repository. This can be either the name of a Git repository
#' stored as a resource in your account, or the URL of a Git repository in
#' [Amazon Web Services
#' CodeCommit](https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html)
#' or in any other Git repository. When you open a notebook instance, it
#' opens in the directory that contains this repository. For more
#' information, see [Associating Git Repositories with SageMaker Notebook
#' Instances](https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html).
#' @param AdditionalCodeRepositories An array of up to three Git repositories to associate with the notebook
#' instance. These can be either the names of Git repositories stored as
#' resources in your account, or the URL of Git repositories in [Amazon Web
#' Services
#' CodeCommit](https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html)
#' or in any other Git repository. These repositories are cloned at the
#' same level as the default repository of your notebook instance. For more
#' information, see [Associating Git Repositories with SageMaker Notebook
#' Instances](https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html).
#' @param AcceleratorTypes A list of the Elastic Inference (EI) instance types to associate with
#' this notebook instance. Currently only one EI instance type can be
#' associated with a notebook instance. For more information, see [Using
#' Elastic Inference in Amazon
#' SageMaker](https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html).
#' @param DisassociateAcceleratorTypes A list of the Elastic Inference (EI) instance types to remove from this
#' notebook instance. This operation is idempotent. If you specify an
#' accelerator type that is not associated with the notebook instance when
#' you call this method, it does not throw an error.
#' @param DisassociateDefaultCodeRepository The name or URL of the default Git repository to remove from this
#' notebook instance. This operation is idempotent. If you specify a Git
#' repository that is not associated with the notebook instance when you
#' call this method, it does not throw an error.
#' @param DisassociateAdditionalCodeRepositories A list of names or URLs of the default Git repositories to remove from
#' this notebook instance. This operation is idempotent. If you specify a
#' Git repository that is not associated with the notebook instance when
#' you call this method, it does not throw an error.
#' @param RootAccess Whether root access is enabled or disabled for users of the notebook
#' instance. The default value is `Enabled`.
#' 
#' If you set this to `Disabled`, users don't have root access on the
#' notebook instance, but lifecycle configuration scripts still run with
#' root permissions.
#' @param InstanceMetadataServiceConfiguration Information on the IMDS configuration of the notebook instance
#'
#' @keywords internal
#'
#' @rdname sagemaker_update_notebook_instance
sagemaker_update_notebook_instance <- function(NotebookInstanceName, InstanceType = NULL, RoleArn = NULL, LifecycleConfigName = NULL, DisassociateLifecycleConfig = NULL, VolumeSizeInGB = NULL, DefaultCodeRepository = NULL, AdditionalCodeRepositories = NULL, AcceleratorTypes = NULL, DisassociateAcceleratorTypes = NULL, DisassociateDefaultCodeRepository = NULL, DisassociateAdditionalCodeRepositories = NULL, RootAccess = NULL, InstanceMetadataServiceConfiguration = NULL) {
  op <- new_operation(
    name = "UpdateNotebookInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$update_notebook_instance_input(NotebookInstanceName = NotebookInstanceName, InstanceType = InstanceType, RoleArn = RoleArn, LifecycleConfigName = LifecycleConfigName, DisassociateLifecycleConfig = DisassociateLifecycleConfig, VolumeSizeInGB = VolumeSizeInGB, DefaultCodeRepository = DefaultCodeRepository, AdditionalCodeRepositories = AdditionalCodeRepositories, AcceleratorTypes = AcceleratorTypes, DisassociateAcceleratorTypes = DisassociateAcceleratorTypes, DisassociateDefaultCodeRepository = DisassociateDefaultCodeRepository, DisassociateAdditionalCodeRepositories = DisassociateAdditionalCodeRepositories, RootAccess = RootAccess, InstanceMetadataServiceConfiguration = InstanceMetadataServiceConfiguration)
  output <- .sagemaker$update_notebook_instance_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$update_notebook_instance <- sagemaker_update_notebook_instance

#' Updates a notebook instance lifecycle configuration created with the
#' CreateNotebookInstanceLifecycleConfig API
#'
#' @description
#' Updates a notebook instance lifecycle configuration created with the [`create_notebook_instance_lifecycle_config`][sagemaker_create_notebook_instance_lifecycle_config] API.
#'
#' See [https://paws-r.github.io/docs/sagemaker/update_notebook_instance_lifecycle_config.html](https://paws-r.github.io/docs/sagemaker/update_notebook_instance_lifecycle_config.html) for full documentation.
#'
#' @param NotebookInstanceLifecycleConfigName &#91;required&#93; The name of the lifecycle configuration.
#' @param OnCreate The shell script that runs only once, when you create a notebook
#' instance. The shell script must be a base64-encoded string.
#' @param OnStart The shell script that runs every time you start a notebook instance,
#' including when you create the notebook instance. The shell script must
#' be a base64-encoded string.
#'
#' @keywords internal
#'
#' @rdname sagemaker_update_notebook_instance_lifecycle_config
sagemaker_update_notebook_instance_lifecycle_config <- function(NotebookInstanceLifecycleConfigName, OnCreate = NULL, OnStart = NULL) {
  op <- new_operation(
    name = "UpdateNotebookInstanceLifecycleConfig",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$update_notebook_instance_lifecycle_config_input(NotebookInstanceLifecycleConfigName = NotebookInstanceLifecycleConfigName, OnCreate = OnCreate, OnStart = OnStart)
  output <- .sagemaker$update_notebook_instance_lifecycle_config_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$update_notebook_instance_lifecycle_config <- sagemaker_update_notebook_instance_lifecycle_config

#' Updates a pipeline
#'
#' @description
#' Updates a pipeline.
#'
#' See [https://paws-r.github.io/docs/sagemaker/update_pipeline.html](https://paws-r.github.io/docs/sagemaker/update_pipeline.html) for full documentation.
#'
#' @param PipelineName &#91;required&#93; The name of the pipeline to update.
#' @param PipelineDisplayName The display name of the pipeline.
#' @param PipelineDefinition The JSON pipeline definition.
#' @param PipelineDefinitionS3Location The location of the pipeline definition stored in Amazon S3. If
#' specified, SageMaker will retrieve the pipeline definition from this
#' location.
#' @param PipelineDescription The description of the pipeline.
#' @param RoleArn The Amazon Resource Name (ARN) that the pipeline uses to execute.
#' @param ParallelismConfiguration If specified, it applies to all executions of this pipeline by default.
#'
#' @keywords internal
#'
#' @rdname sagemaker_update_pipeline
sagemaker_update_pipeline <- function(PipelineName, PipelineDisplayName = NULL, PipelineDefinition = NULL, PipelineDefinitionS3Location = NULL, PipelineDescription = NULL, RoleArn = NULL, ParallelismConfiguration = NULL) {
  op <- new_operation(
    name = "UpdatePipeline",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$update_pipeline_input(PipelineName = PipelineName, PipelineDisplayName = PipelineDisplayName, PipelineDefinition = PipelineDefinition, PipelineDefinitionS3Location = PipelineDefinitionS3Location, PipelineDescription = PipelineDescription, RoleArn = RoleArn, ParallelismConfiguration = ParallelismConfiguration)
  output <- .sagemaker$update_pipeline_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$update_pipeline <- sagemaker_update_pipeline

#' Updates a pipeline execution
#'
#' @description
#' Updates a pipeline execution.
#'
#' See [https://paws-r.github.io/docs/sagemaker/update_pipeline_execution.html](https://paws-r.github.io/docs/sagemaker/update_pipeline_execution.html) for full documentation.
#'
#' @param PipelineExecutionArn &#91;required&#93; The Amazon Resource Name (ARN) of the pipeline execution.
#' @param PipelineExecutionDescription The description of the pipeline execution.
#' @param PipelineExecutionDisplayName The display name of the pipeline execution.
#' @param ParallelismConfiguration This configuration, if specified, overrides the parallelism
#' configuration of the parent pipeline for this specific run.
#'
#' @keywords internal
#'
#' @rdname sagemaker_update_pipeline_execution
sagemaker_update_pipeline_execution <- function(PipelineExecutionArn, PipelineExecutionDescription = NULL, PipelineExecutionDisplayName = NULL, ParallelismConfiguration = NULL) {
  op <- new_operation(
    name = "UpdatePipelineExecution",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$update_pipeline_execution_input(PipelineExecutionArn = PipelineExecutionArn, PipelineExecutionDescription = PipelineExecutionDescription, PipelineExecutionDisplayName = PipelineExecutionDisplayName, ParallelismConfiguration = ParallelismConfiguration)
  output <- .sagemaker$update_pipeline_execution_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$update_pipeline_execution <- sagemaker_update_pipeline_execution

#' Updates a machine learning (ML) project that is created from a template
#' that sets up an ML pipeline from training to deploying an approved model
#'
#' @description
#' Updates a machine learning (ML) project that is created from a template that sets up an ML pipeline from training to deploying an approved model.
#'
#' See [https://paws-r.github.io/docs/sagemaker/update_project.html](https://paws-r.github.io/docs/sagemaker/update_project.html) for full documentation.
#'
#' @param ProjectName &#91;required&#93; The name of the project.
#' @param ProjectDescription The description for the project.
#' @param ServiceCatalogProvisioningUpdateDetails The product ID and provisioning artifact ID to provision a service
#' catalog. The provisioning artifact ID will default to the latest
#' provisioning artifact ID of the product, if you don't provide the
#' provisioning artifact ID. For more information, see [What is Amazon Web
#' Services Service
#' Catalog](https://docs.aws.amazon.com/servicecatalog/latest/adminguide/introduction.html).
#' @param Tags An array of key-value pairs. You can use tags to categorize your Amazon
#' Web Services resources in different ways, for example, by purpose,
#' owner, or environment. For more information, see [Tagging Amazon Web
#' Services
#' Resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html).
#' In addition, the project must have tag update constraints set in order
#' to include this parameter in the request. For more information, see
#' [Amazon Web Services Service Catalog Tag Update
#' Constraints](https://docs.aws.amazon.com/servicecatalog/latest/adminguide/constraints-resourceupdate.html).
#'
#' @keywords internal
#'
#' @rdname sagemaker_update_project
sagemaker_update_project <- function(ProjectName, ProjectDescription = NULL, ServiceCatalogProvisioningUpdateDetails = NULL, Tags = NULL) {
  op <- new_operation(
    name = "UpdateProject",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$update_project_input(ProjectName = ProjectName, ProjectDescription = ProjectDescription, ServiceCatalogProvisioningUpdateDetails = ServiceCatalogProvisioningUpdateDetails, Tags = Tags)
  output <- .sagemaker$update_project_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$update_project <- sagemaker_update_project

#' Update a model training job to request a new Debugger profiling
#' configuration
#'
#' @description
#' Update a model training job to request a new Debugger profiling configuration.
#'
#' See [https://paws-r.github.io/docs/sagemaker/update_training_job.html](https://paws-r.github.io/docs/sagemaker/update_training_job.html) for full documentation.
#'
#' @param TrainingJobName &#91;required&#93; The name of a training job to update the Debugger profiling
#' configuration.
#' @param ProfilerConfig Configuration information for Debugger system monitoring, framework
#' profiling, and storage paths.
#' @param ProfilerRuleConfigurations Configuration information for Debugger rules for profiling system and
#' framework metrics.
#'
#' @keywords internal
#'
#' @rdname sagemaker_update_training_job
sagemaker_update_training_job <- function(TrainingJobName, ProfilerConfig = NULL, ProfilerRuleConfigurations = NULL) {
  op <- new_operation(
    name = "UpdateTrainingJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$update_training_job_input(TrainingJobName = TrainingJobName, ProfilerConfig = ProfilerConfig, ProfilerRuleConfigurations = ProfilerRuleConfigurations)
  output <- .sagemaker$update_training_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$update_training_job <- sagemaker_update_training_job

#' Updates the display name of a trial
#'
#' @description
#' Updates the display name of a trial.
#'
#' See [https://paws-r.github.io/docs/sagemaker/update_trial.html](https://paws-r.github.io/docs/sagemaker/update_trial.html) for full documentation.
#'
#' @param TrialName &#91;required&#93; The name of the trial to update.
#' @param DisplayName The name of the trial as displayed. The name doesn't need to be unique.
#' If `DisplayName` isn't specified, `TrialName` is displayed.
#'
#' @keywords internal
#'
#' @rdname sagemaker_update_trial
sagemaker_update_trial <- function(TrialName, DisplayName = NULL) {
  op <- new_operation(
    name = "UpdateTrial",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$update_trial_input(TrialName = TrialName, DisplayName = DisplayName)
  output <- .sagemaker$update_trial_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$update_trial <- sagemaker_update_trial

#' Updates one or more properties of a trial component
#'
#' @description
#' Updates one or more properties of a trial component.
#'
#' See [https://paws-r.github.io/docs/sagemaker/update_trial_component.html](https://paws-r.github.io/docs/sagemaker/update_trial_component.html) for full documentation.
#'
#' @param TrialComponentName &#91;required&#93; The name of the component to update.
#' @param DisplayName The name of the component as displayed. The name doesn't need to be
#' unique. If `DisplayName` isn't specified, `TrialComponentName` is
#' displayed.
#' @param Status The new status of the component.
#' @param StartTime When the component started.
#' @param EndTime When the component ended.
#' @param Parameters Replaces all of the component's hyperparameters with the specified
#' hyperparameters.
#' @param ParametersToRemove The hyperparameters to remove from the component.
#' @param InputArtifacts Replaces all of the component's input artifacts with the specified
#' artifacts.
#' @param InputArtifactsToRemove The input artifacts to remove from the component.
#' @param OutputArtifacts Replaces all of the component's output artifacts with the specified
#' artifacts.
#' @param OutputArtifactsToRemove The output artifacts to remove from the component.
#'
#' @keywords internal
#'
#' @rdname sagemaker_update_trial_component
sagemaker_update_trial_component <- function(TrialComponentName, DisplayName = NULL, Status = NULL, StartTime = NULL, EndTime = NULL, Parameters = NULL, ParametersToRemove = NULL, InputArtifacts = NULL, InputArtifactsToRemove = NULL, OutputArtifacts = NULL, OutputArtifactsToRemove = NULL) {
  op <- new_operation(
    name = "UpdateTrialComponent",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$update_trial_component_input(TrialComponentName = TrialComponentName, DisplayName = DisplayName, Status = Status, StartTime = StartTime, EndTime = EndTime, Parameters = Parameters, ParametersToRemove = ParametersToRemove, InputArtifacts = InputArtifacts, InputArtifactsToRemove = InputArtifactsToRemove, OutputArtifacts = OutputArtifacts, OutputArtifactsToRemove = OutputArtifactsToRemove)
  output <- .sagemaker$update_trial_component_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$update_trial_component <- sagemaker_update_trial_component

#' Updates a user profile
#'
#' @description
#' Updates a user profile.
#'
#' See [https://paws-r.github.io/docs/sagemaker/update_user_profile.html](https://paws-r.github.io/docs/sagemaker/update_user_profile.html) for full documentation.
#'
#' @param DomainId &#91;required&#93; The domain ID.
#' @param UserProfileName &#91;required&#93; The user profile name.
#' @param UserSettings A collection of settings.
#'
#' @keywords internal
#'
#' @rdname sagemaker_update_user_profile
sagemaker_update_user_profile <- function(DomainId, UserProfileName, UserSettings = NULL) {
  op <- new_operation(
    name = "UpdateUserProfile",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$update_user_profile_input(DomainId = DomainId, UserProfileName = UserProfileName, UserSettings = UserSettings)
  output <- .sagemaker$update_user_profile_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$update_user_profile <- sagemaker_update_user_profile

#' Use this operation to update your workforce
#'
#' @description
#' Use this operation to update your workforce. You can use this operation to require that workers use specific IP addresses to work on tasks and to update your OpenID Connect (OIDC) Identity Provider (IdP) workforce configuration.
#'
#' See [https://paws-r.github.io/docs/sagemaker/update_workforce.html](https://paws-r.github.io/docs/sagemaker/update_workforce.html) for full documentation.
#'
#' @param WorkforceName &#91;required&#93; The name of the private workforce that you want to update. You can find
#' your workforce name by using the operation.
#' @param SourceIpConfig A list of one to ten worker IP address ranges
#' ([CIDRs](https://docs.aws.amazon.com/vpc/latest/userguide/how-it-works.html))
#' that can be used to access tasks assigned to this workforce.
#' 
#' Maximum: Ten CIDR values
#' @param OidcConfig Use this parameter to update your OIDC Identity Provider (IdP)
#' configuration for a workforce made using your own IdP.
#' @param WorkforceVpcConfig Use this parameter to update your VPC configuration for a workforce.
#'
#' @keywords internal
#'
#' @rdname sagemaker_update_workforce
sagemaker_update_workforce <- function(WorkforceName, SourceIpConfig = NULL, OidcConfig = NULL, WorkforceVpcConfig = NULL) {
  op <- new_operation(
    name = "UpdateWorkforce",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$update_workforce_input(WorkforceName = WorkforceName, SourceIpConfig = SourceIpConfig, OidcConfig = OidcConfig, WorkforceVpcConfig = WorkforceVpcConfig)
  output <- .sagemaker$update_workforce_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$update_workforce <- sagemaker_update_workforce

#' Updates an existing work team with new member definitions or description
#'
#' @description
#' Updates an existing work team with new member definitions or description.
#'
#' See [https://paws-r.github.io/docs/sagemaker/update_workteam.html](https://paws-r.github.io/docs/sagemaker/update_workteam.html) for full documentation.
#'
#' @param WorkteamName &#91;required&#93; The name of the work team to update.
#' @param MemberDefinitions A list of `MemberDefinition` objects that contains objects that identify
#' the workers that make up the work team.
#' 
#' Workforces can be created using Amazon Cognito or your own OIDC Identity
#' Provider (IdP). For private workforces created using Amazon Cognito use
#' `CognitoMemberDefinition`. For workforces created using your own OIDC
#' identity provider (IdP) use `OidcMemberDefinition`. You should not
#' provide input for both of these parameters in a single request.
#' 
#' For workforces created using Amazon Cognito, private work teams
#' correspond to Amazon Cognito *user groups* within the user pool used to
#' create a workforce. All of the `CognitoMemberDefinition` objects that
#' make up the member definition must have the same `ClientId` and
#' `UserPool` values. To add a Amazon Cognito user group to an existing
#' worker pool, see Adding groups to a User Pool. For more information
#' about user pools, see [Amazon Cognito User
#' Pools](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html).
#' 
#' For workforces created using your own OIDC IdP, specify the user groups
#' that you want to include in your private work team in
#' `OidcMemberDefinition` by listing those groups in `Groups`. Be aware
#' that user groups that are already in the work team must also be listed
#' in `Groups` when you make this request to remain on the work team. If
#' you do not include these user groups, they will no longer be associated
#' with the work team you update.
#' @param Description An updated description for the work team.
#' @param NotificationConfiguration Configures SNS topic notifications for available or expiring work items
#'
#' @keywords internal
#'
#' @rdname sagemaker_update_workteam
sagemaker_update_workteam <- function(WorkteamName, MemberDefinitions = NULL, Description = NULL, NotificationConfiguration = NULL) {
  op <- new_operation(
    name = "UpdateWorkteam",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$update_workteam_input(WorkteamName = WorkteamName, MemberDefinitions = MemberDefinitions, Description = Description, NotificationConfiguration = NotificationConfiguration)
  output <- .sagemaker$update_workteam_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$update_workteam <- sagemaker_update_workteam
