% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comprehend_operations.R
\name{comprehend_create_endpoint}
\alias{comprehend_create_endpoint}
\title{Creates a model-specific endpoint for synchronous inference for a
previously trained custom model For information about endpoints, see
Managing endpoints}
\usage{
comprehend_create_endpoint(
  EndpointName,
  ModelArn,
  DesiredInferenceUnits,
  ClientRequestToken = NULL,
  Tags = NULL,
  DataAccessRoleArn = NULL
)
}
\arguments{
\item{EndpointName}{[required] This is the descriptive suffix that becomes part of the \code{EndpointArn}
used for all subsequent requests to this resource.}

\item{ModelArn}{[required] The Amazon Resource Number (ARN) of the model to which the endpoint will
be attached.}

\item{DesiredInferenceUnits}{[required] The desired number of inference units to be used by the model using this
endpoint. Each inference unit represents of a throughput of 100
characters per second.}

\item{ClientRequestToken}{An idempotency token provided by the customer. If this token matches a
previous endpoint creation request, Amazon Comprehend will not return a
\code{ResourceInUseException}.}

\item{Tags}{Tags associated with the endpoint being created. A tag is a key-value
pair that adds metadata to the endpoint. For example, a tag with "Sales"
as the key might be added to an endpoint to indicate its use by the
sales department.}

\item{DataAccessRoleArn}{The Amazon Resource Name (ARN) of the AWS identity and Access Management
(IAM) role that grants Amazon Comprehend read access to trained custom
models encrypted with a customer managed key (ModelKmsKeyId).}
}
\description{
Creates a model-specific endpoint for synchronous inference for a previously trained custom model For information about endpoints, see \href{https://docs.aws.amazon.com/comprehend/latest/dg/manage-endpoints.html}{Managing endpoints}.

See \url{https://paws-r.github.io/docs/comprehend/create_endpoint.html} for full documentation.
}
\keyword{internal}
