% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rekognition_operations.R
\name{rekognition_detect_faces}
\alias{rekognition_detect_faces}
\title{Detects faces within an image that is provided as input}
\usage{
rekognition_detect_faces(Image, Attributes = NULL)
}
\arguments{
\item{Image}{[required] The input image as base64-encoded bytes or an S3 object. If you use the
AWS CLI to call Amazon Rekognition operations, passing base64-encoded
image bytes is not supported.

If you are using an AWS SDK to call Amazon Rekognition, you might not
need to base64-encode image bytes passed using the \code{Bytes} field. For
more information, see Images in the Amazon Rekognition developer guide.}

\item{Attributes}{An array of facial attributes you want to be returned. This can be the
default list of attributes or all attributes. If you don't specify a
value for \code{Attributes} or if you specify \verb{["DEFAULT"]}, the API returns
the following subset of facial attributes: \code{BoundingBox}, \code{Confidence},
\code{Pose}, \code{Quality}, and \code{Landmarks}. If you provide \verb{["ALL"]}, all facial
attributes are returned, but the operation takes longer to complete.

If you provide both, \verb{["ALL", "DEFAULT"]}, the service uses a logical
AND operator to determine which attributes to return (in this case, all
attributes).}
}
\description{
Detects faces within an image that is provided as input.

See \url{https://paws-r.github.io/docs/rekognition/detect_faces.html} for full documentation.
}
\keyword{internal}
