% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forecastservice_operations.R
\name{forecastservice_list_what_if_analyses}
\alias{forecastservice_list_what_if_analyses}
\title{Returns a list of what-if analyses created using the
CreateWhatIfAnalysis operation}
\usage{
forecastservice_list_what_if_analyses(
  NextToken = NULL,
  MaxResults = NULL,
  Filters = NULL
)
}
\arguments{
\item{NextToken}{If the result of the previous request was truncated, the response
includes a \code{NextToken}. To retrieve the next set of results, use the
token in the next request. Tokens expire after 24 hours.}

\item{MaxResults}{The number of items to return in the response.}

\item{Filters}{An array of filters. For each filter, you provide a condition and a
match statement. The condition is either \code{IS} or \code{IS_NOT}, which
specifies whether to include or exclude the what-if analysis jobs that
match the statement from the list, respectively. The match statement
consists of a key and a value.

\strong{Filter properties}
\itemize{
\item \code{Condition} - The condition to apply. Valid values are \code{IS} and
\code{IS_NOT}. To include the what-if analysis jobs that match the
statement, specify \code{IS}. To exclude matching what-if analysis jobs,
specify \code{IS_NOT}.
\item \code{Key} - The name of the parameter to filter on. Valid values are
\code{WhatIfAnalysisArn} and \code{Status}.
\item \code{Value} - The value to match.
}

For example, to list all jobs that export a forecast named
\emph{electricityWhatIf}, specify the following filter:

\verb{"Filters": [ \{ "Condition": "IS", "Key": "WhatIfAnalysisArn", "Value": "arn:aws:forecast:us-west-2:<acct-id>:forecast/electricityWhatIf" \} ]}}
}
\description{
Returns a list of what-if analyses created using the \code{\link[=forecastservice_create_what_if_analysis]{create_what_if_analysis}} operation. For each what-if analysis, this operation returns a summary of its properties, including its Amazon Resource Name (ARN). You can retrieve the complete set of properties by using the what-if analysis ARN with the \code{\link[=forecastservice_describe_what_if_analysis]{describe_what_if_analysis}} operation.

See \url{https://www.paws-r-sdk.com/docs/forecastservice_list_what_if_analyses/} for full documentation.
}
\keyword{internal}
