% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frauddetector_operations.R
\name{frauddetector_put_event_type}
\alias{frauddetector_put_event_type}
\title{Creates or updates an event type}
\usage{
frauddetector_put_event_type(
  name,
  description = NULL,
  eventVariables,
  labels = NULL,
  entityTypes,
  eventIngestion = NULL,
  tags = NULL,
  eventOrchestration = NULL
)
}
\arguments{
\item{name}{[required] The name.}

\item{description}{The description of the event type.}

\item{eventVariables}{[required] The event type variables.}

\item{labels}{The event type labels.}

\item{entityTypes}{[required] The entity type for the event type. Example entity types: customer,
merchant, account.}

\item{eventIngestion}{Specifies if ingestion is enabled or disabled.}

\item{tags}{A collection of key and value pairs.}

\item{eventOrchestration}{Enables or disables event orchestration. If enabled, you can send event
predictions to select AWS services for downstream processing of the
events.}
}
\description{
Creates or updates an event type. An event is a business activity that is evaluated for fraud risk. With Amazon Fraud Detector, you generate fraud predictions for events. An event type defines the structure for an event sent to Amazon Fraud Detector. This includes the variables sent as part of the event, the entity performing the event (such as a customer), and the labels that classify the event. Example event types include online payment transactions, account registrations, and authentications.

See \url{https://www.paws-r-sdk.com/docs/frauddetector_put_event_type/} for full documentation.
}
\keyword{internal}
