% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frauddetector_operations.R
\name{frauddetector_create_batch_import_job}
\alias{frauddetector_create_batch_import_job}
\title{Creates a batch import job}
\usage{
frauddetector_create_batch_import_job(
  jobId,
  inputPath,
  outputPath,
  eventTypeName,
  iamRoleArn,
  tags = NULL
)
}
\arguments{
\item{jobId}{[required] The ID of the batch import job. The ID cannot be of a past job, unless
the job exists in \code{CREATE_FAILED} state.}

\item{inputPath}{[required] The URI that points to the Amazon S3 location of your data file.}

\item{outputPath}{[required] The URI that points to the Amazon S3 location for storing your results.}

\item{eventTypeName}{[required] The name of the event type.}

\item{iamRoleArn}{[required] The ARN of the IAM role created for Amazon S3 bucket that holds your
data file.

The IAM role must have read permissions to your input S3 bucket and
write permissions to your output S3 bucket. For more information about
bucket permissions, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/example-policies-s3.html}{User policy examples}
in the \emph{Amazon S3 User Guide}.}

\item{tags}{A collection of key-value pairs associated with this request.}
}
\description{
Creates a batch import job.

See \url{https://www.paws-r-sdk.com/docs/frauddetector_create_batch_import_job/} for full documentation.
}
\keyword{internal}
