% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lexmodelbuildingservice_operations.R
\name{lexmodelbuildingservice_start_migration}
\alias{lexmodelbuildingservice_start_migration}
\title{Starts migrating a bot from Amazon Lex V1 to Amazon Lex V2}
\usage{
lexmodelbuildingservice_start_migration(
  v1BotName,
  v1BotVersion,
  v2BotName,
  v2BotRole,
  migrationStrategy
)
}
\arguments{
\item{v1BotName}{[required] The name of the Amazon Lex V1 bot that you are migrating to Amazon Lex
V2.}

\item{v1BotVersion}{[required] The version of the bot to migrate to Amazon Lex V2. You can migrate the
\verb{$LATEST} version as well as any numbered version.}

\item{v2BotName}{[required] The name of the Amazon Lex V2 bot that you are migrating the Amazon Lex
V1 bot to.
\itemize{
\item If the Amazon Lex V2 bot doesn't exist, you must use the
\code{CREATE_NEW} migration strategy.
\item If the Amazon Lex V2 bot exists, you must use the \code{UPDATE_EXISTING}
migration strategy to change the contents of the Amazon Lex V2 bot.
}}

\item{v2BotRole}{[required] The IAM role that Amazon Lex uses to run the Amazon Lex V2 bot.}

\item{migrationStrategy}{[required] The strategy used to conduct the migration.
\itemize{
\item \code{CREATE_NEW} - Creates a new Amazon Lex V2 bot and migrates the
Amazon Lex V1 bot to the new bot.
\item \code{UPDATE_EXISTING} - Overwrites the existing Amazon Lex V2 bot
metadata and the locale being migrated. It doesn't change any other
locales in the Amazon Lex V2 bot. If the locale doesn't exist, a new
locale is created in the Amazon Lex V2 bot.
}}
}
\description{
Starts migrating a bot from Amazon Lex V1 to Amazon Lex V2. Migrate your bot when you want to take advantage of the new features of Amazon Lex V2.

See \url{https://www.paws-r-sdk.com/docs/lexmodelbuildingservice_start_migration/} for full documentation.
}
\keyword{internal}
