% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appmesh_operations.R
\name{appmesh_create_virtual_node}
\alias{appmesh_create_virtual_node}
\title{Creates a virtual node within a service mesh}
\usage{
appmesh_create_virtual_node(clientToken, meshName, spec, tags,
  virtualNodeName)
}
\arguments{
\item{clientToken}{Unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. Up to 36 letters, numbers, hyphens, and
underscores are allowed.}

\item{meshName}{[required] The name of the service mesh to create the virtual node in.}

\item{spec}{[required] The virtual node specification to apply.}

\item{tags}{Optional metadata that you can apply to the virtual node to assist with
categorization and organization. Each tag consists of a key and an
optional value, both of which you define. Tag keys can have a maximum
character length of 128 characters, and tag values can have a maximum
length of 256 characters.}

\item{virtualNodeName}{[required] The name to use for the virtual node.}
}
\description{
Creates a virtual node within a service mesh.
}
\details{
A virtual node acts as a logical pointer to a particular task group,
such as an Amazon ECS service or a Kubernetes deployment. When you
create a virtual node, you must specify the DNS service discovery
hostname for your task group.

Any inbound traffic that your virtual node expects should be specified
as a \code{listener}. Any outbound traffic that your virtual node expects to
reach should be specified as a \code{backend}.

The response metadata for your new virtual node contains the \code{arn} that
is associated with the virtual node. Set this value (either the full ARN
or the truncated resource name: for example,
\code{mesh/default/virtualNode/simpleapp}) as the \code{APPMESH_VIRTUAL_NODE_NAME}
environment variable for your task group's Envoy proxy container in
your task definition or pod spec. This is then mapped to the \code{node.id}
and \code{node.cluster} Envoy parameters.

If you require your Envoy stats or tracing to use a different name, you
can override the \code{node.cluster} value that is set by
\code{APPMESH_VIRTUAL_NODE_NAME} with the \code{APPMESH_VIRTUAL_NODE_CLUSTER}
environment variable.
}
\section{Request syntax}{
\preformatted{svc$create_virtual_node(
  clientToken = "string",
  meshName = "string",
  spec = list(
    backends = list(
      list(
        virtualService = list(
          virtualServiceName = "string"
        )
      )
    ),
    listeners = list(
      list(
        healthCheck = list(
          healthyThreshold = 123,
          intervalMillis = 123,
          path = "string",
          port = 123,
          protocol = "http"|"tcp",
          timeoutMillis = 123,
          unhealthyThreshold = 123
        ),
        portMapping = list(
          port = 123,
          protocol = "http"|"tcp"
        )
      )
    ),
    logging = list(
      accessLog = list(
        file = list(
          path = "string"
        )
      )
    ),
    serviceDiscovery = list(
      dns = list(
        hostname = "string"
      )
    )
  ),
  tags = list(
    list(
      key = "string",
      value = "string"
    )
  ),
  virtualNodeName = "string"
)
}
}

\keyword{internal}
