% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apigatewayv2_operations.R
\name{apigatewayv2_create_integration_response}
\alias{apigatewayv2_create_integration_response}
\title{Creates an IntegrationResponses}
\usage{
apigatewayv2_create_integration_response(ApiId, ContentHandlingStrategy,
  IntegrationId, IntegrationResponseKey, ResponseParameters,
  ResponseTemplates, TemplateSelectionExpression)
}
\arguments{
\item{ApiId}{[required] The API identifier.}

\item{ContentHandlingStrategy}{Specifies how to handle response payload content type conversions.
Supported values are CONVERT\\_TO\\_BINARY and CONVERT\\_TO\\_TEXT, with the
following behaviors:

CONVERT\\_TO\\_BINARY: Converts a response payload from a Base64-encoded
string to the corresponding binary blob.

CONVERT\\_TO\\_TEXT: Converts a response payload from a binary blob to a
Base64-encoded string.

If this property is not defined, the response payload will be passed
through from the integration response to the route response or method
response without modification.}

\item{IntegrationId}{[required] The integration ID.}

\item{IntegrationResponseKey}{[required] The integration response key.}

\item{ResponseParameters}{A key-value map specifying response parameters that are passed to the
method response from the backend. The key is a method response header
parameter name and the mapped value is an integration response header
value, a static value enclosed within a pair of single quotes, or a JSON
expression from the integration response body. The mapping key must
match the pattern of method.response.header.\{name\}, where \{name\} is a
valid and unique header name. The mapped non-static value must match the
pattern of integration.response.header.\{name\} or
integration.response.body.\{JSON-expression\}, where \{name\} is a valid and
unique response header name and \{JSON-expression\} is a valid JSON
expression without the $ prefix.}

\item{ResponseTemplates}{The collection of response templates for the integration response as a
string-to-string map of key-value pairs. Response templates are
represented as a key/value map, with a content-type as the key and a
template as the value.}

\item{TemplateSelectionExpression}{The template selection expression for the integration response.
Supported only for WebSocket APIs.}
}
\description{
Creates an IntegrationResponses.
}
\section{Request syntax}{
\preformatted{svc$create_integration_response(
  ApiId = "string",
  ContentHandlingStrategy = "CONVERT_TO_BINARY"|"CONVERT_TO_TEXT",
  IntegrationId = "string",
  IntegrationResponseKey = "string",
  ResponseParameters = list(
    "string"
  ),
  ResponseTemplates = list(
    "string"
  ),
  TemplateSelectionExpression = "string"
)
}
}

\keyword{internal}
