% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/servicediscovery_operations.R
\name{servicediscovery_discover_instances}
\alias{servicediscovery_discover_instances}
\title{Discovers registered instances for a specified namespace and service}
\usage{
servicediscovery_discover_instances(NamespaceName, ServiceName,
  MaxResults, QueryParameters, OptionalParameters, HealthStatus)
}
\arguments{
\item{NamespaceName}{[required] The name of the namespace that you specified when you registered the
instance.}

\item{ServiceName}{[required] The name of the service that you specified when you registered the
instance.}

\item{MaxResults}{The maximum number of instances that you want AWS Cloud Map to return in
the response to a \code{DiscoverInstances} request. If you don't specify a
value for \code{MaxResults}, AWS Cloud Map returns up to 100 instances.}

\item{QueryParameters}{Filters to scope the results based on custom attributes for the
instance. For example, \verb{\\\{version=v1, az=1a\\\}}. Only instances that match
all the specified key-value pairs will be returned.}

\item{OptionalParameters}{Opportunistic filters to scope the results based on custom attributes.
If there are instances that match both the filters specified in both the
\code{QueryParameters} parameter and this parameter, they are returned.
Otherwise, these filters are ignored and only instances that match the
filters specified in the \code{QueryParameters} parameter are returned.}

\item{HealthStatus}{The health status of the instances that you want to discover.}
}
\description{
Discovers registered instances for a specified namespace and service.
You can use \code{DiscoverInstances} to discover instances for any type of
namespace. For public and private DNS namespaces, you can also use DNS
queries to discover instances.
}
\section{Request syntax}{
\preformatted{svc$discover_instances(
  NamespaceName = "string",
  ServiceName = "string",
  MaxResults = 123,
  QueryParameters = list(
    "string"
  ),
  OptionalParameters = list(
    "string"
  ),
  HealthStatus = "HEALTHY"|"UNHEALTHY"|"ALL"
)
}
}

\examples{
\dontrun{
# Example: Discover registered instances
svc$discover_instances(
  HealthStatus = "ALL",
  MaxResults = 10L,
  NamespaceName = "example.com",
  ServiceName = "myservice"
)
}

}
\keyword{internal}
