% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route53resolver_operations.R
\name{route53resolver_disassociate_resolver_endpoint_ip_address}
\alias{route53resolver_disassociate_resolver_endpoint_ip_address}
\title{Removes IP addresses from an inbound or an outbound resolver endpoint}
\usage{
route53resolver_disassociate_resolver_endpoint_ip_address(
  ResolverEndpointId, IpAddress)
}
\arguments{
\item{ResolverEndpointId}{[required] The ID of the resolver endpoint that you want to disassociate an IP
address from.}

\item{IpAddress}{[required] The IPv4 address that you want to remove from a resolver endpoint.}
}
\description{
Removes IP addresses from an inbound or an outbound resolver endpoint.
If you want to remove more than one IP address, submit one
\code{DisassociateResolverEndpointIpAddress} request for each IP address.
}
\details{
To add an IP address to an endpoint, see
AssociateResolverEndpointIpAddress.
}
\section{Request syntax}{
\preformatted{svc$disassociate_resolver_endpoint_ip_address(
  ResolverEndpointId = "string",
  IpAddress = list(
    IpId = "string",
    SubnetId = "string",
    Ip = "string"
  )
)
}
}

\keyword{internal}
