% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appmesh_operations.R
\name{appmesh_list_routes}
\alias{appmesh_list_routes}
\title{Returns a list of existing routes in a service mesh}
\usage{
appmesh_list_routes(limit, meshName, nextToken, virtualRouterName)
}
\arguments{
\item{limit}{The maximum number of results returned by \code{ListRoutes} in paginated
output. When you use this parameter, \code{ListRoutes} returns only \code{limit}
results in a single page along with a \code{nextToken} response element. You
can see the remaining results of the initial request by sending another
\code{ListRoutes} request with the returned \code{nextToken} value. This value can
be between 1 and 100. If you don\'t use this parameter, \code{ListRoutes}
returns up to 100 results and a \code{nextToken} value if applicable.}

\item{meshName}{[required] The name of the service mesh to list routes in.}

\item{nextToken}{The \code{nextToken} value returned from a previous paginated \code{ListRoutes}
request where \code{limit} was used and the results exceeded the value of
that parameter. Pagination continues from the end of the previous
results that returned the \code{nextToken} value.}

\item{virtualRouterName}{[required] The name of the virtual router to list routes in.}
}
\description{
Returns a list of existing routes in a service mesh.
}
\section{Request syntax}{
\preformatted{svc$list_routes(
  limit = 123,
  meshName = "string",
  nextToken = "string",
  virtualRouterName = "string"
)
}
}

\keyword{internal}
