% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/directconnect_operations.R
\name{directconnect_create_connection}
\alias{directconnect_create_connection}
\title{Creates a connection between a customer network and a specific Direct
Connect location}
\usage{
directconnect_create_connection(
  location,
  bandwidth,
  connectionName,
  lagId = NULL,
  tags = NULL,
  providerName = NULL,
  requestMACSec = NULL
)
}
\arguments{
\item{location}{[required] The location of the connection.}

\item{bandwidth}{[required] The bandwidth of the connection.}

\item{connectionName}{[required] The name of the connection.}

\item{lagId}{The ID of the LAG.}

\item{tags}{The tags to associate with the lag.}

\item{providerName}{The name of the service provider associated with the requested
connection.}

\item{requestMACSec}{Indicates whether you want the connection to support MAC Security
(MACsec).

MAC Security (MACsec) is only available on dedicated connections. For
information about MAC Security (MACsec) prerequisties, see \href{https://docs.aws.amazon.com/directconnect/latest/UserGuide/direct-connect-mac-sec-getting-started.html#mac-sec-prerequisites}{MACsec prerequisties}
in the \emph{Direct Connect User Guide}.}
}
\description{
Creates a connection between a customer network and a specific Direct Connect location.

See \url{https://www.paws-r-sdk.com/docs/directconnect_create_connection/} for full documentation.
}
\keyword{internal}
