# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include appmesh_service.R
NULL

#' Creates a gateway route
#'
#' @description
#' Creates a gateway route.
#'
#' See [https://www.paws-r-sdk.com/docs/appmesh_create_gateway_route/](https://www.paws-r-sdk.com/docs/appmesh_create_gateway_route/) for full documentation.
#'
#' @param clientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. Up to 36 letters, numbers, hyphens, and
#' underscores are allowed.
#' @param gatewayRouteName &#91;required&#93; The name to use for the gateway route.
#' @param meshName &#91;required&#93; The name of the service mesh to create the gateway route in.
#' @param meshOwner The Amazon Web Services IAM account ID of the service mesh owner. If the
#' account ID is not your own, then the account that you specify must share
#' the mesh with your account before you can create the resource in the
#' service mesh. For more information about mesh sharing, see [Working with
#' shared
#' meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
#' @param spec &#91;required&#93; The gateway route specification to apply.
#' @param tags Optional metadata that you can apply to the gateway route to assist with
#' categorization and organization. Each tag consists of a key and an
#' optional value, both of which you define. Tag keys can have a maximum
#' character length of 128 characters, and tag values can have a maximum
#' length of 256 characters.
#' @param virtualGatewayName &#91;required&#93; The name of the virtual gateway to associate the gateway route with. If
#' the virtual gateway is in a shared mesh, then you must be the owner of
#' the virtual gateway resource.
#'
#' @keywords internal
#'
#' @rdname appmesh_create_gateway_route
appmesh_create_gateway_route <- function(clientToken = NULL, gatewayRouteName, meshName, meshOwner = NULL, spec, tags = NULL, virtualGatewayName) {
  op <- new_operation(
    name = "CreateGatewayRoute",
    http_method = "PUT",
    http_path = "/v20190125/meshes/{meshName}/virtualGateway/{virtualGatewayName}/gatewayRoutes",
    paginator = list()
  )
  input <- .appmesh$create_gateway_route_input(clientToken = clientToken, gatewayRouteName = gatewayRouteName, meshName = meshName, meshOwner = meshOwner, spec = spec, tags = tags, virtualGatewayName = virtualGatewayName)
  output <- .appmesh$create_gateway_route_output()
  config <- get_config()
  svc <- .appmesh$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appmesh$operations$create_gateway_route <- appmesh_create_gateway_route

#' Creates a service mesh
#'
#' @description
#' Creates a service mesh.
#'
#' See [https://www.paws-r-sdk.com/docs/appmesh_create_mesh/](https://www.paws-r-sdk.com/docs/appmesh_create_mesh/) for full documentation.
#'
#' @param clientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. Up to 36 letters, numbers, hyphens, and
#' underscores are allowed.
#' @param meshName &#91;required&#93; The name to use for the service mesh.
#' @param spec The service mesh specification to apply.
#' @param tags Optional metadata that you can apply to the service mesh to assist with
#' categorization and organization. Each tag consists of a key and an
#' optional value, both of which you define. Tag keys can have a maximum
#' character length of 128 characters, and tag values can have a maximum
#' length of 256 characters.
#'
#' @keywords internal
#'
#' @rdname appmesh_create_mesh
appmesh_create_mesh <- function(clientToken = NULL, meshName, spec = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateMesh",
    http_method = "PUT",
    http_path = "/v20190125/meshes",
    paginator = list()
  )
  input <- .appmesh$create_mesh_input(clientToken = clientToken, meshName = meshName, spec = spec, tags = tags)
  output <- .appmesh$create_mesh_output()
  config <- get_config()
  svc <- .appmesh$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appmesh$operations$create_mesh <- appmesh_create_mesh

#' Creates a route that is associated with a virtual router
#'
#' @description
#' Creates a route that is associated with a virtual router.
#'
#' See [https://www.paws-r-sdk.com/docs/appmesh_create_route/](https://www.paws-r-sdk.com/docs/appmesh_create_route/) for full documentation.
#'
#' @param clientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. Up to 36 letters, numbers, hyphens, and
#' underscores are allowed.
#' @param meshName &#91;required&#93; The name of the service mesh to create the route in.
#' @param meshOwner The Amazon Web Services IAM account ID of the service mesh owner. If the
#' account ID is not your own, then the account that you specify must share
#' the mesh with your account before you can create the resource in the
#' service mesh. For more information about mesh sharing, see [Working with
#' shared
#' meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
#' @param routeName &#91;required&#93; The name to use for the route.
#' @param spec &#91;required&#93; The route specification to apply.
#' @param tags Optional metadata that you can apply to the route to assist with
#' categorization and organization. Each tag consists of a key and an
#' optional value, both of which you define. Tag keys can have a maximum
#' character length of 128 characters, and tag values can have a maximum
#' length of 256 characters.
#' @param virtualRouterName &#91;required&#93; The name of the virtual router in which to create the route. If the
#' virtual router is in a shared mesh, then you must be the owner of the
#' virtual router resource.
#'
#' @keywords internal
#'
#' @rdname appmesh_create_route
appmesh_create_route <- function(clientToken = NULL, meshName, meshOwner = NULL, routeName, spec, tags = NULL, virtualRouterName) {
  op <- new_operation(
    name = "CreateRoute",
    http_method = "PUT",
    http_path = "/v20190125/meshes/{meshName}/virtualRouter/{virtualRouterName}/routes",
    paginator = list()
  )
  input <- .appmesh$create_route_input(clientToken = clientToken, meshName = meshName, meshOwner = meshOwner, routeName = routeName, spec = spec, tags = tags, virtualRouterName = virtualRouterName)
  output <- .appmesh$create_route_output()
  config <- get_config()
  svc <- .appmesh$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appmesh$operations$create_route <- appmesh_create_route

#' Creates a virtual gateway
#'
#' @description
#' Creates a virtual gateway.
#'
#' See [https://www.paws-r-sdk.com/docs/appmesh_create_virtual_gateway/](https://www.paws-r-sdk.com/docs/appmesh_create_virtual_gateway/) for full documentation.
#'
#' @param clientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. Up to 36 letters, numbers, hyphens, and
#' underscores are allowed.
#' @param meshName &#91;required&#93; The name of the service mesh to create the virtual gateway in.
#' @param meshOwner The Amazon Web Services IAM account ID of the service mesh owner. If the
#' account ID is not your own, then the account that you specify must share
#' the mesh with your account before you can create the resource in the
#' service mesh. For more information about mesh sharing, see [Working with
#' shared
#' meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
#' @param spec &#91;required&#93; The virtual gateway specification to apply.
#' @param tags Optional metadata that you can apply to the virtual gateway to assist
#' with categorization and organization. Each tag consists of a key and an
#' optional value, both of which you define. Tag keys can have a maximum
#' character length of 128 characters, and tag values can have a maximum
#' length of 256 characters.
#' @param virtualGatewayName &#91;required&#93; The name to use for the virtual gateway.
#'
#' @keywords internal
#'
#' @rdname appmesh_create_virtual_gateway
appmesh_create_virtual_gateway <- function(clientToken = NULL, meshName, meshOwner = NULL, spec, tags = NULL, virtualGatewayName) {
  op <- new_operation(
    name = "CreateVirtualGateway",
    http_method = "PUT",
    http_path = "/v20190125/meshes/{meshName}/virtualGateways",
    paginator = list()
  )
  input <- .appmesh$create_virtual_gateway_input(clientToken = clientToken, meshName = meshName, meshOwner = meshOwner, spec = spec, tags = tags, virtualGatewayName = virtualGatewayName)
  output <- .appmesh$create_virtual_gateway_output()
  config <- get_config()
  svc <- .appmesh$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appmesh$operations$create_virtual_gateway <- appmesh_create_virtual_gateway

#' Creates a virtual node within a service mesh
#'
#' @description
#' Creates a virtual node within a service mesh.
#'
#' See [https://www.paws-r-sdk.com/docs/appmesh_create_virtual_node/](https://www.paws-r-sdk.com/docs/appmesh_create_virtual_node/) for full documentation.
#'
#' @param clientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. Up to 36 letters, numbers, hyphens, and
#' underscores are allowed.
#' @param meshName &#91;required&#93; The name of the service mesh to create the virtual node in.
#' @param meshOwner The Amazon Web Services IAM account ID of the service mesh owner. If the
#' account ID is not your own, then the account that you specify must share
#' the mesh with your account before you can create the resource in the
#' service mesh. For more information about mesh sharing, see [Working with
#' shared
#' meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
#' @param spec &#91;required&#93; The virtual node specification to apply.
#' @param tags Optional metadata that you can apply to the virtual node to assist with
#' categorization and organization. Each tag consists of a key and an
#' optional value, both of which you define. Tag keys can have a maximum
#' character length of 128 characters, and tag values can have a maximum
#' length of 256 characters.
#' @param virtualNodeName &#91;required&#93; The name to use for the virtual node.
#'
#' @keywords internal
#'
#' @rdname appmesh_create_virtual_node
appmesh_create_virtual_node <- function(clientToken = NULL, meshName, meshOwner = NULL, spec, tags = NULL, virtualNodeName) {
  op <- new_operation(
    name = "CreateVirtualNode",
    http_method = "PUT",
    http_path = "/v20190125/meshes/{meshName}/virtualNodes",
    paginator = list()
  )
  input <- .appmesh$create_virtual_node_input(clientToken = clientToken, meshName = meshName, meshOwner = meshOwner, spec = spec, tags = tags, virtualNodeName = virtualNodeName)
  output <- .appmesh$create_virtual_node_output()
  config <- get_config()
  svc <- .appmesh$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appmesh$operations$create_virtual_node <- appmesh_create_virtual_node

#' Creates a virtual router within a service mesh
#'
#' @description
#' Creates a virtual router within a service mesh.
#'
#' See [https://www.paws-r-sdk.com/docs/appmesh_create_virtual_router/](https://www.paws-r-sdk.com/docs/appmesh_create_virtual_router/) for full documentation.
#'
#' @param clientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. Up to 36 letters, numbers, hyphens, and
#' underscores are allowed.
#' @param meshName &#91;required&#93; The name of the service mesh to create the virtual router in.
#' @param meshOwner The Amazon Web Services IAM account ID of the service mesh owner. If the
#' account ID is not your own, then the account that you specify must share
#' the mesh with your account before you can create the resource in the
#' service mesh. For more information about mesh sharing, see [Working with
#' shared
#' meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
#' @param spec &#91;required&#93; The virtual router specification to apply.
#' @param tags Optional metadata that you can apply to the virtual router to assist
#' with categorization and organization. Each tag consists of a key and an
#' optional value, both of which you define. Tag keys can have a maximum
#' character length of 128 characters, and tag values can have a maximum
#' length of 256 characters.
#' @param virtualRouterName &#91;required&#93; The name to use for the virtual router.
#'
#' @keywords internal
#'
#' @rdname appmesh_create_virtual_router
appmesh_create_virtual_router <- function(clientToken = NULL, meshName, meshOwner = NULL, spec, tags = NULL, virtualRouterName) {
  op <- new_operation(
    name = "CreateVirtualRouter",
    http_method = "PUT",
    http_path = "/v20190125/meshes/{meshName}/virtualRouters",
    paginator = list()
  )
  input <- .appmesh$create_virtual_router_input(clientToken = clientToken, meshName = meshName, meshOwner = meshOwner, spec = spec, tags = tags, virtualRouterName = virtualRouterName)
  output <- .appmesh$create_virtual_router_output()
  config <- get_config()
  svc <- .appmesh$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appmesh$operations$create_virtual_router <- appmesh_create_virtual_router

#' Creates a virtual service within a service mesh
#'
#' @description
#' Creates a virtual service within a service mesh.
#'
#' See [https://www.paws-r-sdk.com/docs/appmesh_create_virtual_service/](https://www.paws-r-sdk.com/docs/appmesh_create_virtual_service/) for full documentation.
#'
#' @param clientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. Up to 36 letters, numbers, hyphens, and
#' underscores are allowed.
#' @param meshName &#91;required&#93; The name of the service mesh to create the virtual service in.
#' @param meshOwner The Amazon Web Services IAM account ID of the service mesh owner. If the
#' account ID is not your own, then the account that you specify must share
#' the mesh with your account before you can create the resource in the
#' service mesh. For more information about mesh sharing, see [Working with
#' shared
#' meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
#' @param spec &#91;required&#93; The virtual service specification to apply.
#' @param tags Optional metadata that you can apply to the virtual service to assist
#' with categorization and organization. Each tag consists of a key and an
#' optional value, both of which you define. Tag keys can have a maximum
#' character length of 128 characters, and tag values can have a maximum
#' length of 256 characters.
#' @param virtualServiceName &#91;required&#93; The name to use for the virtual service.
#'
#' @keywords internal
#'
#' @rdname appmesh_create_virtual_service
appmesh_create_virtual_service <- function(clientToken = NULL, meshName, meshOwner = NULL, spec, tags = NULL, virtualServiceName) {
  op <- new_operation(
    name = "CreateVirtualService",
    http_method = "PUT",
    http_path = "/v20190125/meshes/{meshName}/virtualServices",
    paginator = list()
  )
  input <- .appmesh$create_virtual_service_input(clientToken = clientToken, meshName = meshName, meshOwner = meshOwner, spec = spec, tags = tags, virtualServiceName = virtualServiceName)
  output <- .appmesh$create_virtual_service_output()
  config <- get_config()
  svc <- .appmesh$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appmesh$operations$create_virtual_service <- appmesh_create_virtual_service

#' Deletes an existing gateway route
#'
#' @description
#' Deletes an existing gateway route.
#'
#' See [https://www.paws-r-sdk.com/docs/appmesh_delete_gateway_route/](https://www.paws-r-sdk.com/docs/appmesh_delete_gateway_route/) for full documentation.
#'
#' @param gatewayRouteName &#91;required&#93; The name of the gateway route to delete.
#' @param meshName &#91;required&#93; The name of the service mesh to delete the gateway route from.
#' @param meshOwner The Amazon Web Services IAM account ID of the service mesh owner. If the
#' account ID is not your own, then it's the ID of the account that shared
#' the mesh with your account. For more information about mesh sharing, see
#' [Working with shared
#' meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
#' @param virtualGatewayName &#91;required&#93; The name of the virtual gateway to delete the route from.
#'
#' @keywords internal
#'
#' @rdname appmesh_delete_gateway_route
appmesh_delete_gateway_route <- function(gatewayRouteName, meshName, meshOwner = NULL, virtualGatewayName) {
  op <- new_operation(
    name = "DeleteGatewayRoute",
    http_method = "DELETE",
    http_path = "/v20190125/meshes/{meshName}/virtualGateway/{virtualGatewayName}/gatewayRoutes/{gatewayRouteName}",
    paginator = list()
  )
  input <- .appmesh$delete_gateway_route_input(gatewayRouteName = gatewayRouteName, meshName = meshName, meshOwner = meshOwner, virtualGatewayName = virtualGatewayName)
  output <- .appmesh$delete_gateway_route_output()
  config <- get_config()
  svc <- .appmesh$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appmesh$operations$delete_gateway_route <- appmesh_delete_gateway_route

#' Deletes an existing service mesh
#'
#' @description
#' Deletes an existing service mesh.
#'
#' See [https://www.paws-r-sdk.com/docs/appmesh_delete_mesh/](https://www.paws-r-sdk.com/docs/appmesh_delete_mesh/) for full documentation.
#'
#' @param meshName &#91;required&#93; The name of the service mesh to delete.
#'
#' @keywords internal
#'
#' @rdname appmesh_delete_mesh
appmesh_delete_mesh <- function(meshName) {
  op <- new_operation(
    name = "DeleteMesh",
    http_method = "DELETE",
    http_path = "/v20190125/meshes/{meshName}",
    paginator = list()
  )
  input <- .appmesh$delete_mesh_input(meshName = meshName)
  output <- .appmesh$delete_mesh_output()
  config <- get_config()
  svc <- .appmesh$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appmesh$operations$delete_mesh <- appmesh_delete_mesh

#' Deletes an existing route
#'
#' @description
#' Deletes an existing route.
#'
#' See [https://www.paws-r-sdk.com/docs/appmesh_delete_route/](https://www.paws-r-sdk.com/docs/appmesh_delete_route/) for full documentation.
#'
#' @param meshName &#91;required&#93; The name of the service mesh to delete the route in.
#' @param meshOwner The Amazon Web Services IAM account ID of the service mesh owner. If the
#' account ID is not your own, then it's the ID of the account that shared
#' the mesh with your account. For more information about mesh sharing, see
#' [Working with shared
#' meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
#' @param routeName &#91;required&#93; The name of the route to delete.
#' @param virtualRouterName &#91;required&#93; The name of the virtual router to delete the route in.
#'
#' @keywords internal
#'
#' @rdname appmesh_delete_route
appmesh_delete_route <- function(meshName, meshOwner = NULL, routeName, virtualRouterName) {
  op <- new_operation(
    name = "DeleteRoute",
    http_method = "DELETE",
    http_path = "/v20190125/meshes/{meshName}/virtualRouter/{virtualRouterName}/routes/{routeName}",
    paginator = list()
  )
  input <- .appmesh$delete_route_input(meshName = meshName, meshOwner = meshOwner, routeName = routeName, virtualRouterName = virtualRouterName)
  output <- .appmesh$delete_route_output()
  config <- get_config()
  svc <- .appmesh$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appmesh$operations$delete_route <- appmesh_delete_route

#' Deletes an existing virtual gateway
#'
#' @description
#' Deletes an existing virtual gateway. You cannot delete a virtual gateway if any gateway routes are associated to it.
#'
#' See [https://www.paws-r-sdk.com/docs/appmesh_delete_virtual_gateway/](https://www.paws-r-sdk.com/docs/appmesh_delete_virtual_gateway/) for full documentation.
#'
#' @param meshName &#91;required&#93; The name of the service mesh to delete the virtual gateway from.
#' @param meshOwner The Amazon Web Services IAM account ID of the service mesh owner. If the
#' account ID is not your own, then it's the ID of the account that shared
#' the mesh with your account. For more information about mesh sharing, see
#' [Working with shared
#' meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
#' @param virtualGatewayName &#91;required&#93; The name of the virtual gateway to delete.
#'
#' @keywords internal
#'
#' @rdname appmesh_delete_virtual_gateway
appmesh_delete_virtual_gateway <- function(meshName, meshOwner = NULL, virtualGatewayName) {
  op <- new_operation(
    name = "DeleteVirtualGateway",
    http_method = "DELETE",
    http_path = "/v20190125/meshes/{meshName}/virtualGateways/{virtualGatewayName}",
    paginator = list()
  )
  input <- .appmesh$delete_virtual_gateway_input(meshName = meshName, meshOwner = meshOwner, virtualGatewayName = virtualGatewayName)
  output <- .appmesh$delete_virtual_gateway_output()
  config <- get_config()
  svc <- .appmesh$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appmesh$operations$delete_virtual_gateway <- appmesh_delete_virtual_gateway

#' Deletes an existing virtual node
#'
#' @description
#' Deletes an existing virtual node.
#'
#' See [https://www.paws-r-sdk.com/docs/appmesh_delete_virtual_node/](https://www.paws-r-sdk.com/docs/appmesh_delete_virtual_node/) for full documentation.
#'
#' @param meshName &#91;required&#93; The name of the service mesh to delete the virtual node in.
#' @param meshOwner The Amazon Web Services IAM account ID of the service mesh owner. If the
#' account ID is not your own, then it's the ID of the account that shared
#' the mesh with your account. For more information about mesh sharing, see
#' [Working with shared
#' meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
#' @param virtualNodeName &#91;required&#93; The name of the virtual node to delete.
#'
#' @keywords internal
#'
#' @rdname appmesh_delete_virtual_node
appmesh_delete_virtual_node <- function(meshName, meshOwner = NULL, virtualNodeName) {
  op <- new_operation(
    name = "DeleteVirtualNode",
    http_method = "DELETE",
    http_path = "/v20190125/meshes/{meshName}/virtualNodes/{virtualNodeName}",
    paginator = list()
  )
  input <- .appmesh$delete_virtual_node_input(meshName = meshName, meshOwner = meshOwner, virtualNodeName = virtualNodeName)
  output <- .appmesh$delete_virtual_node_output()
  config <- get_config()
  svc <- .appmesh$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appmesh$operations$delete_virtual_node <- appmesh_delete_virtual_node

#' Deletes an existing virtual router
#'
#' @description
#' Deletes an existing virtual router.
#'
#' See [https://www.paws-r-sdk.com/docs/appmesh_delete_virtual_router/](https://www.paws-r-sdk.com/docs/appmesh_delete_virtual_router/) for full documentation.
#'
#' @param meshName &#91;required&#93; The name of the service mesh to delete the virtual router in.
#' @param meshOwner The Amazon Web Services IAM account ID of the service mesh owner. If the
#' account ID is not your own, then it's the ID of the account that shared
#' the mesh with your account. For more information about mesh sharing, see
#' [Working with shared
#' meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
#' @param virtualRouterName &#91;required&#93; The name of the virtual router to delete.
#'
#' @keywords internal
#'
#' @rdname appmesh_delete_virtual_router
appmesh_delete_virtual_router <- function(meshName, meshOwner = NULL, virtualRouterName) {
  op <- new_operation(
    name = "DeleteVirtualRouter",
    http_method = "DELETE",
    http_path = "/v20190125/meshes/{meshName}/virtualRouters/{virtualRouterName}",
    paginator = list()
  )
  input <- .appmesh$delete_virtual_router_input(meshName = meshName, meshOwner = meshOwner, virtualRouterName = virtualRouterName)
  output <- .appmesh$delete_virtual_router_output()
  config <- get_config()
  svc <- .appmesh$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appmesh$operations$delete_virtual_router <- appmesh_delete_virtual_router

#' Deletes an existing virtual service
#'
#' @description
#' Deletes an existing virtual service.
#'
#' See [https://www.paws-r-sdk.com/docs/appmesh_delete_virtual_service/](https://www.paws-r-sdk.com/docs/appmesh_delete_virtual_service/) for full documentation.
#'
#' @param meshName &#91;required&#93; The name of the service mesh to delete the virtual service in.
#' @param meshOwner The Amazon Web Services IAM account ID of the service mesh owner. If the
#' account ID is not your own, then it's the ID of the account that shared
#' the mesh with your account. For more information about mesh sharing, see
#' [Working with shared
#' meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
#' @param virtualServiceName &#91;required&#93; The name of the virtual service to delete.
#'
#' @keywords internal
#'
#' @rdname appmesh_delete_virtual_service
appmesh_delete_virtual_service <- function(meshName, meshOwner = NULL, virtualServiceName) {
  op <- new_operation(
    name = "DeleteVirtualService",
    http_method = "DELETE",
    http_path = "/v20190125/meshes/{meshName}/virtualServices/{virtualServiceName}",
    paginator = list()
  )
  input <- .appmesh$delete_virtual_service_input(meshName = meshName, meshOwner = meshOwner, virtualServiceName = virtualServiceName)
  output <- .appmesh$delete_virtual_service_output()
  config <- get_config()
  svc <- .appmesh$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appmesh$operations$delete_virtual_service <- appmesh_delete_virtual_service

#' Describes an existing gateway route
#'
#' @description
#' Describes an existing gateway route.
#'
#' See [https://www.paws-r-sdk.com/docs/appmesh_describe_gateway_route/](https://www.paws-r-sdk.com/docs/appmesh_describe_gateway_route/) for full documentation.
#'
#' @param gatewayRouteName &#91;required&#93; The name of the gateway route to describe.
#' @param meshName &#91;required&#93; The name of the service mesh that the gateway route resides in.
#' @param meshOwner The Amazon Web Services IAM account ID of the service mesh owner. If the
#' account ID is not your own, then it's the ID of the account that shared
#' the mesh with your account. For more information about mesh sharing, see
#' [Working with shared
#' meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
#' @param virtualGatewayName &#91;required&#93; The name of the virtual gateway that the gateway route is associated
#' with.
#'
#' @keywords internal
#'
#' @rdname appmesh_describe_gateway_route
appmesh_describe_gateway_route <- function(gatewayRouteName, meshName, meshOwner = NULL, virtualGatewayName) {
  op <- new_operation(
    name = "DescribeGatewayRoute",
    http_method = "GET",
    http_path = "/v20190125/meshes/{meshName}/virtualGateway/{virtualGatewayName}/gatewayRoutes/{gatewayRouteName}",
    paginator = list()
  )
  input <- .appmesh$describe_gateway_route_input(gatewayRouteName = gatewayRouteName, meshName = meshName, meshOwner = meshOwner, virtualGatewayName = virtualGatewayName)
  output <- .appmesh$describe_gateway_route_output()
  config <- get_config()
  svc <- .appmesh$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appmesh$operations$describe_gateway_route <- appmesh_describe_gateway_route

#' Describes an existing service mesh
#'
#' @description
#' Describes an existing service mesh.
#'
#' See [https://www.paws-r-sdk.com/docs/appmesh_describe_mesh/](https://www.paws-r-sdk.com/docs/appmesh_describe_mesh/) for full documentation.
#'
#' @param meshName &#91;required&#93; The name of the service mesh to describe.
#' @param meshOwner The Amazon Web Services IAM account ID of the service mesh owner. If the
#' account ID is not your own, then it's the ID of the account that shared
#' the mesh with your account. For more information about mesh sharing, see
#' [Working with shared
#' meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
#'
#' @keywords internal
#'
#' @rdname appmesh_describe_mesh
appmesh_describe_mesh <- function(meshName, meshOwner = NULL) {
  op <- new_operation(
    name = "DescribeMesh",
    http_method = "GET",
    http_path = "/v20190125/meshes/{meshName}",
    paginator = list()
  )
  input <- .appmesh$describe_mesh_input(meshName = meshName, meshOwner = meshOwner)
  output <- .appmesh$describe_mesh_output()
  config <- get_config()
  svc <- .appmesh$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appmesh$operations$describe_mesh <- appmesh_describe_mesh

#' Describes an existing route
#'
#' @description
#' Describes an existing route.
#'
#' See [https://www.paws-r-sdk.com/docs/appmesh_describe_route/](https://www.paws-r-sdk.com/docs/appmesh_describe_route/) for full documentation.
#'
#' @param meshName &#91;required&#93; The name of the service mesh that the route resides in.
#' @param meshOwner The Amazon Web Services IAM account ID of the service mesh owner. If the
#' account ID is not your own, then it's the ID of the account that shared
#' the mesh with your account. For more information about mesh sharing, see
#' [Working with shared
#' meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
#' @param routeName &#91;required&#93; The name of the route to describe.
#' @param virtualRouterName &#91;required&#93; The name of the virtual router that the route is associated with.
#'
#' @keywords internal
#'
#' @rdname appmesh_describe_route
appmesh_describe_route <- function(meshName, meshOwner = NULL, routeName, virtualRouterName) {
  op <- new_operation(
    name = "DescribeRoute",
    http_method = "GET",
    http_path = "/v20190125/meshes/{meshName}/virtualRouter/{virtualRouterName}/routes/{routeName}",
    paginator = list()
  )
  input <- .appmesh$describe_route_input(meshName = meshName, meshOwner = meshOwner, routeName = routeName, virtualRouterName = virtualRouterName)
  output <- .appmesh$describe_route_output()
  config <- get_config()
  svc <- .appmesh$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appmesh$operations$describe_route <- appmesh_describe_route

#' Describes an existing virtual gateway
#'
#' @description
#' Describes an existing virtual gateway.
#'
#' See [https://www.paws-r-sdk.com/docs/appmesh_describe_virtual_gateway/](https://www.paws-r-sdk.com/docs/appmesh_describe_virtual_gateway/) for full documentation.
#'
#' @param meshName &#91;required&#93; The name of the service mesh that the gateway route resides in.
#' @param meshOwner The Amazon Web Services IAM account ID of the service mesh owner. If the
#' account ID is not your own, then it's the ID of the account that shared
#' the mesh with your account. For more information about mesh sharing, see
#' [Working with shared
#' meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
#' @param virtualGatewayName &#91;required&#93; The name of the virtual gateway to describe.
#'
#' @keywords internal
#'
#' @rdname appmesh_describe_virtual_gateway
appmesh_describe_virtual_gateway <- function(meshName, meshOwner = NULL, virtualGatewayName) {
  op <- new_operation(
    name = "DescribeVirtualGateway",
    http_method = "GET",
    http_path = "/v20190125/meshes/{meshName}/virtualGateways/{virtualGatewayName}",
    paginator = list()
  )
  input <- .appmesh$describe_virtual_gateway_input(meshName = meshName, meshOwner = meshOwner, virtualGatewayName = virtualGatewayName)
  output <- .appmesh$describe_virtual_gateway_output()
  config <- get_config()
  svc <- .appmesh$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appmesh$operations$describe_virtual_gateway <- appmesh_describe_virtual_gateway

#' Describes an existing virtual node
#'
#' @description
#' Describes an existing virtual node.
#'
#' See [https://www.paws-r-sdk.com/docs/appmesh_describe_virtual_node/](https://www.paws-r-sdk.com/docs/appmesh_describe_virtual_node/) for full documentation.
#'
#' @param meshName &#91;required&#93; The name of the service mesh that the virtual node resides in.
#' @param meshOwner The Amazon Web Services IAM account ID of the service mesh owner. If the
#' account ID is not your own, then it's the ID of the account that shared
#' the mesh with your account. For more information about mesh sharing, see
#' [Working with shared
#' meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
#' @param virtualNodeName &#91;required&#93; The name of the virtual node to describe.
#'
#' @keywords internal
#'
#' @rdname appmesh_describe_virtual_node
appmesh_describe_virtual_node <- function(meshName, meshOwner = NULL, virtualNodeName) {
  op <- new_operation(
    name = "DescribeVirtualNode",
    http_method = "GET",
    http_path = "/v20190125/meshes/{meshName}/virtualNodes/{virtualNodeName}",
    paginator = list()
  )
  input <- .appmesh$describe_virtual_node_input(meshName = meshName, meshOwner = meshOwner, virtualNodeName = virtualNodeName)
  output <- .appmesh$describe_virtual_node_output()
  config <- get_config()
  svc <- .appmesh$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appmesh$operations$describe_virtual_node <- appmesh_describe_virtual_node

#' Describes an existing virtual router
#'
#' @description
#' Describes an existing virtual router.
#'
#' See [https://www.paws-r-sdk.com/docs/appmesh_describe_virtual_router/](https://www.paws-r-sdk.com/docs/appmesh_describe_virtual_router/) for full documentation.
#'
#' @param meshName &#91;required&#93; The name of the service mesh that the virtual router resides in.
#' @param meshOwner The Amazon Web Services IAM account ID of the service mesh owner. If the
#' account ID is not your own, then it's the ID of the account that shared
#' the mesh with your account. For more information about mesh sharing, see
#' [Working with shared
#' meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
#' @param virtualRouterName &#91;required&#93; The name of the virtual router to describe.
#'
#' @keywords internal
#'
#' @rdname appmesh_describe_virtual_router
appmesh_describe_virtual_router <- function(meshName, meshOwner = NULL, virtualRouterName) {
  op <- new_operation(
    name = "DescribeVirtualRouter",
    http_method = "GET",
    http_path = "/v20190125/meshes/{meshName}/virtualRouters/{virtualRouterName}",
    paginator = list()
  )
  input <- .appmesh$describe_virtual_router_input(meshName = meshName, meshOwner = meshOwner, virtualRouterName = virtualRouterName)
  output <- .appmesh$describe_virtual_router_output()
  config <- get_config()
  svc <- .appmesh$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appmesh$operations$describe_virtual_router <- appmesh_describe_virtual_router

#' Describes an existing virtual service
#'
#' @description
#' Describes an existing virtual service.
#'
#' See [https://www.paws-r-sdk.com/docs/appmesh_describe_virtual_service/](https://www.paws-r-sdk.com/docs/appmesh_describe_virtual_service/) for full documentation.
#'
#' @param meshName &#91;required&#93; The name of the service mesh that the virtual service resides in.
#' @param meshOwner The Amazon Web Services IAM account ID of the service mesh owner. If the
#' account ID is not your own, then it's the ID of the account that shared
#' the mesh with your account. For more information about mesh sharing, see
#' [Working with shared
#' meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
#' @param virtualServiceName &#91;required&#93; The name of the virtual service to describe.
#'
#' @keywords internal
#'
#' @rdname appmesh_describe_virtual_service
appmesh_describe_virtual_service <- function(meshName, meshOwner = NULL, virtualServiceName) {
  op <- new_operation(
    name = "DescribeVirtualService",
    http_method = "GET",
    http_path = "/v20190125/meshes/{meshName}/virtualServices/{virtualServiceName}",
    paginator = list()
  )
  input <- .appmesh$describe_virtual_service_input(meshName = meshName, meshOwner = meshOwner, virtualServiceName = virtualServiceName)
  output <- .appmesh$describe_virtual_service_output()
  config <- get_config()
  svc <- .appmesh$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appmesh$operations$describe_virtual_service <- appmesh_describe_virtual_service

#' Returns a list of existing gateway routes that are associated to a
#' virtual gateway
#'
#' @description
#' Returns a list of existing gateway routes that are associated to a virtual gateway.
#'
#' See [https://www.paws-r-sdk.com/docs/appmesh_list_gateway_routes/](https://www.paws-r-sdk.com/docs/appmesh_list_gateway_routes/) for full documentation.
#'
#' @param limit The maximum number of results returned by
#' [`list_gateway_routes`][appmesh_list_gateway_routes] in paginated
#' output. When you use this parameter,
#' [`list_gateway_routes`][appmesh_list_gateway_routes] returns only
#' `limit` results in a single page along with a `nextToken` response
#' element. You can see the remaining results of the initial request by
#' sending another [`list_gateway_routes`][appmesh_list_gateway_routes]
#' request with the returned `nextToken` value. This value can be between 1
#' and 100. If you don't use this parameter,
#' [`list_gateway_routes`][appmesh_list_gateway_routes] returns up to 100
#' results and a `nextToken` value if applicable.
#' @param meshName &#91;required&#93; The name of the service mesh to list gateway routes in.
#' @param meshOwner The Amazon Web Services IAM account ID of the service mesh owner. If the
#' account ID is not your own, then it's the ID of the account that shared
#' the mesh with your account. For more information about mesh sharing, see
#' [Working with shared
#' meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
#' @param nextToken The `nextToken` value returned from a previous paginated
#' [`list_gateway_routes`][appmesh_list_gateway_routes] request where
#' `limit` was used and the results exceeded the value of that parameter.
#' Pagination continues from the end of the previous results that returned
#' the `nextToken` value.
#' @param virtualGatewayName &#91;required&#93; The name of the virtual gateway to list gateway routes in.
#'
#' @keywords internal
#'
#' @rdname appmesh_list_gateway_routes
appmesh_list_gateway_routes <- function(limit = NULL, meshName, meshOwner = NULL, nextToken = NULL, virtualGatewayName) {
  op <- new_operation(
    name = "ListGatewayRoutes",
    http_method = "GET",
    http_path = "/v20190125/meshes/{meshName}/virtualGateway/{virtualGatewayName}/gatewayRoutes",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "limit", result_key = "gatewayRoutes")
  )
  input <- .appmesh$list_gateway_routes_input(limit = limit, meshName = meshName, meshOwner = meshOwner, nextToken = nextToken, virtualGatewayName = virtualGatewayName)
  output <- .appmesh$list_gateway_routes_output()
  config <- get_config()
  svc <- .appmesh$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appmesh$operations$list_gateway_routes <- appmesh_list_gateway_routes

#' Returns a list of existing service meshes
#'
#' @description
#' Returns a list of existing service meshes.
#'
#' See [https://www.paws-r-sdk.com/docs/appmesh_list_meshes/](https://www.paws-r-sdk.com/docs/appmesh_list_meshes/) for full documentation.
#'
#' @param limit The maximum number of results returned by
#' [`list_meshes`][appmesh_list_meshes] in paginated output. When you use
#' this parameter, [`list_meshes`][appmesh_list_meshes] returns only
#' `limit` results in a single page along with a `nextToken` response
#' element. You can see the remaining results of the initial request by
#' sending another [`list_meshes`][appmesh_list_meshes] request with the
#' returned `nextToken` value. This value can be between 1 and 100. If you
#' don't use this parameter, [`list_meshes`][appmesh_list_meshes] returns
#' up to 100 results and a `nextToken` value if applicable.
#' @param nextToken The `nextToken` value returned from a previous paginated
#' [`list_meshes`][appmesh_list_meshes] request where `limit` was used and
#' the results exceeded the value of that parameter. Pagination continues
#' from the end of the previous results that returned the `nextToken`
#' value.
#' 
#' This token should be treated as an opaque identifier that is used only
#' to retrieve the next items in a list and not for other programmatic
#' purposes.
#'
#' @keywords internal
#'
#' @rdname appmesh_list_meshes
appmesh_list_meshes <- function(limit = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListMeshes",
    http_method = "GET",
    http_path = "/v20190125/meshes",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "limit", result_key = "meshes")
  )
  input <- .appmesh$list_meshes_input(limit = limit, nextToken = nextToken)
  output <- .appmesh$list_meshes_output()
  config <- get_config()
  svc <- .appmesh$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appmesh$operations$list_meshes <- appmesh_list_meshes

#' Returns a list of existing routes in a service mesh
#'
#' @description
#' Returns a list of existing routes in a service mesh.
#'
#' See [https://www.paws-r-sdk.com/docs/appmesh_list_routes/](https://www.paws-r-sdk.com/docs/appmesh_list_routes/) for full documentation.
#'
#' @param limit The maximum number of results returned by
#' [`list_routes`][appmesh_list_routes] in paginated output. When you use
#' this parameter, [`list_routes`][appmesh_list_routes] returns only
#' `limit` results in a single page along with a `nextToken` response
#' element. You can see the remaining results of the initial request by
#' sending another [`list_routes`][appmesh_list_routes] request with the
#' returned `nextToken` value. This value can be between 1 and 100. If you
#' don't use this parameter, [`list_routes`][appmesh_list_routes] returns
#' up to 100 results and a `nextToken` value if applicable.
#' @param meshName &#91;required&#93; The name of the service mesh to list routes in.
#' @param meshOwner The Amazon Web Services IAM account ID of the service mesh owner. If the
#' account ID is not your own, then it's the ID of the account that shared
#' the mesh with your account. For more information about mesh sharing, see
#' [Working with shared
#' meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
#' @param nextToken The `nextToken` value returned from a previous paginated
#' [`list_routes`][appmesh_list_routes] request where `limit` was used and
#' the results exceeded the value of that parameter. Pagination continues
#' from the end of the previous results that returned the `nextToken`
#' value.
#' @param virtualRouterName &#91;required&#93; The name of the virtual router to list routes in.
#'
#' @keywords internal
#'
#' @rdname appmesh_list_routes
appmesh_list_routes <- function(limit = NULL, meshName, meshOwner = NULL, nextToken = NULL, virtualRouterName) {
  op <- new_operation(
    name = "ListRoutes",
    http_method = "GET",
    http_path = "/v20190125/meshes/{meshName}/virtualRouter/{virtualRouterName}/routes",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "limit", result_key = "routes")
  )
  input <- .appmesh$list_routes_input(limit = limit, meshName = meshName, meshOwner = meshOwner, nextToken = nextToken, virtualRouterName = virtualRouterName)
  output <- .appmesh$list_routes_output()
  config <- get_config()
  svc <- .appmesh$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appmesh$operations$list_routes <- appmesh_list_routes

#' List the tags for an App Mesh resource
#'
#' @description
#' List the tags for an App Mesh resource.
#'
#' See [https://www.paws-r-sdk.com/docs/appmesh_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/appmesh_list_tags_for_resource/) for full documentation.
#'
#' @param limit The maximum number of tag results returned by
#' [`list_tags_for_resource`][appmesh_list_tags_for_resource] in paginated
#' output. When this parameter is used,
#' [`list_tags_for_resource`][appmesh_list_tags_for_resource] returns only
#' `limit` results in a single page along with a `nextToken` response
#' element. You can see the remaining results of the initial request by
#' sending another
#' [`list_tags_for_resource`][appmesh_list_tags_for_resource] request with
#' the returned `nextToken` value. This value can be between 1 and 100. If
#' you don't use this parameter,
#' [`list_tags_for_resource`][appmesh_list_tags_for_resource] returns up to
#' 100 results and a `nextToken` value if applicable.
#' @param nextToken The `nextToken` value returned from a previous paginated
#' [`list_tags_for_resource`][appmesh_list_tags_for_resource] request where
#' `limit` was used and the results exceeded the value of that parameter.
#' Pagination continues from the end of the previous results that returned
#' the `nextToken` value.
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) that identifies the resource to list the
#' tags for.
#'
#' @keywords internal
#'
#' @rdname appmesh_list_tags_for_resource
appmesh_list_tags_for_resource <- function(limit = NULL, nextToken = NULL, resourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/v20190125/tags",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "limit", result_key = "tags")
  )
  input <- .appmesh$list_tags_for_resource_input(limit = limit, nextToken = nextToken, resourceArn = resourceArn)
  output <- .appmesh$list_tags_for_resource_output()
  config <- get_config()
  svc <- .appmesh$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appmesh$operations$list_tags_for_resource <- appmesh_list_tags_for_resource

#' Returns a list of existing virtual gateways in a service mesh
#'
#' @description
#' Returns a list of existing virtual gateways in a service mesh.
#'
#' See [https://www.paws-r-sdk.com/docs/appmesh_list_virtual_gateways/](https://www.paws-r-sdk.com/docs/appmesh_list_virtual_gateways/) for full documentation.
#'
#' @param limit The maximum number of results returned by
#' [`list_virtual_gateways`][appmesh_list_virtual_gateways] in paginated
#' output. When you use this parameter,
#' [`list_virtual_gateways`][appmesh_list_virtual_gateways] returns only
#' `limit` results in a single page along with a `nextToken` response
#' element. You can see the remaining results of the initial request by
#' sending another [`list_virtual_gateways`][appmesh_list_virtual_gateways]
#' request with the returned `nextToken` value. This value can be between 1
#' and 100. If you don't use this parameter,
#' [`list_virtual_gateways`][appmesh_list_virtual_gateways] returns up to
#' 100 results and a `nextToken` value if applicable.
#' @param meshName &#91;required&#93; The name of the service mesh to list virtual gateways in.
#' @param meshOwner The Amazon Web Services IAM account ID of the service mesh owner. If the
#' account ID is not your own, then it's the ID of the account that shared
#' the mesh with your account. For more information about mesh sharing, see
#' [Working with shared
#' meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
#' @param nextToken The `nextToken` value returned from a previous paginated
#' [`list_virtual_gateways`][appmesh_list_virtual_gateways] request where
#' `limit` was used and the results exceeded the value of that parameter.
#' Pagination continues from the end of the previous results that returned
#' the `nextToken` value.
#'
#' @keywords internal
#'
#' @rdname appmesh_list_virtual_gateways
appmesh_list_virtual_gateways <- function(limit = NULL, meshName, meshOwner = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListVirtualGateways",
    http_method = "GET",
    http_path = "/v20190125/meshes/{meshName}/virtualGateways",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "limit", result_key = "virtualGateways")
  )
  input <- .appmesh$list_virtual_gateways_input(limit = limit, meshName = meshName, meshOwner = meshOwner, nextToken = nextToken)
  output <- .appmesh$list_virtual_gateways_output()
  config <- get_config()
  svc <- .appmesh$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appmesh$operations$list_virtual_gateways <- appmesh_list_virtual_gateways

#' Returns a list of existing virtual nodes
#'
#' @description
#' Returns a list of existing virtual nodes.
#'
#' See [https://www.paws-r-sdk.com/docs/appmesh_list_virtual_nodes/](https://www.paws-r-sdk.com/docs/appmesh_list_virtual_nodes/) for full documentation.
#'
#' @param limit The maximum number of results returned by
#' [`list_virtual_nodes`][appmesh_list_virtual_nodes] in paginated output.
#' When you use this parameter,
#' [`list_virtual_nodes`][appmesh_list_virtual_nodes] returns only `limit`
#' results in a single page along with a `nextToken` response element. You
#' can see the remaining results of the initial request by sending another
#' [`list_virtual_nodes`][appmesh_list_virtual_nodes] request with the
#' returned `nextToken` value. This value can be between 1 and 100. If you
#' don't use this parameter,
#' [`list_virtual_nodes`][appmesh_list_virtual_nodes] returns up to 100
#' results and a `nextToken` value if applicable.
#' @param meshName &#91;required&#93; The name of the service mesh to list virtual nodes in.
#' @param meshOwner The Amazon Web Services IAM account ID of the service mesh owner. If the
#' account ID is not your own, then it's the ID of the account that shared
#' the mesh with your account. For more information about mesh sharing, see
#' [Working with shared
#' meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
#' @param nextToken The `nextToken` value returned from a previous paginated
#' [`list_virtual_nodes`][appmesh_list_virtual_nodes] request where `limit`
#' was used and the results exceeded the value of that parameter.
#' Pagination continues from the end of the previous results that returned
#' the `nextToken` value.
#'
#' @keywords internal
#'
#' @rdname appmesh_list_virtual_nodes
appmesh_list_virtual_nodes <- function(limit = NULL, meshName, meshOwner = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListVirtualNodes",
    http_method = "GET",
    http_path = "/v20190125/meshes/{meshName}/virtualNodes",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "limit", result_key = "virtualNodes")
  )
  input <- .appmesh$list_virtual_nodes_input(limit = limit, meshName = meshName, meshOwner = meshOwner, nextToken = nextToken)
  output <- .appmesh$list_virtual_nodes_output()
  config <- get_config()
  svc <- .appmesh$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appmesh$operations$list_virtual_nodes <- appmesh_list_virtual_nodes

#' Returns a list of existing virtual routers in a service mesh
#'
#' @description
#' Returns a list of existing virtual routers in a service mesh.
#'
#' See [https://www.paws-r-sdk.com/docs/appmesh_list_virtual_routers/](https://www.paws-r-sdk.com/docs/appmesh_list_virtual_routers/) for full documentation.
#'
#' @param limit The maximum number of results returned by
#' [`list_virtual_routers`][appmesh_list_virtual_routers] in paginated
#' output. When you use this parameter,
#' [`list_virtual_routers`][appmesh_list_virtual_routers] returns only
#' `limit` results in a single page along with a `nextToken` response
#' element. You can see the remaining results of the initial request by
#' sending another [`list_virtual_routers`][appmesh_list_virtual_routers]
#' request with the returned `nextToken` value. This value can be between 1
#' and 100. If you don't use this parameter,
#' [`list_virtual_routers`][appmesh_list_virtual_routers] returns up to 100
#' results and a `nextToken` value if applicable.
#' @param meshName &#91;required&#93; The name of the service mesh to list virtual routers in.
#' @param meshOwner The Amazon Web Services IAM account ID of the service mesh owner. If the
#' account ID is not your own, then it's the ID of the account that shared
#' the mesh with your account. For more information about mesh sharing, see
#' [Working with shared
#' meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
#' @param nextToken The `nextToken` value returned from a previous paginated
#' [`list_virtual_routers`][appmesh_list_virtual_routers] request where
#' `limit` was used and the results exceeded the value of that parameter.
#' Pagination continues from the end of the previous results that returned
#' the `nextToken` value.
#'
#' @keywords internal
#'
#' @rdname appmesh_list_virtual_routers
appmesh_list_virtual_routers <- function(limit = NULL, meshName, meshOwner = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListVirtualRouters",
    http_method = "GET",
    http_path = "/v20190125/meshes/{meshName}/virtualRouters",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "limit", result_key = "virtualRouters")
  )
  input <- .appmesh$list_virtual_routers_input(limit = limit, meshName = meshName, meshOwner = meshOwner, nextToken = nextToken)
  output <- .appmesh$list_virtual_routers_output()
  config <- get_config()
  svc <- .appmesh$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appmesh$operations$list_virtual_routers <- appmesh_list_virtual_routers

#' Returns a list of existing virtual services in a service mesh
#'
#' @description
#' Returns a list of existing virtual services in a service mesh.
#'
#' See [https://www.paws-r-sdk.com/docs/appmesh_list_virtual_services/](https://www.paws-r-sdk.com/docs/appmesh_list_virtual_services/) for full documentation.
#'
#' @param limit The maximum number of results returned by
#' [`list_virtual_services`][appmesh_list_virtual_services] in paginated
#' output. When you use this parameter,
#' [`list_virtual_services`][appmesh_list_virtual_services] returns only
#' `limit` results in a single page along with a `nextToken` response
#' element. You can see the remaining results of the initial request by
#' sending another [`list_virtual_services`][appmesh_list_virtual_services]
#' request with the returned `nextToken` value. This value can be between 1
#' and 100. If you don't use this parameter,
#' [`list_virtual_services`][appmesh_list_virtual_services] returns up to
#' 100 results and a `nextToken` value if applicable.
#' @param meshName &#91;required&#93; The name of the service mesh to list virtual services in.
#' @param meshOwner The Amazon Web Services IAM account ID of the service mesh owner. If the
#' account ID is not your own, then it's the ID of the account that shared
#' the mesh with your account. For more information about mesh sharing, see
#' [Working with shared
#' meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
#' @param nextToken The `nextToken` value returned from a previous paginated
#' [`list_virtual_services`][appmesh_list_virtual_services] request where
#' `limit` was used and the results exceeded the value of that parameter.
#' Pagination continues from the end of the previous results that returned
#' the `nextToken` value.
#'
#' @keywords internal
#'
#' @rdname appmesh_list_virtual_services
appmesh_list_virtual_services <- function(limit = NULL, meshName, meshOwner = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListVirtualServices",
    http_method = "GET",
    http_path = "/v20190125/meshes/{meshName}/virtualServices",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "limit", result_key = "virtualServices")
  )
  input <- .appmesh$list_virtual_services_input(limit = limit, meshName = meshName, meshOwner = meshOwner, nextToken = nextToken)
  output <- .appmesh$list_virtual_services_output()
  config <- get_config()
  svc <- .appmesh$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appmesh$operations$list_virtual_services <- appmesh_list_virtual_services

#' Associates the specified tags to a resource with the specified
#' resourceArn
#'
#' @description
#' Associates the specified tags to a resource with the specified `resourceArn`. If existing tags on a resource aren't specified in the request parameters, they aren't changed. When a resource is deleted, the tags associated with that resource are also deleted.
#'
#' See [https://www.paws-r-sdk.com/docs/appmesh_tag_resource/](https://www.paws-r-sdk.com/docs/appmesh_tag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource to add tags to.
#' @param tags &#91;required&#93; The tags to add to the resource. A tag is an array of key-value pairs.
#' Tag keys can have a maximum character length of 128 characters, and tag
#' values can have a maximum length of 256 characters.
#'
#' @keywords internal
#'
#' @rdname appmesh_tag_resource
appmesh_tag_resource <- function(resourceArn, tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "PUT",
    http_path = "/v20190125/tag",
    paginator = list()
  )
  input <- .appmesh$tag_resource_input(resourceArn = resourceArn, tags = tags)
  output <- .appmesh$tag_resource_output()
  config <- get_config()
  svc <- .appmesh$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appmesh$operations$tag_resource <- appmesh_tag_resource

#' Deletes specified tags from a resource
#'
#' @description
#' Deletes specified tags from a resource.
#'
#' See [https://www.paws-r-sdk.com/docs/appmesh_untag_resource/](https://www.paws-r-sdk.com/docs/appmesh_untag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource to delete tags from.
#' @param tagKeys &#91;required&#93; The keys of the tags to be removed.
#'
#' @keywords internal
#'
#' @rdname appmesh_untag_resource
appmesh_untag_resource <- function(resourceArn, tagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "PUT",
    http_path = "/v20190125/untag",
    paginator = list()
  )
  input <- .appmesh$untag_resource_input(resourceArn = resourceArn, tagKeys = tagKeys)
  output <- .appmesh$untag_resource_output()
  config <- get_config()
  svc <- .appmesh$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appmesh$operations$untag_resource <- appmesh_untag_resource

#' Updates an existing gateway route that is associated to a specified
#' virtual gateway in a service mesh
#'
#' @description
#' Updates an existing gateway route that is associated to a specified virtual gateway in a service mesh.
#'
#' See [https://www.paws-r-sdk.com/docs/appmesh_update_gateway_route/](https://www.paws-r-sdk.com/docs/appmesh_update_gateway_route/) for full documentation.
#'
#' @param clientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. Up to 36 letters, numbers, hyphens, and
#' underscores are allowed.
#' @param gatewayRouteName &#91;required&#93; The name of the gateway route to update.
#' @param meshName &#91;required&#93; The name of the service mesh that the gateway route resides in.
#' @param meshOwner The Amazon Web Services IAM account ID of the service mesh owner. If the
#' account ID is not your own, then it's the ID of the account that shared
#' the mesh with your account. For more information about mesh sharing, see
#' [Working with shared
#' meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
#' @param spec &#91;required&#93; The new gateway route specification to apply. This overwrites the
#' existing data.
#' @param virtualGatewayName &#91;required&#93; The name of the virtual gateway that the gateway route is associated
#' with.
#'
#' @keywords internal
#'
#' @rdname appmesh_update_gateway_route
appmesh_update_gateway_route <- function(clientToken = NULL, gatewayRouteName, meshName, meshOwner = NULL, spec, virtualGatewayName) {
  op <- new_operation(
    name = "UpdateGatewayRoute",
    http_method = "PUT",
    http_path = "/v20190125/meshes/{meshName}/virtualGateway/{virtualGatewayName}/gatewayRoutes/{gatewayRouteName}",
    paginator = list()
  )
  input <- .appmesh$update_gateway_route_input(clientToken = clientToken, gatewayRouteName = gatewayRouteName, meshName = meshName, meshOwner = meshOwner, spec = spec, virtualGatewayName = virtualGatewayName)
  output <- .appmesh$update_gateway_route_output()
  config <- get_config()
  svc <- .appmesh$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appmesh$operations$update_gateway_route <- appmesh_update_gateway_route

#' Updates an existing service mesh
#'
#' @description
#' Updates an existing service mesh.
#'
#' See [https://www.paws-r-sdk.com/docs/appmesh_update_mesh/](https://www.paws-r-sdk.com/docs/appmesh_update_mesh/) for full documentation.
#'
#' @param clientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. Up to 36 letters, numbers, hyphens, and
#' underscores are allowed.
#' @param meshName &#91;required&#93; The name of the service mesh to update.
#' @param spec The service mesh specification to apply.
#'
#' @keywords internal
#'
#' @rdname appmesh_update_mesh
appmesh_update_mesh <- function(clientToken = NULL, meshName, spec = NULL) {
  op <- new_operation(
    name = "UpdateMesh",
    http_method = "PUT",
    http_path = "/v20190125/meshes/{meshName}",
    paginator = list()
  )
  input <- .appmesh$update_mesh_input(clientToken = clientToken, meshName = meshName, spec = spec)
  output <- .appmesh$update_mesh_output()
  config <- get_config()
  svc <- .appmesh$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appmesh$operations$update_mesh <- appmesh_update_mesh

#' Updates an existing route for a specified service mesh and virtual
#' router
#'
#' @description
#' Updates an existing route for a specified service mesh and virtual router.
#'
#' See [https://www.paws-r-sdk.com/docs/appmesh_update_route/](https://www.paws-r-sdk.com/docs/appmesh_update_route/) for full documentation.
#'
#' @param clientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. Up to 36 letters, numbers, hyphens, and
#' underscores are allowed.
#' @param meshName &#91;required&#93; The name of the service mesh that the route resides in.
#' @param meshOwner The Amazon Web Services IAM account ID of the service mesh owner. If the
#' account ID is not your own, then it's the ID of the account that shared
#' the mesh with your account. For more information about mesh sharing, see
#' [Working with shared
#' meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
#' @param routeName &#91;required&#93; The name of the route to update.
#' @param spec &#91;required&#93; The new route specification to apply. This overwrites the existing data.
#' @param virtualRouterName &#91;required&#93; The name of the virtual router that the route is associated with.
#'
#' @keywords internal
#'
#' @rdname appmesh_update_route
appmesh_update_route <- function(clientToken = NULL, meshName, meshOwner = NULL, routeName, spec, virtualRouterName) {
  op <- new_operation(
    name = "UpdateRoute",
    http_method = "PUT",
    http_path = "/v20190125/meshes/{meshName}/virtualRouter/{virtualRouterName}/routes/{routeName}",
    paginator = list()
  )
  input <- .appmesh$update_route_input(clientToken = clientToken, meshName = meshName, meshOwner = meshOwner, routeName = routeName, spec = spec, virtualRouterName = virtualRouterName)
  output <- .appmesh$update_route_output()
  config <- get_config()
  svc <- .appmesh$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appmesh$operations$update_route <- appmesh_update_route

#' Updates an existing virtual gateway in a specified service mesh
#'
#' @description
#' Updates an existing virtual gateway in a specified service mesh.
#'
#' See [https://www.paws-r-sdk.com/docs/appmesh_update_virtual_gateway/](https://www.paws-r-sdk.com/docs/appmesh_update_virtual_gateway/) for full documentation.
#'
#' @param clientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. Up to 36 letters, numbers, hyphens, and
#' underscores are allowed.
#' @param meshName &#91;required&#93; The name of the service mesh that the virtual gateway resides in.
#' @param meshOwner The Amazon Web Services IAM account ID of the service mesh owner. If the
#' account ID is not your own, then it's the ID of the account that shared
#' the mesh with your account. For more information about mesh sharing, see
#' [Working with shared
#' meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
#' @param spec &#91;required&#93; The new virtual gateway specification to apply. This overwrites the
#' existing data.
#' @param virtualGatewayName &#91;required&#93; The name of the virtual gateway to update.
#'
#' @keywords internal
#'
#' @rdname appmesh_update_virtual_gateway
appmesh_update_virtual_gateway <- function(clientToken = NULL, meshName, meshOwner = NULL, spec, virtualGatewayName) {
  op <- new_operation(
    name = "UpdateVirtualGateway",
    http_method = "PUT",
    http_path = "/v20190125/meshes/{meshName}/virtualGateways/{virtualGatewayName}",
    paginator = list()
  )
  input <- .appmesh$update_virtual_gateway_input(clientToken = clientToken, meshName = meshName, meshOwner = meshOwner, spec = spec, virtualGatewayName = virtualGatewayName)
  output <- .appmesh$update_virtual_gateway_output()
  config <- get_config()
  svc <- .appmesh$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appmesh$operations$update_virtual_gateway <- appmesh_update_virtual_gateway

#' Updates an existing virtual node in a specified service mesh
#'
#' @description
#' Updates an existing virtual node in a specified service mesh.
#'
#' See [https://www.paws-r-sdk.com/docs/appmesh_update_virtual_node/](https://www.paws-r-sdk.com/docs/appmesh_update_virtual_node/) for full documentation.
#'
#' @param clientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. Up to 36 letters, numbers, hyphens, and
#' underscores are allowed.
#' @param meshName &#91;required&#93; The name of the service mesh that the virtual node resides in.
#' @param meshOwner The Amazon Web Services IAM account ID of the service mesh owner. If the
#' account ID is not your own, then it's the ID of the account that shared
#' the mesh with your account. For more information about mesh sharing, see
#' [Working with shared
#' meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
#' @param spec &#91;required&#93; The new virtual node specification to apply. This overwrites the
#' existing data.
#' @param virtualNodeName &#91;required&#93; The name of the virtual node to update.
#'
#' @keywords internal
#'
#' @rdname appmesh_update_virtual_node
appmesh_update_virtual_node <- function(clientToken = NULL, meshName, meshOwner = NULL, spec, virtualNodeName) {
  op <- new_operation(
    name = "UpdateVirtualNode",
    http_method = "PUT",
    http_path = "/v20190125/meshes/{meshName}/virtualNodes/{virtualNodeName}",
    paginator = list()
  )
  input <- .appmesh$update_virtual_node_input(clientToken = clientToken, meshName = meshName, meshOwner = meshOwner, spec = spec, virtualNodeName = virtualNodeName)
  output <- .appmesh$update_virtual_node_output()
  config <- get_config()
  svc <- .appmesh$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appmesh$operations$update_virtual_node <- appmesh_update_virtual_node

#' Updates an existing virtual router in a specified service mesh
#'
#' @description
#' Updates an existing virtual router in a specified service mesh.
#'
#' See [https://www.paws-r-sdk.com/docs/appmesh_update_virtual_router/](https://www.paws-r-sdk.com/docs/appmesh_update_virtual_router/) for full documentation.
#'
#' @param clientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. Up to 36 letters, numbers, hyphens, and
#' underscores are allowed.
#' @param meshName &#91;required&#93; The name of the service mesh that the virtual router resides in.
#' @param meshOwner The Amazon Web Services IAM account ID of the service mesh owner. If the
#' account ID is not your own, then it's the ID of the account that shared
#' the mesh with your account. For more information about mesh sharing, see
#' [Working with shared
#' meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
#' @param spec &#91;required&#93; The new virtual router specification to apply. This overwrites the
#' existing data.
#' @param virtualRouterName &#91;required&#93; The name of the virtual router to update.
#'
#' @keywords internal
#'
#' @rdname appmesh_update_virtual_router
appmesh_update_virtual_router <- function(clientToken = NULL, meshName, meshOwner = NULL, spec, virtualRouterName) {
  op <- new_operation(
    name = "UpdateVirtualRouter",
    http_method = "PUT",
    http_path = "/v20190125/meshes/{meshName}/virtualRouters/{virtualRouterName}",
    paginator = list()
  )
  input <- .appmesh$update_virtual_router_input(clientToken = clientToken, meshName = meshName, meshOwner = meshOwner, spec = spec, virtualRouterName = virtualRouterName)
  output <- .appmesh$update_virtual_router_output()
  config <- get_config()
  svc <- .appmesh$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appmesh$operations$update_virtual_router <- appmesh_update_virtual_router

#' Updates an existing virtual service in a specified service mesh
#'
#' @description
#' Updates an existing virtual service in a specified service mesh.
#'
#' See [https://www.paws-r-sdk.com/docs/appmesh_update_virtual_service/](https://www.paws-r-sdk.com/docs/appmesh_update_virtual_service/) for full documentation.
#'
#' @param clientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. Up to 36 letters, numbers, hyphens, and
#' underscores are allowed.
#' @param meshName &#91;required&#93; The name of the service mesh that the virtual service resides in.
#' @param meshOwner The Amazon Web Services IAM account ID of the service mesh owner. If the
#' account ID is not your own, then it's the ID of the account that shared
#' the mesh with your account. For more information about mesh sharing, see
#' [Working with shared
#' meshes](https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html).
#' @param spec &#91;required&#93; The new virtual service specification to apply. This overwrites the
#' existing data.
#' @param virtualServiceName &#91;required&#93; The name of the virtual service to update.
#'
#' @keywords internal
#'
#' @rdname appmesh_update_virtual_service
appmesh_update_virtual_service <- function(clientToken = NULL, meshName, meshOwner = NULL, spec, virtualServiceName) {
  op <- new_operation(
    name = "UpdateVirtualService",
    http_method = "PUT",
    http_path = "/v20190125/meshes/{meshName}/virtualServices/{virtualServiceName}",
    paginator = list()
  )
  input <- .appmesh$update_virtual_service_input(clientToken = clientToken, meshName = meshName, meshOwner = meshOwner, spec = spec, virtualServiceName = virtualServiceName)
  output <- .appmesh$update_virtual_service_output()
  config <- get_config()
  svc <- .appmesh$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appmesh$operations$update_virtual_service <- appmesh_update_virtual_service
