% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route53resolver_operations.R
\name{route53resolver_update_resolver_config}
\alias{route53resolver_update_resolver_config}
\title{Updates the behavior configuration of Route 53 Resolver behavior for a
single VPC from Amazon Virtual Private Cloud}
\usage{
route53resolver_update_resolver_config(ResourceId, AutodefinedReverseFlag)
}
\arguments{
\item{ResourceId}{[required] Resource ID of the Amazon VPC that you want to update the Resolver
configuration for.}

\item{AutodefinedReverseFlag}{[required] Indicates whether or not the Resolver will create autodefined rules for
reverse DNS lookups. This is enabled by default. Disabling this option
will also affect EC2-Classic instances using ClassicLink. For more
information, see
\href{https://aws.amazon.com/blogs/aws/ec2-classic-is-retiring-heres-how-to-prepare/}{ClassicLink}
in the \emph{Amazon EC2 guide}.

We are retiring EC2-Classic on August 15, 2022. We recommend that you
migrate from EC2-Classic to a VPC. For more information, see \href{https://aws.amazon.com/blogs/aws/ec2-classic-is-retiring-heres-how-to-prepare/}{Migrate from EC2-Classic to a VPC}
in the \emph{Amazon EC2 guide} and the blog \href{https://aws.amazon.com/blogs/aws/ec2-classic-is-retiring-heres-how-to-prepare/}{EC2-Classic Networking is Retiring – Here’s How to Prepare}.

It can take some time for the status change to be completed.}
}
\description{
Updates the behavior configuration of Route 53 Resolver behavior for a single VPC from Amazon Virtual Private Cloud.

See \url{https://www.paws-r-sdk.com/docs/route53resolver_update_resolver_config/} for full documentation.
}
\keyword{internal}
