% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apigateway_operations.R
\name{apigateway_create_domain_name}
\alias{apigateway_create_domain_name}
\title{Creates a new domain name}
\usage{
apigateway_create_domain_name(
  domainName,
  certificateName = NULL,
  certificateBody = NULL,
  certificatePrivateKey = NULL,
  certificateChain = NULL,
  certificateArn = NULL,
  regionalCertificateName = NULL,
  regionalCertificateArn = NULL,
  endpointConfiguration = NULL,
  tags = NULL,
  securityPolicy = NULL,
  mutualTlsAuthentication = NULL,
  ownershipVerificationCertificateArn = NULL
)
}
\arguments{
\item{domainName}{[required] The name of the DomainName resource.}

\item{certificateName}{The user-friendly name of the certificate that will be used by
edge-optimized endpoint for this domain name.}

\item{certificateBody}{[Deprecated] The body of the server certificate that will be used by
edge-optimized endpoint for this domain name provided by your
certificate authority.}

\item{certificatePrivateKey}{[Deprecated] Your edge-optimized endpoint's domain name certificate's
private key.}

\item{certificateChain}{[Deprecated] The intermediate certificates and optionally the root
certificate, one after the other without any blank lines, used by an
edge-optimized endpoint for this domain name. If you include the root
certificate, your certificate chain must start with intermediate
certificates and end with the root certificate. Use the intermediate
certificates that were provided by your certificate authority. Do not
include any intermediaries that are not in the chain of trust path.}

\item{certificateArn}{The reference to an Amazon Web Services-managed certificate that will be
used by edge-optimized endpoint for this domain name. Certificate
Manager is the only supported source.}

\item{regionalCertificateName}{The user-friendly name of the certificate that will be used by regional
endpoint for this domain name.}

\item{regionalCertificateArn}{The reference to an Amazon Web Services-managed certificate that will be
used by regional endpoint for this domain name. Certificate Manager is
the only supported source.}

\item{endpointConfiguration}{The endpoint configuration of this DomainName showing the endpoint types
of the domain name.}

\item{tags}{The key-value map of strings. The valid character set is
[a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not
start with \verb{aws:}. The tag value can be up to 256 characters.}

\item{securityPolicy}{The Transport Layer Security (TLS) version + cipher suite for this
DomainName. The valid values are \code{TLS_1_0} and \code{TLS_1_2}.}

\item{mutualTlsAuthentication}{}

\item{ownershipVerificationCertificateArn}{The ARN of the public certificate issued by ACM to validate ownership of
your custom domain. Only required when configuring mutual TLS and using
an ACM imported or private CA certificate ARN as the
regionalCertificateArn.}
}
\description{
Creates a new domain name.

See \url{https://www.paws-r-sdk.com/docs/apigateway_create_domain_name/} for full documentation.
}
\keyword{internal}
