% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acmpca_operations.R
\name{acmpca_import_certificate_authority_certificate}
\alias{acmpca_import_certificate_authority_certificate}
\title{Imports a signed private CA certificate into ACM Private CA}
\usage{
acmpca_import_certificate_authority_certificate(CertificateAuthorityArn,
  Certificate, CertificateChain)
}
\arguments{
\item{CertificateAuthorityArn}{[required] The Amazon Resource Name (ARN) that was returned when you called
\code{\link[=acmpca_create_certificate_authority]{create_certificate_authority}}.
This must be of the form:

\code{arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012 }}

\item{Certificate}{[required] The PEM-encoded certificate for a private CA. This may be a self-signed
certificate in the case of a root CA, or it may be signed by another CA
that you control.}

\item{CertificateChain}{A PEM-encoded file that contains all of your certificates, other than
the certificate you're importing, chaining up to your root CA. Your ACM
Private CA-hosted or on-premises root certificate is the last in the
chain, and each certificate in the chain signs the one preceding.

This parameter must be supplied when you import a subordinate CA. When
you import a root CA, there is no chain.}
}
\value{
An empty list.
}
\description{
Imports a signed private CA certificate into ACM Private CA. This action
is used when you are using a chain of trust whose root is located
outside ACM Private CA. Before you can call this action, the following
preparations must in place:
\enumerate{
\item In ACM Private CA, call the
\code{\link[=acmpca_create_certificate_authority]{create_certificate_authority}}
action to create the private CA that that you plan to back with the
imported certificate.
\item Call the
\code{\link[=acmpca_get_certificate_authority_csr]{get_certificate_authority_csr}}
action to generate a certificate signing request (CSR).
\item Sign the CSR using a root or intermediate CA hosted by either an
on-premises PKI hierarchy or by a commercial CA.
\item Create a certificate chain and copy the signed certificate and the
certificate chain to your working directory.
}

ACM Private CA supports three scenarios for installing a CA certificate:
\itemize{
\item Installing a certificate for a root CA hosted by ACM Private CA.
\item Installing a subordinate CA certificate whose parent authority is
hosted by ACM Private CA.
\item Installing a subordinate CA certificate whose parent authority is
externally hosted.
}

The following addtitional requirements apply when you import a CA
certificate.
\itemize{
\item Only a self-signed certificate can be imported as a root CA.
\item A self-signed certificate cannot be imported as a subordinate CA.
\item Your certificate chain must not include the private CA certificate
that you are importing.
\item Your root CA must be the last certificate in your chain. The
subordinate certificate, if any, that your root CA signed must be
next to last. The subordinate certificate signed by the preceding
subordinate CA must come next, and so on until your chain is built.
\item The chain must be PEM-encoded.
\item The maximum allowed size of a certificate is 32 KB.
\item The maximum allowed size of a certificate chain is 2 MB.
}

\emph{Enforcement of Critical Constraints}

ACM Private CA allows the following extensions to be marked critical in
the imported CA certificate or chain.
\itemize{
\item Basic constraints (\emph{must} be marked critical)
\item Subject alternative names
\item Key usage
\item Extended key usage
\item Authority key identifier
\item Subject key identifier
\item Issuer alternative name
\item Subject directory attributes
\item Subject information access
\item Certificate policies
\item Policy mappings
\item Inhibit anyPolicy
}

ACM Private CA rejects the following extensions when they are marked
critical in an imported CA certificate or chain.
\itemize{
\item Name constraints
\item Policy constraints
\item CRL distribution points
\item Authority information access
\item Freshest CRL
\item Any other extension
}
}
\section{Request syntax}{
\preformatted{svc$import_certificate_authority_certificate(
  CertificateAuthorityArn = "string",
  Certificate = raw,
  CertificateChain = raw
)
}
}

\keyword{internal}
