% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inspector_operations.R
\name{inspector_describe_assessment_templates}
\alias{inspector_describe_assessment_templates}
\title{Describes the assessment templates that are specified by the ARNs of the
assessment templates}
\usage{
inspector_describe_assessment_templates(assessmentTemplateArns)
}
\arguments{
\item{assessmentTemplateArns}{[required]}
}
\value{
A list with the following syntax:\preformatted{list(
  assessmentTemplates = list(
    list(
      arn = "string",
      name = "string",
      assessmentTargetArn = "string",
      durationInSeconds = 123,
      rulesPackageArns = list(
        "string"
      ),
      userAttributesForFindings = list(
        list(
          key = "string",
          value = "string"
        )
      ),
      lastAssessmentRunArn = "string",
      assessmentRunCount = 123,
      createdAt = as.POSIXct(
        "2015-01-01"
      )
    )
  ),
  failedItems = list(
    list(
      failureCode = "INVALID_ARN"|"DUPLICATE_ARN"|"ITEM_DOES_NOT_EXIST"|"ACCESS_DENIED"|"LIMIT_EXCEEDED"|"INTERNAL_ERROR",
      retryable = TRUE|FALSE
    )
  )
)
}
}
\description{
Describes the assessment templates that are specified by the ARNs of the
assessment templates.
}
\section{Request syntax}{
\preformatted{svc$describe_assessment_templates(
  assessmentTemplateArns = list(
    "string"
  )
)
}
}

\examples{
\dontrun{
# Describes the assessment templates that are specified by the ARNs of the
# assessment templates.
svc$describe_assessment_templates(
  assessmentTemplateArns = list(
    "arn:aws:inspector:us-west-2:123456789012:target/0-0kFIPusq/template/0-4r1V2mAw"
  )
)
}

}
\keyword{internal}
