% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ram_operations.R
\name{ram_reject_resource_share_invitation}
\alias{ram_reject_resource_share_invitation}
\title{Rejects an invitation to a resource share from another AWS account}
\usage{
ram_reject_resource_share_invitation(resourceShareInvitationArn,
  clientToken)
}
\arguments{
\item{resourceShareInvitationArn}{[required] The Amazon Resource Name (ARN) of the invitation.}

\item{clientToken}{A unique, case-sensitive identifier that you provide to ensure the
idempotency of the request.}
}
\value{
A list with the following syntax:\preformatted{list(
  resourceShareInvitation = list(
    resourceShareInvitationArn = "string",
    resourceShareName = "string",
    resourceShareArn = "string",
    senderAccountId = "string",
    receiverAccountId = "string",
    invitationTimestamp = as.POSIXct(
      "2015-01-01"
    ),
    status = "PENDING"|"ACCEPTED"|"REJECTED"|"EXPIRED",
    resourceShareAssociations = list(
      list(
        resourceShareArn = "string",
        resourceShareName = "string",
        associatedEntity = "string",
        associationType = "PRINCIPAL"|"RESOURCE",
        status = "ASSOCIATING"|"ASSOCIATED"|"FAILED"|"DISASSOCIATING"|"DISASSOCIATED",
        statusMessage = "string",
        creationTime = as.POSIXct(
          "2015-01-01"
        ),
        lastUpdatedTime = as.POSIXct(
          "2015-01-01"
        ),
        external = TRUE|FALSE
      )
    )
  ),
  clientToken = "string"
)
}
}
\description{
Rejects an invitation to a resource share from another AWS account.
}
\section{Request syntax}{
\preformatted{svc$reject_resource_share_invitation(
  resourceShareInvitationArn = "string",
  clientToken = "string"
)
}
}

\keyword{internal}
