% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inspector_operations.R
\name{inspector_describe_assessment_runs}
\alias{inspector_describe_assessment_runs}
\title{Describes the assessment runs that are specified by the ARNs of the
assessment runs}
\usage{
inspector_describe_assessment_runs(assessmentRunArns)
}
\arguments{
\item{assessmentRunArns}{[required] The ARN that specifies the assessment run that you want to describe.}
}
\description{
Describes the assessment runs that are specified by the ARNs of the
assessment runs.
}
\section{Request syntax}{
\preformatted{svc$describe_assessment_runs(
  assessmentRunArns = list(
    "string"
  )
)
}
}

\examples{
# Describes the assessment runs that are specified by the ARNs of the
# assessment runs.
\donttest{svc$describe_assessment_runs(
  assessmentRunArns = list(
    "arn:aws:inspector:us-west-2:123456789012:target/0-0kFIPusq/template/0-4r1V2mAw/run/0-MK..."
  )
)}

}
\keyword{internal}
