% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/waf_operations.R
\name{waf_delete_rule_group}
\alias{waf_delete_rule_group}
\title{Permanently deletes a RuleGroup}
\usage{
waf_delete_rule_group(RuleGroupId, ChangeToken)
}
\arguments{
\item{RuleGroupId}{[required] The \code{RuleGroupId} of the RuleGroup that you want to delete.
\code{RuleGroupId} is returned by CreateRuleGroup and by ListRuleGroups.}

\item{ChangeToken}{[required] The value returned by the most recent call to GetChangeToken.}
}
\description{
Permanently deletes a RuleGroup. You can't delete a \code{RuleGroup} if
it's still used in any \code{WebACL} objects or if it still includes any
rules.
}
\details{
If you just want to remove a \code{RuleGroup} from a \code{WebACL}, use
UpdateWebACL.

To permanently delete a \code{RuleGroup} from AWS WAF, perform the following
steps:
\enumerate{
\item Update the \code{RuleGroup} to remove rules, if any. For more
information, see UpdateRuleGroup.
\item Use GetChangeToken to get the change token that you provide in the
\code{ChangeToken} parameter of a \code{DeleteRuleGroup} request.
\item Submit a \code{DeleteRuleGroup} request.
}
}
\section{Request syntax}{
\preformatted{svc$delete_rule_group(
  RuleGroupId = "string",
  ChangeToken = "string"
)
}
}

\keyword{internal}
