# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include guardduty_service.R
NULL

#' Accepts the invitation to be monitored by a master GuardDuty account
#'
#' Accepts the invitation to be monitored by a master GuardDuty account.
#'
#' @usage
#' guardduty_accept_invitation(DetectorId, MasterId, InvitationId)
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector of the GuardDuty member account.
#' @param MasterId &#91;required&#93; The account ID of the master GuardDuty account whose invitation you\'re
#' accepting.
#' @param InvitationId &#91;required&#93; This value is used to validate the master account to the member account.
#'
#' @section Request syntax:
#' ```
#' svc$accept_invitation(
#'   DetectorId = "string",
#'   MasterId = "string",
#'   InvitationId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_accept_invitation
guardduty_accept_invitation <- function(DetectorId, MasterId, InvitationId) {
  op <- new_operation(
    name = "AcceptInvitation",
    http_method = "POST",
    http_path = "/detector/{detectorId}/master",
    paginator = list()
  )
  input <- .guardduty$accept_invitation_input(DetectorId = DetectorId, MasterId = MasterId, InvitationId = InvitationId)
  output <- .guardduty$accept_invitation_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$accept_invitation <- guardduty_accept_invitation

#' Archives Amazon GuardDuty findings specified by the list of finding IDs
#'
#' Archives Amazon GuardDuty findings specified by the list of finding IDs.
#'
#' @usage
#' guardduty_archive_findings(DetectorId, FindingIds)
#'
#' @param DetectorId &#91;required&#93; The ID of the detector that specifies the GuardDuty service whose
#' findings you want to archive.
#' @param FindingIds &#91;required&#93; IDs of the findings that you want to archive.
#'
#' @section Request syntax:
#' ```
#' svc$archive_findings(
#'   DetectorId = "string",
#'   FindingIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_archive_findings
guardduty_archive_findings <- function(DetectorId, FindingIds) {
  op <- new_operation(
    name = "ArchiveFindings",
    http_method = "POST",
    http_path = "/detector/{detectorId}/findings/archive",
    paginator = list()
  )
  input <- .guardduty$archive_findings_input(DetectorId = DetectorId, FindingIds = FindingIds)
  output <- .guardduty$archive_findings_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$archive_findings <- guardduty_archive_findings

#' Creates a single Amazon GuardDuty detector
#'
#' Creates a single Amazon GuardDuty detector. A detector is an object that
#' represents the GuardDuty service. A detector must be created in order
#' for GuardDuty to become operational.
#'
#' @usage
#' guardduty_create_detector(Enable, ClientToken,
#'   FindingPublishingFrequency, Tags)
#'
#' @param Enable &#91;required&#93; A boolean value that specifies whether the detector is to be enabled.
#' @param ClientToken The idempotency token for the create request.
#' @param FindingPublishingFrequency A enum value that specifies how frequently customer got Finding updates
#' published.
#' @param Tags The tags to be added to a new detector resource.
#'
#' @section Request syntax:
#' ```
#' svc$create_detector(
#'   Enable = TRUE|FALSE,
#'   ClientToken = "string",
#'   FindingPublishingFrequency = "FIFTEEN_MINUTES"|"ONE_HOUR"|"SIX_HOURS",
#'   Tags = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_create_detector
guardduty_create_detector <- function(Enable, ClientToken = NULL, FindingPublishingFrequency = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateDetector",
    http_method = "POST",
    http_path = "/detector",
    paginator = list()
  )
  input <- .guardduty$create_detector_input(Enable = Enable, ClientToken = ClientToken, FindingPublishingFrequency = FindingPublishingFrequency, Tags = Tags)
  output <- .guardduty$create_detector_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$create_detector <- guardduty_create_detector

#' Creates a filter using the specified finding criteria
#'
#' Creates a filter using the specified finding criteria.
#'
#' @usage
#' guardduty_create_filter(DetectorId, Name, Description, Action, Rank,
#'   FindingCriteria, ClientToken, Tags)
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector of the GuardDuty account for which you
#' want to create a filter.
#' @param Name &#91;required&#93; The name of the filter.
#' @param Description The description of the filter.
#' @param Action Specifies the action that is to be applied to the findings that match
#' the filter.
#' @param Rank Specifies the position of the filter in the list of current filters.
#' Also specifies the order in which this filter is applied to the
#' findings.
#' @param FindingCriteria &#91;required&#93; Represents the criteria to be used in the filter for querying findings.
#' @param ClientToken The idempotency token for the create request.
#' @param Tags The tags to be added to a new filter resource.
#'
#' @section Request syntax:
#' ```
#' svc$create_filter(
#'   DetectorId = "string",
#'   Name = "string",
#'   Description = "string",
#'   Action = "NOOP"|"ARCHIVE",
#'   Rank = 123,
#'   FindingCriteria = list(
#'     Criterion = list(
#'       list(
#'         Eq = list(
#'           "string"
#'         ),
#'         Neq = list(
#'           "string"
#'         ),
#'         Gt = 123,
#'         Gte = 123,
#'         Lt = 123,
#'         Lte = 123,
#'         Equals = list(
#'           "string"
#'         ),
#'         NotEquals = list(
#'           "string"
#'         ),
#'         GreaterThan = 123,
#'         GreaterThanOrEqual = 123,
#'         LessThan = 123,
#'         LessThanOrEqual = 123
#'       )
#'     )
#'   ),
#'   ClientToken = "string",
#'   Tags = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_create_filter
guardduty_create_filter <- function(DetectorId, Name, Description = NULL, Action = NULL, Rank = NULL, FindingCriteria, ClientToken = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateFilter",
    http_method = "POST",
    http_path = "/detector/{detectorId}/filter",
    paginator = list()
  )
  input <- .guardduty$create_filter_input(DetectorId = DetectorId, Name = Name, Description = Description, Action = Action, Rank = Rank, FindingCriteria = FindingCriteria, ClientToken = ClientToken, Tags = Tags)
  output <- .guardduty$create_filter_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$create_filter <- guardduty_create_filter

#' Creates a new IPSet - a list of trusted IP addresses that have been
#' whitelisted for secure communication with AWS infrastructure and
#' applications
#'
#' Creates a new IPSet - a list of trusted IP addresses that have been
#' whitelisted for secure communication with AWS infrastructure and
#' applications.
#'
#' @usage
#' guardduty_create_ip_set(DetectorId, Name, Format, Location, Activate,
#'   ClientToken, Tags)
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector of the GuardDuty account for which you
#' want to create an IPSet.
#' @param Name &#91;required&#93; The user friendly name to identify the IPSet. This name is displayed in
#' all findings that are triggered by activity that involves IP addresses
#' included in this IPSet.
#' @param Format &#91;required&#93; The format of the file that contains the IPSet.
#' @param Location &#91;required&#93; The URI of the file that contains the IPSet. For example
#' (https://s3.us-west-2.amazonaws.com/my-bucket/my-object-key)
#' @param Activate &#91;required&#93; A boolean value that indicates whether GuardDuty is to start using the
#' uploaded IPSet.
#' @param ClientToken The idempotency token for the create request.
#' @param Tags The tags to be added to a new IP set resource.
#'
#' @section Request syntax:
#' ```
#' svc$create_ip_set(
#'   DetectorId = "string",
#'   Name = "string",
#'   Format = "TXT"|"STIX"|"OTX_CSV"|"ALIEN_VAULT"|"PROOF_POINT"|"FIRE_EYE",
#'   Location = "string",
#'   Activate = TRUE|FALSE,
#'   ClientToken = "string",
#'   Tags = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_create_ip_set
guardduty_create_ip_set <- function(DetectorId, Name, Format, Location, Activate, ClientToken = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateIPSet",
    http_method = "POST",
    http_path = "/detector/{detectorId}/ipset",
    paginator = list()
  )
  input <- .guardduty$create_ip_set_input(DetectorId = DetectorId, Name = Name, Format = Format, Location = Location, Activate = Activate, ClientToken = ClientToken, Tags = Tags)
  output <- .guardduty$create_ip_set_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$create_ip_set <- guardduty_create_ip_set

#' Creates member accounts of the current AWS account by specifying a list
#' of AWS account IDs
#'
#' Creates member accounts of the current AWS account by specifying a list
#' of AWS account IDs. The current AWS account can then invite these
#' members to manage GuardDuty in their accounts.
#'
#' @usage
#' guardduty_create_members(DetectorId, AccountDetails)
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector of the GuardDuty account with which you
#' want to associate member accounts.
#' @param AccountDetails &#91;required&#93; A list of account ID and email address pairs of the accounts that you
#' want to associate with the master GuardDuty account.
#'
#' @section Request syntax:
#' ```
#' svc$create_members(
#'   DetectorId = "string",
#'   AccountDetails = list(
#'     list(
#'       AccountId = "string",
#'       Email = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_create_members
guardduty_create_members <- function(DetectorId, AccountDetails) {
  op <- new_operation(
    name = "CreateMembers",
    http_method = "POST",
    http_path = "/detector/{detectorId}/member",
    paginator = list()
  )
  input <- .guardduty$create_members_input(DetectorId = DetectorId, AccountDetails = AccountDetails)
  output <- .guardduty$create_members_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$create_members <- guardduty_create_members

#' Generates example findings of types specified by the list of finding
#' types
#'
#' Generates example findings of types specified by the list of finding
#' types. If \'NULL\' is specified for findingTypes, the API generates
#' example findings of all supported finding types.
#'
#' @usage
#' guardduty_create_sample_findings(DetectorId, FindingTypes)
#'
#' @param DetectorId &#91;required&#93; The ID of the detector to create sample findings for.
#' @param FindingTypes Types of sample findings that you want to generate.
#'
#' @section Request syntax:
#' ```
#' svc$create_sample_findings(
#'   DetectorId = "string",
#'   FindingTypes = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_create_sample_findings
guardduty_create_sample_findings <- function(DetectorId, FindingTypes = NULL) {
  op <- new_operation(
    name = "CreateSampleFindings",
    http_method = "POST",
    http_path = "/detector/{detectorId}/findings/create",
    paginator = list()
  )
  input <- .guardduty$create_sample_findings_input(DetectorId = DetectorId, FindingTypes = FindingTypes)
  output <- .guardduty$create_sample_findings_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$create_sample_findings <- guardduty_create_sample_findings

#' Create a new ThreatIntelSet
#'
#' Create a new ThreatIntelSet. ThreatIntelSets consist of known malicious
#' IP addresses. GuardDuty generates findings based on ThreatIntelSets.
#'
#' @usage
#' guardduty_create_threat_intel_set(DetectorId, Name, Format, Location,
#'   Activate, ClientToken, Tags)
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector of the GuardDuty account for which you
#' want to create a threatIntelSet.
#' @param Name &#91;required&#93; A user-friendly ThreatIntelSet name that is displayed in all finding
#' generated by activity that involves IP addresses included in this
#' ThreatIntelSet.
#' @param Format &#91;required&#93; The format of the file that contains the ThreatIntelSet.
#' @param Location &#91;required&#93; The URI of the file that contains the ThreatIntelSet. For example
#' (https://s3.us-west-2.amazonaws.com/my-bucket/my-object-key).
#' @param Activate &#91;required&#93; A boolean value that indicates whether GuardDuty is to start using the
#' uploaded ThreatIntelSet.
#' @param ClientToken The idempotency token for the create request.
#' @param Tags The tags to be added to a new Threat List resource.
#'
#' @section Request syntax:
#' ```
#' svc$create_threat_intel_set(
#'   DetectorId = "string",
#'   Name = "string",
#'   Format = "TXT"|"STIX"|"OTX_CSV"|"ALIEN_VAULT"|"PROOF_POINT"|"FIRE_EYE",
#'   Location = "string",
#'   Activate = TRUE|FALSE,
#'   ClientToken = "string",
#'   Tags = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_create_threat_intel_set
guardduty_create_threat_intel_set <- function(DetectorId, Name, Format, Location, Activate, ClientToken = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateThreatIntelSet",
    http_method = "POST",
    http_path = "/detector/{detectorId}/threatintelset",
    paginator = list()
  )
  input <- .guardduty$create_threat_intel_set_input(DetectorId = DetectorId, Name = Name, Format = Format, Location = Location, Activate = Activate, ClientToken = ClientToken, Tags = Tags)
  output <- .guardduty$create_threat_intel_set_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$create_threat_intel_set <- guardduty_create_threat_intel_set

#' Declines invitations sent to the current member account by AWS account
#' specified by their account IDs
#'
#' Declines invitations sent to the current member account by AWS account
#' specified by their account IDs.
#'
#' @usage
#' guardduty_decline_invitations(AccountIds)
#'
#' @param AccountIds &#91;required&#93; A list of account IDs of the AWS accounts that sent invitations to the
#' current member account that you want to decline invitations from.
#'
#' @section Request syntax:
#' ```
#' svc$decline_invitations(
#'   AccountIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_decline_invitations
guardduty_decline_invitations <- function(AccountIds) {
  op <- new_operation(
    name = "DeclineInvitations",
    http_method = "POST",
    http_path = "/invitation/decline",
    paginator = list()
  )
  input <- .guardduty$decline_invitations_input(AccountIds = AccountIds)
  output <- .guardduty$decline_invitations_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$decline_invitations <- guardduty_decline_invitations

#' Deletes a Amazon GuardDuty detector specified by the detector ID
#'
#' Deletes a Amazon GuardDuty detector specified by the detector ID.
#'
#' @usage
#' guardduty_delete_detector(DetectorId)
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector that you want to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_detector(
#'   DetectorId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_delete_detector
guardduty_delete_detector <- function(DetectorId) {
  op <- new_operation(
    name = "DeleteDetector",
    http_method = "DELETE",
    http_path = "/detector/{detectorId}",
    paginator = list()
  )
  input <- .guardduty$delete_detector_input(DetectorId = DetectorId)
  output <- .guardduty$delete_detector_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$delete_detector <- guardduty_delete_detector

#' Deletes the filter specified by the filter name
#'
#' Deletes the filter specified by the filter name.
#'
#' @usage
#' guardduty_delete_filter(DetectorId, FilterName)
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector the filter is associated with.
#' @param FilterName &#91;required&#93; The name of the filter you want to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_filter(
#'   DetectorId = "string",
#'   FilterName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_delete_filter
guardduty_delete_filter <- function(DetectorId, FilterName) {
  op <- new_operation(
    name = "DeleteFilter",
    http_method = "DELETE",
    http_path = "/detector/{detectorId}/filter/{filterName}",
    paginator = list()
  )
  input <- .guardduty$delete_filter_input(DetectorId = DetectorId, FilterName = FilterName)
  output <- .guardduty$delete_filter_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$delete_filter <- guardduty_delete_filter

#' Deletes the IPSet specified by the IPSet ID
#'
#' Deletes the IPSet specified by the IPSet ID.
#'
#' @usage
#' guardduty_delete_ip_set(DetectorId, IpSetId)
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector the ipSet is associated with.
#' @param IpSetId &#91;required&#93; The unique ID of the ipSet you want to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_ip_set(
#'   DetectorId = "string",
#'   IpSetId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_delete_ip_set
guardduty_delete_ip_set <- function(DetectorId, IpSetId) {
  op <- new_operation(
    name = "DeleteIPSet",
    http_method = "DELETE",
    http_path = "/detector/{detectorId}/ipset/{ipSetId}",
    paginator = list()
  )
  input <- .guardduty$delete_ip_set_input(DetectorId = DetectorId, IpSetId = IpSetId)
  output <- .guardduty$delete_ip_set_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$delete_ip_set <- guardduty_delete_ip_set

#' Deletes invitations sent to the current member account by AWS accounts
#' specified by their account IDs
#'
#' Deletes invitations sent to the current member account by AWS accounts
#' specified by their account IDs.
#'
#' @usage
#' guardduty_delete_invitations(AccountIds)
#'
#' @param AccountIds &#91;required&#93; A list of account IDs of the AWS accounts that sent invitations to the
#' current member account that you want to delete invitations from.
#'
#' @section Request syntax:
#' ```
#' svc$delete_invitations(
#'   AccountIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_delete_invitations
guardduty_delete_invitations <- function(AccountIds) {
  op <- new_operation(
    name = "DeleteInvitations",
    http_method = "POST",
    http_path = "/invitation/delete",
    paginator = list()
  )
  input <- .guardduty$delete_invitations_input(AccountIds = AccountIds)
  output <- .guardduty$delete_invitations_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$delete_invitations <- guardduty_delete_invitations

#' Deletes GuardDuty member accounts (to the current GuardDuty master
#' account) specified by the account IDs
#'
#' Deletes GuardDuty member accounts (to the current GuardDuty master
#' account) specified by the account IDs.
#'
#' @usage
#' guardduty_delete_members(DetectorId, AccountIds)
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector of the GuardDuty account whose members you
#' want to delete.
#' @param AccountIds &#91;required&#93; A list of account IDs of the GuardDuty member accounts that you want to
#' delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_members(
#'   DetectorId = "string",
#'   AccountIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_delete_members
guardduty_delete_members <- function(DetectorId, AccountIds) {
  op <- new_operation(
    name = "DeleteMembers",
    http_method = "POST",
    http_path = "/detector/{detectorId}/member/delete",
    paginator = list()
  )
  input <- .guardduty$delete_members_input(DetectorId = DetectorId, AccountIds = AccountIds)
  output <- .guardduty$delete_members_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$delete_members <- guardduty_delete_members

#' Deletes ThreatIntelSet specified by the ThreatIntelSet ID
#'
#' Deletes ThreatIntelSet specified by the ThreatIntelSet ID.
#'
#' @usage
#' guardduty_delete_threat_intel_set(DetectorId, ThreatIntelSetId)
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector the threatIntelSet is associated with.
#' @param ThreatIntelSetId &#91;required&#93; The unique ID of the threatIntelSet you want to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_threat_intel_set(
#'   DetectorId = "string",
#'   ThreatIntelSetId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_delete_threat_intel_set
guardduty_delete_threat_intel_set <- function(DetectorId, ThreatIntelSetId) {
  op <- new_operation(
    name = "DeleteThreatIntelSet",
    http_method = "DELETE",
    http_path = "/detector/{detectorId}/threatintelset/{threatIntelSetId}",
    paginator = list()
  )
  input <- .guardduty$delete_threat_intel_set_input(DetectorId = DetectorId, ThreatIntelSetId = ThreatIntelSetId)
  output <- .guardduty$delete_threat_intel_set_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$delete_threat_intel_set <- guardduty_delete_threat_intel_set

#' Disassociates the current GuardDuty member account from its master
#' account
#'
#' Disassociates the current GuardDuty member account from its master
#' account.
#'
#' @usage
#' guardduty_disassociate_from_master_account(DetectorId)
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector of the GuardDuty member account.
#'
#' @section Request syntax:
#' ```
#' svc$disassociate_from_master_account(
#'   DetectorId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_disassociate_from_master_account
guardduty_disassociate_from_master_account <- function(DetectorId) {
  op <- new_operation(
    name = "DisassociateFromMasterAccount",
    http_method = "POST",
    http_path = "/detector/{detectorId}/master/disassociate",
    paginator = list()
  )
  input <- .guardduty$disassociate_from_master_account_input(DetectorId = DetectorId)
  output <- .guardduty$disassociate_from_master_account_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$disassociate_from_master_account <- guardduty_disassociate_from_master_account

#' Disassociates GuardDuty member accounts (to the current GuardDuty master
#' account) specified by the account IDs
#'
#' Disassociates GuardDuty member accounts (to the current GuardDuty master
#' account) specified by the account IDs.
#'
#' @usage
#' guardduty_disassociate_members(DetectorId, AccountIds)
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector of the GuardDuty account whose members you
#' want to disassociate from master.
#' @param AccountIds &#91;required&#93; A list of account IDs of the GuardDuty member accounts that you want to
#' disassociate from master.
#'
#' @section Request syntax:
#' ```
#' svc$disassociate_members(
#'   DetectorId = "string",
#'   AccountIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_disassociate_members
guardduty_disassociate_members <- function(DetectorId, AccountIds) {
  op <- new_operation(
    name = "DisassociateMembers",
    http_method = "POST",
    http_path = "/detector/{detectorId}/member/disassociate",
    paginator = list()
  )
  input <- .guardduty$disassociate_members_input(DetectorId = DetectorId, AccountIds = AccountIds)
  output <- .guardduty$disassociate_members_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$disassociate_members <- guardduty_disassociate_members

#' Retrieves an Amazon GuardDuty detector specified by the detectorId
#'
#' Retrieves an Amazon GuardDuty detector specified by the detectorId.
#'
#' @usage
#' guardduty_get_detector(DetectorId)
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector that you want to get.
#'
#' @section Request syntax:
#' ```
#' svc$get_detector(
#'   DetectorId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_get_detector
guardduty_get_detector <- function(DetectorId) {
  op <- new_operation(
    name = "GetDetector",
    http_method = "GET",
    http_path = "/detector/{detectorId}",
    paginator = list()
  )
  input <- .guardduty$get_detector_input(DetectorId = DetectorId)
  output <- .guardduty$get_detector_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$get_detector <- guardduty_get_detector

#' Returns the details of the filter specified by the filter name
#'
#' Returns the details of the filter specified by the filter name.
#'
#' @usage
#' guardduty_get_filter(DetectorId, FilterName)
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector the filter is associated with.
#' @param FilterName &#91;required&#93; The name of the filter you want to get.
#'
#' @section Request syntax:
#' ```
#' svc$get_filter(
#'   DetectorId = "string",
#'   FilterName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_get_filter
guardduty_get_filter <- function(DetectorId, FilterName) {
  op <- new_operation(
    name = "GetFilter",
    http_method = "GET",
    http_path = "/detector/{detectorId}/filter/{filterName}",
    paginator = list()
  )
  input <- .guardduty$get_filter_input(DetectorId = DetectorId, FilterName = FilterName)
  output <- .guardduty$get_filter_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$get_filter <- guardduty_get_filter

#' Describes Amazon GuardDuty findings specified by finding IDs
#'
#' Describes Amazon GuardDuty findings specified by finding IDs.
#'
#' @usage
#' guardduty_get_findings(DetectorId, FindingIds, SortCriteria)
#'
#' @param DetectorId &#91;required&#93; The ID of the detector that specifies the GuardDuty service whose
#' findings you want to retrieve.
#' @param FindingIds &#91;required&#93; IDs of the findings that you want to retrieve.
#' @param SortCriteria Represents the criteria used for sorting findings.
#'
#' @section Request syntax:
#' ```
#' svc$get_findings(
#'   DetectorId = "string",
#'   FindingIds = list(
#'     "string"
#'   ),
#'   SortCriteria = list(
#'     AttributeName = "string",
#'     OrderBy = "ASC"|"DESC"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_get_findings
guardduty_get_findings <- function(DetectorId, FindingIds, SortCriteria = NULL) {
  op <- new_operation(
    name = "GetFindings",
    http_method = "POST",
    http_path = "/detector/{detectorId}/findings/get",
    paginator = list()
  )
  input <- .guardduty$get_findings_input(DetectorId = DetectorId, FindingIds = FindingIds, SortCriteria = SortCriteria)
  output <- .guardduty$get_findings_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$get_findings <- guardduty_get_findings

#' Lists Amazon GuardDuty findings' statistics for the specified detector
#' ID
#'
#' Lists Amazon GuardDuty findings\' statistics for the specified detector
#' ID.
#'
#' @usage
#' guardduty_get_findings_statistics(DetectorId, FindingStatisticTypes,
#'   FindingCriteria)
#'
#' @param DetectorId &#91;required&#93; The ID of the detector that specifies the GuardDuty service whose
#' findings\' statistics you want to retrieve.
#' @param FindingStatisticTypes &#91;required&#93; Types of finding statistics to retrieve.
#' @param FindingCriteria Represents the criteria used for querying findings.
#'
#' @section Request syntax:
#' ```
#' svc$get_findings_statistics(
#'   DetectorId = "string",
#'   FindingStatisticTypes = list(
#'     "COUNT_BY_SEVERITY"
#'   ),
#'   FindingCriteria = list(
#'     Criterion = list(
#'       list(
#'         Eq = list(
#'           "string"
#'         ),
#'         Neq = list(
#'           "string"
#'         ),
#'         Gt = 123,
#'         Gte = 123,
#'         Lt = 123,
#'         Lte = 123,
#'         Equals = list(
#'           "string"
#'         ),
#'         NotEquals = list(
#'           "string"
#'         ),
#'         GreaterThan = 123,
#'         GreaterThanOrEqual = 123,
#'         LessThan = 123,
#'         LessThanOrEqual = 123
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_get_findings_statistics
guardduty_get_findings_statistics <- function(DetectorId, FindingStatisticTypes, FindingCriteria = NULL) {
  op <- new_operation(
    name = "GetFindingsStatistics",
    http_method = "POST",
    http_path = "/detector/{detectorId}/findings/statistics",
    paginator = list()
  )
  input <- .guardduty$get_findings_statistics_input(DetectorId = DetectorId, FindingStatisticTypes = FindingStatisticTypes, FindingCriteria = FindingCriteria)
  output <- .guardduty$get_findings_statistics_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$get_findings_statistics <- guardduty_get_findings_statistics

#' Retrieves the IPSet specified by the IPSet ID
#'
#' Retrieves the IPSet specified by the IPSet ID.
#'
#' @usage
#' guardduty_get_ip_set(DetectorId, IpSetId)
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector the ipSet is associated with.
#' @param IpSetId &#91;required&#93; The unique ID of the ipSet you want to get.
#'
#' @section Request syntax:
#' ```
#' svc$get_ip_set(
#'   DetectorId = "string",
#'   IpSetId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_get_ip_set
guardduty_get_ip_set <- function(DetectorId, IpSetId) {
  op <- new_operation(
    name = "GetIPSet",
    http_method = "GET",
    http_path = "/detector/{detectorId}/ipset/{ipSetId}",
    paginator = list()
  )
  input <- .guardduty$get_ip_set_input(DetectorId = DetectorId, IpSetId = IpSetId)
  output <- .guardduty$get_ip_set_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$get_ip_set <- guardduty_get_ip_set

#' Returns the count of all GuardDuty membership invitations that were sent
#' to the current member account except the currently accepted invitation
#'
#' Returns the count of all GuardDuty membership invitations that were sent
#' to the current member account except the currently accepted invitation.
#'
#' @usage
#' guardduty_get_invitations_count()
#'
#' @section Request syntax:
#' ```
#' svc$get_invitations_count()
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_get_invitations_count
guardduty_get_invitations_count <- function() {
  op <- new_operation(
    name = "GetInvitationsCount",
    http_method = "GET",
    http_path = "/invitation/count",
    paginator = list()
  )
  input <- .guardduty$get_invitations_count_input()
  output <- .guardduty$get_invitations_count_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$get_invitations_count <- guardduty_get_invitations_count

#' Provides the details for the GuardDuty master account to the current
#' GuardDuty member account
#'
#' Provides the details for the GuardDuty master account to the current
#' GuardDuty member account.
#'
#' @usage
#' guardduty_get_master_account(DetectorId)
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector of the GuardDuty member account.
#'
#' @section Request syntax:
#' ```
#' svc$get_master_account(
#'   DetectorId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_get_master_account
guardduty_get_master_account <- function(DetectorId) {
  op <- new_operation(
    name = "GetMasterAccount",
    http_method = "GET",
    http_path = "/detector/{detectorId}/master",
    paginator = list()
  )
  input <- .guardduty$get_master_account_input(DetectorId = DetectorId)
  output <- .guardduty$get_master_account_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$get_master_account <- guardduty_get_master_account

#' Retrieves GuardDuty member accounts (to the current GuardDuty master
#' account) specified by the account IDs
#'
#' Retrieves GuardDuty member accounts (to the current GuardDuty master
#' account) specified by the account IDs.
#'
#' @usage
#' guardduty_get_members(DetectorId, AccountIds)
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector of the GuardDuty account whose members you
#' want to retrieve.
#' @param AccountIds &#91;required&#93; A list of account IDs of the GuardDuty member accounts that you want to
#' describe.
#'
#' @section Request syntax:
#' ```
#' svc$get_members(
#'   DetectorId = "string",
#'   AccountIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_get_members
guardduty_get_members <- function(DetectorId, AccountIds) {
  op <- new_operation(
    name = "GetMembers",
    http_method = "POST",
    http_path = "/detector/{detectorId}/member/get",
    paginator = list()
  )
  input <- .guardduty$get_members_input(DetectorId = DetectorId, AccountIds = AccountIds)
  output <- .guardduty$get_members_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$get_members <- guardduty_get_members

#' Retrieves the ThreatIntelSet that is specified by the ThreatIntelSet ID
#'
#' Retrieves the ThreatIntelSet that is specified by the ThreatIntelSet ID.
#'
#' @usage
#' guardduty_get_threat_intel_set(DetectorId, ThreatIntelSetId)
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector the threatIntelSet is associated with.
#' @param ThreatIntelSetId &#91;required&#93; The unique ID of the threatIntelSet you want to get.
#'
#' @section Request syntax:
#' ```
#' svc$get_threat_intel_set(
#'   DetectorId = "string",
#'   ThreatIntelSetId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_get_threat_intel_set
guardduty_get_threat_intel_set <- function(DetectorId, ThreatIntelSetId) {
  op <- new_operation(
    name = "GetThreatIntelSet",
    http_method = "GET",
    http_path = "/detector/{detectorId}/threatintelset/{threatIntelSetId}",
    paginator = list()
  )
  input <- .guardduty$get_threat_intel_set_input(DetectorId = DetectorId, ThreatIntelSetId = ThreatIntelSetId)
  output <- .guardduty$get_threat_intel_set_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$get_threat_intel_set <- guardduty_get_threat_intel_set

#' Invites other AWS accounts (created as members of the current AWS
#' account by CreateMembers) to enable GuardDuty and allow the current AWS
#' account to view and manage these accounts' GuardDuty findings on their
#' behalf as the master account
#'
#' Invites other AWS accounts (created as members of the current AWS
#' account by CreateMembers) to enable GuardDuty and allow the current AWS
#' account to view and manage these accounts\' GuardDuty findings on their
#' behalf as the master account.
#'
#' @usage
#' guardduty_invite_members(DetectorId, AccountIds,
#'   DisableEmailNotification, Message)
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector of the GuardDuty account with which you
#' want to invite members.
#' @param AccountIds &#91;required&#93; A list of account IDs of the accounts that you want to invite to
#' GuardDuty as members.
#' @param DisableEmailNotification A boolean value that specifies whether you want to disable email
#' notification to the accounts that you're inviting to GuardDuty as
#' members.
#' @param Message The invitation message that you want to send to the accounts that you're
#' inviting to GuardDuty as members.
#'
#' @section Request syntax:
#' ```
#' svc$invite_members(
#'   DetectorId = "string",
#'   AccountIds = list(
#'     "string"
#'   ),
#'   DisableEmailNotification = TRUE|FALSE,
#'   Message = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_invite_members
guardduty_invite_members <- function(DetectorId, AccountIds, DisableEmailNotification = NULL, Message = NULL) {
  op <- new_operation(
    name = "InviteMembers",
    http_method = "POST",
    http_path = "/detector/{detectorId}/member/invite",
    paginator = list()
  )
  input <- .guardduty$invite_members_input(DetectorId = DetectorId, AccountIds = AccountIds, DisableEmailNotification = DisableEmailNotification, Message = Message)
  output <- .guardduty$invite_members_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$invite_members <- guardduty_invite_members

#' Lists detectorIds of all the existing Amazon GuardDuty detector
#' resources
#'
#' Lists detectorIds of all the existing Amazon GuardDuty detector
#' resources.
#'
#' @usage
#' guardduty_list_detectors(MaxResults, NextToken)
#'
#' @param MaxResults You can use this parameter to indicate the maximum number of items you
#' want in the response. The default value is 50. The maximum value is 50.
#' @param NextToken You can use this parameter when paginating results. Set the value of
#' this parameter to null on your first call to the list action. For
#' subsequent calls to the action fill nextToken in the request with the
#' value of NextToken from the previous response to continue listing data.
#'
#' @section Request syntax:
#' ```
#' svc$list_detectors(
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_list_detectors
guardduty_list_detectors <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListDetectors",
    http_method = "GET",
    http_path = "/detector",
    paginator = list()
  )
  input <- .guardduty$list_detectors_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .guardduty$list_detectors_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$list_detectors <- guardduty_list_detectors

#' Returns a paginated list of the current filters
#'
#' Returns a paginated list of the current filters.
#'
#' @usage
#' guardduty_list_filters(DetectorId, MaxResults, NextToken)
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector the filter is associated with.
#' @param MaxResults You can use this parameter to indicate the maximum number of items you
#' want in the response. The default value is 50. The maximum value is 50.
#' @param NextToken You can use this parameter when paginating results. Set the value of
#' this parameter to null on your first call to the list action. For
#' subsequent calls to the action fill nextToken in the request with the
#' value of NextToken from the previous response to continue listing data.
#'
#' @section Request syntax:
#' ```
#' svc$list_filters(
#'   DetectorId = "string",
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_list_filters
guardduty_list_filters <- function(DetectorId, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListFilters",
    http_method = "GET",
    http_path = "/detector/{detectorId}/filter",
    paginator = list()
  )
  input <- .guardduty$list_filters_input(DetectorId = DetectorId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .guardduty$list_filters_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$list_filters <- guardduty_list_filters

#' Lists Amazon GuardDuty findings for the specified detector ID
#'
#' Lists Amazon GuardDuty findings for the specified detector ID.
#'
#' @usage
#' guardduty_list_findings(DetectorId, FindingCriteria, SortCriteria,
#'   MaxResults, NextToken)
#'
#' @param DetectorId &#91;required&#93; The ID of the detector that specifies the GuardDuty service whose
#' findings you want to list.
#' @param FindingCriteria Represents the criteria used for querying findings.
#' @param SortCriteria Represents the criteria used for sorting findings.
#' @param MaxResults You can use this parameter to indicate the maximum number of items you
#' want in the response. The default value is 50. The maximum value is 50.
#' @param NextToken You can use this parameter when paginating results. Set the value of
#' this parameter to null on your first call to the list action. For
#' subsequent calls to the action fill nextToken in the request with the
#' value of NextToken from the previous response to continue listing data.
#'
#' @section Request syntax:
#' ```
#' svc$list_findings(
#'   DetectorId = "string",
#'   FindingCriteria = list(
#'     Criterion = list(
#'       list(
#'         Eq = list(
#'           "string"
#'         ),
#'         Neq = list(
#'           "string"
#'         ),
#'         Gt = 123,
#'         Gte = 123,
#'         Lt = 123,
#'         Lte = 123,
#'         Equals = list(
#'           "string"
#'         ),
#'         NotEquals = list(
#'           "string"
#'         ),
#'         GreaterThan = 123,
#'         GreaterThanOrEqual = 123,
#'         LessThan = 123,
#'         LessThanOrEqual = 123
#'       )
#'     )
#'   ),
#'   SortCriteria = list(
#'     AttributeName = "string",
#'     OrderBy = "ASC"|"DESC"
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_list_findings
guardduty_list_findings <- function(DetectorId, FindingCriteria = NULL, SortCriteria = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListFindings",
    http_method = "POST",
    http_path = "/detector/{detectorId}/findings",
    paginator = list()
  )
  input <- .guardduty$list_findings_input(DetectorId = DetectorId, FindingCriteria = FindingCriteria, SortCriteria = SortCriteria, MaxResults = MaxResults, NextToken = NextToken)
  output <- .guardduty$list_findings_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$list_findings <- guardduty_list_findings

#' Lists the IPSets of the GuardDuty service specified by the detector ID
#'
#' Lists the IPSets of the GuardDuty service specified by the detector ID.
#'
#' @usage
#' guardduty_list_ip_sets(DetectorId, MaxResults, NextToken)
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector the ipSet is associated with.
#' @param MaxResults You can use this parameter to indicate the maximum number of items you
#' want in the response. The default value is 50. The maximum value is 50.
#' @param NextToken You can use this parameter when paginating results. Set the value of
#' this parameter to null on your first call to the list action. For
#' subsequent calls to the action fill nextToken in the request with the
#' value of NextToken from the previous response to continue listing data.
#'
#' @section Request syntax:
#' ```
#' svc$list_ip_sets(
#'   DetectorId = "string",
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_list_ip_sets
guardduty_list_ip_sets <- function(DetectorId, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListIPSets",
    http_method = "GET",
    http_path = "/detector/{detectorId}/ipset",
    paginator = list()
  )
  input <- .guardduty$list_ip_sets_input(DetectorId = DetectorId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .guardduty$list_ip_sets_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$list_ip_sets <- guardduty_list_ip_sets

#' Lists all GuardDuty membership invitations that were sent to the current
#' AWS account
#'
#' Lists all GuardDuty membership invitations that were sent to the current
#' AWS account.
#'
#' @usage
#' guardduty_list_invitations(MaxResults, NextToken)
#'
#' @param MaxResults You can use this parameter to indicate the maximum number of items you
#' want in the response. The default value is 50. The maximum value is 50.
#' @param NextToken You can use this parameter when paginating results. Set the value of
#' this parameter to null on your first call to the list action. For
#' subsequent calls to the action fill nextToken in the request with the
#' value of NextToken from the previous response to continue listing data.
#'
#' @section Request syntax:
#' ```
#' svc$list_invitations(
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_list_invitations
guardduty_list_invitations <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListInvitations",
    http_method = "GET",
    http_path = "/invitation",
    paginator = list()
  )
  input <- .guardduty$list_invitations_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .guardduty$list_invitations_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$list_invitations <- guardduty_list_invitations

#' Lists details about all member accounts for the current GuardDuty master
#' account
#'
#' Lists details about all member accounts for the current GuardDuty master
#' account.
#'
#' @usage
#' guardduty_list_members(DetectorId, MaxResults, NextToken,
#'   OnlyAssociated)
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector the member is associated with.
#' @param MaxResults You can use this parameter to indicate the maximum number of items you
#' want in the response. The default value is 50. The maximum value is 50.
#' @param NextToken You can use this parameter when paginating results. Set the value of
#' this parameter to null on your first call to the list action. For
#' subsequent calls to the action fill nextToken in the request with the
#' value of NextToken from the previous response to continue listing data.
#' @param OnlyAssociated Specifies whether to only return associated members or to return all
#' members (including members which haven\'t been invited yet or have been
#' disassociated).
#'
#' @section Request syntax:
#' ```
#' svc$list_members(
#'   DetectorId = "string",
#'   MaxResults = 123,
#'   NextToken = "string",
#'   OnlyAssociated = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_list_members
guardduty_list_members <- function(DetectorId, MaxResults = NULL, NextToken = NULL, OnlyAssociated = NULL) {
  op <- new_operation(
    name = "ListMembers",
    http_method = "GET",
    http_path = "/detector/{detectorId}/member",
    paginator = list()
  )
  input <- .guardduty$list_members_input(DetectorId = DetectorId, MaxResults = MaxResults, NextToken = NextToken, OnlyAssociated = OnlyAssociated)
  output <- .guardduty$list_members_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$list_members <- guardduty_list_members

#' Lists tags for a resource
#'
#' Lists tags for a resource. Tagging is currently supported for detectors,
#' finding filters, IP sets, and Threat Intel sets, with a limit of 50 tags
#' per resource. When invoked, this operation returns all assigned tags for
#' a given resource..
#'
#' @usage
#' guardduty_list_tags_for_resource(ResourceArn)
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) for the given GuardDuty resource
#'
#' @section Request syntax:
#' ```
#' svc$list_tags_for_resource(
#'   ResourceArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_list_tags_for_resource
guardduty_list_tags_for_resource <- function(ResourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .guardduty$list_tags_for_resource_input(ResourceArn = ResourceArn)
  output <- .guardduty$list_tags_for_resource_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$list_tags_for_resource <- guardduty_list_tags_for_resource

#' Lists the ThreatIntelSets of the GuardDuty service specified by the
#' detector ID
#'
#' Lists the ThreatIntelSets of the GuardDuty service specified by the
#' detector ID.
#'
#' @usage
#' guardduty_list_threat_intel_sets(DetectorId, MaxResults, NextToken)
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector the threatIntelSet is associated with.
#' @param MaxResults You can use this parameter to indicate the maximum number of items you
#' want in the response. The default value is 50. The maximum value is 50.
#' @param NextToken You can use this parameter when paginating results. Set the value of
#' this parameter to null on your first call to the list action. For
#' subsequent calls to the action fill nextToken in the request with the
#' value of NextToken from the previous response to continue listing data.
#'
#' @section Request syntax:
#' ```
#' svc$list_threat_intel_sets(
#'   DetectorId = "string",
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_list_threat_intel_sets
guardduty_list_threat_intel_sets <- function(DetectorId, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListThreatIntelSets",
    http_method = "GET",
    http_path = "/detector/{detectorId}/threatintelset",
    paginator = list()
  )
  input <- .guardduty$list_threat_intel_sets_input(DetectorId = DetectorId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .guardduty$list_threat_intel_sets_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$list_threat_intel_sets <- guardduty_list_threat_intel_sets

#' Re-enables GuardDuty to monitor findings of the member accounts
#' specified by the account IDs
#'
#' Re-enables GuardDuty to monitor findings of the member accounts
#' specified by the account IDs. A master GuardDuty account can run this
#' command after disabling GuardDuty from monitoring these members\'
#' findings by running StopMonitoringMembers.
#'
#' @usage
#' guardduty_start_monitoring_members(DetectorId, AccountIds)
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector of the GuardDuty account whom you want to
#' re-enable to monitor members\' findings.
#' @param AccountIds &#91;required&#93; A list of account IDs of the GuardDuty member accounts whose findings
#' you want the master account to monitor.
#'
#' @section Request syntax:
#' ```
#' svc$start_monitoring_members(
#'   DetectorId = "string",
#'   AccountIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_start_monitoring_members
guardduty_start_monitoring_members <- function(DetectorId, AccountIds) {
  op <- new_operation(
    name = "StartMonitoringMembers",
    http_method = "POST",
    http_path = "/detector/{detectorId}/member/start",
    paginator = list()
  )
  input <- .guardduty$start_monitoring_members_input(DetectorId = DetectorId, AccountIds = AccountIds)
  output <- .guardduty$start_monitoring_members_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$start_monitoring_members <- guardduty_start_monitoring_members

#' Disables GuardDuty from monitoring findings of the member accounts
#' specified by the account IDs
#'
#' Disables GuardDuty from monitoring findings of the member accounts
#' specified by the account IDs. After running this command, a master
#' GuardDuty account can run StartMonitoringMembers to re-enable GuardDuty
#' to monitor these members' findings.
#'
#' @usage
#' guardduty_stop_monitoring_members(DetectorId, AccountIds)
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector of the GuardDuty account that you want to
#' stop from monitor members\' findings.
#' @param AccountIds &#91;required&#93; A list of account IDs of the GuardDuty member accounts whose findings
#' you want the master account to stop monitoring.
#'
#' @section Request syntax:
#' ```
#' svc$stop_monitoring_members(
#'   DetectorId = "string",
#'   AccountIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_stop_monitoring_members
guardduty_stop_monitoring_members <- function(DetectorId, AccountIds) {
  op <- new_operation(
    name = "StopMonitoringMembers",
    http_method = "POST",
    http_path = "/detector/{detectorId}/member/stop",
    paginator = list()
  )
  input <- .guardduty$stop_monitoring_members_input(DetectorId = DetectorId, AccountIds = AccountIds)
  output <- .guardduty$stop_monitoring_members_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$stop_monitoring_members <- guardduty_stop_monitoring_members

#' Adds tags to a resource
#'
#' Adds tags to a resource.
#'
#' @usage
#' guardduty_tag_resource(ResourceArn, Tags)
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) for the given GuardDuty resource
#' @param Tags &#91;required&#93; The tags to be added to a resource.
#'
#' @section Request syntax:
#' ```
#' svc$tag_resource(
#'   ResourceArn = "string",
#'   Tags = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_tag_resource
guardduty_tag_resource <- function(ResourceArn, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .guardduty$tag_resource_input(ResourceArn = ResourceArn, Tags = Tags)
  output <- .guardduty$tag_resource_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$tag_resource <- guardduty_tag_resource

#' Unarchives Amazon GuardDuty findings specified by the list of finding
#' IDs
#'
#' Unarchives Amazon GuardDuty findings specified by the list of finding
#' IDs.
#'
#' @usage
#' guardduty_unarchive_findings(DetectorId, FindingIds)
#'
#' @param DetectorId &#91;required&#93; The ID of the detector that specifies the GuardDuty service whose
#' findings you want to unarchive.
#' @param FindingIds &#91;required&#93; IDs of the findings that you want to unarchive.
#'
#' @section Request syntax:
#' ```
#' svc$unarchive_findings(
#'   DetectorId = "string",
#'   FindingIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_unarchive_findings
guardduty_unarchive_findings <- function(DetectorId, FindingIds) {
  op <- new_operation(
    name = "UnarchiveFindings",
    http_method = "POST",
    http_path = "/detector/{detectorId}/findings/unarchive",
    paginator = list()
  )
  input <- .guardduty$unarchive_findings_input(DetectorId = DetectorId, FindingIds = FindingIds)
  output <- .guardduty$unarchive_findings_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$unarchive_findings <- guardduty_unarchive_findings

#' Removes tags from a resource
#'
#' Removes tags from a resource.
#'
#' @usage
#' guardduty_untag_resource(ResourceArn, TagKeys)
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) for the given GuardDuty resource
#' @param TagKeys &#91;required&#93; The tag keys to remove from a resource.
#'
#' @section Request syntax:
#' ```
#' svc$untag_resource(
#'   ResourceArn = "string",
#'   TagKeys = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_untag_resource
guardduty_untag_resource <- function(ResourceArn, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .guardduty$untag_resource_input(ResourceArn = ResourceArn, TagKeys = TagKeys)
  output <- .guardduty$untag_resource_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$untag_resource <- guardduty_untag_resource

#' Updates an Amazon GuardDuty detector specified by the detectorId
#'
#' Updates an Amazon GuardDuty detector specified by the detectorId.
#'
#' @usage
#' guardduty_update_detector(DetectorId, Enable,
#'   FindingPublishingFrequency)
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector that you want to update.
#' @param Enable Updated boolean value for the detector that specifies whether the
#' detector is enabled.
#' @param FindingPublishingFrequency A enum value that specifies how frequently customer got Finding updates
#' published.
#'
#' @section Request syntax:
#' ```
#' svc$update_detector(
#'   DetectorId = "string",
#'   Enable = TRUE|FALSE,
#'   FindingPublishingFrequency = "FIFTEEN_MINUTES"|"ONE_HOUR"|"SIX_HOURS"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_update_detector
guardduty_update_detector <- function(DetectorId, Enable = NULL, FindingPublishingFrequency = NULL) {
  op <- new_operation(
    name = "UpdateDetector",
    http_method = "POST",
    http_path = "/detector/{detectorId}",
    paginator = list()
  )
  input <- .guardduty$update_detector_input(DetectorId = DetectorId, Enable = Enable, FindingPublishingFrequency = FindingPublishingFrequency)
  output <- .guardduty$update_detector_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$update_detector <- guardduty_update_detector

#' Updates the filter specified by the filter name
#'
#' Updates the filter specified by the filter name.
#'
#' @usage
#' guardduty_update_filter(DetectorId, FilterName, Description, Action,
#'   Rank, FindingCriteria)
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector that specifies the GuardDuty service where
#' you want to update a filter.
#' @param FilterName &#91;required&#93; The name of the filter.
#' @param Description The description of the filter.
#' @param Action Specifies the action that is to be applied to the findings that match
#' the filter.
#' @param Rank Specifies the position of the filter in the list of current filters.
#' Also specifies the order in which this filter is applied to the
#' findings.
#' @param FindingCriteria Represents the criteria to be used in the filter for querying findings.
#'
#' @section Request syntax:
#' ```
#' svc$update_filter(
#'   DetectorId = "string",
#'   FilterName = "string",
#'   Description = "string",
#'   Action = "NOOP"|"ARCHIVE",
#'   Rank = 123,
#'   FindingCriteria = list(
#'     Criterion = list(
#'       list(
#'         Eq = list(
#'           "string"
#'         ),
#'         Neq = list(
#'           "string"
#'         ),
#'         Gt = 123,
#'         Gte = 123,
#'         Lt = 123,
#'         Lte = 123,
#'         Equals = list(
#'           "string"
#'         ),
#'         NotEquals = list(
#'           "string"
#'         ),
#'         GreaterThan = 123,
#'         GreaterThanOrEqual = 123,
#'         LessThan = 123,
#'         LessThanOrEqual = 123
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_update_filter
guardduty_update_filter <- function(DetectorId, FilterName, Description = NULL, Action = NULL, Rank = NULL, FindingCriteria = NULL) {
  op <- new_operation(
    name = "UpdateFilter",
    http_method = "POST",
    http_path = "/detector/{detectorId}/filter/{filterName}",
    paginator = list()
  )
  input <- .guardduty$update_filter_input(DetectorId = DetectorId, FilterName = FilterName, Description = Description, Action = Action, Rank = Rank, FindingCriteria = FindingCriteria)
  output <- .guardduty$update_filter_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$update_filter <- guardduty_update_filter

#' Marks specified Amazon GuardDuty findings as useful or not useful
#'
#' Marks specified Amazon GuardDuty findings as useful or not useful.
#'
#' @usage
#' guardduty_update_findings_feedback(DetectorId, FindingIds, Feedback,
#'   Comments)
#'
#' @param DetectorId &#91;required&#93; The ID of the detector that specifies the GuardDuty service whose
#' findings you want to mark as useful or not useful.
#' @param FindingIds &#91;required&#93; IDs of the findings that you want to mark as useful or not useful.
#' @param Feedback &#91;required&#93; Valid values: USEFUL \\| NOT\\_USEFUL
#' @param Comments Additional feedback about the GuardDuty findings.
#'
#' @section Request syntax:
#' ```
#' svc$update_findings_feedback(
#'   DetectorId = "string",
#'   FindingIds = list(
#'     "string"
#'   ),
#'   Feedback = "USEFUL"|"NOT_USEFUL",
#'   Comments = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_update_findings_feedback
guardduty_update_findings_feedback <- function(DetectorId, FindingIds, Feedback, Comments = NULL) {
  op <- new_operation(
    name = "UpdateFindingsFeedback",
    http_method = "POST",
    http_path = "/detector/{detectorId}/findings/feedback",
    paginator = list()
  )
  input <- .guardduty$update_findings_feedback_input(DetectorId = DetectorId, FindingIds = FindingIds, Feedback = Feedback, Comments = Comments)
  output <- .guardduty$update_findings_feedback_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$update_findings_feedback <- guardduty_update_findings_feedback

#' Updates the IPSet specified by the IPSet ID
#'
#' Updates the IPSet specified by the IPSet ID.
#'
#' @usage
#' guardduty_update_ip_set(DetectorId, IpSetId, Name, Location, Activate)
#'
#' @param DetectorId &#91;required&#93; The detectorID that specifies the GuardDuty service whose IPSet you want
#' to update.
#' @param IpSetId &#91;required&#93; The unique ID that specifies the IPSet that you want to update.
#' @param Name The unique ID that specifies the IPSet that you want to update.
#' @param Location The updated URI of the file that contains the IPSet. For example
#' (https://s3.us-west-2.amazonaws.com/my-bucket/my-object-key).
#' @param Activate The updated boolean value that specifies whether the IPSet is active or
#' not.
#'
#' @section Request syntax:
#' ```
#' svc$update_ip_set(
#'   DetectorId = "string",
#'   IpSetId = "string",
#'   Name = "string",
#'   Location = "string",
#'   Activate = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_update_ip_set
guardduty_update_ip_set <- function(DetectorId, IpSetId, Name = NULL, Location = NULL, Activate = NULL) {
  op <- new_operation(
    name = "UpdateIPSet",
    http_method = "POST",
    http_path = "/detector/{detectorId}/ipset/{ipSetId}",
    paginator = list()
  )
  input <- .guardduty$update_ip_set_input(DetectorId = DetectorId, IpSetId = IpSetId, Name = Name, Location = Location, Activate = Activate)
  output <- .guardduty$update_ip_set_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$update_ip_set <- guardduty_update_ip_set

#' Updates the ThreatIntelSet specified by ThreatIntelSet ID
#'
#' Updates the ThreatIntelSet specified by ThreatIntelSet ID.
#'
#' @usage
#' guardduty_update_threat_intel_set(DetectorId, ThreatIntelSetId, Name,
#'   Location, Activate)
#'
#' @param DetectorId &#91;required&#93; The detectorID that specifies the GuardDuty service whose ThreatIntelSet
#' you want to update.
#' @param ThreatIntelSetId &#91;required&#93; The unique ID that specifies the ThreatIntelSet that you want to update.
#' @param Name The unique ID that specifies the ThreatIntelSet that you want to update.
#' @param Location The updated URI of the file that contains the ThreateIntelSet. For
#' example (https://s3.us-west-2.amazonaws.com/my-bucket/my-object-key)
#' @param Activate The updated boolean value that specifies whether the ThreateIntelSet is
#' active or not.
#'
#' @section Request syntax:
#' ```
#' svc$update_threat_intel_set(
#'   DetectorId = "string",
#'   ThreatIntelSetId = "string",
#'   Name = "string",
#'   Location = "string",
#'   Activate = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname guardduty_update_threat_intel_set
guardduty_update_threat_intel_set <- function(DetectorId, ThreatIntelSetId, Name = NULL, Location = NULL, Activate = NULL) {
  op <- new_operation(
    name = "UpdateThreatIntelSet",
    http_method = "POST",
    http_path = "/detector/{detectorId}/threatintelset/{threatIntelSetId}",
    paginator = list()
  )
  input <- .guardduty$update_threat_intel_set_input(DetectorId = DetectorId, ThreatIntelSetId = ThreatIntelSetId, Name = Name, Location = Location, Activate = Activate)
  output <- .guardduty$update_threat_intel_set_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$update_threat_intel_set <- guardduty_update_threat_intel_set
