% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kms_operations.R
\name{kms_create_grant}
\alias{kms_create_grant}
\title{Adds a grant to a customer master key (CMK)}
\usage{
kms_create_grant(KeyId, GranteePrincipal, RetiringPrincipal, Operations,
  Constraints, GrantTokens, Name)
}
\arguments{
\item{KeyId}{[required] The unique identifier for the customer master key (CMK) that the grant
applies to.

Specify the key ID or the Amazon Resource Name (ARN) of the CMK. To
specify a CMK in a different AWS account, you must use the key ARN.

For example:
\itemize{
\item Key ID: \verb{1234abcd-12ab-34cd-56ef-1234567890ab}
\item Key ARN:
\verb{arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab}
}

To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey.}

\item{GranteePrincipal}{[required] The principal that is given permission to perform the operations that
the grant permits.

To specify the principal, use the \href{https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html}{Amazon Resource Name (ARN)}
of an AWS principal. Valid AWS principals include AWS accounts (root),
IAM users, IAM roles, federated users, and assumed role users. For
examples of the ARN syntax to use for specifying a principal, see \href{https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-iam}{AWS Identity and Access Management (IAM)}
in the Example ARNs section of the \emph{AWS General Reference}.}

\item{RetiringPrincipal}{The principal that is given permission to retire the grant by using
RetireGrant operation.

To specify the principal, use the \href{https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html}{Amazon Resource Name (ARN)}
of an AWS principal. Valid AWS principals include AWS accounts (root),
IAM users, federated users, and assumed role users. For examples of the
ARN syntax to use for specifying a principal, see \href{https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-iam}{AWS Identity and Access Management (IAM)}
in the Example ARNs section of the \emph{AWS General Reference}.}

\item{Operations}{[required] A list of operations that the grant permits.}

\item{Constraints}{Allows a cryptographic operation only when the encryption context
matches or includes the encryption context specified in this structure.
For more information about encryption context, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context}{Encryption Context}
in the \strong{AWS Key Management Service Developer Guide} .}

\item{GrantTokens}{A list of grant tokens.

For more information, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token}{Grant Tokens}
in the \emph{AWS Key Management Service Developer Guide}.}

\item{Name}{A friendly name for identifying the grant. Use this value to prevent the
unintended creation of duplicate grants when retrying this request.

When this value is absent, all \code{CreateGrant} requests result in a new
grant with a unique \code{GrantId} even if all the supplied parameters are
identical. This can result in unintended duplicates when you retry the
\code{CreateGrant} request.

When this value is present, you can retry a \code{CreateGrant} request with
identical parameters; if the grant already exists, the original
\code{GrantId} is returned without creating a new grant. Note that the
returned grant token is unique with every \code{CreateGrant} request, even
when a duplicate \code{GrantId} is returned. All grant tokens obtained in
this way can be used interchangeably.}
}
\description{
Adds a grant to a customer master key (CMK). The grant allows the
grantee principal to use the CMK when the conditions specified in the
grant are met. When setting permissions, grants are an alternative to
key policies.
}
\details{
To create a grant that allows a cryptographic operation only when the
request includes a particular \href{https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context}{encryption context},
use the \code{Constraints} parameter. For details, see GrantConstraints.

You can create grants on symmetric and asymmetric CMKs. However, if the
grant allows an operation that the CMK does not support, \code{CreateGrant}
fails with a \code{ValidationException}.
\itemize{
\item Grants for symmetric CMKs cannot allow operations that are not
supported for symmetric CMKs, including Sign, Verify, and
GetPublicKey. (There are limited exceptions to this rule for legacy
operations, but you should not create a grant for an operation that
AWS KMS does not support.)
\item Grants for asymmetric CMKs cannot allow operations that are not
supported for asymmetric CMKs, including operations that \href{https://docs.aws.amazon.com/kms/latest/APIReference/API_GenerateDataKey}{generate data keys}
or \href{https://docs.aws.amazon.com/kms/latest/APIReference/API_GenerateDataKeyPair}{data key pairs},
or operations related to \href{https://docs.aws.amazon.com/kms/latest/developerguide/rotate-keys.html}{automatic key rotation},
\href{https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html}{imported key material},
or CMKs in \href{https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html}{custom key stores}.
\item Grants for asymmetric CMKs with a \code{KeyUsage} of \code{ENCRYPT_DECRYPT}
cannot allow the Sign or Verify operations. Grants for asymmetric
CMKs with a \code{KeyUsage} of \code{SIGN_VERIFY} cannot allow the Encrypt or
Decrypt operations.
\item Grants for asymmetric CMKs cannot include an encryption context
grant constraint. An encryption context is not supported on
asymmetric CMKs.
}

For information about symmetric and asymmetric CMKs, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html}{Using Symmetric and Asymmetric CMKs}
in the \emph{AWS Key Management Service Developer Guide}.

To perform this operation on a CMK in a different AWS account, specify
the key ARN in the value of the \code{KeyId} parameter. For more information
about grants, see
\href{https://docs.aws.amazon.com/kms/latest/developerguide/grants.html}{Grants}
in the \strong{AWS Key Management Service Developer Guide} .

The CMK that you use for this operation must be in a compatible key
state. For details, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html}{How Key State Affects Use of a Customer Master Key}
in the \emph{AWS Key Management Service Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$create_grant(
  KeyId = "string",
  GranteePrincipal = "string",
  RetiringPrincipal = "string",
  Operations = list(
    "Decrypt"|"Encrypt"|"GenerateDataKey"|"GenerateDataKeyWithoutPlaintext"|"ReEncryptFrom"|"ReEncryptTo"|"Sign"|"Verify"|"GetPublicKey"|"CreateGrant"|"RetireGrant"|"DescribeKey"|"GenerateDataKeyPair"|"GenerateDataKeyPairWithoutPlaintext"
  ),
  Constraints = list(
    EncryptionContextSubset = list(
      "string"
    ),
    EncryptionContextEquals = list(
      "string"
    )
  ),
  GrantTokens = list(
    "string"
  ),
  Name = "string"
)
}
}

\examples{
# The following example creates a grant that allows the specified IAM role
# to encrypt data with the specified customer master key (CMK).
\donttest{svc$create_grant(
  GranteePrincipal = "arn:aws:iam::111122223333:role/ExampleRole",
  KeyId = "arn:aws:kms:us-east-2:444455556666:key/1234abcd-12ab-34cd-56ef-1234567890ab",
  Operations = list(
    "Encrypt",
    "Decrypt"
  )
)}

}
\keyword{internal}
