% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_update_account_password_policy}
\alias{iam_update_account_password_policy}
\title{Updates the password policy settings for the AWS account}
\usage{
iam_update_account_password_policy(MinimumPasswordLength,
  RequireSymbols, RequireNumbers, RequireUppercaseCharacters,
  RequireLowercaseCharacters, AllowUsersToChangePassword, MaxPasswordAge,
  PasswordReusePrevention, HardExpiry)
}
\arguments{
\item{MinimumPasswordLength}{The minimum number of characters allowed in an IAM user password.

If you do not specify a value for this parameter, then the operation
uses the default value of \code{6}.}

\item{RequireSymbols}{Specifies whether IAM user passwords must contain at least one of the
following non-alphanumeric characters:

! @ \\# \\$ \% \\^ & * ( ) \\_ + - = [ ] \{ \} \\| \'

If you do not specify a value for this parameter, then the operation
uses the default value of \code{false}. The result is that passwords do not
require at least one symbol character.}

\item{RequireNumbers}{Specifies whether IAM user passwords must contain at least one numeric
character (0 to 9).

If you do not specify a value for this parameter, then the operation
uses the default value of \code{false}. The result is that passwords do not
require at least one numeric character.}

\item{RequireUppercaseCharacters}{Specifies whether IAM user passwords must contain at least one uppercase
character from the ISO basic Latin alphabet (A to Z).

If you do not specify a value for this parameter, then the operation
uses the default value of \code{false}. The result is that passwords do not
require at least one uppercase character.}

\item{RequireLowercaseCharacters}{Specifies whether IAM user passwords must contain at least one lowercase
character from the ISO basic Latin alphabet (a to z).

If you do not specify a value for this parameter, then the operation
uses the default value of \code{false}. The result is that passwords do not
require at least one lowercase character.}

\item{AllowUsersToChangePassword}{Allows all IAM users in your account to use the AWS Management Console
to change their own passwords. For more information, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/HowToPwdIAMUser.html}{Letting IAM Users Change Their Own Passwords}
in the \emph{IAM User Guide}.

If you do not specify a value for this parameter, then the operation
uses the default value of \code{false}. The result is that IAM users in the
account do not automatically have permissions to change their own
password.}

\item{MaxPasswordAge}{The number of days that an IAM user password is valid.

If you do not specify a value for this parameter, then the operation
uses the default value of \code{0}. The result is that IAM user passwords
never expire.}

\item{PasswordReusePrevention}{Specifies the number of previous passwords that IAM users are prevented
from reusing.

If you do not specify a value for this parameter, then the operation
uses the default value of \code{0}. The result is that IAM users are not
prevented from reusing previous passwords.}

\item{HardExpiry}{Prevents IAM users from setting a new password after their password has
expired. The IAM user cannot be accessed until an administrator resets
the password.

If you do not specify a value for this parameter, then the operation
uses the default value of \code{false}. The result is that IAM users can
change their passwords after they expire and continue to sign in as the
user.}
}
\description{
Updates the password policy settings for the AWS account.
}
\details{
\itemize{
\item This operation does not support partial updates. No parameters are
required, but if you do not specify a parameter, that parameter\'s
value reverts to its default value. See the \strong{Request Parameters}
section for each parameter\'s default value. Also note that some
parameters do not allow the default parameter to be explicitly set.
Instead, to invoke the default value, do not include that parameter
when you invoke the operation.
}

For more information about using a password policy, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_ManagingPasswordPolicies.html}{Managing an IAM Password Policy}
in the \emph{IAM User Guide}.
}
\section{Request syntax}{
\preformatted{svc$update_account_password_policy(
  MinimumPasswordLength = 123,
  RequireSymbols = TRUE|FALSE,
  RequireNumbers = TRUE|FALSE,
  RequireUppercaseCharacters = TRUE|FALSE,
  RequireLowercaseCharacters = TRUE|FALSE,
  AllowUsersToChangePassword = TRUE|FALSE,
  MaxPasswordAge = 123,
  PasswordReusePrevention = 123,
  HardExpiry = TRUE|FALSE
)
}
}

\examples{
# The following command sets the password policy to require a minimum
# length of eight characters and to require one or more numbers in the
# password:
\dontrun{svc$update_account_password_policy(
  MinimumPasswordLength = 8L,
  RequireNumbers = TRUE
)}

}
\keyword{internal}
