% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fms_operations.R
\name{fms_list_member_accounts}
\alias{fms_list_member_accounts}
\title{Returns a MemberAccounts object that lists the member accounts in the
administrator's AWS organization}
\usage{
fms_list_member_accounts(NextToken, MaxResults)
}
\arguments{
\item{NextToken}{If you specify a value for \code{MaxResults} and you have more account IDs
than the number that you specify for \code{MaxResults}, AWS Firewall Manager
returns a \code{NextToken} value in the response that allows you to list
another group of IDs. For the second and subsequent
\code{ListMemberAccountsRequest} requests, specify the value of \code{NextToken}
from the previous response to get information about another batch of
member account IDs.}

\item{MaxResults}{Specifies the number of member account IDs that you want AWS Firewall
Manager to return for this request. If you have more IDs than the number
that you specify for \code{MaxResults}, the response includes a \code{NextToken}
value that you can use to get another batch of member account IDs.}
}
\description{
Returns a \code{MemberAccounts} object that lists the member accounts in the
administrator\'s AWS organization.
}
\details{
The \code{ListMemberAccounts} must be submitted by the account that is set as
the AWS Firewall Manager administrator.
}
\section{Request syntax}{
\preformatted{svc$list_member_accounts(
  NextToken = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
