% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitoidentity_operations.R
\name{cognitoidentity_unlink_identity}
\alias{cognitoidentity_unlink_identity}
\title{Unlinks a federated identity from an existing account}
\usage{
cognitoidentity_unlink_identity(IdentityId, Logins, LoginsToRemove)
}
\arguments{
\item{IdentityId}{[required] A unique identifier in the format REGION:GUID.}

\item{Logins}{[required] A set of optional name-value pairs that map provider names to provider
tokens.}

\item{LoginsToRemove}{[required] Provider names to unlink from this identity.}
}
\description{
Unlinks a federated identity from an existing account. Unlinked logins
will be considered new identities next time they are seen. Removing the
last linked login will make this identity inaccessible.
}
\details{
This is a public API. You do not need any credentials to call this API.
}
\section{Request syntax}{
\preformatted{svc$unlink_identity(
  IdentityId = "string",
  Logins = list(
    "string"
  ),
  LoginsToRemove = list(
    "string"
  )
)
}
}

\keyword{internal}
