% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/directoryservice_service.R
\name{directoryservice}
\alias{directoryservice}
\title{AWS Directory Service}
\usage{
directoryservice(config = list())
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{access_key_id}:} {AWS access key ID}
\item{\strong{secret_access_key}:} {AWS secret access key}
\item{\strong{session_token}:} {AWS temporary session token}
\item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}:} {Set anonymous credentials.}
\item{\strong{endpoint}:} {The complete URL to use for the constructed client.}
\item{\strong{region}:} {The AWS Region used in instantiating the client.}
\item{\strong{close_connection}:} {Immediately close all HTTP connections.}
\item{\strong{timeout}:} {The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}:} {Set this to \code{true} to force the request to use path-style addressing, i.e., \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
}}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
Directory Service

Directory Service is a web service that makes it easy for you to setup
and run directories in the Amazon Web Services cloud, or connect your
Amazon Web Services resources with an existing self-managed Microsoft
Active Directory. This guide provides detailed information about
Directory Service operations, data types, parameters, and errors. For
information about Directory Services features, see \href{https://aws.amazon.com/directoryservice/}{Directory Service} and the \href{https://docs.aws.amazon.com/directoryservice/latest/admin-guide/what_is.html}{Directory Service Administration Guide}.

Amazon Web Services provides SDKs that consist of libraries and sample
code for various programming languages and platforms (Java, Ruby, .Net,
iOS, Android, etc.). The SDKs provide a convenient way to create
programmatic access to Directory Service and other Amazon Web Services
services. For more information about the Amazon Web Services SDKs,
including how to download and install them, see \href{https://aws.amazon.com/developer/tools/}{Tools for Amazon Web Services}.
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- directoryservice(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical"
  )
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[=directoryservice_accept_shared_directory]{accept_shared_directory} \tab Accepts a directory sharing request that was sent from the directory owner account\cr
\link[=directoryservice_add_ip_routes]{add_ip_routes} \tab If the DNS server for your self-managed domain uses a publicly addressable IP address, you must add a CIDR address block to correctly route traffic to and from your Microsoft AD on Amazon Web Services\cr
\link[=directoryservice_add_region]{add_region} \tab Adds two domain controllers in the specified Region for the specified directory\cr
\link[=directoryservice_add_tags_to_resource]{add_tags_to_resource} \tab Adds or overwrites one or more tags for the specified directory\cr
\link[=directoryservice_cancel_schema_extension]{cancel_schema_extension} \tab Cancels an in-progress schema extension to a Microsoft AD directory\cr
\link[=directoryservice_connect_directory]{connect_directory} \tab Creates an AD Connector to connect to a self-managed directory\cr
\link[=directoryservice_create_alias]{create_alias} \tab Creates an alias for a directory and assigns the alias to the directory\cr
\link[=directoryservice_create_computer]{create_computer} \tab Creates an Active Directory computer object in the specified directory\cr
\link[=directoryservice_create_conditional_forwarder]{create_conditional_forwarder} \tab Creates a conditional forwarder associated with your Amazon Web Services directory\cr
\link[=directoryservice_create_directory]{create_directory} \tab Creates a Simple AD directory\cr
\link[=directoryservice_create_log_subscription]{create_log_subscription} \tab Creates a subscription to forward real-time Directory Service domain controller security logs to the specified Amazon CloudWatch log group in your Amazon Web Services account\cr
\link[=directoryservice_create_microsoft_ad]{create_microsoft_ad} \tab Creates a Microsoft AD directory in the Amazon Web Services Cloud\cr
\link[=directoryservice_create_snapshot]{create_snapshot} \tab Creates a snapshot of a Simple AD or Microsoft AD directory in the Amazon Web Services cloud\cr
\link[=directoryservice_create_trust]{create_trust} \tab Directory Service for Microsoft Active Directory allows you to configure trust relationships\cr
\link[=directoryservice_delete_conditional_forwarder]{delete_conditional_forwarder} \tab Deletes a conditional forwarder that has been set up for your Amazon Web Services directory\cr
\link[=directoryservice_delete_directory]{delete_directory} \tab Deletes an Directory Service directory\cr
\link[=directoryservice_delete_log_subscription]{delete_log_subscription} \tab Deletes the specified log subscription\cr
\link[=directoryservice_delete_snapshot]{delete_snapshot} \tab Deletes a directory snapshot\cr
\link[=directoryservice_delete_trust]{delete_trust} \tab Deletes an existing trust relationship between your Managed Microsoft AD directory and an external domain\cr
\link[=directoryservice_deregister_certificate]{deregister_certificate} \tab Deletes from the system the certificate that was registered for secure LDAP or client certificate authentication\cr
\link[=directoryservice_deregister_event_topic]{deregister_event_topic} \tab Removes the specified directory as a publisher to the specified Amazon SNS topic\cr
\link[=directoryservice_describe_certificate]{describe_certificate} \tab Displays information about the certificate registered for secure LDAP or client certificate authentication\cr
\link[=directoryservice_describe_client_authentication_settings]{describe_client_authentication_settings} \tab Retrieves information about the type of client authentication for the specified directory, if the type is specified\cr
\link[=directoryservice_describe_conditional_forwarders]{describe_conditional_forwarders} \tab Obtains information about the conditional forwarders for this account\cr
\link[=directoryservice_describe_directories]{describe_directories} \tab Obtains information about the directories that belong to this account\cr
\link[=directoryservice_describe_domain_controllers]{describe_domain_controllers} \tab Provides information about any domain controllers in your directory\cr
\link[=directoryservice_describe_event_topics]{describe_event_topics} \tab Obtains information about which Amazon SNS topics receive status messages from the specified directory\cr
\link[=directoryservice_describe_ldaps_settings]{describe_ldaps_settings} \tab Describes the status of LDAP security for the specified directory\cr
\link[=directoryservice_describe_regions]{describe_regions} \tab Provides information about the Regions that are configured for multi-Region replication\cr
\link[=directoryservice_describe_settings]{describe_settings} \tab Retrieves information about the configurable settings for the specified directory\cr
\link[=directoryservice_describe_shared_directories]{describe_shared_directories} \tab Returns the shared directories in your account\cr
\link[=directoryservice_describe_snapshots]{describe_snapshots} \tab Obtains information about the directory snapshots that belong to this account\cr
\link[=directoryservice_describe_trusts]{describe_trusts} \tab Obtains information about the trust relationships for this account\cr
\link[=directoryservice_disable_client_authentication]{disable_client_authentication} \tab Disables alternative client authentication methods for the specified directory\cr
\link[=directoryservice_disable_ldaps]{disable_ldaps} \tab Deactivates LDAP secure calls for the specified directory\cr
\link[=directoryservice_disable_radius]{disable_radius} \tab Disables multi-factor authentication (MFA) with the Remote Authentication Dial In User Service (RADIUS) server for an AD Connector or Microsoft AD directory\cr
\link[=directoryservice_disable_sso]{disable_sso} \tab Disables single-sign on for a directory\cr
\link[=directoryservice_enable_client_authentication]{enable_client_authentication} \tab Enables alternative client authentication methods for the specified directory\cr
\link[=directoryservice_enable_ldaps]{enable_ldaps} \tab Activates the switch for the specific directory to always use LDAP secure calls\cr
\link[=directoryservice_enable_radius]{enable_radius} \tab Enables multi-factor authentication (MFA) with the Remote Authentication Dial In User Service (RADIUS) server for an AD Connector or Microsoft AD directory\cr
\link[=directoryservice_enable_sso]{enable_sso} \tab Enables single sign-on for a directory\cr
\link[=directoryservice_get_directory_limits]{get_directory_limits} \tab Obtains directory limit information for the current Region\cr
\link[=directoryservice_get_snapshot_limits]{get_snapshot_limits} \tab Obtains the manual snapshot limits for a directory\cr
\link[=directoryservice_list_certificates]{list_certificates} \tab For the specified directory, lists all the certificates registered for a secure LDAP or client certificate authentication\cr
\link[=directoryservice_list_ip_routes]{list_ip_routes} \tab Lists the address blocks that you have added to a directory\cr
\link[=directoryservice_list_log_subscriptions]{list_log_subscriptions} \tab Lists the active log subscriptions for the Amazon Web Services account\cr
\link[=directoryservice_list_schema_extensions]{list_schema_extensions} \tab Lists all schema extensions applied to a Microsoft AD Directory\cr
\link[=directoryservice_list_tags_for_resource]{list_tags_for_resource} \tab Lists all tags on a directory\cr
\link[=directoryservice_register_certificate]{register_certificate} \tab Registers a certificate for a secure LDAP or client certificate authentication\cr
\link[=directoryservice_register_event_topic]{register_event_topic} \tab Associates a directory with an Amazon SNS topic\cr
\link[=directoryservice_reject_shared_directory]{reject_shared_directory} \tab Rejects a directory sharing request that was sent from the directory owner account\cr
\link[=directoryservice_remove_ip_routes]{remove_ip_routes} \tab Removes IP address blocks from a directory\cr
\link[=directoryservice_remove_region]{remove_region} \tab Stops all replication and removes the domain controllers from the specified Region\cr
\link[=directoryservice_remove_tags_from_resource]{remove_tags_from_resource} \tab Removes tags from a directory\cr
\link[=directoryservice_reset_user_password]{reset_user_password} \tab Resets the password for any user in your Managed Microsoft AD or Simple AD directory\cr
\link[=directoryservice_restore_from_snapshot]{restore_from_snapshot} \tab Restores a directory using an existing directory snapshot\cr
\link[=directoryservice_share_directory]{share_directory} \tab Shares a specified directory (DirectoryId) in your Amazon Web Services account (directory owner) with another Amazon Web Services account (directory consumer)\cr
\link[=directoryservice_start_schema_extension]{start_schema_extension} \tab Applies a schema extension to a Microsoft AD directory\cr
\link[=directoryservice_unshare_directory]{unshare_directory} \tab Stops the directory sharing between the directory owner and consumer accounts\cr
\link[=directoryservice_update_conditional_forwarder]{update_conditional_forwarder} \tab Updates a conditional forwarder that has been set up for your Amazon Web Services directory\cr
\link[=directoryservice_update_number_of_domain_controllers]{update_number_of_domain_controllers} \tab Adds or removes domain controllers to or from the directory\cr
\link[=directoryservice_update_radius]{update_radius} \tab Updates the Remote Authentication Dial In User Service (RADIUS) server information for an AD Connector or Microsoft AD directory\cr
\link[=directoryservice_update_settings]{update_settings} \tab Updates the configurable settings for the specified directory\cr
\link[=directoryservice_update_trust]{update_trust} \tab Updates the trust that has been set up between your Managed Microsoft AD directory and an self-managed Active Directory\cr
\link[=directoryservice_verify_trust]{verify_trust} \tab Directory Service for Microsoft Active Directory allows you to configure and verify trust relationships
}
}

\examples{
\dontrun{
svc <- directoryservice()
svc$accept_shared_directory(
  Foo = 123
)
}

}
