% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_create_policy_version}
\alias{iam_create_policy_version}
\title{Creates a new version of the specified managed policy}
\usage{
iam_create_policy_version(PolicyArn, PolicyDocument, SetAsDefault = NULL)
}
\arguments{
\item{PolicyArn}{[required] The Amazon Resource Name (ARN) of the IAM policy to which you want to
add a new version.

For more information about ARNs, see \href{https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html}{Amazon Resource Names (ARNs)}
in the \emph{Amazon Web Services General Reference}.}

\item{PolicyDocument}{[required] The JSON policy document that you want to use as the content for this
new version of the policy.

You must provide policies in JSON format in IAM. However, for
CloudFormation templates formatted in YAML, you can provide the policy
in JSON or YAML format. CloudFormation always converts a YAML policy to
JSON format before submitting it to IAM.

The maximum length of the policy document that you can pass in this
operation, including whitespace, is listed below. To view the maximum
character counts of a managed policy with no whitespaces, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html#reference_iam-quotas-entity-length}{IAM and STS character quotas}.

The \href{https://en.wikipedia.org/wiki/Regex}{regex pattern} used to
validate this parameter is a string of characters consisting of the
following:
\itemize{
\item Any printable ASCII character ranging from the space character
(\code{U+0020}) through the end of the ASCII character range
\item The printable characters in the Basic Latin and Latin-1 Supplement
character set (through \verb{U+00FF})
\item The special characters tab (\code{U+0009}), line feed (\verb{U+000A}), and
carriage return (\verb{U+000D})
}}

\item{SetAsDefault}{Specifies whether to set this version as the policy's default version.

When this parameter is \code{true}, the new policy version becomes the
operative version. That is, it becomes the version that is in effect for
the IAM users, groups, and roles that the policy is attached to.

For more information about managed policy versions, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_managed-versioning.html}{Versioning for managed policies}
in the \emph{IAM User Guide}.}
}
\description{
Creates a new version of the specified managed policy. To update a managed policy, you create a new policy version. A managed policy can have up to five versions. If the policy has five versions, you must delete an existing version using \code{\link[=iam_delete_policy_version]{delete_policy_version}} before you create a new version.

See \url{https://paws-r.github.io/docs/iam/create_policy_version.html} for full documentation.
}
\keyword{internal}
